package web

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator 0.14.0.0
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.

import (
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"io"
	"net/http"
)

// AccessControlEntryAction enumerates the values for access control entry
// action.
type AccessControlEntryAction string

const (
	// Deny specifies the deny state for access control entry action.
	Deny AccessControlEntryAction = "Deny"
	// Permit specifies the permit state for access control entry action.
	Permit AccessControlEntryAction = "Permit"
)

// AutoHealActionType enumerates the values for auto heal action type.
type AutoHealActionType string

const (
	// CustomAction specifies the custom action state for auto heal action
	// type.
	CustomAction AutoHealActionType = "CustomAction"
	// LogEvent specifies the log event state for auto heal action type.
	LogEvent AutoHealActionType = "LogEvent"
	// Recycle specifies the recycle state for auto heal action type.
	Recycle AutoHealActionType = "Recycle"
)

// AzureResourceType enumerates the values for azure resource type.
type AzureResourceType string

const (
	// TrafficManager specifies the traffic manager state for azure resource
	// type.
	TrafficManager AzureResourceType = "TrafficManager"
	// Website specifies the website state for azure resource type.
	Website AzureResourceType = "Website"
)

// BackupItemStatus enumerates the values for backup item status.
type BackupItemStatus string

const (
	// Created specifies the created state for backup item status.
	Created BackupItemStatus = "Created"
	// Deleted specifies the deleted state for backup item status.
	Deleted BackupItemStatus = "Deleted"
	// DeleteFailed specifies the delete failed state for backup item status.
	DeleteFailed BackupItemStatus = "DeleteFailed"
	// DeleteInProgress specifies the delete in progress state for backup item
	// status.
	DeleteInProgress BackupItemStatus = "DeleteInProgress"
	// Failed specifies the failed state for backup item status.
	Failed BackupItemStatus = "Failed"
	// InProgress specifies the in progress state for backup item status.
	InProgress BackupItemStatus = "InProgress"
	// PartiallySucceeded specifies the partially succeeded state for backup
	// item status.
	PartiallySucceeded BackupItemStatus = "PartiallySucceeded"
	// Skipped specifies the skipped state for backup item status.
	Skipped BackupItemStatus = "Skipped"
	// Succeeded specifies the succeeded state for backup item status.
	Succeeded BackupItemStatus = "Succeeded"
	// TimedOut specifies the timed out state for backup item status.
	TimedOut BackupItemStatus = "TimedOut"
)

// BackupRestoreOperationType enumerates the values for backup restore
// operation type.
type BackupRestoreOperationType string

const (
	// Clone specifies the clone state for backup restore operation type.
	Clone BackupRestoreOperationType = "Clone"
	// Default specifies the default state for backup restore operation type.
	Default BackupRestoreOperationType = "Default"
	// Relocation specifies the relocation state for backup restore operation
	// type.
	Relocation BackupRestoreOperationType = "Relocation"
)

// BuiltInAuthenticationProvider enumerates the values for built in
// authentication provider.
type BuiltInAuthenticationProvider string

const (
	// AzureActiveDirectory specifies the azure active directory state for
	// built in authentication provider.
	AzureActiveDirectory BuiltInAuthenticationProvider = "AzureActiveDirectory"
	// Facebook specifies the facebook state for built in authentication
	// provider.
	Facebook BuiltInAuthenticationProvider = "Facebook"
	// Google specifies the google state for built in authentication provider.
	Google BuiltInAuthenticationProvider = "Google"
	// MicrosoftAccount specifies the microsoft account state for built in
	// authentication provider.
	MicrosoftAccount BuiltInAuthenticationProvider = "MicrosoftAccount"
	// Twitter specifies the twitter state for built in authentication
	// provider.
	Twitter BuiltInAuthenticationProvider = "Twitter"
)

// ComputeModeOptions enumerates the values for compute mode options.
type ComputeModeOptions string

const (
	// Dedicated specifies the dedicated state for compute mode options.
	Dedicated ComputeModeOptions = "Dedicated"
	// Shared specifies the shared state for compute mode options.
	Shared ComputeModeOptions = "Shared"
)

// CustomHostNameDNSRecordType enumerates the values for custom host name dns
// record type.
type CustomHostNameDNSRecordType string

const (
	// A specifies the a state for custom host name dns record type.
	A CustomHostNameDNSRecordType = "A"
	// CName specifies the c name state for custom host name dns record type.
	CName CustomHostNameDNSRecordType = "CName"
)

// DatabaseServerType enumerates the values for database server type.
type DatabaseServerType string

const (
	// Custom specifies the custom state for database server type.
	Custom DatabaseServerType = "Custom"
	// MySQL specifies the my sql state for database server type.
	MySQL DatabaseServerType = "MySql"
	// SQLAzure specifies the sql azure state for database server type.
	SQLAzure DatabaseServerType = "SQLAzure"
	// SQLServer specifies the sql server state for database server type.
	SQLServer DatabaseServerType = "SQLServer"
)

// DomainStatus enumerates the values for domain status.
type DomainStatus string

const (
	// DomainStatusActive specifies the domain status active state for domain
	// status.
	DomainStatusActive DomainStatus = "Active"
	// DomainStatusAwaiting specifies the domain status awaiting state for
	// domain status.
	DomainStatusAwaiting DomainStatus = "Awaiting"
	// DomainStatusCancelled specifies the domain status cancelled state for
	// domain status.
	DomainStatusCancelled DomainStatus = "Cancelled"
	// DomainStatusConfiscated specifies the domain status confiscated state
	// for domain status.
	DomainStatusConfiscated DomainStatus = "Confiscated"
	// DomainStatusDisabled specifies the domain status disabled state for
	// domain status.
	DomainStatusDisabled DomainStatus = "Disabled"
	// DomainStatusExcluded specifies the domain status excluded state for
	// domain status.
	DomainStatusExcluded DomainStatus = "Excluded"
	// DomainStatusExpired specifies the domain status expired state for
	// domain status.
	DomainStatusExpired DomainStatus = "Expired"
	// DomainStatusFailed specifies the domain status failed state for domain
	// status.
	DomainStatusFailed DomainStatus = "Failed"
	// DomainStatusHeld specifies the domain status held state for domain
	// status.
	DomainStatusHeld DomainStatus = "Held"
	// DomainStatusJSONConverterFailed specifies the domain status json
	// converter failed state for domain status.
	DomainStatusJSONConverterFailed DomainStatus = "JsonConverterFailed"
	// DomainStatusLocked specifies the domain status locked state for domain
	// status.
	DomainStatusLocked DomainStatus = "Locked"
	// DomainStatusParked specifies the domain status parked state for domain
	// status.
	DomainStatusParked DomainStatus = "Parked"
	// DomainStatusPending specifies the domain status pending state for
	// domain status.
	DomainStatusPending DomainStatus = "Pending"
	// DomainStatusReserved specifies the domain status reserved state for
	// domain status.
	DomainStatusReserved DomainStatus = "Reserved"
	// DomainStatusReverted specifies the domain status reverted state for
	// domain status.
	DomainStatusReverted DomainStatus = "Reverted"
	// DomainStatusSuspended specifies the domain status suspended state for
	// domain status.
	DomainStatusSuspended DomainStatus = "Suspended"
	// DomainStatusTransferred specifies the domain status transferred state
	// for domain status.
	DomainStatusTransferred DomainStatus = "Transferred"
	// DomainStatusUnknown specifies the domain status unknown state for
	// domain status.
	DomainStatusUnknown DomainStatus = "Unknown"
	// DomainStatusUnlocked specifies the domain status unlocked state for
	// domain status.
	DomainStatusUnlocked DomainStatus = "Unlocked"
	// DomainStatusUnparked specifies the domain status unparked state for
	// domain status.
	DomainStatusUnparked DomainStatus = "Unparked"
	// DomainStatusUpdated specifies the domain status updated state for
	// domain status.
	DomainStatusUpdated DomainStatus = "Updated"
)

// DomainType enumerates the values for domain type.
type DomainType string

const (
	// Regular specifies the regular state for domain type.
	Regular DomainType = "Regular"
	// SoftDeleted specifies the soft deleted state for domain type.
	SoftDeleted DomainType = "SoftDeleted"
)

// FrequencyUnit enumerates the values for frequency unit.
type FrequencyUnit string

const (
	// Day specifies the day state for frequency unit.
	Day FrequencyUnit = "Day"
	// Hour specifies the hour state for frequency unit.
	Hour FrequencyUnit = "Hour"
)

// HostingEnvironmentStatus enumerates the values for hosting environment
// status.
type HostingEnvironmentStatus string

const (
	// Deleting specifies the deleting state for hosting environment status.
	Deleting HostingEnvironmentStatus = "Deleting"
	// Preparing specifies the preparing state for hosting environment status.
	Preparing HostingEnvironmentStatus = "Preparing"
	// Ready specifies the ready state for hosting environment status.
	Ready HostingEnvironmentStatus = "Ready"
	// Scaling specifies the scaling state for hosting environment status.
	Scaling HostingEnvironmentStatus = "Scaling"
)

// HostNameType enumerates the values for host name type.
type HostNameType string

const (
	// Managed specifies the managed state for host name type.
	Managed HostNameType = "Managed"
	// Verified specifies the verified state for host name type.
	Verified HostNameType = "Verified"
)

// InternalLoadBalancingMode enumerates the values for internal load balancing
// mode.
type InternalLoadBalancingMode string

const (
	// None specifies the none state for internal load balancing mode.
	None InternalLoadBalancingMode = "None"
	// Publishing specifies the publishing state for internal load balancing
	// mode.
	Publishing InternalLoadBalancingMode = "Publishing"
	// Web specifies the web state for internal load balancing mode.
	Web InternalLoadBalancingMode = "Web"
)

// LogLevel enumerates the values for log level.
type LogLevel string

const (
	// Error specifies the error state for log level.
	Error LogLevel = "Error"
	// Information specifies the information state for log level.
	Information LogLevel = "Information"
	// Off specifies the off state for log level.
	Off LogLevel = "Off"
	// Verbose specifies the verbose state for log level.
	Verbose LogLevel = "Verbose"
	// Warning specifies the warning state for log level.
	Warning LogLevel = "Warning"
)

// ManagedHostingEnvironmentStatus enumerates the values for managed hosting
// environment status.
type ManagedHostingEnvironmentStatus string

const (
	// ManagedHostingEnvironmentStatusDeleting specifies the managed hosting
	// environment status deleting state for managed hosting environment
	// status.
	ManagedHostingEnvironmentStatusDeleting ManagedHostingEnvironmentStatus = "Deleting"
	// ManagedHostingEnvironmentStatusPreparing specifies the managed hosting
	// environment status preparing state for managed hosting environment
	// status.
	ManagedHostingEnvironmentStatusPreparing ManagedHostingEnvironmentStatus = "Preparing"
	// ManagedHostingEnvironmentStatusReady specifies the managed hosting
	// environment status ready state for managed hosting environment status.
	ManagedHostingEnvironmentStatusReady ManagedHostingEnvironmentStatus = "Ready"
)

// ManagedPipelineMode enumerates the values for managed pipeline mode.
type ManagedPipelineMode string

const (
	// Classic specifies the classic state for managed pipeline mode.
	Classic ManagedPipelineMode = "Classic"
	// Integrated specifies the integrated state for managed pipeline mode.
	Integrated ManagedPipelineMode = "Integrated"
)

// ProvisioningState enumerates the values for provisioning state.
type ProvisioningState string

const (
	// ProvisioningStateCanceled specifies the provisioning state canceled
	// state for provisioning state.
	ProvisioningStateCanceled ProvisioningState = "Canceled"
	// ProvisioningStateFailed specifies the provisioning state failed state
	// for provisioning state.
	ProvisioningStateFailed ProvisioningState = "Failed"
	// ProvisioningStateInProgress specifies the provisioning state in
	// progress state for provisioning state.
	ProvisioningStateInProgress ProvisioningState = "InProgress"
	// ProvisioningStateSucceeded specifies the provisioning state succeeded
	// state for provisioning state.
	ProvisioningStateSucceeded ProvisioningState = "Succeeded"
)

// SiteAvailabilityState enumerates the values for site availability state.
type SiteAvailabilityState string

const (
	// DisasterRecoveryMode specifies the disaster recovery mode state for
	// site availability state.
	DisasterRecoveryMode SiteAvailabilityState = "DisasterRecoveryMode"
	// Limited specifies the limited state for site availability state.
	Limited SiteAvailabilityState = "Limited"
	// Normal specifies the normal state for site availability state.
	Normal SiteAvailabilityState = "Normal"
)

// SiteLoadBalancing enumerates the values for site load balancing.
type SiteLoadBalancing string

const (
	// LeastRequests specifies the least requests state for site load
	// balancing.
	LeastRequests SiteLoadBalancing = "LeastRequests"
	// LeastResponseTime specifies the least response time state for site load
	// balancing.
	LeastResponseTime SiteLoadBalancing = "LeastResponseTime"
	// RequestHash specifies the request hash state for site load balancing.
	RequestHash SiteLoadBalancing = "RequestHash"
	// WeightedRoundRobin specifies the weighted round robin state for site
	// load balancing.
	WeightedRoundRobin SiteLoadBalancing = "WeightedRoundRobin"
	// WeightedTotalTraffic specifies the weighted total traffic state for
	// site load balancing.
	WeightedTotalTraffic SiteLoadBalancing = "WeightedTotalTraffic"
)

// SslState enumerates the values for ssl state.
type SslState string

const (
	// Disabled specifies the disabled state for ssl state.
	Disabled SslState = "Disabled"
	// IPBasedEnabled specifies the ip based enabled state for ssl state.
	IPBasedEnabled SslState = "IpBasedEnabled"
	// SniEnabled specifies the sni enabled state for ssl state.
	SniEnabled SslState = "SniEnabled"
)

// StatusOptions enumerates the values for status options.
type StatusOptions string

const (
	// StatusOptionsPending specifies the status options pending state for
	// status options.
	StatusOptionsPending StatusOptions = "Pending"
	// StatusOptionsReady specifies the status options ready state for status
	// options.
	StatusOptionsReady StatusOptions = "Ready"
)

// UnauthenticatedClientAction enumerates the values for unauthenticated
// client action.
type UnauthenticatedClientAction string

const (
	// AllowAnonymous specifies the allow anonymous state for unauthenticated
	// client action.
	AllowAnonymous UnauthenticatedClientAction = "AllowAnonymous"
	// RedirectToLoginPage specifies the redirect to login page state for
	// unauthenticated client action.
	RedirectToLoginPage UnauthenticatedClientAction = "RedirectToLoginPage"
)

// UsageState enumerates the values for usage state.
type UsageState string

const (
	// UsageStateExceeded specifies the usage state exceeded state for usage
	// state.
	UsageStateExceeded UsageState = "Exceeded"
	// UsageStateNormal specifies the usage state normal state for usage state.
	UsageStateNormal UsageState = "Normal"
)

// WorkerSizeOptions enumerates the values for worker size options.
type WorkerSizeOptions string

const (
	// Large specifies the large state for worker size options.
	Large WorkerSizeOptions = "Large"
	// Medium specifies the medium state for worker size options.
	Medium WorkerSizeOptions = "Medium"
	// Small specifies the small state for worker size options.
	Small WorkerSizeOptions = "Small"
)

// Address is address information for domain registration
type Address struct {
	Address1   *string `json:"address1,omitempty"`
	Address2   *string `json:"address2,omitempty"`
	City       *string `json:"city,omitempty"`
	Country    *string `json:"country,omitempty"`
	PostalCode *string `json:"postalCode,omitempty"`
	State      *string `json:"state,omitempty"`
}

// AddressResponse is describes main public ip address and any extra vips
type AddressResponse struct {
	autorest.Response   `json:"-"`
	ServiceIPAddress    *string             `json:"serviceIpAddress,omitempty"`
	InternalIPAddress   *string             `json:"internalIpAddress,omitempty"`
	OutboundIPAddresses *[]string           `json:"outboundIpAddresses,omitempty"`
	VipMappings         *[]VirtualIPMapping `json:"vipMappings,omitempty"`
}

// APIDefinitionInfo is information about the formal API definition for the
// web app.
type APIDefinitionInfo struct {
	URL *string `json:"url,omitempty"`
}

// ApplicationLogsConfig is application logs configuration
type ApplicationLogsConfig struct {
	FileSystem        *FileSystemApplicationLogsConfig        `json:"fileSystem,omitempty"`
	AzureTableStorage *AzureTableStorageApplicationLogsConfig `json:"azureTableStorage,omitempty"`
	AzureBlobStorage  *AzureBlobStorageApplicationLogsConfig  `json:"azureBlobStorage,omitempty"`
}

// ArmPlan is the plan object in an ARM, represents a marketplace plan
type ArmPlan struct {
	Name          *string `json:"name,omitempty"`
	Publisher     *string `json:"publisher,omitempty"`
	Product       *string `json:"product,omitempty"`
	PromotionCode *string `json:"promotionCode,omitempty"`
	Version       *string `json:"version,omitempty"`
}

// AutoHealActions is autoHealActions - Describes the actions which can be
// taken by the auto-heal module when a rule is triggered.
type AutoHealActions struct {
	ActionType              AutoHealActionType    `json:"actionType,omitempty"`
	CustomAction            *AutoHealCustomAction `json:"customAction,omitempty"`
	MinProcessExecutionTime *string               `json:"minProcessExecutionTime,omitempty"`
}

// AutoHealCustomAction is autoHealCustomAction - Describes the custom action
// to be executed
// when an auto heal rule is triggered.
type AutoHealCustomAction struct {
	Exe        *string `json:"exe,omitempty"`
	Parameters *string `json:"parameters,omitempty"`
}

// AutoHealRules is autoHealRules - describes the rules which can be defined
// for auto-heal
type AutoHealRules struct {
	Triggers *AutoHealTriggers `json:"triggers,omitempty"`
	Actions  *AutoHealActions  `json:"actions,omitempty"`
}

// AutoHealTriggers is autoHealTriggers - describes the triggers for auto-heal.
type AutoHealTriggers struct {
	Requests         *RequestsBasedTrigger      `json:"requests,omitempty"`
	PrivateBytesInKB *int32                     `json:"privateBytesInKB,omitempty"`
	StatusCodes      *[]StatusCodesBasedTrigger `json:"statusCodes,omitempty"`
	SlowRequests     *SlowRequestsBasedTrigger  `json:"slowRequests,omitempty"`
}

// AzureBlobStorageApplicationLogsConfig is application logs azure blob
// storage configuration
type AzureBlobStorageApplicationLogsConfig struct {
	Level           LogLevel `json:"level,omitempty"`
	SasURL          *string  `json:"sasUrl,omitempty"`
	RetentionInDays *int32   `json:"retentionInDays,omitempty"`
}

// AzureBlobStorageHTTPLogsConfig is http logs to azure blob storage
// configuration
type AzureBlobStorageHTTPLogsConfig struct {
	SasURL          *string `json:"sasUrl,omitempty"`
	RetentionInDays *int32  `json:"retentionInDays,omitempty"`
	Enabled         *bool   `json:"enabled,omitempty"`
}

// AzureTableStorageApplicationLogsConfig is application logs to azure table
// storage configuration
type AzureTableStorageApplicationLogsConfig struct {
	Level  LogLevel `json:"level,omitempty"`
	SasURL *string  `json:"sasUrl,omitempty"`
}

// BackupItem is backup description
type BackupItem struct {
	autorest.Response `json:"-"`
	ID                *string               `json:"id,omitempty"`
	Name              *string               `json:"name,omitempty"`
	Location          *string               `json:"location,omitempty"`
	Type              *string               `json:"type,omitempty"`
	Tags              *map[string]*string   `json:"tags,omitempty"`
	Properties        *BackupItemProperties `json:"properties,omitempty"`
}

// BackupItemCollection is collection of Backup Items
type BackupItemCollection struct {
	autorest.Response `json:"-"`
	Value             *[]BackupItem `json:"value,omitempty"`
	NextLink          *string       `json:"nextLink,omitempty"`
}

// BackupItemProperties is
type BackupItemProperties struct {
	StorageAccountURL    *string                  `json:"storageAccountUrl,omitempty"`
	BlobName             *string                  `json:"blobName,omitempty"`
	Name                 *string                  `json:"name,omitempty"`
	Status               BackupItemStatus         `json:"status,omitempty"`
	SizeInBytes          *int64                   `json:"sizeInBytes,omitempty"`
	Created              *date.Time               `json:"created,omitempty"`
	Log                  *string                  `json:"log,omitempty"`
	Databases            *[]DatabaseBackupSetting `json:"databases,omitempty"`
	Scheduled            *bool                    `json:"scheduled,omitempty"`
	LastRestoreTimeStamp *date.Time               `json:"lastRestoreTimeStamp,omitempty"`
	FinishedTimeStamp    *date.Time               `json:"finishedTimeStamp,omitempty"`
	CorrelationID        *string                  `json:"correlationId,omitempty"`
	WebsiteSizeInBytes   *int64                   `json:"websiteSizeInBytes,omitempty"`
}

// BackupRequest is description of a backup which will be performed
type BackupRequest struct {
	autorest.Response `json:"-"`
	ID                *string                  `json:"id,omitempty"`
	Name              *string                  `json:"name,omitempty"`
	Location          *string                  `json:"location,omitempty"`
	Type              *string                  `json:"type,omitempty"`
	Tags              *map[string]*string      `json:"tags,omitempty"`
	Properties        *BackupRequestProperties `json:"properties,omitempty"`
}

// BackupRequestProperties is
type BackupRequestProperties struct {
	Name              *string                    `json:"name,omitempty"`
	Enabled           *bool                      `json:"enabled,omitempty"`
	StorageAccountURL *string                    `json:"storageAccountUrl,omitempty"`
	BackupSchedule    *BackupSchedule            `json:"backupSchedule,omitempty"`
	Databases         *[]DatabaseBackupSetting   `json:"databases,omitempty"`
	Type              BackupRestoreOperationType `json:"type,omitempty"`
}

// BackupSchedule is description of a backup schedule. Describes how often
// should be the backup performed and what should be the retention policy.
type BackupSchedule struct {
	FrequencyInterval     *int32        `json:"frequencyInterval,omitempty"`
	FrequencyUnit         FrequencyUnit `json:"frequencyUnit,omitempty"`
	KeepAtLeastOneBackup  *bool         `json:"keepAtLeastOneBackup,omitempty"`
	RetentionPeriodInDays *int32        `json:"retentionPeriodInDays,omitempty"`
	StartTime             *date.Time    `json:"startTime,omitempty"`
	LastExecutionTime     *date.Time    `json:"lastExecutionTime,omitempty"`
}

// Certificate is app certificate
type Certificate struct {
	autorest.Response `json:"-"`
	ID                *string                `json:"id,omitempty"`
	Name              *string                `json:"name,omitempty"`
	Location          *string                `json:"location,omitempty"`
	Type              *string                `json:"type,omitempty"`
	Tags              *map[string]*string    `json:"tags,omitempty"`
	Properties        *CertificateProperties `json:"properties,omitempty"`
}

// CertificateCollection is collection of certificates
type CertificateCollection struct {
	autorest.Response `json:"-"`
	Value             *[]Certificate `json:"value,omitempty"`
	NextLink          *string        `json:"nextLink,omitempty"`
}

// CertificateProperties is
type CertificateProperties struct {
	FriendlyName              *string                    `json:"friendlyName,omitempty"`
	SubjectName               *string                    `json:"subjectName,omitempty"`
	HostNames                 *[]string                  `json:"hostNames,omitempty"`
	PfxBlob                   *string                    `json:"pfxBlob,omitempty"`
	SiteName                  *string                    `json:"siteName,omitempty"`
	SelfLink                  *string                    `json:"selfLink,omitempty"`
	Issuer                    *string                    `json:"issuer,omitempty"`
	IssueDate                 *date.Time                 `json:"issueDate,omitempty"`
	ExpirationDate            *date.Time                 `json:"expirationDate,omitempty"`
	Password                  *string                    `json:"password,omitempty"`
	Thumbprint                *string                    `json:"thumbprint,omitempty"`
	Valid                     *bool                      `json:"valid,omitempty"`
	CerBlob                   *string                    `json:"cerBlob,omitempty"`
	PublicKeyHash             *string                    `json:"publicKeyHash,omitempty"`
	HostingEnvironmentProfile *HostingEnvironmentProfile `json:"hostingEnvironmentProfile,omitempty"`
}

// ClassicMobileService is a mobile service
type ClassicMobileService struct {
	autorest.Response `json:"-"`
	ID                *string                         `json:"id,omitempty"`
	Name              *string                         `json:"name,omitempty"`
	Location          *string                         `json:"location,omitempty"`
	Type              *string                         `json:"type,omitempty"`
	Tags              *map[string]*string             `json:"tags,omitempty"`
	Properties        *ClassicMobileServiceProperties `json:"properties,omitempty"`
}

// ClassicMobileServiceCollection is collection of Classic Mobile Services
type ClassicMobileServiceCollection struct {
	autorest.Response `json:"-"`
	Value             *[]ClassicMobileService `json:"value,omitempty"`
	NextLink          *string                 `json:"nextLink,omitempty"`
}

// ClassicMobileServiceProperties is
type ClassicMobileServiceProperties struct {
	Name *string `json:"name,omitempty"`
}

// CloningInfo is represents information needed for cloning operation
type CloningInfo struct {
	CorrelationID             *string             `json:"correlationId,omitempty"`
	Overwrite                 *bool               `json:"overwrite,omitempty"`
	CloneCustomHostNames      *bool               `json:"cloneCustomHostNames,omitempty"`
	CloneSourceControl        *bool               `json:"cloneSourceControl,omitempty"`
	SourceWebAppID            *string             `json:"sourceWebAppId,omitempty"`
	HostingEnvironment        *string             `json:"hostingEnvironment,omitempty"`
	AppSettingsOverrides      *map[string]*string `json:"appSettingsOverrides,omitempty"`
	ConfigureLoadBalancing    *bool               `json:"configureLoadBalancing,omitempty"`
	TrafficManagerProfileID   *string             `json:"trafficManagerProfileId,omitempty"`
	TrafficManagerProfileName *string             `json:"trafficManagerProfileName,omitempty"`
}

// ConnectionStringDictionary is string dictionary resource
type ConnectionStringDictionary struct {
	autorest.Response `json:"-"`
	ID                *string                              `json:"id,omitempty"`
	Name              *string                              `json:"name,omitempty"`
	Location          *string                              `json:"location,omitempty"`
	Type              *string                              `json:"type,omitempty"`
	Tags              *map[string]*string                  `json:"tags,omitempty"`
	Properties        *map[string]*ConnStringValueTypePair `json:"properties,omitempty"`
}

// ConnStringInfo is represents database connection string information
type ConnStringInfo struct {
	Name             *string            `json:"name,omitempty"`
	ConnectionString *string            `json:"connectionString,omitempty"`
	Type             DatabaseServerType `json:"type,omitempty"`
}

// ConnStringValueTypePair is database connection string value to type pair
type ConnStringValueTypePair struct {
	Value *string            `json:"value,omitempty"`
	Type  DatabaseServerType `json:"type,omitempty"`
}

// Contact is contact information for domain registration. If 'Domain Privacy'
// option is not selected then the contact information will be  be made
// publicly available through the Whois directories as per ICANN requirements.
type Contact struct {
	AddressMailing *Address `json:"addressMailing,omitempty"`
	Email          *string  `json:"email,omitempty"`
	Fax            *string  `json:"fax,omitempty"`
	JobTitle       *string  `json:"jobTitle,omitempty"`
	NameFirst      *string  `json:"nameFirst,omitempty"`
	NameLast       *string  `json:"nameLast,omitempty"`
	NameMiddle     *string  `json:"nameMiddle,omitempty"`
	Organization   *string  `json:"organization,omitempty"`
	Phone          *string  `json:"phone,omitempty"`
}

// CorsSettings is cross-Origin Resource Sharing (CORS) settings for the web
// app.
type CorsSettings struct {
	AllowedOrigins *[]string `json:"allowedOrigins,omitempty"`
}

// CsmMoveResourceEnvelope is class containing a list of the resources that
// need to be moved and the resource group they should be moved to
type CsmMoveResourceEnvelope struct {
	TargetResourceGroup *string   `json:"targetResourceGroup,omitempty"`
	Resources           *[]string `json:"resources,omitempty"`
}

// CsmPublishingProfileOptions is publishing options for requested profile
type CsmPublishingProfileOptions struct {
	Format *string `json:"format,omitempty"`
}

// CsmSiteRecoveryEntity is class containting details about site recovery
// operation.
type CsmSiteRecoveryEntity struct {
	SnapshotTime *date.Time `json:"snapshotTime,omitempty"`
	SiteName     *string    `json:"siteName,omitempty"`
	SlotName     *string    `json:"slotName,omitempty"`
}

// CsmSlotEntity is class containing deployment slot parameters
type CsmSlotEntity struct {
	TargetSlot   *string `json:"targetSlot,omitempty"`
	PreserveVnet *bool   `json:"preserveVnet,omitempty"`
}

// CsmUsageQuota is usage of the quota resource
type CsmUsageQuota struct {
	Unit          *string            `json:"unit,omitempty"`
	NextResetTime *date.Time         `json:"nextResetTime,omitempty"`
	CurrentValue  *int64             `json:"currentValue,omitempty"`
	Limit         *int64             `json:"limit,omitempty"`
	Name          *LocalizableString `json:"name,omitempty"`
}

// CsmUsageQuotaCollection is collection of csm usage quotas
type CsmUsageQuotaCollection struct {
	autorest.Response `json:"-"`
	Value             *[]CsmUsageQuota `json:"value,omitempty"`
	NextLink          *string          `json:"nextLink,omitempty"`
}

// Csr is certificate signing request object
type Csr struct {
	autorest.Response `json:"-"`
	ID                *string             `json:"id,omitempty"`
	Name              *string             `json:"name,omitempty"`
	Location          *string             `json:"location,omitempty"`
	Type              *string             `json:"type,omitempty"`
	Tags              *map[string]*string `json:"tags,omitempty"`
	Properties        *CsrProperties      `json:"properties,omitempty"`
}

// CsrProperties is
type CsrProperties struct {
	Name               *string `json:"name,omitempty"`
	DistinguishedName  *string `json:"distinguishedName,omitempty"`
	CsrString          *string `json:"csrString,omitempty"`
	PfxBlob            *string `json:"pfxBlob,omitempty"`
	Password           *string `json:"password,omitempty"`
	PublicKeyHash      *string `json:"publicKeyHash,omitempty"`
	HostingEnvironment *string `json:"hostingEnvironment,omitempty"`
}

// DatabaseBackupSetting is note: properties are serialized in JSON format and
// stored in DB.
// if new properties are added they might not be in the previous
// data rows
// so please handle nulls
type DatabaseBackupSetting struct {
	DatabaseType         *string `json:"databaseType,omitempty"`
	Name                 *string `json:"name,omitempty"`
	ConnectionStringName *string `json:"connectionStringName,omitempty"`
	ConnectionString     *string `json:"connectionString,omitempty"`
}

// DeletedSite is reports deleted site including the timestamp of operation
type DeletedSite struct {
	ID         *string                `json:"id,omitempty"`
	Name       *string                `json:"name,omitempty"`
	Location   *string                `json:"location,omitempty"`
	Type       *string                `json:"type,omitempty"`
	Tags       *map[string]*string    `json:"tags,omitempty"`
	Properties *DeletedSiteProperties `json:"properties,omitempty"`
}

// DeletedSiteCollection is collection of deleted sites
type DeletedSiteCollection struct {
	autorest.Response `json:"-"`
	Value             *[]DeletedSite `json:"value,omitempty"`
	NextLink          *string        `json:"nextLink,omitempty"`
}

// DeletedSiteProperties is
type DeletedSiteProperties struct {
	DeletedTimestamp          *date.Time                 `json:"deletedTimestamp,omitempty"`
	Name                      *string                    `json:"name,omitempty"`
	State                     *string                    `json:"state,omitempty"`
	HostNames                 *[]string                  `json:"hostNames,omitempty"`
	RepositorySiteName        *string                    `json:"repositorySiteName,omitempty"`
	UsageState                UsageState                 `json:"usageState,omitempty"`
	Enabled                   *bool                      `json:"enabled,omitempty"`
	EnabledHostNames          *[]string                  `json:"enabledHostNames,omitempty"`
	AvailabilityState         SiteAvailabilityState      `json:"availabilityState,omitempty"`
	HostNameSslStates         *[]HostNameSslState        `json:"hostNameSslStates,omitempty"`
	ServerFarmID              *string                    `json:"serverFarmId,omitempty"`
	LastModifiedTimeUtc       *date.Time                 `json:"lastModifiedTimeUtc,omitempty"`
	SiteConfig                *SiteConfig                `json:"siteConfig,omitempty"`
	TrafficManagerHostNames   *[]string                  `json:"trafficManagerHostNames,omitempty"`
	PremiumAppDeployed        *bool                      `json:"premiumAppDeployed,omitempty"`
	ScmSiteAlsoStopped        *bool                      `json:"scmSiteAlsoStopped,omitempty"`
	TargetSwapSlot            *string                    `json:"targetSwapSlot,omitempty"`
	HostingEnvironmentProfile *HostingEnvironmentProfile `json:"hostingEnvironmentProfile,omitempty"`
	MicroService              *string                    `json:"microService,omitempty"`
	GatewaySiteName           *string                    `json:"gatewaySiteName,omitempty"`
	ClientAffinityEnabled     *bool                      `json:"clientAffinityEnabled,omitempty"`
	ClientCertEnabled         *bool                      `json:"clientCertEnabled,omitempty"`
	HostNamesDisabled         *bool                      `json:"hostNamesDisabled,omitempty"`
	OutboundIPAddresses       *string                    `json:"outboundIpAddresses,omitempty"`
	CloningInfo               *CloningInfo               `json:"cloningInfo,omitempty"`
}

// Deployment is represents user crendentials used for publishing activity
type Deployment struct {
	autorest.Response `json:"-"`
	ID                *string               `json:"id,omitempty"`
	Name              *string               `json:"name,omitempty"`
	Location          *string               `json:"location,omitempty"`
	Type              *string               `json:"type,omitempty"`
	Tags              *map[string]*string   `json:"tags,omitempty"`
	Properties        *DeploymentProperties `json:"properties,omitempty"`
}

// DeploymentCollection is collection of app deployments
type DeploymentCollection struct {
	autorest.Response `json:"-"`
	Value             *[]Deployment `json:"value,omitempty"`
	NextLink          *string       `json:"nextLink,omitempty"`
}

// DeploymentProperties is
type DeploymentProperties struct {
	ID          *string    `json:"id,omitempty"`
	Status      *int32     `json:"status,omitempty"`
	Message     *string    `json:"message,omitempty"`
	Author      *string    `json:"author,omitempty"`
	Deployer    *string    `json:"deployer,omitempty"`
	AuthorEmail *string    `json:"author_email,omitempty"`
	StartTime   *date.Time `json:"start_time,omitempty"`
	EndTime     *date.Time `json:"end_time,omitempty"`
	Active      *bool      `json:"active,omitempty"`
	Details     *string    `json:"details,omitempty"`
}

// Domain is represents a domain
type Domain struct {
	autorest.Response `json:"-"`
	ID                *string             `json:"id,omitempty"`
	Name              *string             `json:"name,omitempty"`
	Location          *string             `json:"location,omitempty"`
	Type              *string             `json:"type,omitempty"`
	Tags              *map[string]*string `json:"tags,omitempty"`
	Properties        *DomainProperties   `json:"properties,omitempty"`
}

// DomainAvailablilityCheckResult is domain availablility check result
type DomainAvailablilityCheckResult struct {
	autorest.Response `json:"-"`
	Name              *string    `json:"name,omitempty"`
	Available         *bool      `json:"available,omitempty"`
	DomainType        DomainType `json:"domainType,omitempty"`
}

// DomainCollection is collection of domains
type DomainCollection struct {
	autorest.Response `json:"-"`
	Value             *[]Domain `json:"value,omitempty"`
	NextLink          *string   `json:"nextLink,omitempty"`
}

// DomainControlCenterSsoRequest is single sign on request information for
// domain management
type DomainControlCenterSsoRequest struct {
	autorest.Response  `json:"-"`
	URL                *string `json:"url,omitempty"`
	PostParameterKey   *string `json:"postParameterKey,omitempty"`
	PostParameterValue *string `json:"postParameterValue,omitempty"`
}

// DomainProperties is
type DomainProperties struct {
	ContactAdmin                *Contact               `json:"contactAdmin,omitempty"`
	ContactBilling              *Contact               `json:"contactBilling,omitempty"`
	ContactRegistrant           *Contact               `json:"contactRegistrant,omitempty"`
	ContactTech                 *Contact               `json:"contactTech,omitempty"`
	RegistrationStatus          DomainStatus           `json:"registrationStatus,omitempty"`
	ProvisioningState           ProvisioningState      `json:"provisioningState,omitempty"`
	NameServers                 *[]string              `json:"nameServers,omitempty"`
	Privacy                     *bool                  `json:"privacy,omitempty"`
	CreatedTime                 *date.Time             `json:"createdTime,omitempty"`
	ExpirationTime              *date.Time             `json:"expirationTime,omitempty"`
	LastRenewedTime             *date.Time             `json:"lastRenewedTime,omitempty"`
	AutoRenew                   *bool                  `json:"autoRenew,omitempty"`
	ReadyForDNSRecordManagement *bool                  `json:"readyForDnsRecordManagement,omitempty"`
	ManagedHostNames            *[]HostName            `json:"managedHostNames,omitempty"`
	Consent                     *DomainPurchaseConsent `json:"consent,omitempty"`
}

// DomainPurchaseConsent is domain purchase consent object representing
// acceptance of applicable legal agreements
type DomainPurchaseConsent struct {
	AgreementKeys *[]string  `json:"agreementKeys,omitempty"`
	AgreedBy      *string    `json:"agreedBy,omitempty"`
	AgreedAt      *date.Time `json:"agreedAt,omitempty"`
}

// DomainRecommendationSearchParameters is domain recommendation search
// parameters
type DomainRecommendationSearchParameters struct {
	Keywords                 *string `json:"keywords,omitempty"`
	MaxDomainRecommendations *int32  `json:"maxDomainRecommendations,omitempty"`
}

// DomainRegistrationInput is domain registration input for validation Api
type DomainRegistrationInput struct {
	ID         *string                            `json:"id,omitempty"`
	Name       *string                            `json:"name,omitempty"`
	Location   *string                            `json:"location,omitempty"`
	Type       *string                            `json:"type,omitempty"`
	Tags       *map[string]*string                `json:"tags,omitempty"`
	Properties *DomainRegistrationInputProperties `json:"properties,omitempty"`
}

// DomainRegistrationInputProperties is
type DomainRegistrationInputProperties struct {
	Name                        *string                `json:"name,omitempty"`
	ContactAdmin                *Contact               `json:"contactAdmin,omitempty"`
	ContactBilling              *Contact               `json:"contactBilling,omitempty"`
	ContactRegistrant           *Contact               `json:"contactRegistrant,omitempty"`
	ContactTech                 *Contact               `json:"contactTech,omitempty"`
	RegistrationStatus          DomainStatus           `json:"registrationStatus,omitempty"`
	ProvisioningState           ProvisioningState      `json:"provisioningState,omitempty"`
	NameServers                 *[]string              `json:"nameServers,omitempty"`
	Privacy                     *bool                  `json:"privacy,omitempty"`
	CreatedTime                 *date.Time             `json:"createdTime,omitempty"`
	ExpirationTime              *date.Time             `json:"expirationTime,omitempty"`
	LastRenewedTime             *date.Time             `json:"lastRenewedTime,omitempty"`
	AutoRenew                   *bool                  `json:"autoRenew,omitempty"`
	ReadyForDNSRecordManagement *bool                  `json:"readyForDnsRecordManagement,omitempty"`
	ManagedHostNames            *[]HostName            `json:"managedHostNames,omitempty"`
	Consent                     *DomainPurchaseConsent `json:"consent,omitempty"`
}

// EnabledConfig is enabled configuration
type EnabledConfig struct {
	Enabled *bool `json:"enabled,omitempty"`
}

// Experiments is class containing Routing in production experiments
type Experiments struct {
	RampUpRules *[]RampUpRule `json:"rampUpRules,omitempty"`
}

// FileSystemApplicationLogsConfig is application logs to file system
// configuration
type FileSystemApplicationLogsConfig struct {
	Level LogLevel `json:"level,omitempty"`
}

// FileSystemHTTPLogsConfig is http logs to file system configuration
type FileSystemHTTPLogsConfig struct {
	RetentionInMb   *int32 `json:"retentionInMb,omitempty"`
	RetentionInDays *int32 `json:"retentionInDays,omitempty"`
	Enabled         *bool  `json:"enabled,omitempty"`
}

// GeoRegion is geographical region
type GeoRegion struct {
	ID         *string              `json:"id,omitempty"`
	Name       *string              `json:"name,omitempty"`
	Location   *string              `json:"location,omitempty"`
	Type       *string              `json:"type,omitempty"`
	Tags       *map[string]*string  `json:"tags,omitempty"`
	Properties *GeoRegionProperties `json:"properties,omitempty"`
}

// GeoRegionCollection is collection of geo regions
type GeoRegionCollection struct {
	autorest.Response `json:"-"`
	Value             *[]GeoRegion `json:"value,omitempty"`
	NextLink          *string      `json:"nextLink,omitempty"`
}

// GeoRegionProperties is
type GeoRegionProperties struct {
	Name        *string `json:"name,omitempty"`
	Description *string `json:"description,omitempty"`
	DisplayName *string `json:"displayName,omitempty"`
}

// HandlerMapping is the IIS handler mappings used to define which handler
// processes HTTP requests with certain extension.
// For example it is used to configure php-cgi.exe process to
// handle all HTTP requests with *.php extension.
type HandlerMapping struct {
	Extension       *string `json:"extension,omitempty"`
	ScriptProcessor *string `json:"scriptProcessor,omitempty"`
	Arguments       *string `json:"arguments,omitempty"`
}

// HostingEnvironment is description of an hostingEnvironment (App Service
// Environment)
type HostingEnvironment struct {
	autorest.Response `json:"-"`
	ID                *string                       `json:"id,omitempty"`
	Name              *string                       `json:"name,omitempty"`
	Location          *string                       `json:"location,omitempty"`
	Type              *string                       `json:"type,omitempty"`
	Tags              *map[string]*string           `json:"tags,omitempty"`
	Properties        *HostingEnvironmentProperties `json:"properties,omitempty"`
}

// HostingEnvironmentCollection is collection of hosting environments (App
// Service Environments)
type HostingEnvironmentCollection struct {
	autorest.Response `json:"-"`
	Value             *[]HostingEnvironment `json:"value,omitempty"`
	NextLink          *string               `json:"nextLink,omitempty"`
}

// HostingEnvironmentDiagnostics is diagnostics for a hosting environment (App
// Service Environment)
type HostingEnvironmentDiagnostics struct {
	autorest.Response `json:"-"`
	Name              *string `json:"name,omitempty"`
	DiagnosicsOutput  *string `json:"diagnosicsOutput,omitempty"`
}

// HostingEnvironmentProfile is specification for a hostingEnvironment (App
// Service Environment) to use for this resource
type HostingEnvironmentProfile struct {
	ID   *string `json:"id,omitempty"`
	Name *string `json:"name,omitempty"`
	Type *string `json:"type,omitempty"`
}

// HostingEnvironmentProperties is
type HostingEnvironmentProperties struct {
	Name                      *string                      `json:"name,omitempty"`
	Location                  *string                      `json:"location,omitempty"`
	Status                    HostingEnvironmentStatus     `json:"status,omitempty"`
	VnetName                  *string                      `json:"vnetName,omitempty"`
	VnetResourceGroupName     *string                      `json:"vnetResourceGroupName,omitempty"`
	VnetSubnetName            *string                      `json:"vnetSubnetName,omitempty"`
	VirtualNetwork            *VirtualNetworkProfile       `json:"virtualNetwork,omitempty"`
	InternalLoadBalancingMode InternalLoadBalancingMode    `json:"internalLoadBalancingMode,omitempty"`
	MultiSize                 *string                      `json:"multiSize,omitempty"`
	MultiRoleCount            *int32                       `json:"multiRoleCount,omitempty"`
	WorkerPools               *[]WorkerPool                `json:"workerPools,omitempty"`
	IpsslAddressCount         *int32                       `json:"ipsslAddressCount,omitempty"`
	DatabaseEdition           *string                      `json:"databaseEdition,omitempty"`
	DatabaseServiceObjective  *string                      `json:"databaseServiceObjective,omitempty"`
	UpgradeDomains            *int32                       `json:"upgradeDomains,omitempty"`
	SubscriptionID            *string                      `json:"subscriptionId,omitempty"`
	DNSSuffix                 *string                      `json:"dnsSuffix,omitempty"`
	LastAction                *string                      `json:"lastAction,omitempty"`
	LastActionResult          *string                      `json:"lastActionResult,omitempty"`
	AllowedMultiSizes         *string                      `json:"allowedMultiSizes,omitempty"`
	AllowedWorkerSizes        *string                      `json:"allowedWorkerSizes,omitempty"`
	MaximumNumberOfMachines   *int32                       `json:"maximumNumberOfMachines,omitempty"`
	VipMappings               *[]VirtualIPMapping          `json:"vipMappings,omitempty"`
	EnvironmentCapacities     *[]StampCapacity             `json:"environmentCapacities,omitempty"`
	NetworkAccessControlList  *[]NetworkAccessControlEntry `json:"networkAccessControlList,omitempty"`
	EnvironmentIsHealthy      *bool                        `json:"environmentIsHealthy,omitempty"`
	EnvironmentStatus         *string                      `json:"environmentStatus,omitempty"`
	ResourceGroup             *string                      `json:"resourceGroup,omitempty"`
	APIManagementAccountID    *string                      `json:"apiManagementAccountId,omitempty"`
	Suspended                 *bool                        `json:"suspended,omitempty"`
}

// HostName is details of a hostname derived from a domain
type HostName struct {
	Name                        *string                     `json:"name,omitempty"`
	SiteNames                   *[]string                   `json:"siteNames,omitempty"`
	AzureResourceName           *string                     `json:"azureResourceName,omitempty"`
	AzureResourceType           AzureResourceType           `json:"azureResourceType,omitempty"`
	CustomHostNameDNSRecordType CustomHostNameDNSRecordType `json:"customHostNameDnsRecordType,omitempty"`
	HostNameType                HostNameType                `json:"hostNameType,omitempty"`
}

// HostNameBinding is a host name binding object
type HostNameBinding struct {
	autorest.Response `json:"-"`
	ID                *string                    `json:"id,omitempty"`
	Name              *string                    `json:"name,omitempty"`
	Location          *string                    `json:"location,omitempty"`
	Type              *string                    `json:"type,omitempty"`
	Tags              *map[string]*string        `json:"tags,omitempty"`
	Properties        *HostNameBindingProperties `json:"properties,omitempty"`
}

// HostNameBindingCollection is collection of host name bindings
type HostNameBindingCollection struct {
	autorest.Response `json:"-"`
	Value             *[]HostNameBinding `json:"value,omitempty"`
	NextLink          *string            `json:"nextLink,omitempty"`
}

// HostNameBindingProperties is
type HostNameBindingProperties struct {
	Name                        *string                     `json:"name,omitempty"`
	SiteName                    *string                     `json:"siteName,omitempty"`
	DomainID                    *string                     `json:"domainId,omitempty"`
	AzureResourceName           *string                     `json:"azureResourceName,omitempty"`
	AzureResourceType           AzureResourceType           `json:"azureResourceType,omitempty"`
	CustomHostNameDNSRecordType CustomHostNameDNSRecordType `json:"customHostNameDnsRecordType,omitempty"`
	HostNameType                HostNameType                `json:"hostNameType,omitempty"`
}

// HostNameSslState is object that represents a SSL-enabled host name.
type HostNameSslState struct {
	Name       *string  `json:"name,omitempty"`
	SslState   SslState `json:"sslState,omitempty"`
	VirtualIP  *string  `json:"virtualIP,omitempty"`
	Thumbprint *string  `json:"thumbprint,omitempty"`
	ToUpdate   *bool    `json:"toUpdate,omitempty"`
}

// HTTPLogsConfig is http logs configuration
type HTTPLogsConfig struct {
	FileSystem       *FileSystemHTTPLogsConfig       `json:"fileSystem,omitempty"`
	AzureBlobStorage *AzureBlobStorageHTTPLogsConfig `json:"azureBlobStorage,omitempty"`
}

// KeyValuePairStringString is
type KeyValuePairStringString struct {
	Key   *string `json:"key,omitempty"`
	Value *string `json:"value,omitempty"`
}

// ListCsr is
type ListCsr struct {
	autorest.Response `json:"-"`
	Value             *[]Csr `json:"value,omitempty"`
}

// ListHostingEnvironmentDiagnostics is
type ListHostingEnvironmentDiagnostics struct {
	autorest.Response `json:"-"`
	Value             *[]HostingEnvironmentDiagnostics `json:"value,omitempty"`
}

// ListVnetInfo is
type ListVnetInfo struct {
	autorest.Response `json:"-"`
	Value             *[]VnetInfo `json:"value,omitempty"`
}

// ListVnetRoute is
type ListVnetRoute struct {
	autorest.Response `json:"-"`
	Value             *[]VnetRoute `json:"value,omitempty"`
}

// LocalizableString is localizableString object containing the name and a
// localized value.
type LocalizableString struct {
	Value          *string `json:"value,omitempty"`
	LocalizedValue *string `json:"localizedValue,omitempty"`
}

// ManagedHostingEnvironment is description of a managed hosting environment
type ManagedHostingEnvironment struct {
	autorest.Response `json:"-"`
	ID                *string                              `json:"id,omitempty"`
	Name              *string                              `json:"name,omitempty"`
	Location          *string                              `json:"location,omitempty"`
	Type              *string                              `json:"type,omitempty"`
	Tags              *map[string]*string                  `json:"tags,omitempty"`
	Properties        *ManagedHostingEnvironmentProperties `json:"properties,omitempty"`
}

// ManagedHostingEnvironmentCollection is collection of managed hosting
// environments
type ManagedHostingEnvironmentCollection struct {
	autorest.Response `json:"-"`
	Value             *[]ManagedHostingEnvironment `json:"value,omitempty"`
	NextLink          *string                      `json:"nextLink,omitempty"`
}

// ManagedHostingEnvironmentProperties is
type ManagedHostingEnvironmentProperties struct {
	Name                 *string                         `json:"name,omitempty"`
	Location             *string                         `json:"location,omitempty"`
	Status               ManagedHostingEnvironmentStatus `json:"status,omitempty"`
	VirtualNetwork       *VirtualNetworkProfile          `json:"virtualNetwork,omitempty"`
	IpsslAddressCount    *int32                          `json:"ipsslAddressCount,omitempty"`
	DNSSuffix            *string                         `json:"dnsSuffix,omitempty"`
	SubscriptionID       *string                         `json:"subscriptionId,omitempty"`
	ResourceGroup        *string                         `json:"resourceGroup,omitempty"`
	EnvironmentIsHealthy *bool                           `json:"environmentIsHealthy,omitempty"`
	EnvironmentStatus    *string                         `json:"environmentStatus,omitempty"`
	Suspended            *bool                           `json:"suspended,omitempty"`
	APIManagementAccount *string                         `json:"apiManagementAccount,omitempty"`
}

// MetricAvailabilily is class repesenting metrics availability and retention
type MetricAvailabilily struct {
	TimeGrain *string `json:"timeGrain,omitempty"`
	Retention *string `json:"retention,omitempty"`
}

// MetricDefinition is class repesenting metadata for the metrics
type MetricDefinition struct {
	autorest.Response `json:"-"`
	ID                *string                     `json:"id,omitempty"`
	Name              *string                     `json:"name,omitempty"`
	Location          *string                     `json:"location,omitempty"`
	Type              *string                     `json:"type,omitempty"`
	Tags              *map[string]*string         `json:"tags,omitempty"`
	Properties        *MetricDefinitionProperties `json:"properties,omitempty"`
}

// MetricDefinitionCollection is collection of metric defintions
type MetricDefinitionCollection struct {
	autorest.Response `json:"-"`
	Value             *[]MetricDefinition `json:"value,omitempty"`
	NextLink          *string             `json:"nextLink,omitempty"`
}

// MetricDefinitionProperties is
type MetricDefinitionProperties struct {
	Name                   *string               `json:"name,omitempty"`
	Unit                   *string               `json:"unit,omitempty"`
	PrimaryAggregationType *string               `json:"primaryAggregationType,omitempty"`
	MetricAvailabilities   *[]MetricAvailabilily `json:"metricAvailabilities,omitempty"`
	DisplayName            *string               `json:"displayName,omitempty"`
}

// NameIdentifier is identifies an object
type NameIdentifier struct {
	Name *string `json:"name,omitempty"`
}

// NameIdentifierCollection is collection of domain name identifiers
type NameIdentifierCollection struct {
	autorest.Response `json:"-"`
	Value             *[]NameIdentifier `json:"value,omitempty"`
	NextLink          *string           `json:"nextLink,omitempty"`
}

// NameValuePair is name value pair
type NameValuePair struct {
	Name  *string `json:"name,omitempty"`
	Value *string `json:"value,omitempty"`
}

// NetworkAccessControlEntry is
type NetworkAccessControlEntry struct {
	Action       AccessControlEntryAction `json:"action,omitempty"`
	Description  *string                  `json:"description,omitempty"`
	Order        *int32                   `json:"order,omitempty"`
	RemoteSubnet *string                  `json:"remoteSubnet,omitempty"`
}

// NetworkFeatures is this is an object used to store a full view of network
// features (presently VNET integration and Hybrid Connections)
// for a web app.
type NetworkFeatures struct {
	autorest.Response `json:"-"`
	ID                *string                    `json:"id,omitempty"`
	Name              *string                    `json:"name,omitempty"`
	Location          *string                    `json:"location,omitempty"`
	Type              *string                    `json:"type,omitempty"`
	Tags              *map[string]*string        `json:"tags,omitempty"`
	Properties        *NetworkFeaturesProperties `json:"properties,omitempty"`
}

// NetworkFeaturesProperties is
type NetworkFeaturesProperties struct {
	VirtualNetworkName       *string                         `json:"virtualNetworkName,omitempty"`
	VirtualNetworkConnection *VnetInfo                       `json:"virtualNetworkConnection,omitempty"`
	HybridConnections        *[]RelayServiceConnectionEntity `json:"hybridConnections,omitempty"`
}

// PremierAddOnRequest is
type PremierAddOnRequest struct {
	Location   *string                 `json:"location,omitempty"`
	Tags       *map[string]*string     `json:"tags,omitempty"`
	Plan       *ArmPlan                `json:"plan,omitempty"`
	Properties *map[string]interface{} `json:"properties,omitempty"`
	Sku        *SkuDescription         `json:"sku,omitempty"`
}

// RampUpRule is routing rules for ramp up testing. This rule allows to
// redirect static traffic % to a slot or to gradually change routing % based
// on performance
type RampUpRule struct {
	ActionHostName            *string  `json:"actionHostName,omitempty"`
	ReroutePercentage         *float64 `json:"reroutePercentage,omitempty"`
	ChangeStep                *float64 `json:"changeStep,omitempty"`
	ChangeIntervalInMinutes   *int32   `json:"changeIntervalInMinutes,omitempty"`
	MinReroutePercentage      *float64 `json:"minReroutePercentage,omitempty"`
	MaxReroutePercentage      *float64 `json:"maxReroutePercentage,omitempty"`
	ChangeDecisionCallbackURL *string  `json:"changeDecisionCallbackUrl,omitempty"`
	Name                      *string  `json:"name,omitempty"`
}

// ReadCloser is
type ReadCloser struct {
	autorest.Response `json:"-"`
	Value             *io.ReadCloser `json:"value,omitempty"`
}

// RelayServiceConnectionEntity is class that represents a Biztalk Hybrid
// Connection
type RelayServiceConnectionEntity struct {
	autorest.Response `json:"-"`
	ID                *string                                 `json:"id,omitempty"`
	Name              *string                                 `json:"name,omitempty"`
	Location          *string                                 `json:"location,omitempty"`
	Type              *string                                 `json:"type,omitempty"`
	Tags              *map[string]*string                     `json:"tags,omitempty"`
	Properties        *RelayServiceConnectionEntityProperties `json:"properties,omitempty"`
}

// RelayServiceConnectionEntityProperties is
type RelayServiceConnectionEntityProperties struct {
	EntityName               *string `json:"entityName,omitempty"`
	EntityConnectionString   *string `json:"entityConnectionString,omitempty"`
	ResourceType             *string `json:"resourceType,omitempty"`
	ResourceConnectionString *string `json:"resourceConnectionString,omitempty"`
	Hostname                 *string `json:"hostname,omitempty"`
	Port                     *int32  `json:"port,omitempty"`
	BiztalkURI               *string `json:"biztalkUri,omitempty"`
}

// RequestsBasedTrigger is requestsBasedTrigger
type RequestsBasedTrigger struct {
	Count        *int32  `json:"count,omitempty"`
	TimeInterval *string `json:"timeInterval,omitempty"`
}

// Resource is
type Resource struct {
	ID       *string             `json:"id,omitempty"`
	Name     *string             `json:"name,omitempty"`
	Location *string             `json:"location,omitempty"`
	Type     *string             `json:"type,omitempty"`
	Tags     *map[string]*string `json:"tags,omitempty"`
}

// ResourceMetric is object representing a metric for any resource
type ResourceMetric struct {
	Name         *ResourceMetricName         `json:"name,omitempty"`
	Unit         *string                     `json:"unit,omitempty"`
	TimeGrain    *string                     `json:"timeGrain,omitempty"`
	StartTime    *date.Time                  `json:"startTime,omitempty"`
	EndTime      *date.Time                  `json:"endTime,omitempty"`
	ResourceID   *string                     `json:"resourceId,omitempty"`
	MetricValues *[]ResourceMetricValue      `json:"metricValues,omitempty"`
	Properties   *[]KeyValuePairStringString `json:"properties,omitempty"`
}

// ResourceMetricCollection is collection of metric responses
type ResourceMetricCollection struct {
	autorest.Response `json:"-"`
	Value             *[]ResourceMetric `json:"value,omitempty"`
	NextLink          *string           `json:"nextLink,omitempty"`
}

// ResourceMetricName is name of a metric for any resource
type ResourceMetricName struct {
	Value          *string `json:"value,omitempty"`
	LocalizedValue *string `json:"localizedValue,omitempty"`
}

// ResourceMetricValue is value of resource metric
type ResourceMetricValue struct {
	TimeStamp *string  `json:"timeStamp,omitempty"`
	Average   *float64 `json:"average,omitempty"`
	Minimum   *float64 `json:"minimum,omitempty"`
	Maximum   *float64 `json:"maximum,omitempty"`
	Total     *float64 `json:"total,omitempty"`
	Count     *float64 `json:"count,omitempty"`
}

// ResourceNameAvailability is describes if a resource name is available
type ResourceNameAvailability struct {
	autorest.Response `json:"-"`
	NameAvailable     *bool   `json:"nameAvailable,omitempty"`
	Reason            *string `json:"reason,omitempty"`
	Message           *string `json:"message,omitempty"`
}

// ResourceNameAvailabilityRequest is resource name availability request
// content
type ResourceNameAvailabilityRequest struct {
	Name   *string `json:"name,omitempty"`
	Type   *string `json:"type,omitempty"`
	IsFqdn *bool   `json:"isFqdn,omitempty"`
}

// RestoreRequest is description of a restore request
type RestoreRequest struct {
	autorest.Response `json:"-"`
	ID                *string                   `json:"id,omitempty"`
	Name              *string                   `json:"name,omitempty"`
	Location          *string                   `json:"location,omitempty"`
	Type              *string                   `json:"type,omitempty"`
	Tags              *map[string]*string       `json:"tags,omitempty"`
	Properties        *RestoreRequestProperties `json:"properties,omitempty"`
}

// RestoreRequestProperties is
type RestoreRequestProperties struct {
	StorageAccountURL          *string                    `json:"storageAccountUrl,omitempty"`
	BlobName                   *string                    `json:"blobName,omitempty"`
	Overwrite                  *bool                      `json:"overwrite,omitempty"`
	SiteName                   *string                    `json:"siteName,omitempty"`
	Databases                  *[]DatabaseBackupSetting   `json:"databases,omitempty"`
	IgnoreConflictingHostNames *bool                      `json:"ignoreConflictingHostNames,omitempty"`
	OperationType              BackupRestoreOperationType `json:"operationType,omitempty"`
	AdjustConnectionStrings    *bool                      `json:"adjustConnectionStrings,omitempty"`
	HostingEnvironment         *string                    `json:"hostingEnvironment,omitempty"`
}

// RestoreResponse is response for a restore site request
type RestoreResponse struct {
	autorest.Response `json:"-"`
	ID                *string                    `json:"id,omitempty"`
	Name              *string                    `json:"name,omitempty"`
	Location          *string                    `json:"location,omitempty"`
	Type              *string                    `json:"type,omitempty"`
	Tags              *map[string]*string        `json:"tags,omitempty"`
	Properties        *RestoreResponseProperties `json:"properties,omitempty"`
}

// RestoreResponseProperties is
type RestoreResponseProperties struct {
	OperationID *string `json:"operationId,omitempty"`
}

// RoutingRule is routing rules for TiP
type RoutingRule struct {
	Name *string `json:"name,omitempty"`
}

// ServerFarmCollection is collection of serverfarms
type ServerFarmCollection struct {
	autorest.Response `json:"-"`
	Value             *[]ServerFarmWithRichSku `json:"value,omitempty"`
	NextLink          *string                  `json:"nextLink,omitempty"`
}

// ServerFarmWithRichSku is app Service Plan Model
type ServerFarmWithRichSku struct {
	autorest.Response `json:"-"`
	ID                *string                          `json:"id,omitempty"`
	Name              *string                          `json:"name,omitempty"`
	Location          *string                          `json:"location,omitempty"`
	Type              *string                          `json:"type,omitempty"`
	Tags              *map[string]*string              `json:"tags,omitempty"`
	Properties        *ServerFarmWithRichSkuProperties `json:"properties,omitempty"`
	Sku               *SkuDescription                  `json:"sku,omitempty"`
}

// ServerFarmWithRichSkuProperties is
type ServerFarmWithRichSkuProperties struct {
	Name                      *string                    `json:"name,omitempty"`
	Status                    StatusOptions              `json:"status,omitempty"`
	Subscription              *string                    `json:"subscription,omitempty"`
	AdminSiteName             *string                    `json:"adminSiteName,omitempty"`
	HostingEnvironmentProfile *HostingEnvironmentProfile `json:"hostingEnvironmentProfile,omitempty"`
	MaximumNumberOfWorkers    *int32                     `json:"maximumNumberOfWorkers,omitempty"`
	GeoRegion                 *string                    `json:"geoRegion,omitempty"`
	PerSiteScaling            *bool                      `json:"perSiteScaling,omitempty"`
	NumberOfSites             *int32                     `json:"numberOfSites,omitempty"`
	ResourceGroup             *string                    `json:"resourceGroup,omitempty"`
}

// SetObject is
type SetObject struct {
	autorest.Response `json:"-"`
	Value             *map[string]interface{} `json:"value,omitempty"`
}

// Site is represents a web app
type Site struct {
	autorest.Response `json:"-"`
	ID                *string             `json:"id,omitempty"`
	Name              *string             `json:"name,omitempty"`
	Location          *string             `json:"location,omitempty"`
	Type              *string             `json:"type,omitempty"`
	Tags              *map[string]*string `json:"tags,omitempty"`
	Properties        *SiteProperties     `json:"properties,omitempty"`
}

// SiteAuthSettings is configuration settings for the Azure App Service
// Authentication / Authorization feature.
type SiteAuthSettings struct {
	autorest.Response            `json:"-"`
	Enabled                      *bool                         `json:"enabled,omitempty"`
	HTTPAPIPrefixPath            *string                       `json:"httpApiPrefixPath,omitempty"`
	UnauthenticatedClientAction  UnauthenticatedClientAction   `json:"unauthenticatedClientAction,omitempty"`
	TokenStoreEnabled            *bool                         `json:"tokenStoreEnabled,omitempty"`
	AllowedExternalRedirectUrls  *[]string                     `json:"allowedExternalRedirectUrls,omitempty"`
	DefaultProvider              BuiltInAuthenticationProvider `json:"defaultProvider,omitempty"`
	ClientID                     *string                       `json:"clientId,omitempty"`
	ClientSecret                 *string                       `json:"clientSecret,omitempty"`
	Issuer                       *string                       `json:"issuer,omitempty"`
	AllowedAudiences             *[]string                     `json:"allowedAudiences,omitempty"`
	AadClientID                  *string                       `json:"aadClientId,omitempty"`
	OpenIDIssuer                 *string                       `json:"openIdIssuer,omitempty"`
	GoogleClientID               *string                       `json:"googleClientId,omitempty"`
	GoogleClientSecret           *string                       `json:"googleClientSecret,omitempty"`
	GoogleOAuthScopes            *[]string                     `json:"googleOAuthScopes,omitempty"`
	FacebookAppID                *string                       `json:"facebookAppId,omitempty"`
	FacebookAppSecret            *string                       `json:"facebookAppSecret,omitempty"`
	FacebookOAuthScopes          *[]string                     `json:"facebookOAuthScopes,omitempty"`
	TwitterConsumerKey           *string                       `json:"twitterConsumerKey,omitempty"`
	TwitterConsumerSecret        *string                       `json:"twitterConsumerSecret,omitempty"`
	MicrosoftAccountClientID     *string                       `json:"microsoftAccountClientId,omitempty"`
	MicrosoftAccountClientSecret *string                       `json:"microsoftAccountClientSecret,omitempty"`
	MicrosoftAccountOAuthScopes  *[]string                     `json:"microsoftAccountOAuthScopes,omitempty"`
}

// SiteCollection is collection of sites
type SiteCollection struct {
	autorest.Response `json:"-"`
	Value             *[]Site `json:"value,omitempty"`
	NextLink          *string `json:"nextLink,omitempty"`
}

// SiteCollectionPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client SiteCollection) SiteCollectionPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// SiteConfig is configuration of Azure web site
type SiteConfig struct {
	autorest.Response `json:"-"`
	ID                *string               `json:"id,omitempty"`
	Name              *string               `json:"name,omitempty"`
	Location          *string               `json:"location,omitempty"`
	Type              *string               `json:"type,omitempty"`
	Tags              *map[string]*string   `json:"tags,omitempty"`
	Properties        *SiteConfigProperties `json:"properties,omitempty"`
}

// SiteConfigProperties is
type SiteConfigProperties struct {
	NumberOfWorkers              *int32                `json:"numberOfWorkers,omitempty"`
	DefaultDocuments             *[]string             `json:"defaultDocuments,omitempty"`
	NetFrameworkVersion          *string               `json:"netFrameworkVersion,omitempty"`
	PhpVersion                   *string               `json:"phpVersion,omitempty"`
	PythonVersion                *string               `json:"pythonVersion,omitempty"`
	RequestTracingEnabled        *bool                 `json:"requestTracingEnabled,omitempty"`
	RequestTracingExpirationTime *date.Time            `json:"requestTracingExpirationTime,omitempty"`
	RemoteDebuggingEnabled       *bool                 `json:"remoteDebuggingEnabled,omitempty"`
	RemoteDebuggingVersion       *string               `json:"remoteDebuggingVersion,omitempty"`
	HTTPLoggingEnabled           *bool                 `json:"httpLoggingEnabled,omitempty"`
	LogsDirectorySizeLimit       *int32                `json:"logsDirectorySizeLimit,omitempty"`
	DetailedErrorLoggingEnabled  *bool                 `json:"detailedErrorLoggingEnabled,omitempty"`
	PublishingUsername           *string               `json:"publishingUsername,omitempty"`
	PublishingPassword           *string               `json:"publishingPassword,omitempty"`
	AppSettings                  *[]NameValuePair      `json:"appSettings,omitempty"`
	Metadata                     *[]NameValuePair      `json:"metadata,omitempty"`
	ConnectionStrings            *[]ConnStringInfo     `json:"connectionStrings,omitempty"`
	HandlerMappings              *[]HandlerMapping     `json:"handlerMappings,omitempty"`
	DocumentRoot                 *string               `json:"documentRoot,omitempty"`
	ScmType                      *string               `json:"scmType,omitempty"`
	Use32BitWorkerProcess        *bool                 `json:"use32BitWorkerProcess,omitempty"`
	WebSocketsEnabled            *bool                 `json:"webSocketsEnabled,omitempty"`
	AlwaysOn                     *bool                 `json:"alwaysOn,omitempty"`
	JavaVersion                  *string               `json:"javaVersion,omitempty"`
	JavaContainer                *string               `json:"javaContainer,omitempty"`
	JavaContainerVersion         *string               `json:"javaContainerVersion,omitempty"`
	ManagedPipelineMode          ManagedPipelineMode   `json:"managedPipelineMode,omitempty"`
	VirtualApplications          *[]VirtualApplication `json:"virtualApplications,omitempty"`
	LoadBalancing                SiteLoadBalancing     `json:"loadBalancing,omitempty"`
	Experiments                  *Experiments          `json:"experiments,omitempty"`
	Limits                       *SiteLimits           `json:"limits,omitempty"`
	AutoHealEnabled              *bool                 `json:"autoHealEnabled,omitempty"`
	AutoHealRules                *AutoHealRules        `json:"autoHealRules,omitempty"`
	TracingOptions               *string               `json:"tracingOptions,omitempty"`
	VnetName                     *string               `json:"vnetName,omitempty"`
	Cors                         *CorsSettings         `json:"cors,omitempty"`
	APIDefinition                *APIDefinitionInfo    `json:"apiDefinition,omitempty"`
	AutoSwapSlotName             *string               `json:"autoSwapSlotName,omitempty"`
}

// SiteInstance is instance of a web app
type SiteInstance struct {
	ID         *string                 `json:"id,omitempty"`
	Name       *string                 `json:"name,omitempty"`
	Location   *string                 `json:"location,omitempty"`
	Type       *string                 `json:"type,omitempty"`
	Tags       *map[string]*string     `json:"tags,omitempty"`
	Properties *SiteInstanceProperties `json:"properties,omitempty"`
}

// SiteInstanceCollection is collection of site instances
type SiteInstanceCollection struct {
	autorest.Response `json:"-"`
	Value             *[]SiteInstance `json:"value,omitempty"`
	NextLink          *string         `json:"nextLink,omitempty"`
}

// SiteInstanceProperties is
type SiteInstanceProperties struct {
	Name *string `json:"name,omitempty"`
}

// SiteLimits is represents metric limits set on a web app.
type SiteLimits struct {
	MaxPercentageCPU *float64 `json:"maxPercentageCpu,omitempty"`
	MaxMemoryInMb    *int64   `json:"maxMemoryInMb,omitempty"`
	MaxDiskSizeInMb  *int64   `json:"maxDiskSizeInMb,omitempty"`
}

// SiteLogsConfig is configuration of Azure web site
type SiteLogsConfig struct {
	autorest.Response `json:"-"`
	ID                *string                   `json:"id,omitempty"`
	Name              *string                   `json:"name,omitempty"`
	Location          *string                   `json:"location,omitempty"`
	Type              *string                   `json:"type,omitempty"`
	Tags              *map[string]*string       `json:"tags,omitempty"`
	Properties        *SiteLogsConfigProperties `json:"properties,omitempty"`
}

// SiteLogsConfigProperties is
type SiteLogsConfigProperties struct {
	ApplicationLogs       *ApplicationLogsConfig `json:"applicationLogs,omitempty"`
	HTTPLogs              *HTTPLogsConfig        `json:"httpLogs,omitempty"`
	FailedRequestsTracing *EnabledConfig         `json:"failedRequestsTracing,omitempty"`
	DetailedErrorMessages *EnabledConfig         `json:"detailedErrorMessages,omitempty"`
}

// SiteProperties is
type SiteProperties struct {
	Name                      *string                    `json:"name,omitempty"`
	State                     *string                    `json:"state,omitempty"`
	HostNames                 *[]string                  `json:"hostNames,omitempty"`
	RepositorySiteName        *string                    `json:"repositorySiteName,omitempty"`
	UsageState                UsageState                 `json:"usageState,omitempty"`
	Enabled                   *bool                      `json:"enabled,omitempty"`
	EnabledHostNames          *[]string                  `json:"enabledHostNames,omitempty"`
	AvailabilityState         SiteAvailabilityState      `json:"availabilityState,omitempty"`
	HostNameSslStates         *[]HostNameSslState        `json:"hostNameSslStates,omitempty"`
	ServerFarmID              *string                    `json:"serverFarmId,omitempty"`
	LastModifiedTimeUtc       *date.Time                 `json:"lastModifiedTimeUtc,omitempty"`
	SiteConfig                *SiteConfig                `json:"siteConfig,omitempty"`
	TrafficManagerHostNames   *[]string                  `json:"trafficManagerHostNames,omitempty"`
	PremiumAppDeployed        *bool                      `json:"premiumAppDeployed,omitempty"`
	ScmSiteAlsoStopped        *bool                      `json:"scmSiteAlsoStopped,omitempty"`
	TargetSwapSlot            *string                    `json:"targetSwapSlot,omitempty"`
	HostingEnvironmentProfile *HostingEnvironmentProfile `json:"hostingEnvironmentProfile,omitempty"`
	MicroService              *string                    `json:"microService,omitempty"`
	GatewaySiteName           *string                    `json:"gatewaySiteName,omitempty"`
	ClientAffinityEnabled     *bool                      `json:"clientAffinityEnabled,omitempty"`
	ClientCertEnabled         *bool                      `json:"clientCertEnabled,omitempty"`
	HostNamesDisabled         *bool                      `json:"hostNamesDisabled,omitempty"`
	OutboundIPAddresses       *string                    `json:"outboundIpAddresses,omitempty"`
	CloningInfo               *CloningInfo               `json:"cloningInfo,omitempty"`
}

// SitePropertiesModel is
type SitePropertiesModel struct {
	Metadata    *[]NameValuePair `json:"metadata,omitempty"`
	Properties  *[]NameValuePair `json:"properties,omitempty"`
	AppSettings *[]NameValuePair `json:"appSettings,omitempty"`
}

// SiteSourceControl is describes the source control configuration for web app
type SiteSourceControl struct {
	autorest.Response `json:"-"`
	ID                *string                      `json:"id,omitempty"`
	Name              *string                      `json:"name,omitempty"`
	Location          *string                      `json:"location,omitempty"`
	Type              *string                      `json:"type,omitempty"`
	Tags              *map[string]*string          `json:"tags,omitempty"`
	Properties        *SiteSourceControlProperties `json:"properties,omitempty"`
}

// SiteSourceControlProperties is
type SiteSourceControlProperties struct {
	RepoURL                   *string `json:"repoUrl,omitempty"`
	Branch                    *string `json:"branch,omitempty"`
	IsManualIntegration       *bool   `json:"isManualIntegration,omitempty"`
	DeploymentRollbackEnabled *bool   `json:"deploymentRollbackEnabled,omitempty"`
	IsMercurial               *bool   `json:"isMercurial,omitempty"`
}

// SkuCapacity is description of the App Service Plan scale options
type SkuCapacity struct {
	Minimum   *int32  `json:"minimum,omitempty"`
	Maximum   *int32  `json:"maximum,omitempty"`
	Default   *int32  `json:"default,omitempty"`
	ScaleType *string `json:"scaleType,omitempty"`
}

// SkuDescription is describes a sku for a scalable resource
type SkuDescription struct {
	Name     *string `json:"name,omitempty"`
	Tier     *string `json:"tier,omitempty"`
	Size     *string `json:"size,omitempty"`
	Family   *string `json:"family,omitempty"`
	Capacity *int32  `json:"capacity,omitempty"`
}

// SkuInfo is sku discovery information
type SkuInfo struct {
	ResourceType *string         `json:"resourceType,omitempty"`
	Sku          *SkuDescription `json:"sku,omitempty"`
	Capacity     *SkuCapacity    `json:"capacity,omitempty"`
}

// SkuInfoCollection is collection of SkuInfos
type SkuInfoCollection struct {
	autorest.Response `json:"-"`
	Value             *[]SkuInfo `json:"value,omitempty"`
	NextLink          *string    `json:"nextLink,omitempty"`
}

// SlotConfigNames is class containing names for connection strings and
// application settings to be marked as sticky to the slot
// and not moved during swap operation
// This is valid for all deployment slots under the site
type SlotConfigNames struct {
	ConnectionStringNames *[]string `json:"connectionStringNames,omitempty"`
	AppSettingNames       *[]string `json:"appSettingNames,omitempty"`
}

// SlotConfigNamesResource is slot Config names azure resource
type SlotConfigNamesResource struct {
	autorest.Response `json:"-"`
	ID                *string                            `json:"id,omitempty"`
	Name              *string                            `json:"name,omitempty"`
	Location          *string                            `json:"location,omitempty"`
	Type              *string                            `json:"type,omitempty"`
	Tags              *map[string]*string                `json:"tags,omitempty"`
	Properties        *SlotConfigNamesResourceProperties `json:"properties,omitempty"`
}

// SlotConfigNamesResourceProperties is
type SlotConfigNamesResourceProperties struct {
	ConnectionStringNames *[]string `json:"connectionStringNames,omitempty"`
	AppSettingNames       *[]string `json:"appSettingNames,omitempty"`
}

// SlotDifference is an object describing the difference in setting values
// between two web app slots
type SlotDifference struct {
	ID         *string                   `json:"id,omitempty"`
	Name       *string                   `json:"name,omitempty"`
	Location   *string                   `json:"location,omitempty"`
	Type       *string                   `json:"type,omitempty"`
	Tags       *map[string]*string       `json:"tags,omitempty"`
	Properties *SlotDifferenceProperties `json:"properties,omitempty"`
}

// SlotDifferenceCollection is collection of Slot Differences
type SlotDifferenceCollection struct {
	autorest.Response `json:"-"`
	Value             *[]SlotDifference `json:"value,omitempty"`
	NextLink          *string           `json:"nextLink,omitempty"`
}

// SlotDifferenceProperties is
type SlotDifferenceProperties struct {
	Type               *string `json:"type,omitempty"`
	SettingType        *string `json:"settingType,omitempty"`
	DiffRule           *string `json:"diffRule,omitempty"`
	SettingName        *string `json:"settingName,omitempty"`
	ValueInCurrentSlot *string `json:"valueInCurrentSlot,omitempty"`
	ValueInTargetSlot  *string `json:"valueInTargetSlot,omitempty"`
	Description        *string `json:"description,omitempty"`
}

// SlowRequestsBasedTrigger is slowRequestsBasedTrigger
type SlowRequestsBasedTrigger struct {
	TimeTaken    *string `json:"timeTaken,omitempty"`
	Count        *int32  `json:"count,omitempty"`
	TimeInterval *string `json:"timeInterval,omitempty"`
}

// SourceControl is describes the Source Control OAuth Token
type SourceControl struct {
	autorest.Response `json:"-"`
	ID                *string                  `json:"id,omitempty"`
	Name              *string                  `json:"name,omitempty"`
	Location          *string                  `json:"location,omitempty"`
	Type              *string                  `json:"type,omitempty"`
	Tags              *map[string]*string      `json:"tags,omitempty"`
	Properties        *SourceControlProperties `json:"properties,omitempty"`
}

// SourceControlCollection is collection of soure controls
type SourceControlCollection struct {
	autorest.Response `json:"-"`
	Value             *[]SourceControl `json:"value,omitempty"`
	NextLink          *string          `json:"nextLink,omitempty"`
}

// SourceControlProperties is
type SourceControlProperties struct {
	Name           *string    `json:"name,omitempty"`
	Token          *string    `json:"token,omitempty"`
	TokenSecret    *string    `json:"tokenSecret,omitempty"`
	RefreshToken   *string    `json:"refreshToken,omitempty"`
	ExpirationTime *date.Time `json:"expirationTime,omitempty"`
}

// StampCapacity is class containing stamp capacity information
type StampCapacity struct {
	Name                           *string            `json:"name,omitempty"`
	AvailableCapacity              *int64             `json:"availableCapacity,omitempty"`
	TotalCapacity                  *int64             `json:"totalCapacity,omitempty"`
	Unit                           *string            `json:"unit,omitempty"`
	ComputeMode                    ComputeModeOptions `json:"computeMode,omitempty"`
	WorkerSize                     WorkerSizeOptions  `json:"workerSize,omitempty"`
	WorkerSizeID                   *int32             `json:"workerSizeId,omitempty"`
	ExcludeFromCapacityAllocation  *bool              `json:"excludeFromCapacityAllocation,omitempty"`
	IsApplicableForAllComputeModes *bool              `json:"isApplicableForAllComputeModes,omitempty"`
	SiteMode                       *string            `json:"siteMode,omitempty"`
}

// StampCapacityCollection is collection of stamp capacities
type StampCapacityCollection struct {
	autorest.Response `json:"-"`
	Value             *[]StampCapacity `json:"value,omitempty"`
	NextLink          *string          `json:"nextLink,omitempty"`
}

// StatusCodesBasedTrigger is statusCodeBasedTrigger
type StatusCodesBasedTrigger struct {
	Status       *int32  `json:"status,omitempty"`
	SubStatus    *int32  `json:"subStatus,omitempty"`
	Win32Status  *int32  `json:"win32Status,omitempty"`
	Count        *int32  `json:"count,omitempty"`
	TimeInterval *string `json:"timeInterval,omitempty"`
}

// StringDictionary is string dictionary resource
type StringDictionary struct {
	autorest.Response `json:"-"`
	ID                *string             `json:"id,omitempty"`
	Name              *string             `json:"name,omitempty"`
	Location          *string             `json:"location,omitempty"`
	Type              *string             `json:"type,omitempty"`
	Tags              *map[string]*string `json:"tags,omitempty"`
	Properties        *map[string]*string `json:"properties,omitempty"`
}

// TldLegalAgreement is represents a legal agreement for top level domain
type TldLegalAgreement struct {
	AgreementKey *string `json:"agreementKey,omitempty"`
	Title        *string `json:"title,omitempty"`
	Content      *string `json:"content,omitempty"`
	URL          *string `json:"url,omitempty"`
}

// TldLegalAgreementCollection is collection of Tld Legal Agreements
type TldLegalAgreementCollection struct {
	autorest.Response `json:"-"`
	Value             *[]TldLegalAgreement `json:"value,omitempty"`
	NextLink          *string              `json:"nextLink,omitempty"`
}

// TopLevelDomain is a top level domain object
type TopLevelDomain struct {
	autorest.Response `json:"-"`
	ID                *string                   `json:"id,omitempty"`
	Name              *string                   `json:"name,omitempty"`
	Location          *string                   `json:"location,omitempty"`
	Type              *string                   `json:"type,omitempty"`
	Tags              *map[string]*string       `json:"tags,omitempty"`
	Properties        *TopLevelDomainProperties `json:"properties,omitempty"`
}

// TopLevelDomainAgreementOption is options for retrieving the list of top
// level domain legal agreements
type TopLevelDomainAgreementOption struct {
	IncludePrivacy *bool `json:"includePrivacy,omitempty"`
}

// TopLevelDomainCollection is collection of Top Level Domains
type TopLevelDomainCollection struct {
	autorest.Response `json:"-"`
	Value             *[]TopLevelDomain `json:"value,omitempty"`
	NextLink          *string           `json:"nextLink,omitempty"`
}

// TopLevelDomainProperties is
type TopLevelDomainProperties struct {
	Name    *string `json:"name,omitempty"`
	Privacy *bool   `json:"privacy,omitempty"`
}

// Usage is class that represents usage of the quota resource.
type Usage struct {
	ID         *string             `json:"id,omitempty"`
	Name       *string             `json:"name,omitempty"`
	Location   *string             `json:"location,omitempty"`
	Type       *string             `json:"type,omitempty"`
	Tags       *map[string]*string `json:"tags,omitempty"`
	Properties *UsageProperties    `json:"properties,omitempty"`
}

// UsageCollection is collection of usages
type UsageCollection struct {
	autorest.Response `json:"-"`
	Value             *[]Usage `json:"value,omitempty"`
	NextLink          *string  `json:"nextLink,omitempty"`
}

// UsageProperties is
type UsageProperties struct {
	DisplayName   *string            `json:"displayName,omitempty"`
	Name          *string            `json:"name,omitempty"`
	ResourceName  *string            `json:"resourceName,omitempty"`
	Unit          *string            `json:"unit,omitempty"`
	CurrentValue  *int64             `json:"currentValue,omitempty"`
	Limit         *int64             `json:"limit,omitempty"`
	NextResetTime *date.Time         `json:"nextResetTime,omitempty"`
	ComputeMode   ComputeModeOptions `json:"computeMode,omitempty"`
	SiteMode      *string            `json:"siteMode,omitempty"`
}

// User is represents user crendentials used for publishing activity
type User struct {
	autorest.Response `json:"-"`
	ID                *string             `json:"id,omitempty"`
	Name              *string             `json:"name,omitempty"`
	Location          *string             `json:"location,omitempty"`
	Type              *string             `json:"type,omitempty"`
	Tags              *map[string]*string `json:"tags,omitempty"`
	Properties        *UserProperties     `json:"properties,omitempty"`
}

// UserProperties is
type UserProperties struct {
	Name               *string `json:"name,omitempty"`
	PublishingUserName *string `json:"publishingUserName,omitempty"`
	PublishingPassword *string `json:"publishingPassword,omitempty"`
}

// VirtualApplication is
type VirtualApplication struct {
	VirtualPath        *string             `json:"virtualPath,omitempty"`
	PhysicalPath       *string             `json:"physicalPath,omitempty"`
	PreloadEnabled     *bool               `json:"preloadEnabled,omitempty"`
	VirtualDirectories *[]VirtualDirectory `json:"virtualDirectories,omitempty"`
}

// VirtualDirectory is
type VirtualDirectory struct {
	VirtualPath  *string `json:"virtualPath,omitempty"`
	PhysicalPath *string `json:"physicalPath,omitempty"`
}

// VirtualIPMapping is class that represents a VIP mapping
type VirtualIPMapping struct {
	VirtualIP         *string `json:"virtualIP,omitempty"`
	InternalHTTPPort  *int32  `json:"internalHttpPort,omitempty"`
	InternalHTTPSPort *int32  `json:"internalHttpsPort,omitempty"`
	InUse             *bool   `json:"inUse,omitempty"`
}

// VirtualNetworkProfile is specification for using a virtual network
type VirtualNetworkProfile struct {
	ID     *string `json:"id,omitempty"`
	Name   *string `json:"name,omitempty"`
	Type   *string `json:"type,omitempty"`
	Subnet *string `json:"subnet,omitempty"`
}

// VnetGateway is the VnetGateway contract. This is used to give the vnet
// gateway access to the VPN package.
type VnetGateway struct {
	autorest.Response `json:"-"`
	ID                *string                `json:"id,omitempty"`
	Name              *string                `json:"name,omitempty"`
	Location          *string                `json:"location,omitempty"`
	Type              *string                `json:"type,omitempty"`
	Tags              *map[string]*string    `json:"tags,omitempty"`
	Properties        *VnetGatewayProperties `json:"properties,omitempty"`
}

// VnetGatewayProperties is
type VnetGatewayProperties struct {
	VnetName      *string `json:"vnetName,omitempty"`
	VpnPackageURI *string `json:"vpnPackageUri,omitempty"`
}

// VnetInfo is vNETInfo contract. This contract is public and is a stripped
// down version of VNETInfoInternal
type VnetInfo struct {
	autorest.Response `json:"-"`
	ID                *string             `json:"id,omitempty"`
	Name              *string             `json:"name,omitempty"`
	Location          *string             `json:"location,omitempty"`
	Type              *string             `json:"type,omitempty"`
	Tags              *map[string]*string `json:"tags,omitempty"`
	Properties        *VnetInfoProperties `json:"properties,omitempty"`
}

// VnetInfoProperties is
type VnetInfoProperties struct {
	VnetResourceID *string      `json:"vnetResourceId,omitempty"`
	CertThumbprint *string      `json:"certThumbprint,omitempty"`
	CertBlob       *string      `json:"certBlob,omitempty"`
	Routes         *[]VnetRoute `json:"routes,omitempty"`
}

// VnetRoute is vnetRoute contract used to pass routing information for a vnet.
type VnetRoute struct {
	autorest.Response `json:"-"`
	ID                *string              `json:"id,omitempty"`
	Name              *string              `json:"name,omitempty"`
	Location          *string              `json:"location,omitempty"`
	Type              *string              `json:"type,omitempty"`
	Tags              *map[string]*string  `json:"tags,omitempty"`
	Properties        *VnetRouteProperties `json:"properties,omitempty"`
}

// VnetRouteProperties is
type VnetRouteProperties struct {
	Name         *string `json:"name,omitempty"`
	StartAddress *string `json:"startAddress,omitempty"`
	EndAddress   *string `json:"endAddress,omitempty"`
	RouteType    *string `json:"routeType,omitempty"`
}

// WorkerPool is worker pool of a hostingEnvironment (App Service Environment)
type WorkerPool struct {
	autorest.Response `json:"-"`
	ID                *string               `json:"id,omitempty"`
	Name              *string               `json:"name,omitempty"`
	Location          *string               `json:"location,omitempty"`
	Type              *string               `json:"type,omitempty"`
	Tags              *map[string]*string   `json:"tags,omitempty"`
	Properties        *WorkerPoolProperties `json:"properties,omitempty"`
	Sku               *SkuDescription       `json:"sku,omitempty"`
}

// WorkerPoolCollection is collection of worker pools
type WorkerPoolCollection struct {
	autorest.Response `json:"-"`
	Value             *[]WorkerPool `json:"value,omitempty"`
	NextLink          *string       `json:"nextLink,omitempty"`
}

// WorkerPoolProperties is
type WorkerPoolProperties struct {
	WorkerSizeID  *int32             `json:"workerSizeId,omitempty"`
	ComputeMode   ComputeModeOptions `json:"computeMode,omitempty"`
	WorkerSize    *string            `json:"workerSize,omitempty"`
	WorkerCount   *int32             `json:"workerCount,omitempty"`
	InstanceNames *[]string          `json:"instanceNames,omitempty"`
}
