// -*-C++-*-
// This file is part of the gmod package
// Copyright (C) 1997 by Andrew J. Robinson

#ifndef xmH
#define xmH

#include "Sample.h"
#include "Envelope.h"

class XM_sample : public Sample
{
public:
  int load(Sequencer &, FILE *, int, int, void *, void *);
  int volumeEnvelopeY(int &a, char c, unsigned short *b) const
  { return volumeEnvelope.getY(a, c, b); }
  int panEnvelopeY(int &a, char c) const { return panEnvelope.getY(a, c); }
  void decode(char *) const;
  int pan() const { return panning_; }
  int vibratoDepth() const { return vibratoDepth_; }
  int vibratoRate() const { return vibratoRate_; }
  int vibratoType() const { return vibratoType_; }

private:
  Envelope volumeEnvelope;
  Envelope panEnvelope;
  unsigned char panning_;
  unsigned char vibratoType_;
  //unsigned char vibratoSweep_;
  unsigned char vibratoDepth_;
  unsigned char vibratoRate_;
};

#endif
