/*
   Copyright (c) 2004, 2005 by AOSASA Shigeru and Red Hat, Inc.
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions are
   met:

   - Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.

   - Redistributions in binary form must reproduce the above
   copyright notice, this list of conditions and the following
   disclaimer in the documentation and/or other materials provided
   with the distribution.  

   - Neither the name of the AOSASA Shigeru, Red Hat, Inc
   nor the names of its contributors may be used to endorse or
   promote products derived from this software without specific
   prior written permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
   FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
   COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
   INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
   (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
   SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
   HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
   STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
   OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/*
   This software development was supported by
   Information-technorogy Promotion Agency, Japan (IPA).
*/

#ifndef __G_INSPECTOR_ELEMENT_LIST_H__
#define __G_INSPECTOR_ELEMENT_LIST_H__


#include <gtk/gtktreeview.h>
#include <gtk/gtkliststore.h>

#include "ginspector-element.h"


G_BEGIN_DECLS



#define G_TYPE_INSPECTOR_ELEMENT_LIST            (g_inspector_element_list_get_type ())
#define G_INSPECTOR_ELEMENT_LIST(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), G_TYPE_INSPECTOR_ELEMENT_LIST, GInspectorElementList))
#define G_INSPECTOR_ELEMENT_LIST_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), G_TYPE_INSPECTOR_ELEMENT_LIST, GInspectorElementListClass))
#define G_IS_INSPECTOR_ELEMENT_LIST(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), G_TYPE_INSPECTOR_ELEMENT_LIST))
#define G_IS_INSPECTOR_ELEMENT_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), G_TYPE_INSPECTOR_ELEMENT_LIST))
#define G_INSPECTOR_ELEMENT_LIST_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), G_TYPE_INSPECTOR_ELEMENT_LIST, GInspectorElementListClass))


typedef struct _GInspectorElementList		GInspectorElementList;
typedef struct _GInspectorElementListClass	GInspectorElementListClass;
typedef struct _GInspectorElementListColumnInfo	GInspectorElementListColumnInfo;

struct _GInspectorElementList
{
  GtkTreeView tree_view;

  gpointer press_element;
  gpointer dnd_element;
};

struct _GInspectorElementListClass
{
  GtkTreeViewClass parent_class;

  void (* update) (GInspectorElementList *element_list);
};

struct _GInspectorElementListColumnInfo
{
  gint   column;
  gchar *title;
  gchar *gtype_name;
  gchar *attribute;
};

#define G_INSPECTOR_ELEMENT_LIST_COLUMN_ELEMENT_HOLDER 0
#define G_INSPECTOR_ELEMENT_LIST_COLUMN_INFO_ELEMENT_HOLDER { 0, NULL, "GObject", NULL }

#define G_INSPECTOR_ELEMENT_LIST_COLUMN_0      G_INSPECTOR_ELEMENT_LIST_COLUMN_ELEMENT_HOLDER
#define G_INSPECTOR_ELEMENT_LIST_COLUMN_INFO_0 G_INSPECTOR_ELEMENT_LIST_COLUMN_INFO_ELEMENT_HOLDER


GType      g_inspector_element_list_get_type (void) G_GNUC_CONST;

GtkWidget* g_inspector_element_list_new      (GInspectorElementListColumnInfo *columns,
					      gint                             n_columns);
void       g_inspector_element_list_update   (GInspectorElementList           *element_list);


void     g_inspector_element_list_set_row_element (GtkListStore          *list_store,
						   GtkTreeIter           *tree_iter,
						   GInspectorElementType  element_type,
						   gpointer               element);
gboolean g_inspector_element_list_get_iter        (GtkListStore          *list_store,
						   GtkTreeIter           *tree_iter,
						   GInspectorElementType  element_type,
						   gpointer               element);



G_END_DECLS


#endif /* __G_INSPECTOR_ELEMENT_LIST_H__ */
