/*
   Copyright (c) 2004, 2005 by AOSASA Shigeru and Red Hat, Inc.
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions are
   met:

   - Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.

   - Redistributions in binary form must reproduce the above
   copyright notice, this list of conditions and the following
   disclaimer in the documentation and/or other materials provided
   with the distribution.  

   - Neither the name of the AOSASA Shigeru, Red Hat, Inc
   nor the names of its contributors may be used to endorse or
   promote products derived from this software without specific
   prior written permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
   FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
   COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
   INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
   (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
   SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
   HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
   STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
   OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/*
   This software development was supported by
   Information-technorogy Promotion Agency, Japan (IPA).
*/

#include "ginspector-builtin.h"

#include "ginspector-core.h"
#include "ginspector-gtk.h"
#include "ginspector-ui.h"

#include "glrr-gobject.h"
#include "glrr-gtk.h"

#include "misc-utils.h"



static void builtin_module_init (void);

static gpointer create_panel_widget_list (gpointer data,
                                          gpointer func_data,
                                          gpointer invoke_data);



void
g_inspector_builtin_register_module_panel_widget_list (void)
{
  {
    static GInspectorBuiltinModuleInfo builtin_module_info;

    builtin_module_info.name       = "builtin-panel-widget-list";
    builtin_module_info.data       = NULL;
    builtin_module_info.init       = builtin_module_init;
    builtin_module_info.activate   = NULL;
    builtin_module_info.deactivate = NULL;

    g_inspector_builtin_register_module (&builtin_module_info);
  }
}

static void
builtin_module_init (void)
{
  g_inspector_register_procedure ("create-panel-widget-list",
				  "",
				  G_INSPECTOR_PROCEDURE_TYPE_PANEL,
				  G_INSPECTOR_ELEMENT_TYPE_NONE,
				  G_TYPE_NONE,
				  create_panel_widget_list,
				  NULL);
}



static gchar* object_flags_str (GtkObject *object);
static gchar* widget_flags_str (GtkWidget *widget);



enum
{
  COLUMN_0,

  COLUMN_WIDGET,
  COLUMN_PARENT,
  COLUMN_NAME,
  COLUMN_PARENT_NAME,
  COLUMN_GTYPE,
  COLUMN_WIDTH,
  COLUMN_HEIGHT,
  COLUMN_X,
  COLUMN_Y,
  COLUMN_STATE,
  COLUMN_OBJECT_FLAGS,
  COLUMN_WIDGET_FLAGS,

  NUM_COLUMNS
};

static GInspectorElementListColumnInfo columns[NUM_COLUMNS] =
{
  G_INSPECTOR_ELEMENT_LIST_COLUMN_INFO_0,

  { COLUMN_WIDGET,	  "Widget",		"gpointer",	"pointer" },
  { COLUMN_PARENT,	  "Parent",		"gpointer",	"pointer" },
  { COLUMN_NAME,	  "Name",		"gchararray",	"text" },
  { COLUMN_PARENT_NAME,	  "Parent Name",	"gchararray",	"text" },
  { COLUMN_GTYPE,	  "GType",		"_gtype",	"gtype" },
  { COLUMN_WIDTH,	  "Width",		"gint",		"text" },
  { COLUMN_HEIGHT,	  "Height",		"gint",		"text" },
  { COLUMN_X,		  "X",			"gint",		"text" },
  { COLUMN_Y,		  "Y",			"gint",		"text" },
  { COLUMN_STATE,	  "State",		"gchararray",	"text" },
  { COLUMN_OBJECT_FLAGS,  "ObjectFlags",	"gchararray",	"text" },
  { COLUMN_WIDGET_FLAGS,  "WidgetFlags",	"gchararray",	"text" },
};

static void
append_row (GtkListStore *list_store,
	    GtkWidget    *widget)
{
  gchar *name;
  gchar *parent_name;
  gchar *widget_state;
  gchar *object_flags;
  gchar *widget_flags;

  GtkTreeIter tree_iter;

  GtkWidget *parent;

  GList *free_list;

  free_list = NULL;

  parent = widget->parent;


  if (widget != NULL)
    name = gtk_widget_get_name_or_null (widget);
  else
    name = NULL;

  if (parent != NULL)
    parent_name = gtk_widget_get_name_or_null (parent);
  else
    parent_name = NULL;

  widget_state
    = g_type_enum_get_value_nick (GTK_TYPE_STATE_TYPE, widget->state);

  object_flags = object_flags_str (GTK_OBJECT (widget));
  free_list = g_list_append (free_list, object_flags);

  widget_flags = widget_flags_str (widget);
  free_list = g_list_append (free_list, widget_flags);

  
  


  gtk_list_store_append (list_store, &tree_iter);

  g_inspector_element_list_set_row_element_gobject (list_store, &tree_iter,
						    G_OBJECT (widget));

  gtk_list_store_set
	(list_store, &tree_iter,
	 COLUMN_WIDGET,		widget,
	 COLUMN_PARENT,		parent,
	 COLUMN_NAME,		name,
	 COLUMN_PARENT_NAME,	parent_name,
	 COLUMN_GTYPE,	   	G_OBJECT_TYPE (widget),
	 COLUMN_WIDTH,	   	widget->allocation.width,
	 COLUMN_HEIGHT,	   	widget->allocation.height,
	 COLUMN_X,		widget->allocation.x,
	 COLUMN_Y,		widget->allocation.y,
	 COLUMN_STATE,	   	widget_state,
	 COLUMN_OBJECT_FLAGS, 	object_flags,
	 COLUMN_WIDGET_FLAGS, 	widget_flags,
	 -1);


  g_list_foreach (free_list, (GFunc)g_free, NULL);
}

static void
create_list (GtkListStore *list_store)
{
  GList *widgets;
  GList *tmp;
  GtkWidget *widget;


  widgets = gtk_get_widget_list ();

  tmp = widgets;
  while (tmp != NULL)
    {
      widget = GTK_WIDGET (tmp->data);
      tmp = g_list_next (tmp);

      if (g_inspector_tag_check_widget (widget) != TRUE)
	{
	  append_row (list_store, widget);
	}
    }

  g_list_free (widgets);
}

static void
update (GInspectorElementList *element_list,
	gpointer               user_data)
{
  GtkListStore *list_store;

  list_store = GTK_LIST_STORE (gtk_tree_view_get_model (GTK_TREE_VIEW (element_list)));

#if 1
  g_object_ref (list_store);
  gtk_tree_view_set_model (GTK_TREE_VIEW (element_list), NULL);
#endif

#if 0
  gtk_tree_sortable_set_sort_column_id (GTK_TREE_SORTABLE (list_store),
					GTK_TREE_SORTABLE_DEFAULT_SORT_COLUMN_ID, 0);
#else
  gtk_tree_sortable_set_sort_column_id (GTK_TREE_SORTABLE (list_store),
					-2, 0);
#endif

  gtk_list_store_clear (list_store);
  create_list (list_store);

#if 1
  gtk_tree_view_set_model (GTK_TREE_VIEW (element_list), GTK_TREE_MODEL (list_store));
  g_object_unref (list_store);
#endif
}

static gpointer
create_panel_widget_list (gpointer data,
			  gpointer func_data,
			  gpointer invoke_data)
{
  GtkWidget *top;
  GtkWidget *panel;
  GtkWidget *frame;
  GtkWidget *scrolled_window;
  GtkWidget *element_list;


  {
    panel = g_object_new (G_TYPE_INSPECTOR_PANEL,
                          NULL);
    top = panel;
  }

  {
    frame = g_inspector_panel_frame_new ();
    g_inspector_panel_frame_set_title (G_INSPECTOR_PANEL_FRAME (frame), "Widget List");

    gtk_container_add (GTK_CONTAINER (panel), frame);
  }

  {
    scrolled_window = gtk_scrolled_window_new (NULL, NULL);
    gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled_window),
				    GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);

    gtk_container_add (GTK_CONTAINER (frame), scrolled_window);
  }

  {
    element_list = g_inspector_element_list_new (columns,
						 G_N_ELEMENTS (columns));
    g_signal_connect (element_list,
		      "update",
		      G_CALLBACK (update),
		      NULL);

    gtk_container_add (GTK_CONTAINER (scrolled_window),
		       element_list);

    g_inspector_panel_attach_element_list (G_INSPECTOR_PANEL (panel),
					   G_INSPECTOR_ELEMENT_LIST (element_list));
  }

  {
    g_signal_connect_swapped (gtk_frame_get_label_widget (GTK_FRAME (frame)),
			      "clicked",
			      G_CALLBACK (g_inspector_panel_update),
			      panel);
  }




  g_inspector_panel_update (G_INSPECTOR_PANEL (panel));


  return top;
}





static gchar *
object_flags_str (GtkObject *object)
{
  return g_type_flags_string (GTK_TYPE_OBJECT_FLAGS,
			      GTK_OBJECT_FLAGS (object));
}

static gchar *
widget_flags_str (GtkWidget *widget)
{
  return g_type_flags_string (GTK_TYPE_WIDGET_FLAGS,
			      GTK_WIDGET_FLAGS (widget));
}
