#include "vektor.h"
#include "printer.h"
#include "parser.h"
#include "gfanapplication.h"
#include "binomial.h"
#include "latticeideal.h"
#include "buchberger.h"
#include "division.h"
#include "field_rationals.h"

class LatticeTestApplication : public GFanApplication
{
public:
  IntegerVector remainder(IntegerVector v, const IntegerVectorList &l)
  {
      AsciiPrinter(Stderr).printVectorList(l);
      AsciiPrinter(Stderr).printVector(v);
    while(!v.isZero())
      {
	bool quit=true;
	for(IntegerVectorList::const_iterator i=l.begin();i!=l.end();i++)
	  {
	    if(i->divides(v))
	      {
		v-=*i;
		quit=false;
		break;
	      }
	    if(i->divides(-v))
	      {
		v+=*i;
		quit=false;
		break;
	      }
	  }
	if(quit)break;
	//	    AsciiPrinter(Stderr).printVector(v);
      }
    //  AsciiPrinter(Stderr).printVector(v);
    return v;
  }
  void order(TermOrder const &t, IntegerVector &v)
  {
    if(!t(v,v-v))
      v=-v;
  }
  IntegerVectorList strangeBuchberger(IntegerVectorList B, TermOrder const &t)
  {
    for(IntegerVectorList::iterator i=B.begin();i!=B.end();i++)order(t,*i);
    IntegerVectorList S;
    for(IntegerVectorList::iterator i=B.begin();i!=B.end();i++)
      for(IntegerVectorList::iterator j=i;j!=B.end();j++)
      {
	S.push_back(*j-*i);
	S.push_back(*j+*i);
      }
    while(!S.empty())
      {
	//    AsciiPrinter(Stderr).printString("B:\n");
	//  AsciiPrinter(Stderr).printVectorList(B);
	//  AsciiPrinter(Stderr).printString("\n");

	fprintf(stderr,"B:%i, S:%i\n",B.size(),S.size());
	IntegerVector v=*S.begin();
	S.pop_front();
	v=remainder(v,B);
	if(!v.isZero())
	  {
	    //  AsciiPrinter(Stderr).printVector(v);
	    //  AsciiPrinter(Stderr).printString("jfkajk\n");

	    order(t,v);
	    B.push_back(v);
	    for(IntegerVectorList::const_iterator j=B.begin();j!=B.end();j++)
	      {
		S.push_back(v+*j);
		S.push_back(v-*j);
	      }
	  }
      }
    return B;
  }

  bool includeInDefaultInstallation()
  {
    return false;
  }
  LatticeTestApplication()
  {
    registerOptions();
  }
  char *name()
  {
    return "_latticetest";
  }
  int main()
  {
    FileParser P(Stdin);

    IntegerVectorList ivl=P.parseIntegerVectorList();
    fprintf(stderr,"A\n");
    IntegerMatrix A=rowsToIntegerMatrix(ivl);

    LexicographicTermOrder t;

    A=A.transposed();
    fprintf(stderr,"A\n");
    IntegerVectorList b=latticeIdealRevLex(A);
    fprintf(stderr,"A\n");
    PolynomialRing theRing(Q,b.begin()->size());
    PolynomialSet g(theRing);
    fprintf(stderr,"A\n");
    for(IntegerVectorList::const_iterator i=b.begin();i!=b.end();i++)
      g.push_back(integerVectorToBinomial(*i,theRing));
    fprintf(stderr,"B\n");
    buchberger(&g,t);
    fprintf(stderr,"C\n");

    IntegerVectorList b2=strangeBuchberger(ivl,t);
    PolynomialSet g2(g.getRing());
    for(IntegerVectorList::const_iterator i=b2.begin();i!=b2.end();i++)
      g2.push_back(integerVectorToBinomial(*i,theRing));
    buchberger(&g2,t);

    AsciiPrinter(Stdout).printPolynomialSet(g);
    AsciiPrinter(Stdout).printPolynomialSet(g2);

    fprintf(Stdout,"%i\n",areIdealsEqual(g,g2));

    return 0;
  }
  const char *helpText()
  {
    return "Tests Niels' conjecture.\n";
  }
};

static LatticeTestApplication theApplication;
