//Written in the D programming language
/**
 * Fast Regular expressions for D, internal tables
 *
 * License: $(WEB boost.org/LICENSE_1_0.txt, Boost License 1.0).
 *
 * Authors: Dmitry Olshansky
 *
 */
//Automatically generated from Unicode Character Database files
module std.internal.uni_tab;

import std.internal.uni;


struct CommonCaseEntry
{
    dchar start, end;
    uint op;
    @property uint delta() const { return op & 0xFF_FFFF; }
    @property uint xor()const {   return op & doXor; }
    @property uint neg()const {   return op & doMinus; }
    enum doXor = 1<<31, doMinus = 1<<30;
}


//sorted by .start
immutable commonCaseTable = [
CommonCaseEntry(0x00041, 0x0005b, 2147483680),
CommonCaseEntry(0x00061, 0x0006b, 2147483680),
CommonCaseEntry(0x0006b, 0x0006c, 2147483680),
CommonCaseEntry(0x0006b, 0x0006c, 8383),
CommonCaseEntry(0x0006c, 0x00073, 2147483680),
CommonCaseEntry(0x00073, 0x00074, 2147483680),
CommonCaseEntry(0x00073, 0x00074, 2147483916),
CommonCaseEntry(0x00074, 0x0007b, 2147483680),
CommonCaseEntry(0x000b5, 0x000b6, 775),
CommonCaseEntry(0x000c0, 0x000d7, 2147483680),
CommonCaseEntry(0x000d8, 0x000df, 2147483680),
CommonCaseEntry(0x000df, 0x000e0, 7615),
CommonCaseEntry(0x000e0, 0x000e5, 2147483680),
CommonCaseEntry(0x000e5, 0x000e6, 2147483680),
CommonCaseEntry(0x000e5, 0x000e6, 8262),
CommonCaseEntry(0x000e6, 0x000f7, 2147483680),
CommonCaseEntry(0x000f8, 0x000ff, 2147483680),
CommonCaseEntry(0x000ff, 0x00100, 121),
CommonCaseEntry(0x00100, 0x00130, 2147483649),
CommonCaseEntry(0x00132, 0x00138, 2147483649),
CommonCaseEntry(0x00139, 0x00149, 2147483649),
CommonCaseEntry(0x0014a, 0x00178, 2147483649),
CommonCaseEntry(0x00178, 0x00179, 1073741945),
CommonCaseEntry(0x00179, 0x0017f, 2147483649),
CommonCaseEntry(0x0017f, 0x00180, 2147483916),
CommonCaseEntry(0x00180, 0x00181, 195),
CommonCaseEntry(0x00181, 0x00182, 210),
CommonCaseEntry(0x00182, 0x00186, 2147483649),
CommonCaseEntry(0x00186, 0x00187, 206),
CommonCaseEntry(0x00187, 0x00189, 2147483649),
CommonCaseEntry(0x00189, 0x0018b, 205),
CommonCaseEntry(0x0018b, 0x0018d, 2147483649),
CommonCaseEntry(0x0018e, 0x0018f, 79),
CommonCaseEntry(0x0018f, 0x00190, 202),
CommonCaseEntry(0x00190, 0x00191, 203),
CommonCaseEntry(0x00191, 0x00193, 2147483649),
CommonCaseEntry(0x00193, 0x00194, 205),
CommonCaseEntry(0x00194, 0x00195, 207),
CommonCaseEntry(0x00195, 0x00196, 97),
CommonCaseEntry(0x00196, 0x00197, 211),
CommonCaseEntry(0x00197, 0x00198, 209),
CommonCaseEntry(0x00198, 0x0019a, 2147483649),
CommonCaseEntry(0x0019a, 0x0019b, 163),
CommonCaseEntry(0x0019c, 0x0019d, 211),
CommonCaseEntry(0x0019d, 0x0019e, 213),
CommonCaseEntry(0x0019e, 0x0019f, 130),
CommonCaseEntry(0x0019f, 0x001a0, 214),
CommonCaseEntry(0x001a0, 0x001a6, 2147483649),
CommonCaseEntry(0x001a6, 0x001a7, 218),
CommonCaseEntry(0x001a7, 0x001a9, 2147483649),
CommonCaseEntry(0x001a9, 0x001aa, 218),
CommonCaseEntry(0x001ac, 0x001ae, 2147483649),
CommonCaseEntry(0x001ae, 0x001af, 218),
CommonCaseEntry(0x001af, 0x001b1, 2147483649),
CommonCaseEntry(0x001b1, 0x001b3, 217),
CommonCaseEntry(0x001b3, 0x001b7, 2147483649),
CommonCaseEntry(0x001b7, 0x001b8, 219),
CommonCaseEntry(0x001b8, 0x001ba, 2147483649),
CommonCaseEntry(0x001bc, 0x001be, 2147483649),
CommonCaseEntry(0x001bf, 0x001c0, 56),
CommonCaseEntry(0x001c4, 0x001c5, 2147483650),
CommonCaseEntry(0x001c5, 0x001c6, 2147483649),
CommonCaseEntry(0x001c6, 0x001c7, 2147483649),
CommonCaseEntry(0x001c6, 0x001c7, 2147483650),
CommonCaseEntry(0x001c7, 0x001c8, 2),
CommonCaseEntry(0x001c8, 0x001c9, 2147483649),
CommonCaseEntry(0x001c9, 0x001ca, 2147483649),
CommonCaseEntry(0x001c9, 0x001ca, 1073741826),
CommonCaseEntry(0x001ca, 0x001cb, 2),
CommonCaseEntry(0x001cb, 0x001cc, 2147483649),
CommonCaseEntry(0x001cc, 0x001cd, 2147483649),
CommonCaseEntry(0x001cc, 0x001cd, 1073741826),
CommonCaseEntry(0x001cd, 0x001dd, 2147483649),
CommonCaseEntry(0x001dd, 0x001de, 1073741903),
CommonCaseEntry(0x001de, 0x001f0, 2147483649),
CommonCaseEntry(0x001f1, 0x001f2, 2147483650),
CommonCaseEntry(0x001f2, 0x001f3, 2147483649),
CommonCaseEntry(0x001f3, 0x001f4, 2147483649),
CommonCaseEntry(0x001f3, 0x001f4, 2147483650),
CommonCaseEntry(0x001f4, 0x001f6, 2147483649),
CommonCaseEntry(0x001f6, 0x001f7, 1073741921),
CommonCaseEntry(0x001f7, 0x001f8, 1073741880),
CommonCaseEntry(0x001f8, 0x00220, 2147483649),
CommonCaseEntry(0x00220, 0x00221, 1073741954),
CommonCaseEntry(0x00222, 0x00234, 2147483649),
CommonCaseEntry(0x0023a, 0x0023b, 10795),
CommonCaseEntry(0x0023b, 0x0023d, 2147483649),
CommonCaseEntry(0x0023d, 0x0023e, 1073741987),
CommonCaseEntry(0x0023e, 0x0023f, 10792),
CommonCaseEntry(0x0023f, 0x00241, 10815),
CommonCaseEntry(0x00241, 0x00243, 2147483649),
CommonCaseEntry(0x00243, 0x00244, 1073742019),
CommonCaseEntry(0x00244, 0x00245, 69),
CommonCaseEntry(0x00245, 0x00246, 71),
CommonCaseEntry(0x00246, 0x00250, 2147483649),
CommonCaseEntry(0x00250, 0x00251, 10783),
CommonCaseEntry(0x00251, 0x00252, 10780),
CommonCaseEntry(0x00252, 0x00253, 10782),
CommonCaseEntry(0x00253, 0x00254, 1073742034),
CommonCaseEntry(0x00254, 0x00255, 1073742030),
CommonCaseEntry(0x00256, 0x00258, 1073742029),
CommonCaseEntry(0x00259, 0x0025a, 1073742026),
CommonCaseEntry(0x0025b, 0x0025c, 1073742027),
CommonCaseEntry(0x00260, 0x00261, 1073742029),
CommonCaseEntry(0x00263, 0x00264, 1073742031),
CommonCaseEntry(0x00265, 0x00266, 42280),
CommonCaseEntry(0x00268, 0x00269, 1073742033),
CommonCaseEntry(0x00269, 0x0026a, 1073742035),
CommonCaseEntry(0x0026b, 0x0026c, 10743),
CommonCaseEntry(0x0026f, 0x00270, 1073742035),
CommonCaseEntry(0x00271, 0x00272, 10749),
CommonCaseEntry(0x00272, 0x00273, 1073742037),
CommonCaseEntry(0x00275, 0x00276, 1073742038),
CommonCaseEntry(0x0027d, 0x0027e, 10727),
CommonCaseEntry(0x00280, 0x00281, 1073742042),
CommonCaseEntry(0x00283, 0x00284, 1073742042),
CommonCaseEntry(0x00288, 0x00289, 1073742042),
CommonCaseEntry(0x00289, 0x0028a, 1073741893),
CommonCaseEntry(0x0028a, 0x0028c, 1073742041),
CommonCaseEntry(0x0028c, 0x0028d, 1073741895),
CommonCaseEntry(0x00292, 0x00293, 1073742043),
CommonCaseEntry(0x00345, 0x00346, 116),
CommonCaseEntry(0x00370, 0x00374, 2147483649),
CommonCaseEntry(0x00376, 0x00378, 2147483649),
CommonCaseEntry(0x0037b, 0x0037e, 130),
CommonCaseEntry(0x00386, 0x00387, 38),
CommonCaseEntry(0x00388, 0x0038b, 37),
CommonCaseEntry(0x0038c, 0x0038d, 2147483712),
CommonCaseEntry(0x0038e, 0x00390, 63),
CommonCaseEntry(0x00391, 0x003a2, 32),
CommonCaseEntry(0x003a3, 0x003ac, 32),
CommonCaseEntry(0x003ac, 0x003ad, 1073741862),
CommonCaseEntry(0x003ad, 0x003b0, 1073741861),
CommonCaseEntry(0x003b1, 0x003b2, 1073741856),
CommonCaseEntry(0x003b2, 0x003b3, 1073741856),
CommonCaseEntry(0x003b2, 0x003b3, 30),
CommonCaseEntry(0x003b3, 0x003b5, 1073741856),
CommonCaseEntry(0x003b5, 0x003b6, 1073741856),
CommonCaseEntry(0x003b5, 0x003b6, 2147483712),
CommonCaseEntry(0x003b6, 0x003b8, 1073741856),
CommonCaseEntry(0x003b8, 0x003b9, 1073741856),
CommonCaseEntry(0x003b8, 0x003b9, 25),
CommonCaseEntry(0x003b8, 0x003b9, 60),
CommonCaseEntry(0x003b9, 0x003ba, 1073741856),
CommonCaseEntry(0x003b9, 0x003ba, 7173),
CommonCaseEntry(0x003b9, 0x003ba, 1073741940),
CommonCaseEntry(0x003ba, 0x003bb, 1073741856),
CommonCaseEntry(0x003ba, 0x003bb, 54),
CommonCaseEntry(0x003bb, 0x003bc, 1073741856),
CommonCaseEntry(0x003bc, 0x003bd, 1073742599),
CommonCaseEntry(0x003bc, 0x003bd, 1073741856),
CommonCaseEntry(0x003bd, 0x003c0, 1073741856),
CommonCaseEntry(0x003c0, 0x003c1, 1073741856),
CommonCaseEntry(0x003c0, 0x003c1, 2147483670),
CommonCaseEntry(0x003c1, 0x003c2, 1073741856),
CommonCaseEntry(0x003c1, 0x003c2, 2147483696),
CommonCaseEntry(0x003c2, 0x003c3, 2147483649),
CommonCaseEntry(0x003c3, 0x003c4, 2147483649),
CommonCaseEntry(0x003c3, 0x003c4, 1073741856),
CommonCaseEntry(0x003c4, 0x003c6, 1073741856),
CommonCaseEntry(0x003c6, 0x003c7, 1073741856),
CommonCaseEntry(0x003c6, 0x003c7, 15),
CommonCaseEntry(0x003c7, 0x003c9, 1073741856),
CommonCaseEntry(0x003c9, 0x003ca, 1073741856),
CommonCaseEntry(0x003c9, 0x003ca, 7517),
CommonCaseEntry(0x003ca, 0x003cc, 1073741856),
CommonCaseEntry(0x003cc, 0x003cd, 2147483712),
CommonCaseEntry(0x003cd, 0x003cf, 1073741887),
CommonCaseEntry(0x003cf, 0x003d0, 8),
CommonCaseEntry(0x003d0, 0x003d1, 1073741854),
CommonCaseEntry(0x003d1, 0x003d2, 1073741849),
CommonCaseEntry(0x003d5, 0x003d6, 1073741839),
CommonCaseEntry(0x003d6, 0x003d7, 2147483670),
CommonCaseEntry(0x003d7, 0x003d8, 1073741832),
CommonCaseEntry(0x003d8, 0x003f0, 2147483649),
CommonCaseEntry(0x003f0, 0x003f1, 1073741878),
CommonCaseEntry(0x003f1, 0x003f2, 2147483696),
CommonCaseEntry(0x003f2, 0x003f3, 7),
CommonCaseEntry(0x003f4, 0x003f5, 1073741884),
CommonCaseEntry(0x003f5, 0x003f6, 2147483712),
CommonCaseEntry(0x003f7, 0x003f9, 2147483649),
CommonCaseEntry(0x003f9, 0x003fa, 1073741831),
CommonCaseEntry(0x003fa, 0x003fc, 2147483649),
CommonCaseEntry(0x003fd, 0x00400, 1073741954),
CommonCaseEntry(0x00400, 0x00410, 2147483728),
CommonCaseEntry(0x00410, 0x00430, 32),
CommonCaseEntry(0x00430, 0x00450, 1073741856),
CommonCaseEntry(0x00450, 0x00460, 2147483728),
CommonCaseEntry(0x00460, 0x00482, 2147483649),
CommonCaseEntry(0x0048a, 0x004c0, 2147483649),
CommonCaseEntry(0x004c0, 0x004c1, 2147483663),
CommonCaseEntry(0x004c1, 0x004cf, 2147483649),
CommonCaseEntry(0x004cf, 0x004d0, 2147483663),
CommonCaseEntry(0x004d0, 0x00528, 2147483649),
CommonCaseEntry(0x00531, 0x00557, 48),
CommonCaseEntry(0x00561, 0x00587, 1073741872),
CommonCaseEntry(0x010a0, 0x010c6, 7264),
CommonCaseEntry(0x01d79, 0x01d7a, 35332),
CommonCaseEntry(0x01d7d, 0x01d7e, 3814),
CommonCaseEntry(0x01e00, 0x01e61, 2147483649),
CommonCaseEntry(0x01e61, 0x01e62, 2147483649),
CommonCaseEntry(0x01e61, 0x01e62, 58),
CommonCaseEntry(0x01e62, 0x01e96, 2147483649),
CommonCaseEntry(0x01e9b, 0x01e9c, 1073741882),
CommonCaseEntry(0x01e9e, 0x01e9f, 1073749439),
CommonCaseEntry(0x01ea0, 0x01f00, 2147483649),
CommonCaseEntry(0x01f00, 0x01f16, 2147483656),
CommonCaseEntry(0x01f18, 0x01f1e, 2147483656),
CommonCaseEntry(0x01f20, 0x01f46, 2147483656),
CommonCaseEntry(0x01f48, 0x01f4e, 2147483656),
CommonCaseEntry(0x01f51, 0x01f52, 2147483656),
CommonCaseEntry(0x01f53, 0x01f54, 2147483656),
CommonCaseEntry(0x01f55, 0x01f56, 2147483656),
CommonCaseEntry(0x01f57, 0x01f58, 2147483656),
CommonCaseEntry(0x01f59, 0x01f5a, 2147483656),
CommonCaseEntry(0x01f5b, 0x01f5c, 2147483656),
CommonCaseEntry(0x01f5d, 0x01f5e, 2147483656),
CommonCaseEntry(0x01f5f, 0x01f70, 2147483656),
CommonCaseEntry(0x01f70, 0x01f72, 74),
CommonCaseEntry(0x01f72, 0x01f76, 86),
CommonCaseEntry(0x01f76, 0x01f78, 100),
CommonCaseEntry(0x01f78, 0x01f7a, 2147483776),
CommonCaseEntry(0x01f7a, 0x01f7c, 112),
CommonCaseEntry(0x01f7c, 0x01f7e, 126),
CommonCaseEntry(0x01f80, 0x01fb2, 2147483656),
CommonCaseEntry(0x01fb3, 0x01fb4, 9),
CommonCaseEntry(0x01fb8, 0x01fba, 2147483656),
CommonCaseEntry(0x01fba, 0x01fbc, 1073741898),
CommonCaseEntry(0x01fbc, 0x01fbd, 1073741833),
CommonCaseEntry(0x01fbe, 0x01fbf, 1073748997),
CommonCaseEntry(0x01fc3, 0x01fc4, 9),
CommonCaseEntry(0x01fc8, 0x01fcc, 1073741910),
CommonCaseEntry(0x01fcc, 0x01fcd, 1073741833),
CommonCaseEntry(0x01fd0, 0x01fd2, 2147483656),
CommonCaseEntry(0x01fd8, 0x01fda, 2147483656),
CommonCaseEntry(0x01fda, 0x01fdc, 1073741924),
CommonCaseEntry(0x01fe0, 0x01fe2, 2147483656),
CommonCaseEntry(0x01fe5, 0x01fe6, 7),
CommonCaseEntry(0x01fe8, 0x01fea, 2147483656),
CommonCaseEntry(0x01fea, 0x01fec, 1073741936),
CommonCaseEntry(0x01fec, 0x01fed, 1073741831),
CommonCaseEntry(0x01ff3, 0x01ff4, 9),
CommonCaseEntry(0x01ff8, 0x01ffa, 2147483776),
CommonCaseEntry(0x01ffa, 0x01ffc, 1073741950),
CommonCaseEntry(0x01ffc, 0x01ffd, 1073741833),
CommonCaseEntry(0x02126, 0x02127, 1073749341),
CommonCaseEntry(0x0212a, 0x0212b, 1073750207),
CommonCaseEntry(0x0212b, 0x0212c, 1073750086),
CommonCaseEntry(0x02132, 0x02133, 28),
CommonCaseEntry(0x0214e, 0x0214f, 1073741852),
CommonCaseEntry(0x02160, 0x02180, 2147483664),
CommonCaseEntry(0x02183, 0x02185, 2147483649),
CommonCaseEntry(0x024b6, 0x024d0, 26),
CommonCaseEntry(0x024d0, 0x024ea, 1073741850),
CommonCaseEntry(0x02c00, 0x02c2f, 48),
CommonCaseEntry(0x02c30, 0x02c5f, 1073741872),
CommonCaseEntry(0x02c60, 0x02c62, 2147483649),
CommonCaseEntry(0x02c62, 0x02c63, 1073752567),
CommonCaseEntry(0x02c63, 0x02c64, 1073745638),
CommonCaseEntry(0x02c64, 0x02c65, 1073752551),
CommonCaseEntry(0x02c65, 0x02c66, 1073752619),
CommonCaseEntry(0x02c66, 0x02c67, 1073752616),
CommonCaseEntry(0x02c67, 0x02c6d, 2147483649),
CommonCaseEntry(0x02c6d, 0x02c6e, 1073752604),
CommonCaseEntry(0x02c6e, 0x02c6f, 1073752573),
CommonCaseEntry(0x02c6f, 0x02c70, 1073752607),
CommonCaseEntry(0x02c70, 0x02c71, 1073752606),
CommonCaseEntry(0x02c72, 0x02c74, 2147483649),
CommonCaseEntry(0x02c75, 0x02c77, 2147483649),
CommonCaseEntry(0x02c7e, 0x02c80, 1073752639),
CommonCaseEntry(0x02c80, 0x02ce4, 2147483649),
CommonCaseEntry(0x02ceb, 0x02cef, 2147483649),
CommonCaseEntry(0x02d00, 0x02d26, 1073749088),
CommonCaseEntry(0x0a640, 0x0a66e, 2147483649),
CommonCaseEntry(0x0a680, 0x0a698, 2147483649),
CommonCaseEntry(0x0a722, 0x0a730, 2147483649),
CommonCaseEntry(0x0a732, 0x0a770, 2147483649),
CommonCaseEntry(0x0a779, 0x0a77d, 2147483649),
CommonCaseEntry(0x0a77d, 0x0a77e, 1073777156),
CommonCaseEntry(0x0a77e, 0x0a788, 2147483649),
CommonCaseEntry(0x0a78b, 0x0a78d, 2147483649),
CommonCaseEntry(0x0a78d, 0x0a78e, 1073784104),
CommonCaseEntry(0x0a790, 0x0a792, 2147483649),
CommonCaseEntry(0x0a7a0, 0x0a7aa, 2147483649),
CommonCaseEntry(0x0ff21, 0x0ff3b, 32),
CommonCaseEntry(0x0ff41, 0x0ff5b, 1073741856),
CommonCaseEntry(0x10400, 0x10428, 40),
CommonCaseEntry(0x10428, 0x10450, 1073741864),
];

struct UnicodeProperty
{
    string name;
    immutable CodepointSet set;
}
immutable(CodepointSet) unicodeInCombining_Diacritical_Marks_Supplement = CodepointSet([
    0x01dc0, 0x01e00,
]);

immutable(CodepointSet) unicodeInCJK_Radicals_Supplement = CodepointSet([
    0x02e80, 0x02f00,
]);

immutable(CodepointSet) unicodeInEthiopic_Supplement = CodepointSet([
    0x01380, 0x013a0,
]);

immutable(CodepointSet) unicodeInPhags_pa = CodepointSet([
    0x0a840, 0x0a880,
]);

immutable(CodepointSet) unicodeInSyriac = CodepointSet([
    0x00700, 0x00750,
]);

immutable(CodepointSet) unicodeInGujarati = CodepointSet([
    0x00a80, 0x00b00,
]);

immutable(CodepointSet) unicodeOther_ID_Start = CodepointSet([
    0x02118, 0x02119,
    0x0212e, 0x0212f,
    0x0309b, 0x0309d,
]);

immutable(CodepointSet) unicodeInKharoshthi = CodepointSet([
    0x10a00, 0x10a60,
]);

immutable(CodepointSet) unicodeInHangul_Jamo = CodepointSet([
    0x01100, 0x01200,
]);

immutable(CodepointSet) unicodeRunic = CodepointSet([
    0x016a0, 0x016eb,
    0x016ee, 0x016f1,
]);

immutable(CodepointSet) unicodeInKayah_Li = CodepointSet([
    0x0a900, 0x0a930,
]);

immutable(CodepointSet) unicodeOther_Default_Ignorable_Code_Point = CodepointSet([
    0x0034f, 0x00350,
    0x0115f, 0x01161,
    0x02065, 0x0206a,
    0x03164, 0x03165,
    0x0ffa0, 0x0ffa1,
    0x0fff0, 0x0fff9,
    0xe0000, 0xe0001,
    0xe0002, 0xe0020,
    0xe0080, 0xe0100,
    0xe01f0, 0xe1000,
]);

immutable(CodepointSet) unicodeOld_Turkic = CodepointSet([
    0x10c00, 0x10c49,
]);

immutable(CodepointSet) unicodeInLydian = CodepointSet([
    0x10920, 0x10940,
]);

immutable(CodepointSet) unicodeIDS_Binary_Operator = CodepointSet([
    0x02ff0, 0x02ff2,
    0x02ff4, 0x02ffc,
]);

immutable(CodepointSet) unicodeTai_Tham = CodepointSet([
    0x01a20, 0x01a5f,
    0x01a60, 0x01a7d,
    0x01a7f, 0x01a8a,
    0x01a90, 0x01a9a,
    0x01aa0, 0x01aae,
]);

immutable(CodepointSet) unicodeLinear_B = CodepointSet([
    0x10000, 0x1000c,
    0x1000d, 0x10027,
    0x10028, 0x1003b,
    0x1003c, 0x1003e,
    0x1003f, 0x1004e,
    0x10050, 0x1005e,
    0x10080, 0x100fb,
]);

immutable(CodepointSet) unicodeInSupplemental_Arrows_A = CodepointSet([
    0x027f0, 0x02800,
]);

immutable(CodepointSet) unicodeInMathematical_Alphanumeric_Symbols = CodepointSet([
    0x1d400, 0x1d800,
]);

immutable(CodepointSet) unicodeArmenian = CodepointSet([
    0x00531, 0x00557,
    0x00559, 0x00560,
    0x00561, 0x00588,
    0x0058a, 0x0058b,
    0x0fb13, 0x0fb18,
]);

immutable(CodepointSet) unicodeInBlock_Elements = CodepointSet([
    0x02580, 0x025a0,
]);

immutable(CodepointSet) unicodeInSupplemental_Arrows_B = CodepointSet([
    0x02900, 0x02980,
]);

immutable(CodepointSet) unicodeInBalinese = CodepointSet([
    0x01b00, 0x01b80,
]);

immutable(CodepointSet) unicodeCyrillic = CodepointSet([
    0x00400, 0x00485,
    0x00487, 0x00528,
    0x01d2b, 0x01d2c,
    0x01d78, 0x01d79,
    0x02de0, 0x02e00,
    0x0a640, 0x0a674,
    0x0a67c, 0x0a698,
]);

immutable(CodepointSet) unicodeInBamum_Supplement = CodepointSet([
    0x16800, 0x16a40,
]);

immutable(CodepointSet) unicodeWhite_Space = CodepointSet([
    0x00009, 0x0000e,
    0x00020, 0x00021,
    0x00085, 0x00086,
    0x000a0, 0x000a1,
    0x01680, 0x01681,
    0x0180e, 0x0180f,
    0x02000, 0x0200b,
    0x02028, 0x0202a,
    0x0202f, 0x02030,
    0x0205f, 0x02060,
    0x03000, 0x03001,
]);

immutable(CodepointSet) unicodeBatak = CodepointSet([
    0x01bc0, 0x01bf4,
    0x01bfc, 0x01c00,
]);

immutable(CodepointSet) unicodeDeprecated = CodepointSet([
    0x00149, 0x0014a,
    0x00673, 0x00674,
    0x00f77, 0x00f78,
    0x00f79, 0x00f7a,
    0x017a3, 0x017a5,
    0x0206a, 0x02070,
    0x02329, 0x0232b,
    0xe0001, 0xe0002,
    0xe0020, 0xe0080,
]);

immutable(CodepointSet) unicodeInUnified_Canadian_Aboriginal_Syllabics_Extended = CodepointSet([
    0x018b0, 0x01900,
]);

immutable(CodepointSet) unicodeCherokee = CodepointSet([
    0x013a0, 0x013f5,
]);

immutable(CodepointSet) unicodeInInscriptional_Parthian = CodepointSet([
    0x10b40, 0x10b60,
]);

immutable(CodepointSet) unicodeHiragana = CodepointSet([
    0x03041, 0x03097,
    0x0309d, 0x030a0,
    0x1b001, 0x1b002,
    0x1f200, 0x1f201,
]);

immutable(CodepointSet) unicodeInCJK_Compatibility_Ideographs = CodepointSet([
    0x0f900, 0x0fb00,
]);

immutable(CodepointSet) unicodeInAncient_Symbols = CodepointSet([
    0x10190, 0x101d0,
]);

immutable(CodepointSet) unicodeInOld_South_Arabian = CodepointSet([
    0x10a60, 0x10a80,
]);

immutable(CodepointSet) unicodePattern_Syntax = CodepointSet([
    0x00021, 0x00030,
    0x0003a, 0x00041,
    0x0005b, 0x0005f,
    0x00060, 0x00061,
    0x0007b, 0x0007f,
    0x000a1, 0x000a8,
    0x000a9, 0x000aa,
    0x000ab, 0x000ad,
    0x000ae, 0x000af,
    0x000b0, 0x000b2,
    0x000b6, 0x000b7,
    0x000bb, 0x000bc,
    0x000bf, 0x000c0,
    0x000d7, 0x000d8,
    0x000f7, 0x000f8,
    0x02010, 0x02028,
    0x02030, 0x0203f,
    0x02041, 0x02054,
    0x02055, 0x0205f,
    0x02190, 0x02460,
    0x02500, 0x02776,
    0x02794, 0x02c00,
    0x02e00, 0x02e80,
    0x03001, 0x03004,
    0x03008, 0x03021,
    0x03030, 0x03031,
    0x0fd3e, 0x0fd40,
    0x0fe45, 0x0fe47,
]);

immutable(CodepointSet) unicodeNew_Tai_Lue = CodepointSet([
    0x01980, 0x019ac,
    0x019b0, 0x019ca,
    0x019d0, 0x019db,
    0x019de, 0x019e0,
]);

immutable(CodepointSet) unicodeASCII_Hex_Digit = CodepointSet([
    0x00030, 0x0003a,
    0x00041, 0x00047,
    0x00061, 0x00067,
]);

immutable(CodepointSet) unicodeArabic = CodepointSet([
    0x00600, 0x00604,
    0x00606, 0x0060c,
    0x0060d, 0x0061b,
    0x0061e, 0x0061f,
    0x00620, 0x00640,
    0x00641, 0x0064b,
    0x00656, 0x0065f,
    0x0066a, 0x00670,
    0x00671, 0x006dd,
    0x006de, 0x00700,
    0x00750, 0x00780,
    0x0fb50, 0x0fbc2,
    0x0fbd3, 0x0fd3e,
    0x0fd50, 0x0fd90,
    0x0fd92, 0x0fdc8,
    0x0fdf0, 0x0fdfd,
    0x0fe70, 0x0fe75,
    0x0fe76, 0x0fefd,
    0x10e60, 0x10e7f,
]);

immutable(CodepointSet) unicodeInCuneiform_Numbers_and_Punctuation = CodepointSet([
    0x12400, 0x12480,
]);

immutable(CodepointSet) unicodeBrahmi = CodepointSet([
    0x11000, 0x1104e,
    0x11052, 0x11070,
]);

immutable(CodepointSet) unicodeInControl_Pictures = CodepointSet([
    0x02400, 0x02440,
]);

immutable(CodepointSet) unicodeOther_ID_Continue = CodepointSet([
    0x000b7, 0x000b8,
    0x00387, 0x00388,
    0x01369, 0x01372,
    0x019da, 0x019db,
]);

immutable(CodepointSet) unicodeInOl_Chiki = CodepointSet([
    0x01c50, 0x01c80,
]);

immutable(CodepointSet) unicodeInArmenian = CodepointSet([
    0x00530, 0x00590,
]);

immutable(CodepointSet) unicodeInCyrillic = CodepointSet([
    0x00400, 0x00500,
]);

immutable(CodepointSet) unicodeInNew_Tai_Lue = CodepointSet([
    0x01980, 0x019e0,
]);

immutable(CodepointSet) unicodeInHigh_Surrogates = CodepointSet([
    0x0d800, 0x0db80,
]);

immutable(CodepointSet) unicodeInHigh_Private_Use_Surrogates = CodepointSet([
    0x0db80, 0x0dc00,
]);

immutable(CodepointSet) unicodeInAncient_Greek_Numbers = CodepointSet([
    0x10140, 0x10190,
]);

immutable(CodepointSet) unicodeQuotation_Mark = CodepointSet([
    0x00022, 0x00023,
    0x00027, 0x00028,
    0x000ab, 0x000ac,
    0x000bb, 0x000bc,
    0x02018, 0x02020,
    0x02039, 0x0203b,
    0x0300c, 0x03010,
    0x0301d, 0x03020,
    0x0fe41, 0x0fe45,
    0x0ff02, 0x0ff03,
    0x0ff07, 0x0ff08,
    0x0ff62, 0x0ff64,
]);

immutable(CodepointSet) unicodeTai_Le = CodepointSet([
    0x01950, 0x0196e,
    0x01970, 0x01975,
]);

immutable(CodepointSet) unicodeCc = CodepointSet([
    0x00000, 0x00020,
    0x0007f, 0x000a0,
]);

immutable(CodepointSet) unicodeInCherokee = CodepointSet([
    0x013a0, 0x01400,
]);

immutable(CodepointSet) unicodeCoptic = CodepointSet([
    0x003e2, 0x003f0,
    0x02c80, 0x02cf2,
    0x02cf9, 0x02d00,
]);

immutable(CodepointSet) unicodeInCyrillic_Supplement = CodepointSet([
    0x00500, 0x00530,
]);

immutable(CodepointSet) unicodeCf = CodepointSet([
    0x000ad, 0x000ae,
    0x00600, 0x00604,
    0x006dd, 0x006de,
    0x0070f, 0x00710,
    0x017b4, 0x017b6,
    0x0200b, 0x02010,
    0x0202a, 0x0202f,
    0x02060, 0x02065,
    0x0206a, 0x02070,
    0x0feff, 0x0ff00,
    0x0fff9, 0x0fffc,
    0x110bd, 0x110be,
    0x1d173, 0x1d17b,
    0xe0001, 0xe0002,
    0xe0020, 0xe0080,
]);

immutable(CodepointSet) unicodeGothic = CodepointSet([
    0x10330, 0x1034b,
]);

immutable(CodepointSet) unicodeInHiragana = CodepointSet([
    0x03040, 0x030a0,
]);

immutable(CodepointSet) unicodeInIPA_Extensions = CodepointSet([
    0x00250, 0x002b0,
]);

immutable(CodepointSet) unicodeOgham = CodepointSet([
    0x01680, 0x0169d,
]);

immutable(CodepointSet) unicodeInCJK_Compatibility_Forms = CodepointSet([
    0x0fe30, 0x0fe50,
]);

immutable(CodepointSet) unicodeInShavian = CodepointSet([
    0x10450, 0x10480,
]);

immutable(CodepointSet) unicodeCn = CodepointSet([
    0x00378, 0x0037a,
    0x0037f, 0x00384,
    0x0038b, 0x0038c,
    0x0038d, 0x0038e,
    0x003a2, 0x003a3,
    0x00528, 0x00531,
    0x00557, 0x00559,
    0x00560, 0x00561,
    0x00588, 0x00589,
    0x0058b, 0x00591,
    0x005c8, 0x005d0,
    0x005eb, 0x005f0,
    0x005f5, 0x00600,
    0x00604, 0x00606,
    0x0061c, 0x0061e,
    0x0070e, 0x0070f,
    0x0074b, 0x0074d,
    0x007b2, 0x007c0,
    0x007fb, 0x00800,
    0x0082e, 0x00830,
    0x0083f, 0x00840,
    0x0085c, 0x0085e,
    0x0085f, 0x00900,
    0x00978, 0x00979,
    0x00980, 0x00981,
    0x00984, 0x00985,
    0x0098d, 0x0098f,
    0x00991, 0x00993,
    0x009a9, 0x009aa,
    0x009b1, 0x009b2,
    0x009b3, 0x009b6,
    0x009ba, 0x009bc,
    0x009c5, 0x009c7,
    0x009c9, 0x009cb,
    0x009cf, 0x009d7,
    0x009d8, 0x009dc,
    0x009de, 0x009df,
    0x009e4, 0x009e6,
    0x009fc, 0x00a01,
    0x00a04, 0x00a05,
    0x00a0b, 0x00a0f,
    0x00a11, 0x00a13,
    0x00a29, 0x00a2a,
    0x00a31, 0x00a32,
    0x00a34, 0x00a35,
    0x00a37, 0x00a38,
    0x00a3a, 0x00a3c,
    0x00a3d, 0x00a3e,
    0x00a43, 0x00a47,
    0x00a49, 0x00a4b,
    0x00a4e, 0x00a51,
    0x00a52, 0x00a59,
    0x00a5d, 0x00a5e,
    0x00a5f, 0x00a66,
    0x00a76, 0x00a81,
    0x00a84, 0x00a85,
    0x00a8e, 0x00a8f,
    0x00a92, 0x00a93,
    0x00aa9, 0x00aaa,
    0x00ab1, 0x00ab2,
    0x00ab4, 0x00ab5,
    0x00aba, 0x00abc,
    0x00ac6, 0x00ac7,
    0x00aca, 0x00acb,
    0x00ace, 0x00ad0,
    0x00ad1, 0x00ae0,
    0x00ae4, 0x00ae6,
    0x00af0, 0x00af1,
    0x00af2, 0x00b01,
    0x00b04, 0x00b05,
    0x00b0d, 0x00b0f,
    0x00b11, 0x00b13,
    0x00b29, 0x00b2a,
    0x00b31, 0x00b32,
    0x00b34, 0x00b35,
    0x00b3a, 0x00b3c,
    0x00b45, 0x00b47,
    0x00b49, 0x00b4b,
    0x00b4e, 0x00b56,
    0x00b58, 0x00b5c,
    0x00b5e, 0x00b5f,
    0x00b64, 0x00b66,
    0x00b78, 0x00b82,
    0x00b84, 0x00b85,
    0x00b8b, 0x00b8e,
    0x00b91, 0x00b92,
    0x00b96, 0x00b99,
    0x00b9b, 0x00b9c,
    0x00b9d, 0x00b9e,
    0x00ba0, 0x00ba3,
    0x00ba5, 0x00ba8,
    0x00bab, 0x00bae,
    0x00bba, 0x00bbe,
    0x00bc3, 0x00bc6,
    0x00bc9, 0x00bca,
    0x00bce, 0x00bd0,
    0x00bd1, 0x00bd7,
    0x00bd8, 0x00be6,
    0x00bfb, 0x00c01,
    0x00c04, 0x00c05,
    0x00c0d, 0x00c0e,
    0x00c11, 0x00c12,
    0x00c29, 0x00c2a,
    0x00c34, 0x00c35,
    0x00c3a, 0x00c3d,
    0x00c45, 0x00c46,
    0x00c49, 0x00c4a,
    0x00c4e, 0x00c55,
    0x00c57, 0x00c58,
    0x00c5a, 0x00c60,
    0x00c64, 0x00c66,
    0x00c70, 0x00c78,
    0x00c80, 0x00c82,
    0x00c84, 0x00c85,
    0x00c8d, 0x00c8e,
    0x00c91, 0x00c92,
    0x00ca9, 0x00caa,
    0x00cb4, 0x00cb5,
    0x00cba, 0x00cbc,
    0x00cc5, 0x00cc6,
    0x00cc9, 0x00cca,
    0x00cce, 0x00cd5,
    0x00cd7, 0x00cde,
    0x00cdf, 0x00ce0,
    0x00ce4, 0x00ce6,
    0x00cf0, 0x00cf1,
    0x00cf3, 0x00d02,
    0x00d04, 0x00d05,
    0x00d0d, 0x00d0e,
    0x00d11, 0x00d12,
    0x00d3b, 0x00d3d,
    0x00d45, 0x00d46,
    0x00d49, 0x00d4a,
    0x00d4f, 0x00d57,
    0x00d58, 0x00d60,
    0x00d64, 0x00d66,
    0x00d76, 0x00d79,
    0x00d80, 0x00d82,
    0x00d84, 0x00d85,
    0x00d97, 0x00d9a,
    0x00db2, 0x00db3,
    0x00dbc, 0x00dbd,
    0x00dbe, 0x00dc0,
    0x00dc7, 0x00dca,
    0x00dcb, 0x00dcf,
    0x00dd5, 0x00dd6,
    0x00dd7, 0x00dd8,
    0x00de0, 0x00df2,
    0x00df5, 0x00e01,
    0x00e3b, 0x00e3f,
    0x00e5c, 0x00e81,
    0x00e83, 0x00e84,
    0x00e85, 0x00e87,
    0x00e89, 0x00e8a,
    0x00e8b, 0x00e8d,
    0x00e8e, 0x00e94,
    0x00e98, 0x00e99,
    0x00ea0, 0x00ea1,
    0x00ea4, 0x00ea5,
    0x00ea6, 0x00ea7,
    0x00ea8, 0x00eaa,
    0x00eac, 0x00ead,
    0x00eba, 0x00ebb,
    0x00ebe, 0x00ec0,
    0x00ec5, 0x00ec6,
    0x00ec7, 0x00ec8,
    0x00ece, 0x00ed0,
    0x00eda, 0x00edc,
    0x00ede, 0x00f00,
    0x00f48, 0x00f49,
    0x00f6d, 0x00f71,
    0x00f98, 0x00f99,
    0x00fbd, 0x00fbe,
    0x00fcd, 0x00fce,
    0x00fdb, 0x01000,
    0x010c6, 0x010d0,
    0x010fd, 0x01100,
    0x01249, 0x0124a,
    0x0124e, 0x01250,
    0x01257, 0x01258,
    0x01259, 0x0125a,
    0x0125e, 0x01260,
    0x01289, 0x0128a,
    0x0128e, 0x01290,
    0x012b1, 0x012b2,
    0x012b6, 0x012b8,
    0x012bf, 0x012c0,
    0x012c1, 0x012c2,
    0x012c6, 0x012c8,
    0x012d7, 0x012d8,
    0x01311, 0x01312,
    0x01316, 0x01318,
    0x0135b, 0x0135d,
    0x0137d, 0x01380,
    0x0139a, 0x013a0,
    0x013f5, 0x01400,
    0x0169d, 0x016a0,
    0x016f1, 0x01700,
    0x0170d, 0x0170e,
    0x01715, 0x01720,
    0x01737, 0x01740,
    0x01754, 0x01760,
    0x0176d, 0x0176e,
    0x01771, 0x01772,
    0x01774, 0x01780,
    0x017de, 0x017e0,
    0x017ea, 0x017f0,
    0x017fa, 0x01800,
    0x0180f, 0x01810,
    0x0181a, 0x01820,
    0x01878, 0x01880,
    0x018ab, 0x018b0,
    0x018f6, 0x01900,
    0x0191d, 0x01920,
    0x0192c, 0x01930,
    0x0193c, 0x01940,
    0x01941, 0x01944,
    0x0196e, 0x01970,
    0x01975, 0x01980,
    0x019ac, 0x019b0,
    0x019ca, 0x019d0,
    0x019db, 0x019de,
    0x01a1c, 0x01a1e,
    0x01a5f, 0x01a60,
    0x01a7d, 0x01a7f,
    0x01a8a, 0x01a90,
    0x01a9a, 0x01aa0,
    0x01aae, 0x01b00,
    0x01b4c, 0x01b50,
    0x01b7d, 0x01b80,
    0x01bab, 0x01bae,
    0x01bba, 0x01bc0,
    0x01bf4, 0x01bfc,
    0x01c38, 0x01c3b,
    0x01c4a, 0x01c4d,
    0x01c80, 0x01cd0,
    0x01cf3, 0x01d00,
    0x01de7, 0x01dfc,
    0x01f16, 0x01f18,
    0x01f1e, 0x01f20,
    0x01f46, 0x01f48,
    0x01f4e, 0x01f50,
    0x01f58, 0x01f59,
    0x01f5a, 0x01f5b,
    0x01f5c, 0x01f5d,
    0x01f5e, 0x01f5f,
    0x01f7e, 0x01f80,
    0x01fb5, 0x01fb6,
    0x01fc5, 0x01fc6,
    0x01fd4, 0x01fd6,
    0x01fdc, 0x01fdd,
    0x01ff0, 0x01ff2,
    0x01ff5, 0x01ff6,
    0x01fff, 0x02000,
    0x02065, 0x0206a,
    0x02072, 0x02074,
    0x0208f, 0x02090,
    0x0209d, 0x020a0,
    0x020ba, 0x020d0,
    0x020f1, 0x02100,
    0x0218a, 0x02190,
    0x023f4, 0x02400,
    0x02427, 0x02440,
    0x0244b, 0x02460,
    0x02700, 0x02701,
    0x027cb, 0x027cc,
    0x027cd, 0x027ce,
    0x02b4d, 0x02b50,
    0x02b5a, 0x02c00,
    0x02c2f, 0x02c30,
    0x02c5f, 0x02c60,
    0x02cf2, 0x02cf9,
    0x02d26, 0x02d30,
    0x02d66, 0x02d6f,
    0x02d71, 0x02d7f,
    0x02d97, 0x02da0,
    0x02da7, 0x02da8,
    0x02daf, 0x02db0,
    0x02db7, 0x02db8,
    0x02dbf, 0x02dc0,
    0x02dc7, 0x02dc8,
    0x02dcf, 0x02dd0,
    0x02dd7, 0x02dd8,
    0x02ddf, 0x02de0,
    0x02e32, 0x02e80,
    0x02e9a, 0x02e9b,
    0x02ef4, 0x02f00,
    0x02fd6, 0x02ff0,
    0x02ffc, 0x03000,
    0x03040, 0x03041,
    0x03097, 0x03099,
    0x03100, 0x03105,
    0x0312e, 0x03131,
    0x0318f, 0x03190,
    0x031bb, 0x031c0,
    0x031e4, 0x031f0,
    0x0321f, 0x03220,
    0x032ff, 0x03300,
    0x04db6, 0x04dc0,
    0x09fcc, 0x0a000,
    0x0a48d, 0x0a490,
    0x0a4c7, 0x0a4d0,
    0x0a62c, 0x0a640,
    0x0a674, 0x0a67c,
    0x0a698, 0x0a6a0,
    0x0a6f8, 0x0a700,
    0x0a78f, 0x0a790,
    0x0a792, 0x0a7a0,
    0x0a7aa, 0x0a7fa,
    0x0a82c, 0x0a830,
    0x0a83a, 0x0a840,
    0x0a878, 0x0a880,
    0x0a8c5, 0x0a8ce,
    0x0a8da, 0x0a8e0,
    0x0a8fc, 0x0a900,
    0x0a954, 0x0a95f,
    0x0a97d, 0x0a980,
    0x0a9ce, 0x0a9cf,
    0x0a9da, 0x0a9de,
    0x0a9e0, 0x0aa00,
    0x0aa37, 0x0aa40,
    0x0aa4e, 0x0aa50,
    0x0aa5a, 0x0aa5c,
    0x0aa7c, 0x0aa80,
    0x0aac3, 0x0aadb,
    0x0aae0, 0x0ab01,
    0x0ab07, 0x0ab09,
    0x0ab0f, 0x0ab11,
    0x0ab17, 0x0ab20,
    0x0ab27, 0x0ab28,
    0x0ab2f, 0x0abc0,
    0x0abee, 0x0abf0,
    0x0abfa, 0x0ac00,
    0x0d7a4, 0x0d7b0,
    0x0d7c7, 0x0d7cb,
    0x0d7fc, 0x0d800,
    0x0fa2e, 0x0fa30,
    0x0fa6e, 0x0fa70,
    0x0fada, 0x0fb00,
    0x0fb07, 0x0fb13,
    0x0fb18, 0x0fb1d,
    0x0fb37, 0x0fb38,
    0x0fb3d, 0x0fb3e,
    0x0fb3f, 0x0fb40,
    0x0fb42, 0x0fb43,
    0x0fb45, 0x0fb46,
    0x0fbc2, 0x0fbd3,
    0x0fd40, 0x0fd50,
    0x0fd90, 0x0fd92,
    0x0fdc8, 0x0fdf0,
    0x0fdfe, 0x0fe00,
    0x0fe1a, 0x0fe20,
    0x0fe27, 0x0fe30,
    0x0fe53, 0x0fe54,
    0x0fe67, 0x0fe68,
    0x0fe6c, 0x0fe70,
    0x0fe75, 0x0fe76,
    0x0fefd, 0x0feff,
    0x0ff00, 0x0ff01,
    0x0ffbf, 0x0ffc2,
    0x0ffc8, 0x0ffca,
    0x0ffd0, 0x0ffd2,
    0x0ffd8, 0x0ffda,
    0x0ffdd, 0x0ffe0,
    0x0ffe7, 0x0ffe8,
    0x0ffef, 0x0fff9,
    0x0fffe, 0x10000,
    0x1000c, 0x1000d,
    0x10027, 0x10028,
    0x1003b, 0x1003c,
    0x1003e, 0x1003f,
    0x1004e, 0x10050,
    0x1005e, 0x10080,
    0x100fb, 0x10100,
    0x10103, 0x10107,
    0x10134, 0x10137,
    0x1018b, 0x10190,
    0x1019c, 0x101d0,
    0x101fe, 0x10280,
    0x1029d, 0x102a0,
    0x102d1, 0x10300,
    0x1031f, 0x10320,
    0x10324, 0x10330,
    0x1034b, 0x10380,
    0x1039e, 0x1039f,
    0x103c4, 0x103c8,
    0x103d6, 0x10400,
    0x1049e, 0x104a0,
    0x104aa, 0x10800,
    0x10806, 0x10808,
    0x10809, 0x1080a,
    0x10836, 0x10837,
    0x10839, 0x1083c,
    0x1083d, 0x1083f,
    0x10856, 0x10857,
    0x10860, 0x10900,
    0x1091c, 0x1091f,
    0x1093a, 0x1093f,
    0x10940, 0x10a00,
    0x10a04, 0x10a05,
    0x10a07, 0x10a0c,
    0x10a14, 0x10a15,
    0x10a18, 0x10a19,
    0x10a34, 0x10a38,
    0x10a3b, 0x10a3f,
    0x10a48, 0x10a50,
    0x10a59, 0x10a60,
    0x10a80, 0x10b00,
    0x10b36, 0x10b39,
    0x10b56, 0x10b58,
    0x10b73, 0x10b78,
    0x10b80, 0x10c00,
    0x10c49, 0x10e60,
    0x10e7f, 0x11000,
    0x1104e, 0x11052,
    0x11070, 0x11080,
    0x110c2, 0x12000,
    0x1236f, 0x12400,
    0x12463, 0x12470,
    0x12474, 0x13000,
    0x1342f, 0x16800,
    0x16a39, 0x1b000,
    0x1b002, 0x1d000,
    0x1d0f6, 0x1d100,
    0x1d127, 0x1d129,
    0x1d1de, 0x1d200,
    0x1d246, 0x1d300,
    0x1d357, 0x1d360,
    0x1d372, 0x1d400,
    0x1d455, 0x1d456,
    0x1d49d, 0x1d49e,
    0x1d4a0, 0x1d4a2,
    0x1d4a3, 0x1d4a5,
    0x1d4a7, 0x1d4a9,
    0x1d4ad, 0x1d4ae,
    0x1d4ba, 0x1d4bb,
    0x1d4bc, 0x1d4bd,
    0x1d4c4, 0x1d4c5,
    0x1d506, 0x1d507,
    0x1d50b, 0x1d50d,
    0x1d515, 0x1d516,
    0x1d51d, 0x1d51e,
    0x1d53a, 0x1d53b,
    0x1d53f, 0x1d540,
    0x1d545, 0x1d546,
    0x1d547, 0x1d54a,
    0x1d551, 0x1d552,
    0x1d6a6, 0x1d6a8,
    0x1d7cc, 0x1d7ce,
    0x1d800, 0x1f000,
    0x1f02c, 0x1f030,
    0x1f094, 0x1f0a0,
    0x1f0af, 0x1f0b1,
    0x1f0bf, 0x1f0c1,
    0x1f0d0, 0x1f0d1,
    0x1f0e0, 0x1f100,
    0x1f10b, 0x1f110,
    0x1f12f, 0x1f130,
    0x1f16a, 0x1f170,
    0x1f19b, 0x1f1e6,
    0x1f203, 0x1f210,
    0x1f23b, 0x1f240,
    0x1f249, 0x1f250,
    0x1f252, 0x1f300,
    0x1f321, 0x1f330,
    0x1f336, 0x1f337,
    0x1f37d, 0x1f380,
    0x1f394, 0x1f3a0,
    0x1f3c5, 0x1f3c6,
    0x1f3cb, 0x1f3e0,
    0x1f3f1, 0x1f400,
    0x1f43f, 0x1f440,
    0x1f441, 0x1f442,
    0x1f4f8, 0x1f4f9,
    0x1f4fd, 0x1f500,
    0x1f53e, 0x1f550,
    0x1f568, 0x1f5fb,
    0x1f600, 0x1f601,
    0x1f611, 0x1f612,
    0x1f615, 0x1f616,
    0x1f617, 0x1f618,
    0x1f619, 0x1f61a,
    0x1f61b, 0x1f61c,
    0x1f61f, 0x1f620,
    0x1f626, 0x1f628,
    0x1f62c, 0x1f62d,
    0x1f62e, 0x1f630,
    0x1f634, 0x1f635,
    0x1f641, 0x1f645,
    0x1f650, 0x1f680,
    0x1f6c6, 0x1f700,
    0x1f774, 0x20000,
    0x2a6d7, 0x2a700,
    0x2b735, 0x2b740,
    0x2b81e, 0x2f800,
    0x2fa1e, 0xe0001,
    0xe0002, 0xe0020,
    0xe0080, 0xe0100,
    0xe01f0, 0xf0000,
    0xffffe, 0x100000,
    0x10fffe, 0x110000,
]);

immutable(CodepointSet) unicodeInPhaistos_Disc = CodepointSet([
    0x101d0, 0x10200,
]);

immutable(CodepointSet) unicodeCo = CodepointSet([
    0x0e000, 0x0f900,
    0xf0000, 0xffffe,
    0x100000, 0x10fffe,
]);

immutable(CodepointSet) unicodeInKana_Supplement = CodepointSet([
    0x1b000, 0x1b100,
]);

immutable(CodepointSet) unicodeMath = CodepointSet([
    0x0002b, 0x0002c,
    0x0003c, 0x0003f,
    0x0005e, 0x0005f,
    0x0007c, 0x0007d,
    0x0007e, 0x0007f,
    0x000ac, 0x000ad,
    0x000b1, 0x000b2,
    0x000d7, 0x000d8,
    0x000f7, 0x000f8,
    0x003d0, 0x003d3,
    0x003d5, 0x003d6,
    0x003f0, 0x003f2,
    0x003f4, 0x003f7,
    0x00606, 0x00609,
    0x02016, 0x02017,
    0x02032, 0x02035,
    0x02040, 0x02041,
    0x02044, 0x02045,
    0x02052, 0x02053,
    0x02061, 0x02065,
    0x0207a, 0x0207f,
    0x0208a, 0x0208f,
    0x020d0, 0x020dd,
    0x020e1, 0x020e2,
    0x020e5, 0x020e7,
    0x020eb, 0x020f0,
    0x02102, 0x02103,
    0x02107, 0x02108,
    0x0210a, 0x02114,
    0x02115, 0x02116,
    0x02118, 0x0211e,
    0x02124, 0x02125,
    0x02128, 0x0212a,
    0x0212c, 0x0212e,
    0x0212f, 0x02132,
    0x02133, 0x02139,
    0x0213c, 0x0214a,
    0x0214b, 0x0214c,
    0x02190, 0x021a8,
    0x021a9, 0x021af,
    0x021b0, 0x021b2,
    0x021b6, 0x021b8,
    0x021bc, 0x021dc,
    0x021dd, 0x021de,
    0x021e4, 0x021e6,
    0x021f4, 0x02300,
    0x02308, 0x0230c,
    0x02320, 0x02322,
    0x0237c, 0x0237d,
    0x0239b, 0x023b6,
    0x023b7, 0x023b8,
    0x023d0, 0x023d1,
    0x023dc, 0x023e3,
    0x025a0, 0x025a2,
    0x025ae, 0x025b8,
    0x025bc, 0x025c2,
    0x025c6, 0x025c8,
    0x025ca, 0x025cc,
    0x025cf, 0x025d4,
    0x025e2, 0x025e3,
    0x025e4, 0x025e5,
    0x025e7, 0x025ed,
    0x025f8, 0x02600,
    0x02605, 0x02607,
    0x02640, 0x02641,
    0x02642, 0x02643,
    0x02660, 0x02664,
    0x0266d, 0x02670,
    0x027c0, 0x027cb,
    0x027cc, 0x027cd,
    0x027ce, 0x02800,
    0x02900, 0x02b00,
    0x02b30, 0x02b45,
    0x02b47, 0x02b4d,
    0x0fb29, 0x0fb2a,
    0x0fe61, 0x0fe67,
    0x0fe68, 0x0fe69,
    0x0ff0b, 0x0ff0c,
    0x0ff1c, 0x0ff1f,
    0x0ff3c, 0x0ff3d,
    0x0ff3e, 0x0ff3f,
    0x0ff5c, 0x0ff5d,
    0x0ff5e, 0x0ff5f,
    0x0ffe2, 0x0ffe3,
    0x0ffe9, 0x0ffed,
    0x1d400, 0x1d455,
    0x1d456, 0x1d49d,
    0x1d49e, 0x1d4a0,
    0x1d4a2, 0x1d4a3,
    0x1d4a5, 0x1d4a7,
    0x1d4a9, 0x1d4ad,
    0x1d4ae, 0x1d4ba,
    0x1d4bb, 0x1d4bc,
    0x1d4bd, 0x1d4c4,
    0x1d4c5, 0x1d506,
    0x1d507, 0x1d50b,
    0x1d50d, 0x1d515,
    0x1d516, 0x1d51d,
    0x1d51e, 0x1d53a,
    0x1d53b, 0x1d53f,
    0x1d540, 0x1d545,
    0x1d546, 0x1d547,
    0x1d54a, 0x1d551,
    0x1d552, 0x1d6a6,
    0x1d6a8, 0x1d7cc,
    0x1d7ce, 0x1d800,
]);

immutable(CodepointSet) unicodeInLinear_B_Ideograms = CodepointSet([
    0x10080, 0x10100,
]);

immutable(CodepointSet) unicodeInYi_Syllables = CodepointSet([
    0x0a000, 0x0a490,
]);

immutable(CodepointSet) unicodeInInscriptional_Pahlavi = CodepointSet([
    0x10b60, 0x10b80,
]);

immutable(CodepointSet) unicodeCs = CodepointSet([
    0x0d800, 0x0e000,
]);

immutable(CodepointSet) unicodeInHangul_Jamo_Extended_A = CodepointSet([
    0x0a960, 0x0a980,
]);

immutable(CodepointSet) unicodeInGlagolitic = CodepointSet([
    0x02c00, 0x02c60,
]);

immutable(CodepointSet) unicodeInHangul_Jamo_Extended_B = CodepointSet([
    0x0d7b0, 0x0d800,
]);

immutable(CodepointSet) unicodeInSpecials = CodepointSet([
    0x0fff0, 0x10000,
]);

immutable(CodepointSet) unicodeBopomofo = CodepointSet([
    0x002ea, 0x002ec,
    0x03105, 0x0312e,
    0x031a0, 0x031bb,
]);

immutable(CodepointSet) unicodeInBamum = CodepointSet([
    0x0a6a0, 0x0a700,
]);

immutable(CodepointSet) unicodeInPlaying_Cards = CodepointSet([
    0x1f0a0, 0x1f100,
]);

immutable(CodepointSet) unicodeInArabic = CodepointSet([
    0x00600, 0x00700,
]);

immutable(CodepointSet) unicodeVariation_Selector = CodepointSet([
    0x0180b, 0x0180e,
    0x0fe00, 0x0fe10,
    0xe0100, 0xe01f0,
]);

immutable(CodepointSet) unicodeInMathematical_Operators = CodepointSet([
    0x02200, 0x02300,
]);

immutable(CodepointSet) unicodeInPhonetic_Extensions_Supplement = CodepointSet([
    0x01d80, 0x01dc0,
]);

immutable(CodepointSet) unicodeInBrahmi = CodepointSet([
    0x11000, 0x11080,
]);

immutable(CodepointSet) unicodeMalayalam = CodepointSet([
    0x00d02, 0x00d04,
    0x00d05, 0x00d0d,
    0x00d0e, 0x00d11,
    0x00d12, 0x00d3b,
    0x00d3d, 0x00d45,
    0x00d46, 0x00d49,
    0x00d4a, 0x00d4f,
    0x00d57, 0x00d58,
    0x00d60, 0x00d64,
    0x00d66, 0x00d76,
    0x00d79, 0x00d80,
]);

immutable(CodepointSet) unicodeInCJK_Unified_Ideographs_Extension_A = CodepointSet([
    0x03400, 0x04dc0,
]);

immutable(CodepointSet) unicodeInCJK_Unified_Ideographs_Extension_B = CodepointSet([
    0x20000, 0x2a6e0,
]);

immutable(CodepointSet) unicodeInYijing_Hexagram_Symbols = CodepointSet([
    0x04dc0, 0x04e00,
]);

immutable(CodepointSet) unicodeInCJK_Unified_Ideographs_Extension_C = CodepointSet([
    0x2a700, 0x2b740,
]);

immutable(CodepointSet) unicodeInTibetan = CodepointSet([
    0x00f00, 0x01000,
]);

immutable(CodepointSet) unicodeInImperial_Aramaic = CodepointSet([
    0x10840, 0x10860,
]);

immutable(CodepointSet) unicodeInCJK_Unified_Ideographs_Extension_D = CodepointSet([
    0x2b740, 0x2b820,
]);

immutable(CodepointSet) unicodeInAlchemical_Symbols = CodepointSet([
    0x1f700, 0x1f780,
]);

immutable(CodepointSet) unicodePattern_White_Space = CodepointSet([
    0x00009, 0x0000e,
    0x00020, 0x00021,
    0x00085, 0x00086,
    0x0200e, 0x02010,
    0x02028, 0x0202a,
]);

immutable(CodepointSet) unicodeInEmoticons = CodepointSet([
    0x1f600, 0x1f650,
]);

immutable(CodepointSet) unicodeInYi_Radicals = CodepointSet([
    0x0a490, 0x0a4d0,
]);

immutable(CodepointSet) unicodeInBraille_Patterns = CodepointSet([
    0x02800, 0x02900,
]);

immutable(CodepointSet) unicodeInscriptional_Pahlavi = CodepointSet([
    0x10b60, 0x10b73,
    0x10b78, 0x10b80,
]);

immutable(CodepointSet) unicodeInCoptic = CodepointSet([
    0x02c80, 0x02d00,
]);

immutable(CodepointSet) unicodeInGothic = CodepointSet([
    0x10330, 0x10350,
]);

immutable(CodepointSet) unicodeInDevanagari = CodepointSet([
    0x00900, 0x00980,
]);

immutable(CodepointSet) unicodeSTerm = CodepointSet([
    0x00021, 0x00022,
    0x0002e, 0x0002f,
    0x0003f, 0x00040,
    0x0055c, 0x0055d,
    0x0055e, 0x0055f,
    0x00589, 0x0058a,
    0x0061f, 0x00620,
    0x006d4, 0x006d5,
    0x00700, 0x00703,
    0x007f9, 0x007fa,
    0x00964, 0x00966,
    0x0104a, 0x0104c,
    0x01362, 0x01363,
    0x01367, 0x01369,
    0x0166e, 0x0166f,
    0x01735, 0x01737,
    0x01803, 0x01804,
    0x01809, 0x0180a,
    0x01944, 0x01946,
    0x01aa8, 0x01aac,
    0x01b5a, 0x01b5c,
    0x01b5e, 0x01b60,
    0x01c3b, 0x01c3d,
    0x01c7e, 0x01c80,
    0x0203c, 0x0203e,
    0x02047, 0x0204a,
    0x02e2e, 0x02e2f,
    0x03002, 0x03003,
    0x0a4ff, 0x0a500,
    0x0a60e, 0x0a610,
    0x0a6f3, 0x0a6f4,
    0x0a6f7, 0x0a6f8,
    0x0a876, 0x0a878,
    0x0a8ce, 0x0a8d0,
    0x0a92f, 0x0a930,
    0x0a9c8, 0x0a9ca,
    0x0aa5d, 0x0aa60,
    0x0abeb, 0x0abec,
    0x0fe52, 0x0fe53,
    0x0fe56, 0x0fe58,
    0x0ff01, 0x0ff02,
    0x0ff0e, 0x0ff0f,
    0x0ff1f, 0x0ff20,
    0x0ff61, 0x0ff62,
    0x10a56, 0x10a58,
    0x11047, 0x11049,
    0x110be, 0x110c2,
]);

immutable(CodepointSet) unicodeInTai_Viet = CodepointSet([
    0x0aa80, 0x0aae0,
]);

immutable(CodepointSet) unicodeInDeseret = CodepointSet([
    0x10400, 0x10450,
]);

immutable(CodepointSet) unicodeHebrew = CodepointSet([
    0x00591, 0x005c8,
    0x005d0, 0x005eb,
    0x005f0, 0x005f5,
    0x0fb1d, 0x0fb37,
    0x0fb38, 0x0fb3d,
    0x0fb3e, 0x0fb3f,
    0x0fb40, 0x0fb42,
    0x0fb43, 0x0fb45,
    0x0fb46, 0x0fb50,
]);

immutable(CodepointSet) unicodeLisu = CodepointSet([
    0x0a4d0, 0x0a500,
]);

immutable(CodepointSet) unicodeInSupplementary_Private_Use_Area_A = CodepointSet([
    0xf0000, 0x100000,
]);

immutable(CodepointSet) unicodeInSupplementary_Private_Use_Area_B = CodepointSet([
    0x100000, 0x110000,
]);

immutable(CodepointSet) unicodeUgaritic = CodepointSet([
    0x10380, 0x1039e,
    0x1039f, 0x103a0,
]);

immutable(CodepointSet) unicodeInMongolian = CodepointSet([
    0x01800, 0x018b0,
]);

immutable(CodepointSet) unicodeInBopomofo = CodepointSet([
    0x03100, 0x03130,
]);

immutable(CodepointSet) unicodeOld_Persian = CodepointSet([
    0x103a0, 0x103c4,
    0x103c8, 0x103d6,
]);

immutable(CodepointSet) unicodeInCJK_Compatibility_Ideographs_Supplement = CodepointSet([
    0x2f800, 0x2fa20,
]);

immutable(CodepointSet) unicodeInMahjong_Tiles = CodepointSet([
    0x1f000, 0x1f030,
]);

immutable(CodepointSet) unicodePhoenician = CodepointSet([
    0x10900, 0x1091c,
    0x1091f, 0x10920,
]);

immutable(CodepointSet) unicodeEgyptian_Hieroglyphs = CodepointSet([
    0x13000, 0x1342f,
]);

immutable(CodepointSet) unicodeInVariation_Selectors_Supplement = CodepointSet([
    0xe0100, 0xe01f0,
]);

immutable(CodepointSet) unicodeInLisu = CodepointSet([
    0x0a4d0, 0x0a500,
]);

immutable(CodepointSet) unicodeInLow_Surrogates = CodepointSet([
    0x0dc00, 0x0e000,
]);

immutable(CodepointSet) unicodeInUgaritic = CodepointSet([
    0x10380, 0x103a0,
]);

immutable(CodepointSet) unicodeInAncient_Greek_Musical_Notation = CodepointSet([
    0x1d200, 0x1d250,
]);

immutable(CodepointSet) unicodeInSupplemental_Punctuation = CodepointSet([
    0x02e00, 0x02e80,
]);

immutable(CodepointSet) unicodeInTamil = CodepointSet([
    0x00b80, 0x00c00,
]);

immutable(CodepointSet) unicodeBidi_Control = CodepointSet([
    0x0200e, 0x02010,
    0x0202a, 0x0202f,
]);

immutable(CodepointSet) unicodeKatakana = CodepointSet([
    0x030a1, 0x030fb,
    0x030fd, 0x03100,
    0x031f0, 0x03200,
    0x032d0, 0x032ff,
    0x03300, 0x03358,
    0x0ff66, 0x0ff70,
    0x0ff71, 0x0ff9e,
    0x1b000, 0x1b001,
]);

immutable(CodepointSet) unicodeInKanbun = CodepointSet([
    0x03190, 0x031a0,
]);

immutable(CodepointSet) unicodeInHebrew = CodepointSet([
    0x00590, 0x00600,
]);

immutable(CodepointSet) unicodeTai_Viet = CodepointSet([
    0x0aa80, 0x0aac3,
    0x0aadb, 0x0aae0,
]);

immutable(CodepointSet) unicodeShavian = CodepointSet([
    0x10450, 0x10480,
]);

immutable(CodepointSet) unicodeInHanunoo = CodepointSet([
    0x01720, 0x01740,
]);

immutable(CodepointSet) unicodeOther_Lowercase = CodepointSet([
    0x002b0, 0x002b9,
    0x002c0, 0x002c2,
    0x002e0, 0x002e5,
    0x00345, 0x00346,
    0x0037a, 0x0037b,
    0x01d2c, 0x01d62,
    0x01d78, 0x01d79,
    0x01d9b, 0x01dc0,
    0x02090, 0x02095,
    0x02170, 0x02180,
    0x024d0, 0x024ea,
    0x02c7d, 0x02c7e,
    0x0a770, 0x0a771,
]);

immutable(CodepointSet) unicodeDash = CodepointSet([
    0x0002d, 0x0002e,
    0x0058a, 0x0058b,
    0x005be, 0x005bf,
    0x01400, 0x01401,
    0x01806, 0x01807,
    0x02010, 0x02016,
    0x02053, 0x02054,
    0x0207b, 0x0207c,
    0x0208b, 0x0208c,
    0x02212, 0x02213,
    0x02e17, 0x02e18,
    0x02e1a, 0x02e1b,
    0x0301c, 0x0301d,
    0x03030, 0x03031,
    0x030a0, 0x030a1,
    0x0fe31, 0x0fe33,
    0x0fe58, 0x0fe59,
    0x0fe63, 0x0fe64,
    0x0ff0d, 0x0ff0e,
]);

immutable(CodepointSet) unicodeInSinhala = CodepointSet([
    0x00d80, 0x00e00,
]);

immutable(CodepointSet) unicodeKaithi = CodepointSet([
    0x11080, 0x110c2,
]);

immutable(CodepointSet) unicodeInSundanese = CodepointSet([
    0x01b80, 0x01bc0,
]);

immutable(CodepointSet) unicodeInEthiopic_Extended_A = CodepointSet([
    0x0ab00, 0x0ab30,
]);

immutable(CodepointSet) unicodeInAegean_Numbers = CodepointSet([
    0x10100, 0x10140,
]);

immutable(CodepointSet) unicodeTibetan = CodepointSet([
    0x00f00, 0x00f48,
    0x00f49, 0x00f6d,
    0x00f71, 0x00f98,
    0x00f99, 0x00fbd,
    0x00fbe, 0x00fcd,
    0x00fce, 0x00fd5,
    0x00fd9, 0x00fdb,
]);

immutable(CodepointSet) unicodeSamaritan = CodepointSet([
    0x00800, 0x0082e,
    0x00830, 0x0083f,
]);

immutable(CodepointSet) unicodeInOptical_Character_Recognition = CodepointSet([
    0x02440, 0x02460,
]);

immutable(CodepointSet) unicodeInKatakana = CodepointSet([
    0x030a0, 0x03100,
]);

immutable(CodepointSet) unicodeInVariation_Selectors = CodepointSet([
    0x0fe00, 0x0fe10,
]);

immutable(CodepointSet) unicodeOld_Italic = CodepointSet([
    0x10300, 0x1031f,
    0x10320, 0x10324,
]);

immutable(CodepointSet) unicodeInEnclosed_CJK_Letters_and_Months = CodepointSet([
    0x03200, 0x03300,
]);

immutable(CodepointSet) unicodeInLatin_1_Supplement = CodepointSet([
    0x00080, 0x00100,
]);

immutable(CodepointSet) unicodeHan = CodepointSet([
    0x02e80, 0x02e9a,
    0x02e9b, 0x02ef4,
    0x02f00, 0x02fd6,
    0x03005, 0x03006,
    0x03007, 0x03008,
    0x03021, 0x0302a,
    0x03038, 0x0303c,
    0x03400, 0x04db6,
    0x04e00, 0x09fcc,
    0x0f900, 0x0fa2e,
    0x0fa30, 0x0fa6e,
    0x0fa70, 0x0fada,
    0x20000, 0x2a6d7,
    0x2a700, 0x2b735,
    0x2b740, 0x2b81e,
    0x2f800, 0x2fa1e,
]);

immutable(CodepointSet) unicodeDeseret = CodepointSet([
    0x10400, 0x10450,
]);

immutable(CodepointSet) unicodeInMyanmar = CodepointSet([
    0x01000, 0x010a0,
]);

immutable(CodepointSet) unicodeLl = CodepointSet([
    0x00061, 0x0007b,
    0x000aa, 0x000ab,
    0x000b5, 0x000b6,
    0x000ba, 0x000bb,
    0x000df, 0x000f7,
    0x000f8, 0x00100,
    0x00101, 0x00102,
    0x00103, 0x00104,
    0x00105, 0x00106,
    0x00107, 0x00108,
    0x00109, 0x0010a,
    0x0010b, 0x0010c,
    0x0010d, 0x0010e,
    0x0010f, 0x00110,
    0x00111, 0x00112,
    0x00113, 0x00114,
    0x00115, 0x00116,
    0x00117, 0x00118,
    0x00119, 0x0011a,
    0x0011b, 0x0011c,
    0x0011d, 0x0011e,
    0x0011f, 0x00120,
    0x00121, 0x00122,
    0x00123, 0x00124,
    0x00125, 0x00126,
    0x00127, 0x00128,
    0x00129, 0x0012a,
    0x0012b, 0x0012c,
    0x0012d, 0x0012e,
    0x0012f, 0x00130,
    0x00131, 0x00132,
    0x00133, 0x00134,
    0x00135, 0x00136,
    0x00137, 0x00139,
    0x0013a, 0x0013b,
    0x0013c, 0x0013d,
    0x0013e, 0x0013f,
    0x00140, 0x00141,
    0x00142, 0x00143,
    0x00144, 0x00145,
    0x00146, 0x00147,
    0x00148, 0x0014a,
    0x0014b, 0x0014c,
    0x0014d, 0x0014e,
    0x0014f, 0x00150,
    0x00151, 0x00152,
    0x00153, 0x00154,
    0x00155, 0x00156,
    0x00157, 0x00158,
    0x00159, 0x0015a,
    0x0015b, 0x0015c,
    0x0015d, 0x0015e,
    0x0015f, 0x00160,
    0x00161, 0x00162,
    0x00163, 0x00164,
    0x00165, 0x00166,
    0x00167, 0x00168,
    0x00169, 0x0016a,
    0x0016b, 0x0016c,
    0x0016d, 0x0016e,
    0x0016f, 0x00170,
    0x00171, 0x00172,
    0x00173, 0x00174,
    0x00175, 0x00176,
    0x00177, 0x00178,
    0x0017a, 0x0017b,
    0x0017c, 0x0017d,
    0x0017e, 0x00181,
    0x00183, 0x00184,
    0x00185, 0x00186,
    0x00188, 0x00189,
    0x0018c, 0x0018e,
    0x00192, 0x00193,
    0x00195, 0x00196,
    0x00199, 0x0019c,
    0x0019e, 0x0019f,
    0x001a1, 0x001a2,
    0x001a3, 0x001a4,
    0x001a5, 0x001a6,
    0x001a8, 0x001a9,
    0x001aa, 0x001ac,
    0x001ad, 0x001ae,
    0x001b0, 0x001b1,
    0x001b4, 0x001b5,
    0x001b6, 0x001b7,
    0x001b9, 0x001bb,
    0x001bd, 0x001c0,
    0x001c6, 0x001c7,
    0x001c9, 0x001ca,
    0x001cc, 0x001cd,
    0x001ce, 0x001cf,
    0x001d0, 0x001d1,
    0x001d2, 0x001d3,
    0x001d4, 0x001d5,
    0x001d6, 0x001d7,
    0x001d8, 0x001d9,
    0x001da, 0x001db,
    0x001dc, 0x001de,
    0x001df, 0x001e0,
    0x001e1, 0x001e2,
    0x001e3, 0x001e4,
    0x001e5, 0x001e6,
    0x001e7, 0x001e8,
    0x001e9, 0x001ea,
    0x001eb, 0x001ec,
    0x001ed, 0x001ee,
    0x001ef, 0x001f1,
    0x001f3, 0x001f4,
    0x001f5, 0x001f6,
    0x001f9, 0x001fa,
    0x001fb, 0x001fc,
    0x001fd, 0x001fe,
    0x001ff, 0x00200,
    0x00201, 0x00202,
    0x00203, 0x00204,
    0x00205, 0x00206,
    0x00207, 0x00208,
    0x00209, 0x0020a,
    0x0020b, 0x0020c,
    0x0020d, 0x0020e,
    0x0020f, 0x00210,
    0x00211, 0x00212,
    0x00213, 0x00214,
    0x00215, 0x00216,
    0x00217, 0x00218,
    0x00219, 0x0021a,
    0x0021b, 0x0021c,
    0x0021d, 0x0021e,
    0x0021f, 0x00220,
    0x00221, 0x00222,
    0x00223, 0x00224,
    0x00225, 0x00226,
    0x00227, 0x00228,
    0x00229, 0x0022a,
    0x0022b, 0x0022c,
    0x0022d, 0x0022e,
    0x0022f, 0x00230,
    0x00231, 0x00232,
    0x00233, 0x0023a,
    0x0023c, 0x0023d,
    0x0023f, 0x00241,
    0x00242, 0x00243,
    0x00247, 0x00248,
    0x00249, 0x0024a,
    0x0024b, 0x0024c,
    0x0024d, 0x0024e,
    0x0024f, 0x00294,
    0x00295, 0x002b0,
    0x00371, 0x00372,
    0x00373, 0x00374,
    0x00377, 0x00378,
    0x0037b, 0x0037e,
    0x00390, 0x00391,
    0x003ac, 0x003cf,
    0x003d0, 0x003d2,
    0x003d5, 0x003d8,
    0x003d9, 0x003da,
    0x003db, 0x003dc,
    0x003dd, 0x003de,
    0x003df, 0x003e0,
    0x003e1, 0x003e2,
    0x003e3, 0x003e4,
    0x003e5, 0x003e6,
    0x003e7, 0x003e8,
    0x003e9, 0x003ea,
    0x003eb, 0x003ec,
    0x003ed, 0x003ee,
    0x003ef, 0x003f4,
    0x003f5, 0x003f6,
    0x003f8, 0x003f9,
    0x003fb, 0x003fd,
    0x00430, 0x00460,
    0x00461, 0x00462,
    0x00463, 0x00464,
    0x00465, 0x00466,
    0x00467, 0x00468,
    0x00469, 0x0046a,
    0x0046b, 0x0046c,
    0x0046d, 0x0046e,
    0x0046f, 0x00470,
    0x00471, 0x00472,
    0x00473, 0x00474,
    0x00475, 0x00476,
    0x00477, 0x00478,
    0x00479, 0x0047a,
    0x0047b, 0x0047c,
    0x0047d, 0x0047e,
    0x0047f, 0x00480,
    0x00481, 0x00482,
    0x0048b, 0x0048c,
    0x0048d, 0x0048e,
    0x0048f, 0x00490,
    0x00491, 0x00492,
    0x00493, 0x00494,
    0x00495, 0x00496,
    0x00497, 0x00498,
    0x00499, 0x0049a,
    0x0049b, 0x0049c,
    0x0049d, 0x0049e,
    0x0049f, 0x004a0,
    0x004a1, 0x004a2,
    0x004a3, 0x004a4,
    0x004a5, 0x004a6,
    0x004a7, 0x004a8,
    0x004a9, 0x004aa,
    0x004ab, 0x004ac,
    0x004ad, 0x004ae,
    0x004af, 0x004b0,
    0x004b1, 0x004b2,
    0x004b3, 0x004b4,
    0x004b5, 0x004b6,
    0x004b7, 0x004b8,
    0x004b9, 0x004ba,
    0x004bb, 0x004bc,
    0x004bd, 0x004be,
    0x004bf, 0x004c0,
    0x004c2, 0x004c3,
    0x004c4, 0x004c5,
    0x004c6, 0x004c7,
    0x004c8, 0x004c9,
    0x004ca, 0x004cb,
    0x004cc, 0x004cd,
    0x004ce, 0x004d0,
    0x004d1, 0x004d2,
    0x004d3, 0x004d4,
    0x004d5, 0x004d6,
    0x004d7, 0x004d8,
    0x004d9, 0x004da,
    0x004db, 0x004dc,
    0x004dd, 0x004de,
    0x004df, 0x004e0,
    0x004e1, 0x004e2,
    0x004e3, 0x004e4,
    0x004e5, 0x004e6,
    0x004e7, 0x004e8,
    0x004e9, 0x004ea,
    0x004eb, 0x004ec,
    0x004ed, 0x004ee,
    0x004ef, 0x004f0,
    0x004f1, 0x004f2,
    0x004f3, 0x004f4,
    0x004f5, 0x004f6,
    0x004f7, 0x004f8,
    0x004f9, 0x004fa,
    0x004fb, 0x004fc,
    0x004fd, 0x004fe,
    0x004ff, 0x00500,
    0x00501, 0x00502,
    0x00503, 0x00504,
    0x00505, 0x00506,
    0x00507, 0x00508,
    0x00509, 0x0050a,
    0x0050b, 0x0050c,
    0x0050d, 0x0050e,
    0x0050f, 0x00510,
    0x00511, 0x00512,
    0x00513, 0x00514,
    0x00515, 0x00516,
    0x00517, 0x00518,
    0x00519, 0x0051a,
    0x0051b, 0x0051c,
    0x0051d, 0x0051e,
    0x0051f, 0x00520,
    0x00521, 0x00522,
    0x00523, 0x00524,
    0x00525, 0x00526,
    0x00527, 0x00528,
    0x00561, 0x00588,
    0x01d00, 0x01d2c,
    0x01d62, 0x01d78,
    0x01d79, 0x01d9b,
    0x01e01, 0x01e02,
    0x01e03, 0x01e04,
    0x01e05, 0x01e06,
    0x01e07, 0x01e08,
    0x01e09, 0x01e0a,
    0x01e0b, 0x01e0c,
    0x01e0d, 0x01e0e,
    0x01e0f, 0x01e10,
    0x01e11, 0x01e12,
    0x01e13, 0x01e14,
    0x01e15, 0x01e16,
    0x01e17, 0x01e18,
    0x01e19, 0x01e1a,
    0x01e1b, 0x01e1c,
    0x01e1d, 0x01e1e,
    0x01e1f, 0x01e20,
    0x01e21, 0x01e22,
    0x01e23, 0x01e24,
    0x01e25, 0x01e26,
    0x01e27, 0x01e28,
    0x01e29, 0x01e2a,
    0x01e2b, 0x01e2c,
    0x01e2d, 0x01e2e,
    0x01e2f, 0x01e30,
    0x01e31, 0x01e32,
    0x01e33, 0x01e34,
    0x01e35, 0x01e36,
    0x01e37, 0x01e38,
    0x01e39, 0x01e3a,
    0x01e3b, 0x01e3c,
    0x01e3d, 0x01e3e,
    0x01e3f, 0x01e40,
    0x01e41, 0x01e42,
    0x01e43, 0x01e44,
    0x01e45, 0x01e46,
    0x01e47, 0x01e48,
    0x01e49, 0x01e4a,
    0x01e4b, 0x01e4c,
    0x01e4d, 0x01e4e,
    0x01e4f, 0x01e50,
    0x01e51, 0x01e52,
    0x01e53, 0x01e54,
    0x01e55, 0x01e56,
    0x01e57, 0x01e58,
    0x01e59, 0x01e5a,
    0x01e5b, 0x01e5c,
    0x01e5d, 0x01e5e,
    0x01e5f, 0x01e60,
    0x01e61, 0x01e62,
    0x01e63, 0x01e64,
    0x01e65, 0x01e66,
    0x01e67, 0x01e68,
    0x01e69, 0x01e6a,
    0x01e6b, 0x01e6c,
    0x01e6d, 0x01e6e,
    0x01e6f, 0x01e70,
    0x01e71, 0x01e72,
    0x01e73, 0x01e74,
    0x01e75, 0x01e76,
    0x01e77, 0x01e78,
    0x01e79, 0x01e7a,
    0x01e7b, 0x01e7c,
    0x01e7d, 0x01e7e,
    0x01e7f, 0x01e80,
    0x01e81, 0x01e82,
    0x01e83, 0x01e84,
    0x01e85, 0x01e86,
    0x01e87, 0x01e88,
    0x01e89, 0x01e8a,
    0x01e8b, 0x01e8c,
    0x01e8d, 0x01e8e,
    0x01e8f, 0x01e90,
    0x01e91, 0x01e92,
    0x01e93, 0x01e94,
    0x01e95, 0x01e9e,
    0x01e9f, 0x01ea0,
    0x01ea1, 0x01ea2,
    0x01ea3, 0x01ea4,
    0x01ea5, 0x01ea6,
    0x01ea7, 0x01ea8,
    0x01ea9, 0x01eaa,
    0x01eab, 0x01eac,
    0x01ead, 0x01eae,
    0x01eaf, 0x01eb0,
    0x01eb1, 0x01eb2,
    0x01eb3, 0x01eb4,
    0x01eb5, 0x01eb6,
    0x01eb7, 0x01eb8,
    0x01eb9, 0x01eba,
    0x01ebb, 0x01ebc,
    0x01ebd, 0x01ebe,
    0x01ebf, 0x01ec0,
    0x01ec1, 0x01ec2,
    0x01ec3, 0x01ec4,
    0x01ec5, 0x01ec6,
    0x01ec7, 0x01ec8,
    0x01ec9, 0x01eca,
    0x01ecb, 0x01ecc,
    0x01ecd, 0x01ece,
    0x01ecf, 0x01ed0,
    0x01ed1, 0x01ed2,
    0x01ed3, 0x01ed4,
    0x01ed5, 0x01ed6,
    0x01ed7, 0x01ed8,
    0x01ed9, 0x01eda,
    0x01edb, 0x01edc,
    0x01edd, 0x01ede,
    0x01edf, 0x01ee0,
    0x01ee1, 0x01ee2,
    0x01ee3, 0x01ee4,
    0x01ee5, 0x01ee6,
    0x01ee7, 0x01ee8,
    0x01ee9, 0x01eea,
    0x01eeb, 0x01eec,
    0x01eed, 0x01eee,
    0x01eef, 0x01ef0,
    0x01ef1, 0x01ef2,
    0x01ef3, 0x01ef4,
    0x01ef5, 0x01ef6,
    0x01ef7, 0x01ef8,
    0x01ef9, 0x01efa,
    0x01efb, 0x01efc,
    0x01efd, 0x01efe,
    0x01eff, 0x01f08,
    0x01f10, 0x01f16,
    0x01f20, 0x01f28,
    0x01f30, 0x01f38,
    0x01f40, 0x01f46,
    0x01f50, 0x01f58,
    0x01f60, 0x01f68,
    0x01f70, 0x01f7e,
    0x01f80, 0x01f88,
    0x01f90, 0x01f98,
    0x01fa0, 0x01fa8,
    0x01fb0, 0x01fb5,
    0x01fb6, 0x01fb8,
    0x01fbe, 0x01fbf,
    0x01fc2, 0x01fc5,
    0x01fc6, 0x01fc8,
    0x01fd0, 0x01fd4,
    0x01fd6, 0x01fd8,
    0x01fe0, 0x01fe8,
    0x01ff2, 0x01ff5,
    0x01ff6, 0x01ff8,
    0x0210a, 0x0210b,
    0x0210e, 0x02110,
    0x02113, 0x02114,
    0x0212f, 0x02130,
    0x02134, 0x02135,
    0x02139, 0x0213a,
    0x0213c, 0x0213e,
    0x02146, 0x0214a,
    0x0214e, 0x0214f,
    0x02184, 0x02185,
    0x02c30, 0x02c5f,
    0x02c61, 0x02c62,
    0x02c65, 0x02c67,
    0x02c68, 0x02c69,
    0x02c6a, 0x02c6b,
    0x02c6c, 0x02c6d,
    0x02c71, 0x02c72,
    0x02c73, 0x02c75,
    0x02c76, 0x02c7d,
    0x02c81, 0x02c82,
    0x02c83, 0x02c84,
    0x02c85, 0x02c86,
    0x02c87, 0x02c88,
    0x02c89, 0x02c8a,
    0x02c8b, 0x02c8c,
    0x02c8d, 0x02c8e,
    0x02c8f, 0x02c90,
    0x02c91, 0x02c92,
    0x02c93, 0x02c94,
    0x02c95, 0x02c96,
    0x02c97, 0x02c98,
    0x02c99, 0x02c9a,
    0x02c9b, 0x02c9c,
    0x02c9d, 0x02c9e,
    0x02c9f, 0x02ca0,
    0x02ca1, 0x02ca2,
    0x02ca3, 0x02ca4,
    0x02ca5, 0x02ca6,
    0x02ca7, 0x02ca8,
    0x02ca9, 0x02caa,
    0x02cab, 0x02cac,
    0x02cad, 0x02cae,
    0x02caf, 0x02cb0,
    0x02cb1, 0x02cb2,
    0x02cb3, 0x02cb4,
    0x02cb5, 0x02cb6,
    0x02cb7, 0x02cb8,
    0x02cb9, 0x02cba,
    0x02cbb, 0x02cbc,
    0x02cbd, 0x02cbe,
    0x02cbf, 0x02cc0,
    0x02cc1, 0x02cc2,
    0x02cc3, 0x02cc4,
    0x02cc5, 0x02cc6,
    0x02cc7, 0x02cc8,
    0x02cc9, 0x02cca,
    0x02ccb, 0x02ccc,
    0x02ccd, 0x02cce,
    0x02ccf, 0x02cd0,
    0x02cd1, 0x02cd2,
    0x02cd3, 0x02cd4,
    0x02cd5, 0x02cd6,
    0x02cd7, 0x02cd8,
    0x02cd9, 0x02cda,
    0x02cdb, 0x02cdc,
    0x02cdd, 0x02cde,
    0x02cdf, 0x02ce0,
    0x02ce1, 0x02ce2,
    0x02ce3, 0x02ce5,
    0x02cec, 0x02ced,
    0x02cee, 0x02cef,
    0x02d00, 0x02d26,
    0x0a641, 0x0a642,
    0x0a643, 0x0a644,
    0x0a645, 0x0a646,
    0x0a647, 0x0a648,
    0x0a649, 0x0a64a,
    0x0a64b, 0x0a64c,
    0x0a64d, 0x0a64e,
    0x0a64f, 0x0a650,
    0x0a651, 0x0a652,
    0x0a653, 0x0a654,
    0x0a655, 0x0a656,
    0x0a657, 0x0a658,
    0x0a659, 0x0a65a,
    0x0a65b, 0x0a65c,
    0x0a65d, 0x0a65e,
    0x0a65f, 0x0a660,
    0x0a661, 0x0a662,
    0x0a663, 0x0a664,
    0x0a665, 0x0a666,
    0x0a667, 0x0a668,
    0x0a669, 0x0a66a,
    0x0a66b, 0x0a66c,
    0x0a66d, 0x0a66e,
    0x0a681, 0x0a682,
    0x0a683, 0x0a684,
    0x0a685, 0x0a686,
    0x0a687, 0x0a688,
    0x0a689, 0x0a68a,
    0x0a68b, 0x0a68c,
    0x0a68d, 0x0a68e,
    0x0a68f, 0x0a690,
    0x0a691, 0x0a692,
    0x0a693, 0x0a694,
    0x0a695, 0x0a696,
    0x0a697, 0x0a698,
    0x0a723, 0x0a724,
    0x0a725, 0x0a726,
    0x0a727, 0x0a728,
    0x0a729, 0x0a72a,
    0x0a72b, 0x0a72c,
    0x0a72d, 0x0a72e,
    0x0a72f, 0x0a732,
    0x0a733, 0x0a734,
    0x0a735, 0x0a736,
    0x0a737, 0x0a738,
    0x0a739, 0x0a73a,
    0x0a73b, 0x0a73c,
    0x0a73d, 0x0a73e,
    0x0a73f, 0x0a740,
    0x0a741, 0x0a742,
    0x0a743, 0x0a744,
    0x0a745, 0x0a746,
    0x0a747, 0x0a748,
    0x0a749, 0x0a74a,
    0x0a74b, 0x0a74c,
    0x0a74d, 0x0a74e,
    0x0a74f, 0x0a750,
    0x0a751, 0x0a752,
    0x0a753, 0x0a754,
    0x0a755, 0x0a756,
    0x0a757, 0x0a758,
    0x0a759, 0x0a75a,
    0x0a75b, 0x0a75c,
    0x0a75d, 0x0a75e,
    0x0a75f, 0x0a760,
    0x0a761, 0x0a762,
    0x0a763, 0x0a764,
    0x0a765, 0x0a766,
    0x0a767, 0x0a768,
    0x0a769, 0x0a76a,
    0x0a76b, 0x0a76c,
    0x0a76d, 0x0a76e,
    0x0a76f, 0x0a770,
    0x0a771, 0x0a779,
    0x0a77a, 0x0a77b,
    0x0a77c, 0x0a77d,
    0x0a77f, 0x0a780,
    0x0a781, 0x0a782,
    0x0a783, 0x0a784,
    0x0a785, 0x0a786,
    0x0a787, 0x0a788,
    0x0a78c, 0x0a78d,
    0x0a78e, 0x0a78f,
    0x0a791, 0x0a792,
    0x0a7a1, 0x0a7a2,
    0x0a7a3, 0x0a7a4,
    0x0a7a5, 0x0a7a6,
    0x0a7a7, 0x0a7a8,
    0x0a7a9, 0x0a7aa,
    0x0a7fa, 0x0a7fb,
    0x0fb00, 0x0fb07,
    0x0fb13, 0x0fb18,
    0x0ff41, 0x0ff5b,
    0x10428, 0x10450,
    0x1d41a, 0x1d434,
    0x1d44e, 0x1d455,
    0x1d456, 0x1d468,
    0x1d482, 0x1d49c,
    0x1d4b6, 0x1d4ba,
    0x1d4bb, 0x1d4bc,
    0x1d4bd, 0x1d4c4,
    0x1d4c5, 0x1d4d0,
    0x1d4ea, 0x1d504,
    0x1d51e, 0x1d538,
    0x1d552, 0x1d56c,
    0x1d586, 0x1d5a0,
    0x1d5ba, 0x1d5d4,
    0x1d5ee, 0x1d608,
    0x1d622, 0x1d63c,
    0x1d656, 0x1d670,
    0x1d68a, 0x1d6a6,
    0x1d6c2, 0x1d6db,
    0x1d6dc, 0x1d6e2,
    0x1d6fc, 0x1d715,
    0x1d716, 0x1d71c,
    0x1d736, 0x1d74f,
    0x1d750, 0x1d756,
    0x1d770, 0x1d789,
    0x1d78a, 0x1d790,
    0x1d7aa, 0x1d7c3,
    0x1d7c4, 0x1d7ca,
    0x1d7cb, 0x1d7cc,
]);

immutable(CodepointSet) unicodeSaurashtra = CodepointSet([
    0x0a880, 0x0a8c5,
    0x0a8ce, 0x0a8da,
]);

immutable(CodepointSet) unicodeInLinear_B_Syllabary = CodepointSet([
    0x10000, 0x10080,
]);

immutable(CodepointSet) unicodeLm = CodepointSet([
    0x002b0, 0x002c2,
    0x002c6, 0x002d2,
    0x002e0, 0x002e5,
    0x002ec, 0x002ed,
    0x002ee, 0x002ef,
    0x00374, 0x00375,
    0x0037a, 0x0037b,
    0x00559, 0x0055a,
    0x00640, 0x00641,
    0x006e5, 0x006e7,
    0x007f4, 0x007f6,
    0x007fa, 0x007fb,
    0x0081a, 0x0081b,
    0x00824, 0x00825,
    0x00828, 0x00829,
    0x00971, 0x00972,
    0x00e46, 0x00e47,
    0x00ec6, 0x00ec7,
    0x010fc, 0x010fd,
    0x017d7, 0x017d8,
    0x01843, 0x01844,
    0x01aa7, 0x01aa8,
    0x01c78, 0x01c7e,
    0x01d2c, 0x01d62,
    0x01d78, 0x01d79,
    0x01d9b, 0x01dc0,
    0x02071, 0x02072,
    0x0207f, 0x02080,
    0x02090, 0x0209d,
    0x02c7d, 0x02c7e,
    0x02d6f, 0x02d70,
    0x02e2f, 0x02e30,
    0x03005, 0x03006,
    0x03031, 0x03036,
    0x0303b, 0x0303c,
    0x0309d, 0x0309f,
    0x030fc, 0x030ff,
    0x0a015, 0x0a016,
    0x0a4f8, 0x0a4fe,
    0x0a60c, 0x0a60d,
    0x0a67f, 0x0a680,
    0x0a717, 0x0a720,
    0x0a770, 0x0a771,
    0x0a788, 0x0a789,
    0x0a9cf, 0x0a9d0,
    0x0aa70, 0x0aa71,
    0x0aadd, 0x0aade,
    0x0ff70, 0x0ff71,
    0x0ff9e, 0x0ffa0,
]);

immutable(CodepointSet) unicodeInKannada = CodepointSet([
    0x00c80, 0x00d00,
]);

immutable(CodepointSet) unicodeInLimbu = CodepointSet([
    0x01900, 0x01950,
]);

immutable(CodepointSet) unicodeInByzantine_Musical_Symbols = CodepointSet([
    0x1d000, 0x1d100,
]);

immutable(CodepointSet) unicodeMc = CodepointSet([
    0x00903, 0x00904,
    0x0093b, 0x0093c,
    0x0093e, 0x00941,
    0x00949, 0x0094d,
    0x0094e, 0x00950,
    0x00982, 0x00984,
    0x009be, 0x009c1,
    0x009c7, 0x009c9,
    0x009cb, 0x009cd,
    0x009d7, 0x009d8,
    0x00a03, 0x00a04,
    0x00a3e, 0x00a41,
    0x00a83, 0x00a84,
    0x00abe, 0x00ac1,
    0x00ac9, 0x00aca,
    0x00acb, 0x00acd,
    0x00b02, 0x00b04,
    0x00b3e, 0x00b3f,
    0x00b40, 0x00b41,
    0x00b47, 0x00b49,
    0x00b4b, 0x00b4d,
    0x00b57, 0x00b58,
    0x00bbe, 0x00bc0,
    0x00bc1, 0x00bc3,
    0x00bc6, 0x00bc9,
    0x00bca, 0x00bcd,
    0x00bd7, 0x00bd8,
    0x00c01, 0x00c04,
    0x00c41, 0x00c45,
    0x00c82, 0x00c84,
    0x00cbe, 0x00cbf,
    0x00cc0, 0x00cc5,
    0x00cc7, 0x00cc9,
    0x00cca, 0x00ccc,
    0x00cd5, 0x00cd7,
    0x00d02, 0x00d04,
    0x00d3e, 0x00d41,
    0x00d46, 0x00d49,
    0x00d4a, 0x00d4d,
    0x00d57, 0x00d58,
    0x00d82, 0x00d84,
    0x00dcf, 0x00dd2,
    0x00dd8, 0x00de0,
    0x00df2, 0x00df4,
    0x00f3e, 0x00f40,
    0x00f7f, 0x00f80,
    0x0102b, 0x0102d,
    0x01031, 0x01032,
    0x01038, 0x01039,
    0x0103b, 0x0103d,
    0x01056, 0x01058,
    0x01062, 0x01065,
    0x01067, 0x0106e,
    0x01083, 0x01085,
    0x01087, 0x0108d,
    0x0108f, 0x01090,
    0x0109a, 0x0109d,
    0x017b6, 0x017b7,
    0x017be, 0x017c6,
    0x017c7, 0x017c9,
    0x01923, 0x01927,
    0x01929, 0x0192c,
    0x01930, 0x01932,
    0x01933, 0x01939,
    0x019b0, 0x019c1,
    0x019c8, 0x019ca,
    0x01a19, 0x01a1c,
    0x01a55, 0x01a56,
    0x01a57, 0x01a58,
    0x01a61, 0x01a62,
    0x01a63, 0x01a65,
    0x01a6d, 0x01a73,
    0x01b04, 0x01b05,
    0x01b35, 0x01b36,
    0x01b3b, 0x01b3c,
    0x01b3d, 0x01b42,
    0x01b43, 0x01b45,
    0x01b82, 0x01b83,
    0x01ba1, 0x01ba2,
    0x01ba6, 0x01ba8,
    0x01baa, 0x01bab,
    0x01be7, 0x01be8,
    0x01bea, 0x01bed,
    0x01bee, 0x01bef,
    0x01bf2, 0x01bf4,
    0x01c24, 0x01c2c,
    0x01c34, 0x01c36,
    0x01ce1, 0x01ce2,
    0x01cf2, 0x01cf3,
    0x0a823, 0x0a825,
    0x0a827, 0x0a828,
    0x0a880, 0x0a882,
    0x0a8b4, 0x0a8c4,
    0x0a952, 0x0a954,
    0x0a983, 0x0a984,
    0x0a9b4, 0x0a9b6,
    0x0a9ba, 0x0a9bc,
    0x0a9bd, 0x0a9c1,
    0x0aa2f, 0x0aa31,
    0x0aa33, 0x0aa35,
    0x0aa4d, 0x0aa4e,
    0x0aa7b, 0x0aa7c,
    0x0abe3, 0x0abe5,
    0x0abe6, 0x0abe8,
    0x0abe9, 0x0abeb,
    0x0abec, 0x0abed,
    0x11000, 0x11001,
    0x11002, 0x11003,
    0x11082, 0x11083,
    0x110b0, 0x110b3,
    0x110b7, 0x110b9,
    0x1d165, 0x1d167,
    0x1d16d, 0x1d173,
]);

immutable(CodepointSet) unicodeLo = CodepointSet([
    0x001bb, 0x001bc,
    0x001c0, 0x001c4,
    0x00294, 0x00295,
    0x005d0, 0x005eb,
    0x005f0, 0x005f3,
    0x00620, 0x00640,
    0x00641, 0x0064b,
    0x0066e, 0x00670,
    0x00671, 0x006d4,
    0x006d5, 0x006d6,
    0x006ee, 0x006f0,
    0x006fa, 0x006fd,
    0x006ff, 0x00700,
    0x00710, 0x00711,
    0x00712, 0x00730,
    0x0074d, 0x007a6,
    0x007b1, 0x007b2,
    0x007ca, 0x007eb,
    0x00800, 0x00816,
    0x00840, 0x00859,
    0x00904, 0x0093a,
    0x0093d, 0x0093e,
    0x00950, 0x00951,
    0x00958, 0x00962,
    0x00972, 0x00978,
    0x00979, 0x00980,
    0x00985, 0x0098d,
    0x0098f, 0x00991,
    0x00993, 0x009a9,
    0x009aa, 0x009b1,
    0x009b2, 0x009b3,
    0x009b6, 0x009ba,
    0x009bd, 0x009be,
    0x009ce, 0x009cf,
    0x009dc, 0x009de,
    0x009df, 0x009e2,
    0x009f0, 0x009f2,
    0x00a05, 0x00a0b,
    0x00a0f, 0x00a11,
    0x00a13, 0x00a29,
    0x00a2a, 0x00a31,
    0x00a32, 0x00a34,
    0x00a35, 0x00a37,
    0x00a38, 0x00a3a,
    0x00a59, 0x00a5d,
    0x00a5e, 0x00a5f,
    0x00a72, 0x00a75,
    0x00a85, 0x00a8e,
    0x00a8f, 0x00a92,
    0x00a93, 0x00aa9,
    0x00aaa, 0x00ab1,
    0x00ab2, 0x00ab4,
    0x00ab5, 0x00aba,
    0x00abd, 0x00abe,
    0x00ad0, 0x00ad1,
    0x00ae0, 0x00ae2,
    0x00b05, 0x00b0d,
    0x00b0f, 0x00b11,
    0x00b13, 0x00b29,
    0x00b2a, 0x00b31,
    0x00b32, 0x00b34,
    0x00b35, 0x00b3a,
    0x00b3d, 0x00b3e,
    0x00b5c, 0x00b5e,
    0x00b5f, 0x00b62,
    0x00b71, 0x00b72,
    0x00b83, 0x00b84,
    0x00b85, 0x00b8b,
    0x00b8e, 0x00b91,
    0x00b92, 0x00b96,
    0x00b99, 0x00b9b,
    0x00b9c, 0x00b9d,
    0x00b9e, 0x00ba0,
    0x00ba3, 0x00ba5,
    0x00ba8, 0x00bab,
    0x00bae, 0x00bba,
    0x00bd0, 0x00bd1,
    0x00c05, 0x00c0d,
    0x00c0e, 0x00c11,
    0x00c12, 0x00c29,
    0x00c2a, 0x00c34,
    0x00c35, 0x00c3a,
    0x00c3d, 0x00c3e,
    0x00c58, 0x00c5a,
    0x00c60, 0x00c62,
    0x00c85, 0x00c8d,
    0x00c8e, 0x00c91,
    0x00c92, 0x00ca9,
    0x00caa, 0x00cb4,
    0x00cb5, 0x00cba,
    0x00cbd, 0x00cbe,
    0x00cde, 0x00cdf,
    0x00ce0, 0x00ce2,
    0x00cf1, 0x00cf3,
    0x00d05, 0x00d0d,
    0x00d0e, 0x00d11,
    0x00d12, 0x00d3b,
    0x00d3d, 0x00d3e,
    0x00d4e, 0x00d4f,
    0x00d60, 0x00d62,
    0x00d7a, 0x00d80,
    0x00d85, 0x00d97,
    0x00d9a, 0x00db2,
    0x00db3, 0x00dbc,
    0x00dbd, 0x00dbe,
    0x00dc0, 0x00dc7,
    0x00e01, 0x00e31,
    0x00e32, 0x00e34,
    0x00e40, 0x00e46,
    0x00e81, 0x00e83,
    0x00e84, 0x00e85,
    0x00e87, 0x00e89,
    0x00e8a, 0x00e8b,
    0x00e8d, 0x00e8e,
    0x00e94, 0x00e98,
    0x00e99, 0x00ea0,
    0x00ea1, 0x00ea4,
    0x00ea5, 0x00ea6,
    0x00ea7, 0x00ea8,
    0x00eaa, 0x00eac,
    0x00ead, 0x00eb1,
    0x00eb2, 0x00eb4,
    0x00ebd, 0x00ebe,
    0x00ec0, 0x00ec5,
    0x00edc, 0x00ede,
    0x00f00, 0x00f01,
    0x00f40, 0x00f48,
    0x00f49, 0x00f6d,
    0x00f88, 0x00f8d,
    0x01000, 0x0102b,
    0x0103f, 0x01040,
    0x01050, 0x01056,
    0x0105a, 0x0105e,
    0x01061, 0x01062,
    0x01065, 0x01067,
    0x0106e, 0x01071,
    0x01075, 0x01082,
    0x0108e, 0x0108f,
    0x010d0, 0x010fb,
    0x01100, 0x01249,
    0x0124a, 0x0124e,
    0x01250, 0x01257,
    0x01258, 0x01259,
    0x0125a, 0x0125e,
    0x01260, 0x01289,
    0x0128a, 0x0128e,
    0x01290, 0x012b1,
    0x012b2, 0x012b6,
    0x012b8, 0x012bf,
    0x012c0, 0x012c1,
    0x012c2, 0x012c6,
    0x012c8, 0x012d7,
    0x012d8, 0x01311,
    0x01312, 0x01316,
    0x01318, 0x0135b,
    0x01380, 0x01390,
    0x013a0, 0x013f5,
    0x01401, 0x0166d,
    0x0166f, 0x01680,
    0x01681, 0x0169b,
    0x016a0, 0x016eb,
    0x01700, 0x0170d,
    0x0170e, 0x01712,
    0x01720, 0x01732,
    0x01740, 0x01752,
    0x01760, 0x0176d,
    0x0176e, 0x01771,
    0x01780, 0x017b4,
    0x017dc, 0x017dd,
    0x01820, 0x01843,
    0x01844, 0x01878,
    0x01880, 0x018a9,
    0x018aa, 0x018ab,
    0x018b0, 0x018f6,
    0x01900, 0x0191d,
    0x01950, 0x0196e,
    0x01970, 0x01975,
    0x01980, 0x019ac,
    0x019c1, 0x019c8,
    0x01a00, 0x01a17,
    0x01a20, 0x01a55,
    0x01b05, 0x01b34,
    0x01b45, 0x01b4c,
    0x01b83, 0x01ba1,
    0x01bae, 0x01bb0,
    0x01bc0, 0x01be6,
    0x01c00, 0x01c24,
    0x01c4d, 0x01c50,
    0x01c5a, 0x01c78,
    0x01ce9, 0x01ced,
    0x01cee, 0x01cf2,
    0x02135, 0x02139,
    0x02d30, 0x02d66,
    0x02d80, 0x02d97,
    0x02da0, 0x02da7,
    0x02da8, 0x02daf,
    0x02db0, 0x02db7,
    0x02db8, 0x02dbf,
    0x02dc0, 0x02dc7,
    0x02dc8, 0x02dcf,
    0x02dd0, 0x02dd7,
    0x02dd8, 0x02ddf,
    0x03006, 0x03007,
    0x0303c, 0x0303d,
    0x03041, 0x03097,
    0x0309f, 0x030a0,
    0x030a1, 0x030fb,
    0x030ff, 0x03100,
    0x03105, 0x0312e,
    0x03131, 0x0318f,
    0x031a0, 0x031bb,
    0x031f0, 0x03200,
    0x03400, 0x04db6,
    0x04e00, 0x09fcc,
    0x0a000, 0x0a015,
    0x0a016, 0x0a48d,
    0x0a4d0, 0x0a4f8,
    0x0a500, 0x0a60c,
    0x0a610, 0x0a620,
    0x0a62a, 0x0a62c,
    0x0a66e, 0x0a66f,
    0x0a6a0, 0x0a6e6,
    0x0a7fb, 0x0a802,
    0x0a803, 0x0a806,
    0x0a807, 0x0a80b,
    0x0a80c, 0x0a823,
    0x0a840, 0x0a874,
    0x0a882, 0x0a8b4,
    0x0a8f2, 0x0a8f8,
    0x0a8fb, 0x0a8fc,
    0x0a90a, 0x0a926,
    0x0a930, 0x0a947,
    0x0a960, 0x0a97d,
    0x0a984, 0x0a9b3,
    0x0aa00, 0x0aa29,
    0x0aa40, 0x0aa43,
    0x0aa44, 0x0aa4c,
    0x0aa60, 0x0aa70,
    0x0aa71, 0x0aa77,
    0x0aa7a, 0x0aa7b,
    0x0aa80, 0x0aab0,
    0x0aab1, 0x0aab2,
    0x0aab5, 0x0aab7,
    0x0aab9, 0x0aabe,
    0x0aac0, 0x0aac1,
    0x0aac2, 0x0aac3,
    0x0aadb, 0x0aadd,
    0x0ab01, 0x0ab07,
    0x0ab09, 0x0ab0f,
    0x0ab11, 0x0ab17,
    0x0ab20, 0x0ab27,
    0x0ab28, 0x0ab2f,
    0x0abc0, 0x0abe3,
    0x0ac00, 0x0d7a4,
    0x0d7b0, 0x0d7c7,
    0x0d7cb, 0x0d7fc,
    0x0f900, 0x0fa2e,
    0x0fa30, 0x0fa6e,
    0x0fa70, 0x0fada,
    0x0fb1d, 0x0fb1e,
    0x0fb1f, 0x0fb29,
    0x0fb2a, 0x0fb37,
    0x0fb38, 0x0fb3d,
    0x0fb3e, 0x0fb3f,
    0x0fb40, 0x0fb42,
    0x0fb43, 0x0fb45,
    0x0fb46, 0x0fbb2,
    0x0fbd3, 0x0fd3e,
    0x0fd50, 0x0fd90,
    0x0fd92, 0x0fdc8,
    0x0fdf0, 0x0fdfc,
    0x0fe70, 0x0fe75,
    0x0fe76, 0x0fefd,
    0x0ff66, 0x0ff70,
    0x0ff71, 0x0ff9e,
    0x0ffa0, 0x0ffbf,
    0x0ffc2, 0x0ffc8,
    0x0ffca, 0x0ffd0,
    0x0ffd2, 0x0ffd8,
    0x0ffda, 0x0ffdd,
    0x10000, 0x1000c,
    0x1000d, 0x10027,
    0x10028, 0x1003b,
    0x1003c, 0x1003e,
    0x1003f, 0x1004e,
    0x10050, 0x1005e,
    0x10080, 0x100fb,
    0x10280, 0x1029d,
    0x102a0, 0x102d1,
    0x10300, 0x1031f,
    0x10330, 0x10341,
    0x10342, 0x1034a,
    0x10380, 0x1039e,
    0x103a0, 0x103c4,
    0x103c8, 0x103d0,
    0x10450, 0x1049e,
    0x10800, 0x10806,
    0x10808, 0x10809,
    0x1080a, 0x10836,
    0x10837, 0x10839,
    0x1083c, 0x1083d,
    0x1083f, 0x10856,
    0x10900, 0x10916,
    0x10920, 0x1093a,
    0x10a00, 0x10a01,
    0x10a10, 0x10a14,
    0x10a15, 0x10a18,
    0x10a19, 0x10a34,
    0x10a60, 0x10a7d,
    0x10b00, 0x10b36,
    0x10b40, 0x10b56,
    0x10b60, 0x10b73,
    0x10c00, 0x10c49,
    0x11003, 0x11038,
    0x11083, 0x110b0,
    0x12000, 0x1236f,
    0x13000, 0x1342f,
    0x16800, 0x16a39,
    0x1b000, 0x1b002,
    0x20000, 0x2a6d7,
    0x2a700, 0x2b735,
    0x2b740, 0x2b81e,
    0x2f800, 0x2fa1e,
]);

immutable(CodepointSet) unicodeMe = CodepointSet([
    0x00488, 0x0048a,
    0x020dd, 0x020e1,
    0x020e2, 0x020e5,
    0x0a670, 0x0a673,
]);

immutable(CodepointSet) unicodeInMeetei_Mayek = CodepointSet([
    0x0abc0, 0x0ac00,
]);

immutable(CodepointSet) unicodeLt = CodepointSet([
    0x001c5, 0x001c6,
    0x001c8, 0x001c9,
    0x001cb, 0x001cc,
    0x001f2, 0x001f3,
    0x01f88, 0x01f90,
    0x01f98, 0x01fa0,
    0x01fa8, 0x01fb0,
    0x01fbc, 0x01fbd,
    0x01fcc, 0x01fcd,
    0x01ffc, 0x01ffd,
]);

immutable(CodepointSet) unicodeInKhmer = CodepointSet([
    0x01780, 0x01800,
]);

immutable(CodepointSet) unicodeInEthiopic_Extended = CodepointSet([
    0x02d80, 0x02de0,
]);

immutable(CodepointSet) unicodeLu = CodepointSet([
    0x00041, 0x0005b,
    0x000c0, 0x000d7,
    0x000d8, 0x000df,
    0x00100, 0x00101,
    0x00102, 0x00103,
    0x00104, 0x00105,
    0x00106, 0x00107,
    0x00108, 0x00109,
    0x0010a, 0x0010b,
    0x0010c, 0x0010d,
    0x0010e, 0x0010f,
    0x00110, 0x00111,
    0x00112, 0x00113,
    0x00114, 0x00115,
    0x00116, 0x00117,
    0x00118, 0x00119,
    0x0011a, 0x0011b,
    0x0011c, 0x0011d,
    0x0011e, 0x0011f,
    0x00120, 0x00121,
    0x00122, 0x00123,
    0x00124, 0x00125,
    0x00126, 0x00127,
    0x00128, 0x00129,
    0x0012a, 0x0012b,
    0x0012c, 0x0012d,
    0x0012e, 0x0012f,
    0x00130, 0x00131,
    0x00132, 0x00133,
    0x00134, 0x00135,
    0x00136, 0x00137,
    0x00139, 0x0013a,
    0x0013b, 0x0013c,
    0x0013d, 0x0013e,
    0x0013f, 0x00140,
    0x00141, 0x00142,
    0x00143, 0x00144,
    0x00145, 0x00146,
    0x00147, 0x00148,
    0x0014a, 0x0014b,
    0x0014c, 0x0014d,
    0x0014e, 0x0014f,
    0x00150, 0x00151,
    0x00152, 0x00153,
    0x00154, 0x00155,
    0x00156, 0x00157,
    0x00158, 0x00159,
    0x0015a, 0x0015b,
    0x0015c, 0x0015d,
    0x0015e, 0x0015f,
    0x00160, 0x00161,
    0x00162, 0x00163,
    0x00164, 0x00165,
    0x00166, 0x00167,
    0x00168, 0x00169,
    0x0016a, 0x0016b,
    0x0016c, 0x0016d,
    0x0016e, 0x0016f,
    0x00170, 0x00171,
    0x00172, 0x00173,
    0x00174, 0x00175,
    0x00176, 0x00177,
    0x00178, 0x0017a,
    0x0017b, 0x0017c,
    0x0017d, 0x0017e,
    0x00181, 0x00183,
    0x00184, 0x00185,
    0x00186, 0x00188,
    0x00189, 0x0018c,
    0x0018e, 0x00192,
    0x00193, 0x00195,
    0x00196, 0x00199,
    0x0019c, 0x0019e,
    0x0019f, 0x001a1,
    0x001a2, 0x001a3,
    0x001a4, 0x001a5,
    0x001a6, 0x001a8,
    0x001a9, 0x001aa,
    0x001ac, 0x001ad,
    0x001ae, 0x001b0,
    0x001b1, 0x001b4,
    0x001b5, 0x001b6,
    0x001b7, 0x001b9,
    0x001bc, 0x001bd,
    0x001c4, 0x001c5,
    0x001c7, 0x001c8,
    0x001ca, 0x001cb,
    0x001cd, 0x001ce,
    0x001cf, 0x001d0,
    0x001d1, 0x001d2,
    0x001d3, 0x001d4,
    0x001d5, 0x001d6,
    0x001d7, 0x001d8,
    0x001d9, 0x001da,
    0x001db, 0x001dc,
    0x001de, 0x001df,
    0x001e0, 0x001e1,
    0x001e2, 0x001e3,
    0x001e4, 0x001e5,
    0x001e6, 0x001e7,
    0x001e8, 0x001e9,
    0x001ea, 0x001eb,
    0x001ec, 0x001ed,
    0x001ee, 0x001ef,
    0x001f1, 0x001f2,
    0x001f4, 0x001f5,
    0x001f6, 0x001f9,
    0x001fa, 0x001fb,
    0x001fc, 0x001fd,
    0x001fe, 0x001ff,
    0x00200, 0x00201,
    0x00202, 0x00203,
    0x00204, 0x00205,
    0x00206, 0x00207,
    0x00208, 0x00209,
    0x0020a, 0x0020b,
    0x0020c, 0x0020d,
    0x0020e, 0x0020f,
    0x00210, 0x00211,
    0x00212, 0x00213,
    0x00214, 0x00215,
    0x00216, 0x00217,
    0x00218, 0x00219,
    0x0021a, 0x0021b,
    0x0021c, 0x0021d,
    0x0021e, 0x0021f,
    0x00220, 0x00221,
    0x00222, 0x00223,
    0x00224, 0x00225,
    0x00226, 0x00227,
    0x00228, 0x00229,
    0x0022a, 0x0022b,
    0x0022c, 0x0022d,
    0x0022e, 0x0022f,
    0x00230, 0x00231,
    0x00232, 0x00233,
    0x0023a, 0x0023c,
    0x0023d, 0x0023f,
    0x00241, 0x00242,
    0x00243, 0x00247,
    0x00248, 0x00249,
    0x0024a, 0x0024b,
    0x0024c, 0x0024d,
    0x0024e, 0x0024f,
    0x00370, 0x00371,
    0x00372, 0x00373,
    0x00376, 0x00377,
    0x00386, 0x00387,
    0x00388, 0x0038b,
    0x0038c, 0x0038d,
    0x0038e, 0x00390,
    0x00391, 0x003a2,
    0x003a3, 0x003ac,
    0x003cf, 0x003d0,
    0x003d2, 0x003d5,
    0x003d8, 0x003d9,
    0x003da, 0x003db,
    0x003dc, 0x003dd,
    0x003de, 0x003df,
    0x003e0, 0x003e1,
    0x003e2, 0x003e3,
    0x003e4, 0x003e5,
    0x003e6, 0x003e7,
    0x003e8, 0x003e9,
    0x003ea, 0x003eb,
    0x003ec, 0x003ed,
    0x003ee, 0x003ef,
    0x003f4, 0x003f5,
    0x003f7, 0x003f8,
    0x003f9, 0x003fb,
    0x003fd, 0x00430,
    0x00460, 0x00461,
    0x00462, 0x00463,
    0x00464, 0x00465,
    0x00466, 0x00467,
    0x00468, 0x00469,
    0x0046a, 0x0046b,
    0x0046c, 0x0046d,
    0x0046e, 0x0046f,
    0x00470, 0x00471,
    0x00472, 0x00473,
    0x00474, 0x00475,
    0x00476, 0x00477,
    0x00478, 0x00479,
    0x0047a, 0x0047b,
    0x0047c, 0x0047d,
    0x0047e, 0x0047f,
    0x00480, 0x00481,
    0x0048a, 0x0048b,
    0x0048c, 0x0048d,
    0x0048e, 0x0048f,
    0x00490, 0x00491,
    0x00492, 0x00493,
    0x00494, 0x00495,
    0x00496, 0x00497,
    0x00498, 0x00499,
    0x0049a, 0x0049b,
    0x0049c, 0x0049d,
    0x0049e, 0x0049f,
    0x004a0, 0x004a1,
    0x004a2, 0x004a3,
    0x004a4, 0x004a5,
    0x004a6, 0x004a7,
    0x004a8, 0x004a9,
    0x004aa, 0x004ab,
    0x004ac, 0x004ad,
    0x004ae, 0x004af,
    0x004b0, 0x004b1,
    0x004b2, 0x004b3,
    0x004b4, 0x004b5,
    0x004b6, 0x004b7,
    0x004b8, 0x004b9,
    0x004ba, 0x004bb,
    0x004bc, 0x004bd,
    0x004be, 0x004bf,
    0x004c0, 0x004c2,
    0x004c3, 0x004c4,
    0x004c5, 0x004c6,
    0x004c7, 0x004c8,
    0x004c9, 0x004ca,
    0x004cb, 0x004cc,
    0x004cd, 0x004ce,
    0x004d0, 0x004d1,
    0x004d2, 0x004d3,
    0x004d4, 0x004d5,
    0x004d6, 0x004d7,
    0x004d8, 0x004d9,
    0x004da, 0x004db,
    0x004dc, 0x004dd,
    0x004de, 0x004df,
    0x004e0, 0x004e1,
    0x004e2, 0x004e3,
    0x004e4, 0x004e5,
    0x004e6, 0x004e7,
    0x004e8, 0x004e9,
    0x004ea, 0x004eb,
    0x004ec, 0x004ed,
    0x004ee, 0x004ef,
    0x004f0, 0x004f1,
    0x004f2, 0x004f3,
    0x004f4, 0x004f5,
    0x004f6, 0x004f7,
    0x004f8, 0x004f9,
    0x004fa, 0x004fb,
    0x004fc, 0x004fd,
    0x004fe, 0x004ff,
    0x00500, 0x00501,
    0x00502, 0x00503,
    0x00504, 0x00505,
    0x00506, 0x00507,
    0x00508, 0x00509,
    0x0050a, 0x0050b,
    0x0050c, 0x0050d,
    0x0050e, 0x0050f,
    0x00510, 0x00511,
    0x00512, 0x00513,
    0x00514, 0x00515,
    0x00516, 0x00517,
    0x00518, 0x00519,
    0x0051a, 0x0051b,
    0x0051c, 0x0051d,
    0x0051e, 0x0051f,
    0x00520, 0x00521,
    0x00522, 0x00523,
    0x00524, 0x00525,
    0x00526, 0x00527,
    0x00531, 0x00557,
    0x010a0, 0x010c6,
    0x01e00, 0x01e01,
    0x01e02, 0x01e03,
    0x01e04, 0x01e05,
    0x01e06, 0x01e07,
    0x01e08, 0x01e09,
    0x01e0a, 0x01e0b,
    0x01e0c, 0x01e0d,
    0x01e0e, 0x01e0f,
    0x01e10, 0x01e11,
    0x01e12, 0x01e13,
    0x01e14, 0x01e15,
    0x01e16, 0x01e17,
    0x01e18, 0x01e19,
    0x01e1a, 0x01e1b,
    0x01e1c, 0x01e1d,
    0x01e1e, 0x01e1f,
    0x01e20, 0x01e21,
    0x01e22, 0x01e23,
    0x01e24, 0x01e25,
    0x01e26, 0x01e27,
    0x01e28, 0x01e29,
    0x01e2a, 0x01e2b,
    0x01e2c, 0x01e2d,
    0x01e2e, 0x01e2f,
    0x01e30, 0x01e31,
    0x01e32, 0x01e33,
    0x01e34, 0x01e35,
    0x01e36, 0x01e37,
    0x01e38, 0x01e39,
    0x01e3a, 0x01e3b,
    0x01e3c, 0x01e3d,
    0x01e3e, 0x01e3f,
    0x01e40, 0x01e41,
    0x01e42, 0x01e43,
    0x01e44, 0x01e45,
    0x01e46, 0x01e47,
    0x01e48, 0x01e49,
    0x01e4a, 0x01e4b,
    0x01e4c, 0x01e4d,
    0x01e4e, 0x01e4f,
    0x01e50, 0x01e51,
    0x01e52, 0x01e53,
    0x01e54, 0x01e55,
    0x01e56, 0x01e57,
    0x01e58, 0x01e59,
    0x01e5a, 0x01e5b,
    0x01e5c, 0x01e5d,
    0x01e5e, 0x01e5f,
    0x01e60, 0x01e61,
    0x01e62, 0x01e63,
    0x01e64, 0x01e65,
    0x01e66, 0x01e67,
    0x01e68, 0x01e69,
    0x01e6a, 0x01e6b,
    0x01e6c, 0x01e6d,
    0x01e6e, 0x01e6f,
    0x01e70, 0x01e71,
    0x01e72, 0x01e73,
    0x01e74, 0x01e75,
    0x01e76, 0x01e77,
    0x01e78, 0x01e79,
    0x01e7a, 0x01e7b,
    0x01e7c, 0x01e7d,
    0x01e7e, 0x01e7f,
    0x01e80, 0x01e81,
    0x01e82, 0x01e83,
    0x01e84, 0x01e85,
    0x01e86, 0x01e87,
    0x01e88, 0x01e89,
    0x01e8a, 0x01e8b,
    0x01e8c, 0x01e8d,
    0x01e8e, 0x01e8f,
    0x01e90, 0x01e91,
    0x01e92, 0x01e93,
    0x01e94, 0x01e95,
    0x01e9e, 0x01e9f,
    0x01ea0, 0x01ea1,
    0x01ea2, 0x01ea3,
    0x01ea4, 0x01ea5,
    0x01ea6, 0x01ea7,
    0x01ea8, 0x01ea9,
    0x01eaa, 0x01eab,
    0x01eac, 0x01ead,
    0x01eae, 0x01eaf,
    0x01eb0, 0x01eb1,
    0x01eb2, 0x01eb3,
    0x01eb4, 0x01eb5,
    0x01eb6, 0x01eb7,
    0x01eb8, 0x01eb9,
    0x01eba, 0x01ebb,
    0x01ebc, 0x01ebd,
    0x01ebe, 0x01ebf,
    0x01ec0, 0x01ec1,
    0x01ec2, 0x01ec3,
    0x01ec4, 0x01ec5,
    0x01ec6, 0x01ec7,
    0x01ec8, 0x01ec9,
    0x01eca, 0x01ecb,
    0x01ecc, 0x01ecd,
    0x01ece, 0x01ecf,
    0x01ed0, 0x01ed1,
    0x01ed2, 0x01ed3,
    0x01ed4, 0x01ed5,
    0x01ed6, 0x01ed7,
    0x01ed8, 0x01ed9,
    0x01eda, 0x01edb,
    0x01edc, 0x01edd,
    0x01ede, 0x01edf,
    0x01ee0, 0x01ee1,
    0x01ee2, 0x01ee3,
    0x01ee4, 0x01ee5,
    0x01ee6, 0x01ee7,
    0x01ee8, 0x01ee9,
    0x01eea, 0x01eeb,
    0x01eec, 0x01eed,
    0x01eee, 0x01eef,
    0x01ef0, 0x01ef1,
    0x01ef2, 0x01ef3,
    0x01ef4, 0x01ef5,
    0x01ef6, 0x01ef7,
    0x01ef8, 0x01ef9,
    0x01efa, 0x01efb,
    0x01efc, 0x01efd,
    0x01efe, 0x01eff,
    0x01f08, 0x01f10,
    0x01f18, 0x01f1e,
    0x01f28, 0x01f30,
    0x01f38, 0x01f40,
    0x01f48, 0x01f4e,
    0x01f59, 0x01f5a,
    0x01f5b, 0x01f5c,
    0x01f5d, 0x01f5e,
    0x01f5f, 0x01f60,
    0x01f68, 0x01f70,
    0x01fb8, 0x01fbc,
    0x01fc8, 0x01fcc,
    0x01fd8, 0x01fdc,
    0x01fe8, 0x01fed,
    0x01ff8, 0x01ffc,
    0x02102, 0x02103,
    0x02107, 0x02108,
    0x0210b, 0x0210e,
    0x02110, 0x02113,
    0x02115, 0x02116,
    0x02119, 0x0211e,
    0x02124, 0x02125,
    0x02126, 0x02127,
    0x02128, 0x02129,
    0x0212a, 0x0212e,
    0x02130, 0x02134,
    0x0213e, 0x02140,
    0x02145, 0x02146,
    0x02183, 0x02184,
    0x02c00, 0x02c2f,
    0x02c60, 0x02c61,
    0x02c62, 0x02c65,
    0x02c67, 0x02c68,
    0x02c69, 0x02c6a,
    0x02c6b, 0x02c6c,
    0x02c6d, 0x02c71,
    0x02c72, 0x02c73,
    0x02c75, 0x02c76,
    0x02c7e, 0x02c81,
    0x02c82, 0x02c83,
    0x02c84, 0x02c85,
    0x02c86, 0x02c87,
    0x02c88, 0x02c89,
    0x02c8a, 0x02c8b,
    0x02c8c, 0x02c8d,
    0x02c8e, 0x02c8f,
    0x02c90, 0x02c91,
    0x02c92, 0x02c93,
    0x02c94, 0x02c95,
    0x02c96, 0x02c97,
    0x02c98, 0x02c99,
    0x02c9a, 0x02c9b,
    0x02c9c, 0x02c9d,
    0x02c9e, 0x02c9f,
    0x02ca0, 0x02ca1,
    0x02ca2, 0x02ca3,
    0x02ca4, 0x02ca5,
    0x02ca6, 0x02ca7,
    0x02ca8, 0x02ca9,
    0x02caa, 0x02cab,
    0x02cac, 0x02cad,
    0x02cae, 0x02caf,
    0x02cb0, 0x02cb1,
    0x02cb2, 0x02cb3,
    0x02cb4, 0x02cb5,
    0x02cb6, 0x02cb7,
    0x02cb8, 0x02cb9,
    0x02cba, 0x02cbb,
    0x02cbc, 0x02cbd,
    0x02cbe, 0x02cbf,
    0x02cc0, 0x02cc1,
    0x02cc2, 0x02cc3,
    0x02cc4, 0x02cc5,
    0x02cc6, 0x02cc7,
    0x02cc8, 0x02cc9,
    0x02cca, 0x02ccb,
    0x02ccc, 0x02ccd,
    0x02cce, 0x02ccf,
    0x02cd0, 0x02cd1,
    0x02cd2, 0x02cd3,
    0x02cd4, 0x02cd5,
    0x02cd6, 0x02cd7,
    0x02cd8, 0x02cd9,
    0x02cda, 0x02cdb,
    0x02cdc, 0x02cdd,
    0x02cde, 0x02cdf,
    0x02ce0, 0x02ce1,
    0x02ce2, 0x02ce3,
    0x02ceb, 0x02cec,
    0x02ced, 0x02cee,
    0x0a640, 0x0a641,
    0x0a642, 0x0a643,
    0x0a644, 0x0a645,
    0x0a646, 0x0a647,
    0x0a648, 0x0a649,
    0x0a64a, 0x0a64b,
    0x0a64c, 0x0a64d,
    0x0a64e, 0x0a64f,
    0x0a650, 0x0a651,
    0x0a652, 0x0a653,
    0x0a654, 0x0a655,
    0x0a656, 0x0a657,
    0x0a658, 0x0a659,
    0x0a65a, 0x0a65b,
    0x0a65c, 0x0a65d,
    0x0a65e, 0x0a65f,
    0x0a660, 0x0a661,
    0x0a662, 0x0a663,
    0x0a664, 0x0a665,
    0x0a666, 0x0a667,
    0x0a668, 0x0a669,
    0x0a66a, 0x0a66b,
    0x0a66c, 0x0a66d,
    0x0a680, 0x0a681,
    0x0a682, 0x0a683,
    0x0a684, 0x0a685,
    0x0a686, 0x0a687,
    0x0a688, 0x0a689,
    0x0a68a, 0x0a68b,
    0x0a68c, 0x0a68d,
    0x0a68e, 0x0a68f,
    0x0a690, 0x0a691,
    0x0a692, 0x0a693,
    0x0a694, 0x0a695,
    0x0a696, 0x0a697,
    0x0a722, 0x0a723,
    0x0a724, 0x0a725,
    0x0a726, 0x0a727,
    0x0a728, 0x0a729,
    0x0a72a, 0x0a72b,
    0x0a72c, 0x0a72d,
    0x0a72e, 0x0a72f,
    0x0a732, 0x0a733,
    0x0a734, 0x0a735,
    0x0a736, 0x0a737,
    0x0a738, 0x0a739,
    0x0a73a, 0x0a73b,
    0x0a73c, 0x0a73d,
    0x0a73e, 0x0a73f,
    0x0a740, 0x0a741,
    0x0a742, 0x0a743,
    0x0a744, 0x0a745,
    0x0a746, 0x0a747,
    0x0a748, 0x0a749,
    0x0a74a, 0x0a74b,
    0x0a74c, 0x0a74d,
    0x0a74e, 0x0a74f,
    0x0a750, 0x0a751,
    0x0a752, 0x0a753,
    0x0a754, 0x0a755,
    0x0a756, 0x0a757,
    0x0a758, 0x0a759,
    0x0a75a, 0x0a75b,
    0x0a75c, 0x0a75d,
    0x0a75e, 0x0a75f,
    0x0a760, 0x0a761,
    0x0a762, 0x0a763,
    0x0a764, 0x0a765,
    0x0a766, 0x0a767,
    0x0a768, 0x0a769,
    0x0a76a, 0x0a76b,
    0x0a76c, 0x0a76d,
    0x0a76e, 0x0a76f,
    0x0a779, 0x0a77a,
    0x0a77b, 0x0a77c,
    0x0a77d, 0x0a77f,
    0x0a780, 0x0a781,
    0x0a782, 0x0a783,
    0x0a784, 0x0a785,
    0x0a786, 0x0a787,
    0x0a78b, 0x0a78c,
    0x0a78d, 0x0a78e,
    0x0a790, 0x0a791,
    0x0a7a0, 0x0a7a1,
    0x0a7a2, 0x0a7a3,
    0x0a7a4, 0x0a7a5,
    0x0a7a6, 0x0a7a7,
    0x0a7a8, 0x0a7a9,
    0x0ff21, 0x0ff3b,
    0x10400, 0x10428,
    0x1d400, 0x1d41a,
    0x1d434, 0x1d44e,
    0x1d468, 0x1d482,
    0x1d49c, 0x1d49d,
    0x1d49e, 0x1d4a0,
    0x1d4a2, 0x1d4a3,
    0x1d4a5, 0x1d4a7,
    0x1d4a9, 0x1d4ad,
    0x1d4ae, 0x1d4b6,
    0x1d4d0, 0x1d4ea,
    0x1d504, 0x1d506,
    0x1d507, 0x1d50b,
    0x1d50d, 0x1d515,
    0x1d516, 0x1d51d,
    0x1d538, 0x1d53a,
    0x1d53b, 0x1d53f,
    0x1d540, 0x1d545,
    0x1d546, 0x1d547,
    0x1d54a, 0x1d551,
    0x1d56c, 0x1d586,
    0x1d5a0, 0x1d5ba,
    0x1d5d4, 0x1d5ee,
    0x1d608, 0x1d622,
    0x1d63c, 0x1d656,
    0x1d670, 0x1d68a,
    0x1d6a8, 0x1d6c1,
    0x1d6e2, 0x1d6fb,
    0x1d71c, 0x1d735,
    0x1d756, 0x1d76f,
    0x1d790, 0x1d7a9,
    0x1d7ca, 0x1d7cb,
]);

immutable(CodepointSet) unicodeCarian = CodepointSet([
    0x102a0, 0x102d1,
]);

immutable(CodepointSet) unicodeInKaithi = CodepointSet([
    0x11080, 0x110d0,
]);

immutable(CodepointSet) unicodeInVedic_Extensions = CodepointSet([
    0x01cd0, 0x01d00,
]);

immutable(CodepointSet) unicodeMn = CodepointSet([
    0x00300, 0x00370,
    0x00483, 0x00488,
    0x00591, 0x005be,
    0x005bf, 0x005c0,
    0x005c1, 0x005c3,
    0x005c4, 0x005c6,
    0x005c7, 0x005c8,
    0x00610, 0x0061b,
    0x0064b, 0x00660,
    0x00670, 0x00671,
    0x006d6, 0x006dd,
    0x006df, 0x006e5,
    0x006e7, 0x006e9,
    0x006ea, 0x006ee,
    0x00711, 0x00712,
    0x00730, 0x0074b,
    0x007a6, 0x007b1,
    0x007eb, 0x007f4,
    0x00816, 0x0081a,
    0x0081b, 0x00824,
    0x00825, 0x00828,
    0x00829, 0x0082e,
    0x00859, 0x0085c,
    0x00900, 0x00903,
    0x0093a, 0x0093b,
    0x0093c, 0x0093d,
    0x00941, 0x00949,
    0x0094d, 0x0094e,
    0x00951, 0x00958,
    0x00962, 0x00964,
    0x00981, 0x00982,
    0x009bc, 0x009bd,
    0x009c1, 0x009c5,
    0x009cd, 0x009ce,
    0x009e2, 0x009e4,
    0x00a01, 0x00a03,
    0x00a3c, 0x00a3d,
    0x00a41, 0x00a43,
    0x00a47, 0x00a49,
    0x00a4b, 0x00a4e,
    0x00a51, 0x00a52,
    0x00a70, 0x00a72,
    0x00a75, 0x00a76,
    0x00a81, 0x00a83,
    0x00abc, 0x00abd,
    0x00ac1, 0x00ac6,
    0x00ac7, 0x00ac9,
    0x00acd, 0x00ace,
    0x00ae2, 0x00ae4,
    0x00b01, 0x00b02,
    0x00b3c, 0x00b3d,
    0x00b3f, 0x00b40,
    0x00b41, 0x00b45,
    0x00b4d, 0x00b4e,
    0x00b56, 0x00b57,
    0x00b62, 0x00b64,
    0x00b82, 0x00b83,
    0x00bc0, 0x00bc1,
    0x00bcd, 0x00bce,
    0x00c3e, 0x00c41,
    0x00c46, 0x00c49,
    0x00c4a, 0x00c4e,
    0x00c55, 0x00c57,
    0x00c62, 0x00c64,
    0x00cbc, 0x00cbd,
    0x00cbf, 0x00cc0,
    0x00cc6, 0x00cc7,
    0x00ccc, 0x00cce,
    0x00ce2, 0x00ce4,
    0x00d41, 0x00d45,
    0x00d4d, 0x00d4e,
    0x00d62, 0x00d64,
    0x00dca, 0x00dcb,
    0x00dd2, 0x00dd5,
    0x00dd6, 0x00dd7,
    0x00e31, 0x00e32,
    0x00e34, 0x00e3b,
    0x00e47, 0x00e4f,
    0x00eb1, 0x00eb2,
    0x00eb4, 0x00eba,
    0x00ebb, 0x00ebd,
    0x00ec8, 0x00ece,
    0x00f18, 0x00f1a,
    0x00f35, 0x00f36,
    0x00f37, 0x00f38,
    0x00f39, 0x00f3a,
    0x00f71, 0x00f7f,
    0x00f80, 0x00f85,
    0x00f86, 0x00f88,
    0x00f8d, 0x00f98,
    0x00f99, 0x00fbd,
    0x00fc6, 0x00fc7,
    0x0102d, 0x01031,
    0x01032, 0x01038,
    0x01039, 0x0103b,
    0x0103d, 0x0103f,
    0x01058, 0x0105a,
    0x0105e, 0x01061,
    0x01071, 0x01075,
    0x01082, 0x01083,
    0x01085, 0x01087,
    0x0108d, 0x0108e,
    0x0109d, 0x0109e,
    0x0135d, 0x01360,
    0x01712, 0x01715,
    0x01732, 0x01735,
    0x01752, 0x01754,
    0x01772, 0x01774,
    0x017b7, 0x017be,
    0x017c6, 0x017c7,
    0x017c9, 0x017d4,
    0x017dd, 0x017de,
    0x0180b, 0x0180e,
    0x018a9, 0x018aa,
    0x01920, 0x01923,
    0x01927, 0x01929,
    0x01932, 0x01933,
    0x01939, 0x0193c,
    0x01a17, 0x01a19,
    0x01a56, 0x01a57,
    0x01a58, 0x01a5f,
    0x01a60, 0x01a61,
    0x01a62, 0x01a63,
    0x01a65, 0x01a6d,
    0x01a73, 0x01a7d,
    0x01a7f, 0x01a80,
    0x01b00, 0x01b04,
    0x01b34, 0x01b35,
    0x01b36, 0x01b3b,
    0x01b3c, 0x01b3d,
    0x01b42, 0x01b43,
    0x01b6b, 0x01b74,
    0x01b80, 0x01b82,
    0x01ba2, 0x01ba6,
    0x01ba8, 0x01baa,
    0x01be6, 0x01be7,
    0x01be8, 0x01bea,
    0x01bed, 0x01bee,
    0x01bef, 0x01bf2,
    0x01c2c, 0x01c34,
    0x01c36, 0x01c38,
    0x01cd0, 0x01cd3,
    0x01cd4, 0x01ce1,
    0x01ce2, 0x01ce9,
    0x01ced, 0x01cee,
    0x01dc0, 0x01de7,
    0x01dfc, 0x01e00,
    0x020d0, 0x020dd,
    0x020e1, 0x020e2,
    0x020e5, 0x020f1,
    0x02cef, 0x02cf2,
    0x02d7f, 0x02d80,
    0x02de0, 0x02e00,
    0x0302a, 0x03030,
    0x03099, 0x0309b,
    0x0a66f, 0x0a670,
    0x0a67c, 0x0a67e,
    0x0a6f0, 0x0a6f2,
    0x0a802, 0x0a803,
    0x0a806, 0x0a807,
    0x0a80b, 0x0a80c,
    0x0a825, 0x0a827,
    0x0a8c4, 0x0a8c5,
    0x0a8e0, 0x0a8f2,
    0x0a926, 0x0a92e,
    0x0a947, 0x0a952,
    0x0a980, 0x0a983,
    0x0a9b3, 0x0a9b4,
    0x0a9b6, 0x0a9ba,
    0x0a9bc, 0x0a9bd,
    0x0aa29, 0x0aa2f,
    0x0aa31, 0x0aa33,
    0x0aa35, 0x0aa37,
    0x0aa43, 0x0aa44,
    0x0aa4c, 0x0aa4d,
    0x0aab0, 0x0aab1,
    0x0aab2, 0x0aab5,
    0x0aab7, 0x0aab9,
    0x0aabe, 0x0aac0,
    0x0aac1, 0x0aac2,
    0x0abe5, 0x0abe6,
    0x0abe8, 0x0abe9,
    0x0abed, 0x0abee,
    0x0fb1e, 0x0fb1f,
    0x0fe00, 0x0fe10,
    0x0fe20, 0x0fe27,
    0x101fd, 0x101fe,
    0x10a01, 0x10a04,
    0x10a05, 0x10a07,
    0x10a0c, 0x10a10,
    0x10a38, 0x10a3b,
    0x10a3f, 0x10a40,
    0x11001, 0x11002,
    0x11038, 0x11047,
    0x11080, 0x11082,
    0x110b3, 0x110b7,
    0x110b9, 0x110bb,
    0x1d167, 0x1d16a,
    0x1d17b, 0x1d183,
    0x1d185, 0x1d18c,
    0x1d1aa, 0x1d1ae,
    0x1d242, 0x1d245,
    0xe0100, 0xe01f0,
]);

immutable(CodepointSet) unicodeNd = CodepointSet([
    0x00030, 0x0003a,
    0x00660, 0x0066a,
    0x006f0, 0x006fa,
    0x007c0, 0x007ca,
    0x00966, 0x00970,
    0x009e6, 0x009f0,
    0x00a66, 0x00a70,
    0x00ae6, 0x00af0,
    0x00b66, 0x00b70,
    0x00be6, 0x00bf0,
    0x00c66, 0x00c70,
    0x00ce6, 0x00cf0,
    0x00d66, 0x00d70,
    0x00e50, 0x00e5a,
    0x00ed0, 0x00eda,
    0x00f20, 0x00f2a,
    0x01040, 0x0104a,
    0x01090, 0x0109a,
    0x017e0, 0x017ea,
    0x01810, 0x0181a,
    0x01946, 0x01950,
    0x019d0, 0x019da,
    0x01a80, 0x01a8a,
    0x01a90, 0x01a9a,
    0x01b50, 0x01b5a,
    0x01bb0, 0x01bba,
    0x01c40, 0x01c4a,
    0x01c50, 0x01c5a,
    0x0a620, 0x0a62a,
    0x0a8d0, 0x0a8da,
    0x0a900, 0x0a90a,
    0x0a9d0, 0x0a9da,
    0x0aa50, 0x0aa5a,
    0x0abf0, 0x0abfa,
    0x0ff10, 0x0ff1a,
    0x104a0, 0x104aa,
    0x11066, 0x11070,
    0x1d7ce, 0x1d800,
]);

immutable(CodepointSet) unicodeBamum = CodepointSet([
    0x0a6a0, 0x0a6f8,
    0x16800, 0x16a39,
]);

immutable(CodepointSet) unicodeJavanese = CodepointSet([
    0x0a980, 0x0a9ce,
    0x0a9cf, 0x0a9da,
    0x0a9de, 0x0a9e0,
]);

immutable(CodepointSet) unicodeTifinagh = CodepointSet([
    0x02d30, 0x02d66,
    0x02d6f, 0x02d71,
    0x02d7f, 0x02d80,
]);

immutable(CodepointSet) unicodeInHalfwidth_and_Fullwidth_Forms = CodepointSet([
    0x0ff00, 0x0fff0,
]);

immutable(CodepointSet) unicodeInDevanagari_Extended = CodepointSet([
    0x0a8e0, 0x0a900,
]);

immutable(CodepointSet) unicodeInIdeographic_Description_Characters = CodepointSet([
    0x02ff0, 0x03000,
]);

immutable(CodepointSet) unicodeInCuneiform = CodepointSet([
    0x12000, 0x12400,
]);

immutable(CodepointSet) unicodeNl = CodepointSet([
    0x016ee, 0x016f1,
    0x02160, 0x02183,
    0x02185, 0x02189,
    0x03007, 0x03008,
    0x03021, 0x0302a,
    0x03038, 0x0303b,
    0x0a6e6, 0x0a6f0,
    0x10140, 0x10175,
    0x10341, 0x10342,
    0x1034a, 0x1034b,
    0x103d1, 0x103d6,
    0x12400, 0x12463,
]);

immutable(CodepointSet) unicodeInHangul_Compatibility_Jamo = CodepointSet([
    0x03130, 0x03190,
]);

immutable(CodepointSet) unicodeNo = CodepointSet([
    0x000b2, 0x000b4,
    0x000b9, 0x000ba,
    0x000bc, 0x000bf,
    0x009f4, 0x009fa,
    0x00b72, 0x00b78,
    0x00bf0, 0x00bf3,
    0x00c78, 0x00c7f,
    0x00d70, 0x00d76,
    0x00f2a, 0x00f34,
    0x01369, 0x0137d,
    0x017f0, 0x017fa,
    0x019da, 0x019db,
    0x02070, 0x02071,
    0x02074, 0x0207a,
    0x02080, 0x0208a,
    0x02150, 0x02160,
    0x02189, 0x0218a,
    0x02460, 0x0249c,
    0x024ea, 0x02500,
    0x02776, 0x02794,
    0x02cfd, 0x02cfe,
    0x03192, 0x03196,
    0x03220, 0x0322a,
    0x03251, 0x03260,
    0x03280, 0x0328a,
    0x032b1, 0x032c0,
    0x0a830, 0x0a836,
    0x10107, 0x10134,
    0x10175, 0x10179,
    0x1018a, 0x1018b,
    0x10320, 0x10324,
    0x10858, 0x10860,
    0x10916, 0x1091c,
    0x10a40, 0x10a48,
    0x10a7d, 0x10a7f,
    0x10b58, 0x10b60,
    0x10b78, 0x10b80,
    0x10e60, 0x10e7f,
    0x11052, 0x11066,
    0x1d360, 0x1d372,
    0x1f100, 0x1f10b,
]);

immutable(CodepointSet) unicodeInOriya = CodepointSet([
    0x00b00, 0x00b80,
]);

immutable(CodepointSet) unicodeLogical_Order_Exception = CodepointSet([
    0x00e40, 0x00e45,
    0x00ec0, 0x00ec5,
    0x0aab5, 0x0aab7,
    0x0aab9, 0x0aaba,
    0x0aabb, 0x0aabd,
]);

immutable(CodepointSet) unicodeInscriptional_Parthian = CodepointSet([
    0x10b40, 0x10b56,
    0x10b58, 0x10b60,
]);

immutable(CodepointSet) unicodeSyloti_Nagri = CodepointSet([
    0x0a800, 0x0a82c,
]);

immutable(CodepointSet) unicodeInBengali = CodepointSet([
    0x00980, 0x00a00,
]);

immutable(CodepointSet) unicodeInTagalog = CodepointSet([
    0x01700, 0x01720,
]);

immutable(CodepointSet) unicodeInMyanmar_Extended_A = CodepointSet([
    0x0aa60, 0x0aa80,
]);

immutable(CodepointSet) unicodeInAvestan = CodepointSet([
    0x10b00, 0x10b40,
]);

immutable(CodepointSet) unicodePc = CodepointSet([
    0x0005f, 0x00060,
    0x0203f, 0x02041,
    0x02054, 0x02055,
    0x0fe33, 0x0fe35,
    0x0fe4d, 0x0fe50,
    0x0ff3f, 0x0ff40,
]);

immutable(CodepointSet) unicodeInCyrillic_Extended_A = CodepointSet([
    0x02de0, 0x02e00,
]);

immutable(CodepointSet) unicodePd = CodepointSet([
    0x0002d, 0x0002e,
    0x0058a, 0x0058b,
    0x005be, 0x005bf,
    0x01400, 0x01401,
    0x01806, 0x01807,
    0x02010, 0x02016,
    0x02e17, 0x02e18,
    0x02e1a, 0x02e1b,
    0x0301c, 0x0301d,
    0x03030, 0x03031,
    0x030a0, 0x030a1,
    0x0fe31, 0x0fe33,
    0x0fe58, 0x0fe59,
    0x0fe63, 0x0fe64,
    0x0ff0d, 0x0ff0e,
]);

immutable(CodepointSet) unicodeInCyrillic_Extended_B = CodepointSet([
    0x0a640, 0x0a6a0,
]);

immutable(CodepointSet) unicodeInBasic_Latin = CodepointSet([
    0x00000, 0x00080,
]);

immutable(CodepointSet) unicodePe = CodepointSet([
    0x00029, 0x0002a,
    0x0005d, 0x0005e,
    0x0007d, 0x0007e,
    0x00f3b, 0x00f3c,
    0x00f3d, 0x00f3e,
    0x0169c, 0x0169d,
    0x02046, 0x02047,
    0x0207e, 0x0207f,
    0x0208e, 0x0208f,
    0x0232a, 0x0232b,
    0x02769, 0x0276a,
    0x0276b, 0x0276c,
    0x0276d, 0x0276e,
    0x0276f, 0x02770,
    0x02771, 0x02772,
    0x02773, 0x02774,
    0x02775, 0x02776,
    0x027c6, 0x027c7,
    0x027e7, 0x027e8,
    0x027e9, 0x027ea,
    0x027eb, 0x027ec,
    0x027ed, 0x027ee,
    0x027ef, 0x027f0,
    0x02984, 0x02985,
    0x02986, 0x02987,
    0x02988, 0x02989,
    0x0298a, 0x0298b,
    0x0298c, 0x0298d,
    0x0298e, 0x0298f,
    0x02990, 0x02991,
    0x02992, 0x02993,
    0x02994, 0x02995,
    0x02996, 0x02997,
    0x02998, 0x02999,
    0x029d9, 0x029da,
    0x029db, 0x029dc,
    0x029fd, 0x029fe,
    0x02e23, 0x02e24,
    0x02e25, 0x02e26,
    0x02e27, 0x02e28,
    0x02e29, 0x02e2a,
    0x03009, 0x0300a,
    0x0300b, 0x0300c,
    0x0300d, 0x0300e,
    0x0300f, 0x03010,
    0x03011, 0x03012,
    0x03015, 0x03016,
    0x03017, 0x03018,
    0x03019, 0x0301a,
    0x0301b, 0x0301c,
    0x0301e, 0x03020,
    0x0fd3f, 0x0fd40,
    0x0fe18, 0x0fe19,
    0x0fe36, 0x0fe37,
    0x0fe38, 0x0fe39,
    0x0fe3a, 0x0fe3b,
    0x0fe3c, 0x0fe3d,
    0x0fe3e, 0x0fe3f,
    0x0fe40, 0x0fe41,
    0x0fe42, 0x0fe43,
    0x0fe44, 0x0fe45,
    0x0fe48, 0x0fe49,
    0x0fe5a, 0x0fe5b,
    0x0fe5c, 0x0fe5d,
    0x0fe5e, 0x0fe5f,
    0x0ff09, 0x0ff0a,
    0x0ff3d, 0x0ff3e,
    0x0ff5d, 0x0ff5e,
    0x0ff60, 0x0ff61,
    0x0ff63, 0x0ff64,
]);

immutable(CodepointSet) unicodeHanunoo = CodepointSet([
    0x01720, 0x01735,
]);

immutable(CodepointSet) unicodePf = CodepointSet([
    0x000bb, 0x000bc,
    0x02019, 0x0201a,
    0x0201d, 0x0201e,
    0x0203a, 0x0203b,
    0x02e03, 0x02e04,
    0x02e05, 0x02e06,
    0x02e0a, 0x02e0b,
    0x02e0d, 0x02e0e,
    0x02e1d, 0x02e1e,
    0x02e21, 0x02e22,
]);

immutable(CodepointSet) unicodePi = CodepointSet([
    0x000ab, 0x000ac,
    0x02018, 0x02019,
    0x0201b, 0x0201d,
    0x0201f, 0x02020,
    0x02039, 0x0203a,
    0x02e02, 0x02e03,
    0x02e04, 0x02e05,
    0x02e09, 0x02e0a,
    0x02e0c, 0x02e0d,
    0x02e1c, 0x02e1d,
    0x02e20, 0x02e21,
]);

immutable(CodepointSet) unicodeSinhala = CodepointSet([
    0x00d82, 0x00d84,
    0x00d85, 0x00d97,
    0x00d9a, 0x00db2,
    0x00db3, 0x00dbc,
    0x00dbd, 0x00dbe,
    0x00dc0, 0x00dc7,
    0x00dca, 0x00dcb,
    0x00dcf, 0x00dd5,
    0x00dd6, 0x00dd7,
    0x00dd8, 0x00de0,
    0x00df2, 0x00df5,
]);

immutable(CodepointSet) unicodeInJavanese = CodepointSet([
    0x0a980, 0x0a9e0,
]);

immutable(CodepointSet) unicodeInCarian = CodepointSet([
    0x102a0, 0x102e0,
]);

immutable(CodepointSet) unicodeInDomino_Tiles = CodepointSet([
    0x1f030, 0x1f0a0,
]);

immutable(CodepointSet) unicodeInTifinagh = CodepointSet([
    0x02d30, 0x02d80,
]);

immutable(CodepointSet) unicodeLycian = CodepointSet([
    0x10280, 0x1029d,
]);

immutable(CodepointSet) unicodeInGeometric_Shapes = CodepointSet([
    0x025a0, 0x02600,
]);

immutable(CodepointSet) unicodeInArabic_Presentation_Forms_A = CodepointSet([
    0x0fb50, 0x0fe00,
]);

immutable(CodepointSet) unicodeInArabic_Presentation_Forms_B = CodepointSet([
    0x0fe70, 0x0ff00,
]);

immutable(CodepointSet) unicodePo = CodepointSet([
    0x00021, 0x00024,
    0x00025, 0x00028,
    0x0002a, 0x0002b,
    0x0002c, 0x0002d,
    0x0002e, 0x00030,
    0x0003a, 0x0003c,
    0x0003f, 0x00041,
    0x0005c, 0x0005d,
    0x000a1, 0x000a2,
    0x000b7, 0x000b8,
    0x000bf, 0x000c0,
    0x0037e, 0x0037f,
    0x00387, 0x00388,
    0x0055a, 0x00560,
    0x00589, 0x0058a,
    0x005c0, 0x005c1,
    0x005c3, 0x005c4,
    0x005c6, 0x005c7,
    0x005f3, 0x005f5,
    0x00609, 0x0060b,
    0x0060c, 0x0060e,
    0x0061b, 0x0061c,
    0x0061e, 0x00620,
    0x0066a, 0x0066e,
    0x006d4, 0x006d5,
    0x00700, 0x0070e,
    0x007f7, 0x007fa,
    0x00830, 0x0083f,
    0x0085e, 0x0085f,
    0x00964, 0x00966,
    0x00970, 0x00971,
    0x00df4, 0x00df5,
    0x00e4f, 0x00e50,
    0x00e5a, 0x00e5c,
    0x00f04, 0x00f13,
    0x00f85, 0x00f86,
    0x00fd0, 0x00fd5,
    0x00fd9, 0x00fdb,
    0x0104a, 0x01050,
    0x010fb, 0x010fc,
    0x01361, 0x01369,
    0x0166d, 0x0166f,
    0x016eb, 0x016ee,
    0x01735, 0x01737,
    0x017d4, 0x017d7,
    0x017d8, 0x017db,
    0x01800, 0x01806,
    0x01807, 0x0180b,
    0x01944, 0x01946,
    0x01a1e, 0x01a20,
    0x01aa0, 0x01aa7,
    0x01aa8, 0x01aae,
    0x01b5a, 0x01b61,
    0x01bfc, 0x01c00,
    0x01c3b, 0x01c40,
    0x01c7e, 0x01c80,
    0x01cd3, 0x01cd4,
    0x02016, 0x02018,
    0x02020, 0x02028,
    0x02030, 0x02039,
    0x0203b, 0x0203f,
    0x02041, 0x02044,
    0x02047, 0x02052,
    0x02053, 0x02054,
    0x02055, 0x0205f,
    0x02cf9, 0x02cfd,
    0x02cfe, 0x02d00,
    0x02d70, 0x02d71,
    0x02e00, 0x02e02,
    0x02e06, 0x02e09,
    0x02e0b, 0x02e0c,
    0x02e0e, 0x02e17,
    0x02e18, 0x02e1a,
    0x02e1b, 0x02e1c,
    0x02e1e, 0x02e20,
    0x02e2a, 0x02e2f,
    0x02e30, 0x02e32,
    0x03001, 0x03004,
    0x0303d, 0x0303e,
    0x030fb, 0x030fc,
    0x0a4fe, 0x0a500,
    0x0a60d, 0x0a610,
    0x0a673, 0x0a674,
    0x0a67e, 0x0a67f,
    0x0a6f2, 0x0a6f8,
    0x0a874, 0x0a878,
    0x0a8ce, 0x0a8d0,
    0x0a8f8, 0x0a8fb,
    0x0a92e, 0x0a930,
    0x0a95f, 0x0a960,
    0x0a9c1, 0x0a9ce,
    0x0a9de, 0x0a9e0,
    0x0aa5c, 0x0aa60,
    0x0aade, 0x0aae0,
    0x0abeb, 0x0abec,
    0x0fe10, 0x0fe17,
    0x0fe19, 0x0fe1a,
    0x0fe30, 0x0fe31,
    0x0fe45, 0x0fe47,
    0x0fe49, 0x0fe4d,
    0x0fe50, 0x0fe53,
    0x0fe54, 0x0fe58,
    0x0fe5f, 0x0fe62,
    0x0fe68, 0x0fe69,
    0x0fe6a, 0x0fe6c,
    0x0ff01, 0x0ff04,
    0x0ff05, 0x0ff08,
    0x0ff0a, 0x0ff0b,
    0x0ff0c, 0x0ff0d,
    0x0ff0e, 0x0ff10,
    0x0ff1a, 0x0ff1c,
    0x0ff1f, 0x0ff21,
    0x0ff3c, 0x0ff3d,
    0x0ff61, 0x0ff62,
    0x0ff64, 0x0ff66,
    0x10100, 0x10102,
    0x1039f, 0x103a0,
    0x103d0, 0x103d1,
    0x10857, 0x10858,
    0x1091f, 0x10920,
    0x1093f, 0x10940,
    0x10a50, 0x10a59,
    0x10a7f, 0x10a80,
    0x10b39, 0x10b40,
    0x11047, 0x1104e,
    0x110bb, 0x110bd,
    0x110be, 0x110c2,
    0x12470, 0x12474,
]);

immutable(CodepointSet) unicodeTerminal_Punctuation = CodepointSet([
    0x00021, 0x00022,
    0x0002c, 0x0002d,
    0x0002e, 0x0002f,
    0x0003a, 0x0003c,
    0x0003f, 0x00040,
    0x0037e, 0x0037f,
    0x00387, 0x00388,
    0x00589, 0x0058a,
    0x005c3, 0x005c4,
    0x0060c, 0x0060d,
    0x0061b, 0x0061c,
    0x0061f, 0x00620,
    0x006d4, 0x006d5,
    0x00700, 0x0070b,
    0x0070c, 0x0070d,
    0x007f8, 0x007fa,
    0x00830, 0x0083f,
    0x0085e, 0x0085f,
    0x00964, 0x00966,
    0x00e5a, 0x00e5c,
    0x00f08, 0x00f09,
    0x00f0d, 0x00f13,
    0x0104a, 0x0104c,
    0x01361, 0x01369,
    0x0166d, 0x0166f,
    0x016eb, 0x016ee,
    0x017d4, 0x017d7,
    0x017da, 0x017db,
    0x01802, 0x01806,
    0x01808, 0x0180a,
    0x01944, 0x01946,
    0x01aa8, 0x01aac,
    0x01b5a, 0x01b5c,
    0x01b5d, 0x01b60,
    0x01c3b, 0x01c40,
    0x01c7e, 0x01c80,
    0x0203c, 0x0203e,
    0x02047, 0x0204a,
    0x02e2e, 0x02e2f,
    0x03001, 0x03003,
    0x0a4fe, 0x0a500,
    0x0a60d, 0x0a610,
    0x0a6f3, 0x0a6f8,
    0x0a876, 0x0a878,
    0x0a8ce, 0x0a8d0,
    0x0a92f, 0x0a930,
    0x0a9c7, 0x0a9ca,
    0x0aa5d, 0x0aa60,
    0x0aadf, 0x0aae0,
    0x0abeb, 0x0abec,
    0x0fe50, 0x0fe53,
    0x0fe54, 0x0fe58,
    0x0ff01, 0x0ff02,
    0x0ff0c, 0x0ff0d,
    0x0ff0e, 0x0ff0f,
    0x0ff1a, 0x0ff1c,
    0x0ff1f, 0x0ff20,
    0x0ff61, 0x0ff62,
    0x0ff64, 0x0ff65,
    0x1039f, 0x103a0,
    0x103d0, 0x103d1,
    0x10857, 0x10858,
    0x1091f, 0x10920,
    0x10b3a, 0x10b40,
    0x11047, 0x1104e,
    0x110be, 0x110c2,
    0x12470, 0x12474,
]);

immutable(CodepointSet) unicodePs = CodepointSet([
    0x00028, 0x00029,
    0x0005b, 0x0005c,
    0x0007b, 0x0007c,
    0x00f3a, 0x00f3b,
    0x00f3c, 0x00f3d,
    0x0169b, 0x0169c,
    0x0201a, 0x0201b,
    0x0201e, 0x0201f,
    0x02045, 0x02046,
    0x0207d, 0x0207e,
    0x0208d, 0x0208e,
    0x02329, 0x0232a,
    0x02768, 0x02769,
    0x0276a, 0x0276b,
    0x0276c, 0x0276d,
    0x0276e, 0x0276f,
    0x02770, 0x02771,
    0x02772, 0x02773,
    0x02774, 0x02775,
    0x027c5, 0x027c6,
    0x027e6, 0x027e7,
    0x027e8, 0x027e9,
    0x027ea, 0x027eb,
    0x027ec, 0x027ed,
    0x027ee, 0x027ef,
    0x02983, 0x02984,
    0x02985, 0x02986,
    0x02987, 0x02988,
    0x02989, 0x0298a,
    0x0298b, 0x0298c,
    0x0298d, 0x0298e,
    0x0298f, 0x02990,
    0x02991, 0x02992,
    0x02993, 0x02994,
    0x02995, 0x02996,
    0x02997, 0x02998,
    0x029d8, 0x029d9,
    0x029da, 0x029db,
    0x029fc, 0x029fd,
    0x02e22, 0x02e23,
    0x02e24, 0x02e25,
    0x02e26, 0x02e27,
    0x02e28, 0x02e29,
    0x03008, 0x03009,
    0x0300a, 0x0300b,
    0x0300c, 0x0300d,
    0x0300e, 0x0300f,
    0x03010, 0x03011,
    0x03014, 0x03015,
    0x03016, 0x03017,
    0x03018, 0x03019,
    0x0301a, 0x0301b,
    0x0301d, 0x0301e,
    0x0fd3e, 0x0fd3f,
    0x0fe17, 0x0fe18,
    0x0fe35, 0x0fe36,
    0x0fe37, 0x0fe38,
    0x0fe39, 0x0fe3a,
    0x0fe3b, 0x0fe3c,
    0x0fe3d, 0x0fe3e,
    0x0fe3f, 0x0fe40,
    0x0fe41, 0x0fe42,
    0x0fe43, 0x0fe44,
    0x0fe47, 0x0fe48,
    0x0fe59, 0x0fe5a,
    0x0fe5b, 0x0fe5c,
    0x0fe5d, 0x0fe5e,
    0x0ff08, 0x0ff09,
    0x0ff3b, 0x0ff3c,
    0x0ff5b, 0x0ff5c,
    0x0ff5f, 0x0ff60,
    0x0ff62, 0x0ff63,
]);

immutable(CodepointSet) unicodeInSpacing_Modifier_Letters = CodepointSet([
    0x002b0, 0x00300,
]);

immutable(CodepointSet) unicodeOther_Alphabetic = CodepointSet([
    0x00345, 0x00346,
    0x005b0, 0x005be,
    0x005bf, 0x005c0,
    0x005c1, 0x005c3,
    0x005c4, 0x005c6,
    0x005c7, 0x005c8,
    0x00610, 0x0061b,
    0x0064b, 0x00658,
    0x00659, 0x00660,
    0x00670, 0x00671,
    0x006d6, 0x006dd,
    0x006e1, 0x006e5,
    0x006e7, 0x006e9,
    0x006ed, 0x006ee,
    0x00711, 0x00712,
    0x00730, 0x00740,
    0x007a6, 0x007b1,
    0x00816, 0x00818,
    0x0081b, 0x00824,
    0x00825, 0x00828,
    0x00829, 0x0082d,
    0x00900, 0x00904,
    0x0093a, 0x0093c,
    0x0093e, 0x0094d,
    0x0094e, 0x00950,
    0x00955, 0x00958,
    0x00962, 0x00964,
    0x00981, 0x00984,
    0x009be, 0x009c5,
    0x009c7, 0x009c9,
    0x009cb, 0x009cd,
    0x009d7, 0x009d8,
    0x009e2, 0x009e4,
    0x00a01, 0x00a04,
    0x00a3e, 0x00a43,
    0x00a47, 0x00a49,
    0x00a4b, 0x00a4d,
    0x00a51, 0x00a52,
    0x00a70, 0x00a72,
    0x00a75, 0x00a76,
    0x00a81, 0x00a84,
    0x00abe, 0x00ac6,
    0x00ac7, 0x00aca,
    0x00acb, 0x00acd,
    0x00ae2, 0x00ae4,
    0x00b01, 0x00b04,
    0x00b3e, 0x00b45,
    0x00b47, 0x00b49,
    0x00b4b, 0x00b4d,
    0x00b56, 0x00b58,
    0x00b62, 0x00b64,
    0x00b82, 0x00b83,
    0x00bbe, 0x00bc3,
    0x00bc6, 0x00bc9,
    0x00bca, 0x00bcd,
    0x00bd7, 0x00bd8,
    0x00c01, 0x00c04,
    0x00c3e, 0x00c45,
    0x00c46, 0x00c49,
    0x00c4a, 0x00c4d,
    0x00c55, 0x00c57,
    0x00c62, 0x00c64,
    0x00c82, 0x00c84,
    0x00cbe, 0x00cc5,
    0x00cc6, 0x00cc9,
    0x00cca, 0x00ccd,
    0x00cd5, 0x00cd7,
    0x00ce2, 0x00ce4,
    0x00d02, 0x00d04,
    0x00d3e, 0x00d45,
    0x00d46, 0x00d49,
    0x00d4a, 0x00d4d,
    0x00d57, 0x00d58,
    0x00d62, 0x00d64,
    0x00d82, 0x00d84,
    0x00dcf, 0x00dd5,
    0x00dd6, 0x00dd7,
    0x00dd8, 0x00de0,
    0x00df2, 0x00df4,
    0x00e31, 0x00e32,
    0x00e34, 0x00e3b,
    0x00e4d, 0x00e4e,
    0x00eb1, 0x00eb2,
    0x00eb4, 0x00eba,
    0x00ebb, 0x00ebd,
    0x00ecd, 0x00ece,
    0x00f71, 0x00f82,
    0x00f8d, 0x00f98,
    0x00f99, 0x00fbd,
    0x0102b, 0x01037,
    0x01038, 0x01039,
    0x0103b, 0x0103f,
    0x01056, 0x0105a,
    0x0105e, 0x01061,
    0x01062, 0x01063,
    0x01067, 0x01069,
    0x01071, 0x01075,
    0x01082, 0x01087,
    0x0109c, 0x0109e,
    0x0135f, 0x01360,
    0x01712, 0x01714,
    0x01732, 0x01734,
    0x01752, 0x01754,
    0x01772, 0x01774,
    0x017b6, 0x017c9,
    0x018a9, 0x018aa,
    0x01920, 0x0192c,
    0x01930, 0x01939,
    0x019b0, 0x019c1,
    0x019c8, 0x019ca,
    0x01a17, 0x01a1c,
    0x01a55, 0x01a5f,
    0x01a61, 0x01a75,
    0x01b00, 0x01b05,
    0x01b35, 0x01b44,
    0x01b80, 0x01b83,
    0x01ba1, 0x01baa,
    0x01be7, 0x01bf2,
    0x01c24, 0x01c36,
    0x01cf2, 0x01cf3,
    0x024b6, 0x024ea,
    0x02de0, 0x02e00,
    0x0a823, 0x0a828,
    0x0a880, 0x0a882,
    0x0a8b4, 0x0a8c4,
    0x0a926, 0x0a92b,
    0x0a947, 0x0a953,
    0x0a980, 0x0a984,
    0x0a9b4, 0x0a9c0,
    0x0aa29, 0x0aa37,
    0x0aa43, 0x0aa44,
    0x0aa4c, 0x0aa4e,
    0x0aab0, 0x0aab1,
    0x0aab2, 0x0aab5,
    0x0aab7, 0x0aab9,
    0x0aabe, 0x0aabf,
    0x0abe3, 0x0abeb,
    0x0fb1e, 0x0fb1f,
    0x10a01, 0x10a04,
    0x10a05, 0x10a07,
    0x10a0c, 0x10a10,
    0x11000, 0x11003,
    0x11038, 0x11046,
    0x11082, 0x11083,
    0x110b0, 0x110b9,
]);

immutable(CodepointSet) unicodeLepcha = CodepointSet([
    0x01c00, 0x01c38,
    0x01c3b, 0x01c4a,
    0x01c4d, 0x01c50,
]);

immutable(CodepointSet) unicodeKayah_Li = CodepointSet([
    0x0a900, 0x0a930,
]);

immutable(CodepointSet) unicodeInCounting_Rod_Numerals = CodepointSet([
    0x1d360, 0x1d380,
]);

immutable(CodepointSet) unicodeNko = CodepointSet([
    0x007c0, 0x007fb,
]);

immutable(CodepointSet) unicodeInOld_Turkic = CodepointSet([
    0x10c00, 0x10c50,
]);

immutable(CodepointSet) unicodeInMiscellaneous_Symbols_And_Pictographs = CodepointSet([
    0x1f300, 0x1f600,
]);

immutable(CodepointSet) unicodeInLao = CodepointSet([
    0x00e80, 0x00f00,
]);

immutable(CodepointSet) unicodeInNKo = CodepointSet([
    0x007c0, 0x00800,
]);

immutable(CodepointSet) unicodeInGreek_and_Coptic = CodepointSet([
    0x00370, 0x00400,
]);

immutable(CodepointSet) unicodePhags_Pa = CodepointSet([
    0x0a840, 0x0a878,
]);

immutable(CodepointSet) unicodeCypriot = CodepointSet([
    0x10800, 0x10806,
    0x10808, 0x10809,
    0x1080a, 0x10836,
    0x10837, 0x10839,
    0x1083c, 0x1083d,
    0x1083f, 0x10840,
]);

immutable(CodepointSet) unicodeInModifier_Tone_Letters = CodepointSet([
    0x0a700, 0x0a720,
]);

immutable(CodepointSet) unicodeTamil = CodepointSet([
    0x00b82, 0x00b84,
    0x00b85, 0x00b8b,
    0x00b8e, 0x00b91,
    0x00b92, 0x00b96,
    0x00b99, 0x00b9b,
    0x00b9c, 0x00b9d,
    0x00b9e, 0x00ba0,
    0x00ba3, 0x00ba5,
    0x00ba8, 0x00bab,
    0x00bae, 0x00bba,
    0x00bbe, 0x00bc3,
    0x00bc6, 0x00bc9,
    0x00bca, 0x00bce,
    0x00bd0, 0x00bd1,
    0x00bd7, 0x00bd8,
    0x00be6, 0x00bfb,
]);

immutable(CodepointSet) unicodeMyanmar = CodepointSet([
    0x01000, 0x010a0,
    0x0aa60, 0x0aa7c,
]);

immutable(CodepointSet) unicodeSc = CodepointSet([
    0x00024, 0x00025,
    0x000a2, 0x000a6,
    0x0060b, 0x0060c,
    0x009f2, 0x009f4,
    0x009fb, 0x009fc,
    0x00af1, 0x00af2,
    0x00bf9, 0x00bfa,
    0x00e3f, 0x00e40,
    0x017db, 0x017dc,
    0x020a0, 0x020ba,
    0x0a838, 0x0a839,
    0x0fdfc, 0x0fdfd,
    0x0fe69, 0x0fe6a,
    0x0ff04, 0x0ff05,
    0x0ffe0, 0x0ffe2,
    0x0ffe5, 0x0ffe7,
]);

immutable(CodepointSet) unicodeInPrivate_Use_Area = CodepointSet([
    0x0e000, 0x0f900,
]);

immutable(CodepointSet) unicodeKannada = CodepointSet([
    0x00c82, 0x00c84,
    0x00c85, 0x00c8d,
    0x00c8e, 0x00c91,
    0x00c92, 0x00ca9,
    0x00caa, 0x00cb4,
    0x00cb5, 0x00cba,
    0x00cbc, 0x00cc5,
    0x00cc6, 0x00cc9,
    0x00cca, 0x00cce,
    0x00cd5, 0x00cd7,
    0x00cde, 0x00cdf,
    0x00ce0, 0x00ce4,
    0x00ce6, 0x00cf0,
    0x00cf1, 0x00cf3,
]);

immutable(CodepointSet) unicodeInPhonetic_Extensions = CodepointSet([
    0x01d00, 0x01d80,
]);

immutable(CodepointSet) unicodeInEgyptian_Hieroglyphs = CodepointSet([
    0x13000, 0x13430,
]);

immutable(CodepointSet) unicodeTelugu = CodepointSet([
    0x00c01, 0x00c04,
    0x00c05, 0x00c0d,
    0x00c0e, 0x00c11,
    0x00c12, 0x00c29,
    0x00c2a, 0x00c34,
    0x00c35, 0x00c3a,
    0x00c3d, 0x00c45,
    0x00c46, 0x00c49,
    0x00c4a, 0x00c4e,
    0x00c55, 0x00c57,
    0x00c58, 0x00c5a,
    0x00c60, 0x00c64,
    0x00c66, 0x00c70,
    0x00c78, 0x00c80,
]);

immutable(CodepointSet) unicodeInCombining_Diacritical_Marks = CodepointSet([
    0x00300, 0x00370,
]);

immutable(CodepointSet) unicodeCham = CodepointSet([
    0x0aa00, 0x0aa37,
    0x0aa40, 0x0aa4e,
    0x0aa50, 0x0aa5a,
    0x0aa5c, 0x0aa60,
]);

immutable(CodepointSet) unicodeInArabic_Supplement = CodepointSet([
    0x00750, 0x00780,
]);

immutable(CodepointSet) unicodeSk = CodepointSet([
    0x0005e, 0x0005f,
    0x00060, 0x00061,
    0x000a8, 0x000a9,
    0x000af, 0x000b0,
    0x000b4, 0x000b5,
    0x000b8, 0x000b9,
    0x002c2, 0x002c6,
    0x002d2, 0x002e0,
    0x002e5, 0x002ec,
    0x002ed, 0x002ee,
    0x002ef, 0x00300,
    0x00375, 0x00376,
    0x00384, 0x00386,
    0x01fbd, 0x01fbe,
    0x01fbf, 0x01fc2,
    0x01fcd, 0x01fd0,
    0x01fdd, 0x01fe0,
    0x01fed, 0x01ff0,
    0x01ffd, 0x01fff,
    0x0309b, 0x0309d,
    0x0a700, 0x0a717,
    0x0a720, 0x0a722,
    0x0a789, 0x0a78b,
    0x0fbb2, 0x0fbc2,
    0x0ff3e, 0x0ff3f,
    0x0ff40, 0x0ff41,
    0x0ffe3, 0x0ffe4,
]);

immutable(CodepointSet) unicodeImperial_Aramaic = CodepointSet([
    0x10840, 0x10856,
    0x10857, 0x10860,
]);

immutable(CodepointSet) unicodeSm = CodepointSet([
    0x0002b, 0x0002c,
    0x0003c, 0x0003f,
    0x0007c, 0x0007d,
    0x0007e, 0x0007f,
    0x000ac, 0x000ad,
    0x000b1, 0x000b2,
    0x000d7, 0x000d8,
    0x000f7, 0x000f8,
    0x003f6, 0x003f7,
    0x00606, 0x00609,
    0x02044, 0x02045,
    0x02052, 0x02053,
    0x0207a, 0x0207d,
    0x0208a, 0x0208d,
    0x02118, 0x02119,
    0x02140, 0x02145,
    0x0214b, 0x0214c,
    0x02190, 0x02195,
    0x0219a, 0x0219c,
    0x021a0, 0x021a1,
    0x021a3, 0x021a4,
    0x021a6, 0x021a7,
    0x021ae, 0x021af,
    0x021ce, 0x021d0,
    0x021d2, 0x021d3,
    0x021d4, 0x021d5,
    0x021f4, 0x02300,
    0x02308, 0x0230c,
    0x02320, 0x02322,
    0x0237c, 0x0237d,
    0x0239b, 0x023b4,
    0x023dc, 0x023e2,
    0x025b7, 0x025b8,
    0x025c1, 0x025c2,
    0x025f8, 0x02600,
    0x0266f, 0x02670,
    0x027c0, 0x027c5,
    0x027c7, 0x027cb,
    0x027cc, 0x027cd,
    0x027ce, 0x027e6,
    0x027f0, 0x02800,
    0x02900, 0x02983,
    0x02999, 0x029d8,
    0x029dc, 0x029fc,
    0x029fe, 0x02b00,
    0x02b30, 0x02b45,
    0x02b47, 0x02b4d,
    0x0fb29, 0x0fb2a,
    0x0fe62, 0x0fe63,
    0x0fe64, 0x0fe67,
    0x0ff0b, 0x0ff0c,
    0x0ff1c, 0x0ff1f,
    0x0ff5c, 0x0ff5d,
    0x0ff5e, 0x0ff5f,
    0x0ffe2, 0x0ffe3,
    0x0ffe9, 0x0ffed,
    0x1d6c1, 0x1d6c2,
    0x1d6db, 0x1d6dc,
    0x1d6fb, 0x1d6fc,
    0x1d715, 0x1d716,
    0x1d735, 0x1d736,
    0x1d74f, 0x1d750,
    0x1d76f, 0x1d770,
    0x1d789, 0x1d78a,
    0x1d7a9, 0x1d7aa,
    0x1d7c3, 0x1d7c4,
]);

immutable(CodepointSet) unicodeKharoshthi = CodepointSet([
    0x10a00, 0x10a04,
    0x10a05, 0x10a07,
    0x10a0c, 0x10a14,
    0x10a15, 0x10a18,
    0x10a19, 0x10a34,
    0x10a38, 0x10a3b,
    0x10a3f, 0x10a48,
    0x10a50, 0x10a59,
]);

immutable(CodepointSet) unicodeInLycian = CodepointSet([
    0x10280, 0x102a0,
]);

immutable(CodepointSet) unicodeInCombining_Half_Marks = CodepointSet([
    0x0fe20, 0x0fe30,
]);

immutable(CodepointSet) unicodeSo = CodepointSet([
    0x000a6, 0x000a8,
    0x000a9, 0x000aa,
    0x000ae, 0x000af,
    0x000b0, 0x000b1,
    0x000b6, 0x000b7,
    0x00482, 0x00483,
    0x0060e, 0x00610,
    0x006de, 0x006df,
    0x006e9, 0x006ea,
    0x006fd, 0x006ff,
    0x007f6, 0x007f7,
    0x009fa, 0x009fb,
    0x00b70, 0x00b71,
    0x00bf3, 0x00bf9,
    0x00bfa, 0x00bfb,
    0x00c7f, 0x00c80,
    0x00d79, 0x00d7a,
    0x00f01, 0x00f04,
    0x00f13, 0x00f18,
    0x00f1a, 0x00f20,
    0x00f34, 0x00f35,
    0x00f36, 0x00f37,
    0x00f38, 0x00f39,
    0x00fbe, 0x00fc6,
    0x00fc7, 0x00fcd,
    0x00fce, 0x00fd0,
    0x00fd5, 0x00fd9,
    0x0109e, 0x010a0,
    0x01360, 0x01361,
    0x01390, 0x0139a,
    0x01940, 0x01941,
    0x019de, 0x01a00,
    0x01b61, 0x01b6b,
    0x01b74, 0x01b7d,
    0x02100, 0x02102,
    0x02103, 0x02107,
    0x02108, 0x0210a,
    0x02114, 0x02115,
    0x02116, 0x02118,
    0x0211e, 0x02124,
    0x02125, 0x02126,
    0x02127, 0x02128,
    0x02129, 0x0212a,
    0x0212e, 0x0212f,
    0x0213a, 0x0213c,
    0x0214a, 0x0214b,
    0x0214c, 0x0214e,
    0x0214f, 0x02150,
    0x02195, 0x0219a,
    0x0219c, 0x021a0,
    0x021a1, 0x021a3,
    0x021a4, 0x021a6,
    0x021a7, 0x021ae,
    0x021af, 0x021ce,
    0x021d0, 0x021d2,
    0x021d3, 0x021d4,
    0x021d5, 0x021f4,
    0x02300, 0x02308,
    0x0230c, 0x02320,
    0x02322, 0x02329,
    0x0232b, 0x0237c,
    0x0237d, 0x0239b,
    0x023b4, 0x023dc,
    0x023e2, 0x023f4,
    0x02400, 0x02427,
    0x02440, 0x0244b,
    0x0249c, 0x024ea,
    0x02500, 0x025b7,
    0x025b8, 0x025c1,
    0x025c2, 0x025f8,
    0x02600, 0x0266f,
    0x02670, 0x02700,
    0x02701, 0x02768,
    0x02794, 0x027c0,
    0x02800, 0x02900,
    0x02b00, 0x02b30,
    0x02b45, 0x02b47,
    0x02b50, 0x02b5a,
    0x02ce5, 0x02ceb,
    0x02e80, 0x02e9a,
    0x02e9b, 0x02ef4,
    0x02f00, 0x02fd6,
    0x02ff0, 0x02ffc,
    0x03004, 0x03005,
    0x03012, 0x03014,
    0x03020, 0x03021,
    0x03036, 0x03038,
    0x0303e, 0x03040,
    0x03190, 0x03192,
    0x03196, 0x031a0,
    0x031c0, 0x031e4,
    0x03200, 0x0321f,
    0x0322a, 0x03251,
    0x03260, 0x03280,
    0x0328a, 0x032b1,
    0x032c0, 0x032ff,
    0x03300, 0x03400,
    0x04dc0, 0x04e00,
    0x0a490, 0x0a4c7,
    0x0a828, 0x0a82c,
    0x0a836, 0x0a838,
    0x0a839, 0x0a83a,
    0x0aa77, 0x0aa7a,
    0x0fdfd, 0x0fdfe,
    0x0ffe4, 0x0ffe5,
    0x0ffe8, 0x0ffe9,
    0x0ffed, 0x0ffef,
    0x0fffc, 0x0fffe,
    0x10102, 0x10103,
    0x10137, 0x10140,
    0x10179, 0x1018a,
    0x10190, 0x1019c,
    0x101d0, 0x101fd,
    0x1d000, 0x1d0f6,
    0x1d100, 0x1d127,
    0x1d129, 0x1d165,
    0x1d16a, 0x1d16d,
    0x1d183, 0x1d185,
    0x1d18c, 0x1d1aa,
    0x1d1ae, 0x1d1de,
    0x1d200, 0x1d242,
    0x1d245, 0x1d246,
    0x1d300, 0x1d357,
    0x1f000, 0x1f02c,
    0x1f030, 0x1f094,
    0x1f0a0, 0x1f0af,
    0x1f0b1, 0x1f0bf,
    0x1f0c1, 0x1f0d0,
    0x1f0d1, 0x1f0e0,
    0x1f110, 0x1f12f,
    0x1f130, 0x1f16a,
    0x1f170, 0x1f19b,
    0x1f1e6, 0x1f203,
    0x1f210, 0x1f23b,
    0x1f240, 0x1f249,
    0x1f250, 0x1f252,
    0x1f300, 0x1f321,
    0x1f330, 0x1f336,
    0x1f337, 0x1f37d,
    0x1f380, 0x1f394,
    0x1f3a0, 0x1f3c5,
    0x1f3c6, 0x1f3cb,
    0x1f3e0, 0x1f3f1,
    0x1f400, 0x1f43f,
    0x1f440, 0x1f441,
    0x1f442, 0x1f4f8,
    0x1f4f9, 0x1f4fd,
    0x1f500, 0x1f53e,
    0x1f550, 0x1f568,
    0x1f5fb, 0x1f600,
    0x1f601, 0x1f611,
    0x1f612, 0x1f615,
    0x1f616, 0x1f617,
    0x1f618, 0x1f619,
    0x1f61a, 0x1f61b,
    0x1f61c, 0x1f61f,
    0x1f620, 0x1f626,
    0x1f628, 0x1f62c,
    0x1f62d, 0x1f62e,
    0x1f630, 0x1f634,
    0x1f635, 0x1f641,
    0x1f645, 0x1f650,
    0x1f680, 0x1f6c6,
    0x1f700, 0x1f774,
]);

immutable(CodepointSet) unicodeInEnclosed_Alphanumeric_Supplement = CodepointSet([
    0x1f100, 0x1f200,
]);

immutable(CodepointSet) unicodeInTai_Le = CodepointSet([
    0x01950, 0x01980,
]);

immutable(CodepointSet) unicodeInMandaic = CodepointSet([
    0x00840, 0x00860,
]);

immutable(CodepointSet) unicodeInLepcha = CodepointSet([
    0x01c00, 0x01c50,
]);

immutable(CodepointSet) unicodeCanadian_Aboriginal = CodepointSet([
    0x01400, 0x01680,
    0x018b0, 0x018f6,
]);

immutable(CodepointSet) unicodeInGreek_Extended = CodepointSet([
    0x01f00, 0x02000,
]);

immutable(CodepointSet) unicodeInCJK_Unified_Ideographs = CodepointSet([
    0x04e00, 0x0a000,
]);

immutable(CodepointSet) unicodeIDS_Trinary_Operator = CodepointSet([
    0x02ff2, 0x02ff4,
]);

immutable(CodepointSet) unicodeInMiscellaneous_Symbols = CodepointSet([
    0x02600, 0x02700,
]);

immutable(CodepointSet) unicodeLao = CodepointSet([
    0x00e81, 0x00e83,
    0x00e84, 0x00e85,
    0x00e87, 0x00e89,
    0x00e8a, 0x00e8b,
    0x00e8d, 0x00e8e,
    0x00e94, 0x00e98,
    0x00e99, 0x00ea0,
    0x00ea1, 0x00ea4,
    0x00ea5, 0x00ea6,
    0x00ea7, 0x00ea8,
    0x00eaa, 0x00eac,
    0x00ead, 0x00eba,
    0x00ebb, 0x00ebe,
    0x00ec0, 0x00ec5,
    0x00ec6, 0x00ec7,
    0x00ec8, 0x00ece,
    0x00ed0, 0x00eda,
    0x00edc, 0x00ede,
]);

immutable(CodepointSet) unicodeInLatin_Extended_Additional = CodepointSet([
    0x01e00, 0x01f00,
]);

immutable(CodepointSet) unicodeRadical = CodepointSet([
    0x02e80, 0x02e9a,
    0x02e9b, 0x02ef4,
    0x02f00, 0x02fd6,
]);

immutable(CodepointSet) unicodeMongolian = CodepointSet([
    0x01800, 0x01802,
    0x01804, 0x01805,
    0x01806, 0x0180f,
    0x01810, 0x0181a,
    0x01820, 0x01878,
    0x01880, 0x018ab,
]);

immutable(CodepointSet) unicodeInVai = CodepointSet([
    0x0a500, 0x0a640,
]);

immutable(CodepointSet) unicodeBengali = CodepointSet([
    0x00981, 0x00984,
    0x00985, 0x0098d,
    0x0098f, 0x00991,
    0x00993, 0x009a9,
    0x009aa, 0x009b1,
    0x009b2, 0x009b3,
    0x009b6, 0x009ba,
    0x009bc, 0x009c5,
    0x009c7, 0x009c9,
    0x009cb, 0x009cf,
    0x009d7, 0x009d8,
    0x009dc, 0x009de,
    0x009df, 0x009e4,
    0x009e6, 0x009fc,
]);

immutable(CodepointSet) unicodeLatin = CodepointSet([
    0x00041, 0x0005b,
    0x00061, 0x0007b,
    0x000aa, 0x000ab,
    0x000ba, 0x000bb,
    0x000c0, 0x000d7,
    0x000d8, 0x000f7,
    0x000f8, 0x002b9,
    0x002e0, 0x002e5,
    0x01d00, 0x01d26,
    0x01d2c, 0x01d5d,
    0x01d62, 0x01d66,
    0x01d6b, 0x01d78,
    0x01d79, 0x01dbf,
    0x01e00, 0x01f00,
    0x02071, 0x02072,
    0x0207f, 0x02080,
    0x02090, 0x0209d,
    0x0212a, 0x0212c,
    0x02132, 0x02133,
    0x0214e, 0x0214f,
    0x02160, 0x02189,
    0x02c60, 0x02c80,
    0x0a722, 0x0a788,
    0x0a78b, 0x0a78f,
    0x0a790, 0x0a792,
    0x0a7a0, 0x0a7aa,
    0x0a7fa, 0x0a800,
    0x0fb00, 0x0fb07,
    0x0ff21, 0x0ff3b,
    0x0ff41, 0x0ff5b,
]);

immutable(CodepointSet) unicodeTagalog = CodepointSet([
    0x01700, 0x0170d,
    0x0170e, 0x01715,
]);

immutable(CodepointSet) unicodeRejang = CodepointSet([
    0x0a930, 0x0a954,
    0x0a95f, 0x0a960,
]);

immutable(CodepointSet) unicodeInCombining_Diacritical_Marks_for_Symbols = CodepointSet([
    0x020d0, 0x02100,
]);

immutable(CodepointSet) unicodeInSupplemental_Mathematical_Operators = CodepointSet([
    0x02a00, 0x02b00,
]);

immutable(CodepointSet) unicodeInCham = CodepointSet([
    0x0aa00, 0x0aa60,
]);

immutable(CodepointSet) unicodeAvestan = CodepointSet([
    0x10b00, 0x10b36,
    0x10b39, 0x10b40,
]);

immutable(CodepointSet) unicodeInMiscellaneous_Mathematical_Symbols_A = CodepointSet([
    0x027c0, 0x027f0,
]);

immutable(CodepointSet) unicodeInMiscellaneous_Mathematical_Symbols_B = CodepointSet([
    0x02980, 0x02a00,
]);

immutable(CodepointSet) unicodeInTelugu = CodepointSet([
    0x00c00, 0x00c80,
]);

immutable(CodepointSet) unicodeLimbu = CodepointSet([
    0x01900, 0x0191d,
    0x01920, 0x0192c,
    0x01930, 0x0193c,
    0x01940, 0x01941,
    0x01944, 0x01950,
]);

immutable(CodepointSet) unicodeInGeneral_Punctuation = CodepointSet([
    0x02000, 0x02070,
]);

immutable(CodepointSet) unicodeUnified_Ideograph = CodepointSet([
    0x03400, 0x04db6,
    0x04e00, 0x09fcc,
    0x0fa0e, 0x0fa10,
    0x0fa11, 0x0fa12,
    0x0fa13, 0x0fa15,
    0x0fa1f, 0x0fa20,
    0x0fa21, 0x0fa22,
    0x0fa23, 0x0fa25,
    0x0fa27, 0x0fa2a,
    0x20000, 0x2a6d7,
    0x2a700, 0x2b735,
    0x2b740, 0x2b81e,
]);

immutable(CodepointSet) unicodeInPhoenician = CodepointSet([
    0x10900, 0x10920,
]);

immutable(CodepointSet) unicodeOld_South_Arabian = CodepointSet([
    0x10a60, 0x10a80,
]);

immutable(CodepointSet) unicodeInBuhid = CodepointSet([
    0x01740, 0x01760,
]);

immutable(CodepointSet) unicodeKhmer = CodepointSet([
    0x01780, 0x017de,
    0x017e0, 0x017ea,
    0x017f0, 0x017fa,
    0x019e0, 0x01a00,
]);

immutable(CodepointSet) unicodeInLatin_Extended_A = CodepointSet([
    0x00100, 0x00180,
]);

immutable(CodepointSet) unicodeInLatin_Extended_B = CodepointSet([
    0x00180, 0x00250,
]);

immutable(CodepointSet) unicodeInLatin_Extended_C = CodepointSet([
    0x02c60, 0x02c80,
]);

immutable(CodepointSet) unicodeInLatin_Extended_D = CodepointSet([
    0x0a720, 0x0a800,
]);

immutable(CodepointSet) unicodeGurmukhi = CodepointSet([
    0x00a01, 0x00a04,
    0x00a05, 0x00a0b,
    0x00a0f, 0x00a11,
    0x00a13, 0x00a29,
    0x00a2a, 0x00a31,
    0x00a32, 0x00a34,
    0x00a35, 0x00a37,
    0x00a38, 0x00a3a,
    0x00a3c, 0x00a3d,
    0x00a3e, 0x00a43,
    0x00a47, 0x00a49,
    0x00a4b, 0x00a4e,
    0x00a51, 0x00a52,
    0x00a59, 0x00a5d,
    0x00a5e, 0x00a5f,
    0x00a66, 0x00a76,
]);

immutable(CodepointSet) unicodeInOsmanya = CodepointSet([
    0x10480, 0x104b0,
]);

immutable(CodepointSet) unicodeInCJK_Compatibility = CodepointSet([
    0x03300, 0x03400,
]);

immutable(CodepointSet) unicodeOriya = CodepointSet([
    0x00b01, 0x00b04,
    0x00b05, 0x00b0d,
    0x00b0f, 0x00b11,
    0x00b13, 0x00b29,
    0x00b2a, 0x00b31,
    0x00b32, 0x00b34,
    0x00b35, 0x00b3a,
    0x00b3c, 0x00b45,
    0x00b47, 0x00b49,
    0x00b4b, 0x00b4e,
    0x00b56, 0x00b58,
    0x00b5c, 0x00b5e,
    0x00b5f, 0x00b64,
    0x00b66, 0x00b78,
]);

immutable(CodepointSet) unicodeBuginese = CodepointSet([
    0x01a00, 0x01a1c,
    0x01a1e, 0x01a20,
]);

immutable(CodepointSet) unicodeInGeorgian_Supplement = CodepointSet([
    0x02d00, 0x02d30,
]);

immutable(CodepointSet) unicodeInCJK_Strokes = CodepointSet([
    0x031c0, 0x031f0,
]);

immutable(CodepointSet) unicodeVai = CodepointSet([
    0x0a500, 0x0a62c,
]);

immutable(CodepointSet) unicodeHangul = CodepointSet([
    0x01100, 0x01200,
    0x0302e, 0x03030,
    0x03131, 0x0318f,
    0x03200, 0x0321f,
    0x03260, 0x0327f,
    0x0a960, 0x0a97d,
    0x0ac00, 0x0d7a4,
    0x0d7b0, 0x0d7c7,
    0x0d7cb, 0x0d7fc,
    0x0ffa0, 0x0ffbf,
    0x0ffc2, 0x0ffc8,
    0x0ffca, 0x0ffd0,
    0x0ffd2, 0x0ffd8,
    0x0ffda, 0x0ffdd,
]);

immutable(CodepointSet) unicodeInRejang = CodepointSet([
    0x0a930, 0x0a960,
]);

immutable(CodepointSet) unicodeInMiscellaneous_Technical = CodepointSet([
    0x02300, 0x02400,
]);

immutable(CodepointSet) unicodeInTransport_And_Map_Symbols = CodepointSet([
    0x1f680, 0x1f700,
]);

immutable(CodepointSet) unicodeHyphen = CodepointSet([
    0x0002d, 0x0002e,
    0x000ad, 0x000ae,
    0x0058a, 0x0058b,
    0x01806, 0x01807,
    0x02010, 0x02012,
    0x02e17, 0x02e18,
    0x030fb, 0x030fc,
    0x0fe63, 0x0fe64,
    0x0ff0d, 0x0ff0e,
    0x0ff65, 0x0ff66,
]);

immutable(CodepointSet) unicodeThai = CodepointSet([
    0x00e01, 0x00e3b,
    0x00e40, 0x00e5c,
]);

immutable(CodepointSet) unicodeSundanese = CodepointSet([
    0x01b80, 0x01bab,
    0x01bae, 0x01bba,
]);

immutable(CodepointSet) unicodeInRunic = CodepointSet([
    0x016a0, 0x01700,
]);

immutable(CodepointSet) unicodeDiacritic = CodepointSet([
    0x0005e, 0x0005f,
    0x00060, 0x00061,
    0x000a8, 0x000a9,
    0x000af, 0x000b0,
    0x000b4, 0x000b5,
    0x000b7, 0x000b9,
    0x002b0, 0x0034f,
    0x00350, 0x00358,
    0x0035d, 0x00363,
    0x00374, 0x00376,
    0x0037a, 0x0037b,
    0x00384, 0x00386,
    0x00483, 0x00488,
    0x00559, 0x0055a,
    0x00591, 0x005a2,
    0x005a3, 0x005be,
    0x005bf, 0x005c0,
    0x005c1, 0x005c3,
    0x005c4, 0x005c5,
    0x0064b, 0x00653,
    0x00657, 0x00659,
    0x006df, 0x006e1,
    0x006e5, 0x006e7,
    0x006ea, 0x006ed,
    0x00730, 0x0074b,
    0x007a6, 0x007b1,
    0x007eb, 0x007f6,
    0x00818, 0x0081a,
    0x0093c, 0x0093d,
    0x0094d, 0x0094e,
    0x00951, 0x00955,
    0x00971, 0x00972,
    0x009bc, 0x009bd,
    0x009cd, 0x009ce,
    0x00a3c, 0x00a3d,
    0x00a4d, 0x00a4e,
    0x00abc, 0x00abd,
    0x00acd, 0x00ace,
    0x00b3c, 0x00b3d,
    0x00b4d, 0x00b4e,
    0x00bcd, 0x00bce,
    0x00c4d, 0x00c4e,
    0x00cbc, 0x00cbd,
    0x00ccd, 0x00cce,
    0x00d4d, 0x00d4e,
    0x00dca, 0x00dcb,
    0x00e47, 0x00e4d,
    0x00e4e, 0x00e4f,
    0x00ec8, 0x00ecd,
    0x00f18, 0x00f1a,
    0x00f35, 0x00f36,
    0x00f37, 0x00f38,
    0x00f39, 0x00f3a,
    0x00f3e, 0x00f40,
    0x00f82, 0x00f85,
    0x00f86, 0x00f88,
    0x00fc6, 0x00fc7,
    0x01037, 0x01038,
    0x01039, 0x0103b,
    0x01087, 0x0108e,
    0x0108f, 0x01090,
    0x0109a, 0x0109c,
    0x017c9, 0x017d4,
    0x017dd, 0x017de,
    0x01939, 0x0193c,
    0x01a75, 0x01a7d,
    0x01a7f, 0x01a80,
    0x01b34, 0x01b35,
    0x01b44, 0x01b45,
    0x01b6b, 0x01b74,
    0x01baa, 0x01bab,
    0x01c36, 0x01c38,
    0x01c78, 0x01c7e,
    0x01cd0, 0x01ce9,
    0x01ced, 0x01cee,
    0x01d2c, 0x01d6b,
    0x01dc4, 0x01dd0,
    0x01dfd, 0x01e00,
    0x01fbd, 0x01fbe,
    0x01fbf, 0x01fc2,
    0x01fcd, 0x01fd0,
    0x01fdd, 0x01fe0,
    0x01fed, 0x01ff0,
    0x01ffd, 0x01fff,
    0x02cef, 0x02cf2,
    0x02e2f, 0x02e30,
    0x0302a, 0x03030,
    0x03099, 0x0309d,
    0x030fc, 0x030fd,
    0x0a66f, 0x0a670,
    0x0a67c, 0x0a67e,
    0x0a67f, 0x0a680,
    0x0a6f0, 0x0a6f2,
    0x0a717, 0x0a722,
    0x0a788, 0x0a789,
    0x0a8c4, 0x0a8c5,
    0x0a8e0, 0x0a8f2,
    0x0a92b, 0x0a92f,
    0x0a953, 0x0a954,
    0x0a9b3, 0x0a9b4,
    0x0a9c0, 0x0a9c1,
    0x0aa7b, 0x0aa7c,
    0x0aabf, 0x0aac3,
    0x0abec, 0x0abee,
    0x0fb1e, 0x0fb1f,
    0x0fe20, 0x0fe27,
    0x0ff3e, 0x0ff3f,
    0x0ff40, 0x0ff41,
    0x0ff70, 0x0ff71,
    0x0ff9e, 0x0ffa0,
    0x0ffe3, 0x0ffe4,
    0x110b9, 0x110bb,
    0x1d167, 0x1d16a,
    0x1d16d, 0x1d173,
    0x1d17b, 0x1d183,
    0x1d185, 0x1d18c,
    0x1d1aa, 0x1d1ae,
]);

immutable(CodepointSet) unicodeYi = CodepointSet([
    0x0a000, 0x0a48d,
    0x0a490, 0x0a4c7,
]);

immutable(CodepointSet) unicodeInAlphabetic_Presentation_Forms = CodepointSet([
    0x0fb00, 0x0fb50,
]);

immutable(CodepointSet) unicodeExtender = CodepointSet([
    0x000b7, 0x000b8,
    0x002d0, 0x002d2,
    0x00640, 0x00641,
    0x007fa, 0x007fb,
    0x00e46, 0x00e47,
    0x00ec6, 0x00ec7,
    0x01843, 0x01844,
    0x01aa7, 0x01aa8,
    0x01c36, 0x01c37,
    0x01c7b, 0x01c7c,
    0x03005, 0x03006,
    0x03031, 0x03036,
    0x0309d, 0x0309f,
    0x030fc, 0x030ff,
    0x0a015, 0x0a016,
    0x0a60c, 0x0a60d,
    0x0a9cf, 0x0a9d0,
    0x0aa70, 0x0aa71,
    0x0aadd, 0x0aade,
    0x0ff70, 0x0ff71,
]);

immutable(CodepointSet) unicodeGlagolitic = CodepointSet([
    0x02c00, 0x02c2f,
    0x02c30, 0x02c5f,
]);

immutable(CodepointSet) unicodeInSuperscripts_and_Subscripts = CodepointSet([
    0x02070, 0x020a0,
]);

immutable(CodepointSet) unicodeInMalayalam = CodepointSet([
    0x00d00, 0x00d80,
]);

immutable(CodepointSet) unicodeJoin_Control = CodepointSet([
    0x0200c, 0x0200e,
]);

immutable(CodepointSet) unicodeInBatak = CodepointSet([
    0x01bc0, 0x01c00,
]);

immutable(CodepointSet) unicodeThaana = CodepointSet([
    0x00780, 0x007b2,
]);

immutable(CodepointSet) unicodeSoft_Dotted = CodepointSet([
    0x00069, 0x0006b,
    0x0012f, 0x00130,
    0x00249, 0x0024a,
    0x00268, 0x00269,
    0x0029d, 0x0029e,
    0x002b2, 0x002b3,
    0x003f3, 0x003f4,
    0x00456, 0x00457,
    0x00458, 0x00459,
    0x01d62, 0x01d63,
    0x01d96, 0x01d97,
    0x01da4, 0x01da5,
    0x01da8, 0x01da9,
    0x01e2d, 0x01e2e,
    0x01ecb, 0x01ecc,
    0x02071, 0x02072,
    0x02148, 0x0214a,
    0x02c7c, 0x02c7d,
    0x1d422, 0x1d424,
    0x1d456, 0x1d458,
    0x1d48a, 0x1d48c,
    0x1d4be, 0x1d4c0,
    0x1d4f2, 0x1d4f4,
    0x1d526, 0x1d528,
    0x1d55a, 0x1d55c,
    0x1d58e, 0x1d590,
    0x1d5c2, 0x1d5c4,
    0x1d5f6, 0x1d5f8,
    0x1d62a, 0x1d62c,
    0x1d65e, 0x1d660,
    0x1d692, 0x1d694,
]);

immutable(CodepointSet) unicodeBraille = CodepointSet([
    0x02800, 0x02900,
]);

immutable(CodepointSet) unicodeInGurmukhi = CodepointSet([
    0x00a00, 0x00a80,
]);

immutable(CodepointSet) unicodeMandaic = CodepointSet([
    0x00840, 0x0085c,
    0x0085e, 0x0085f,
]);

immutable(CodepointSet) unicodeInUnified_Canadian_Aboriginal_Syllabics = CodepointSet([
    0x01400, 0x01680,
]);

immutable(CodepointSet) unicodeInDingbats = CodepointSet([
    0x02700, 0x027c0,
]);

immutable(CodepointSet) unicodeZl = CodepointSet([
    0x02028, 0x02029,
]);

immutable(CodepointSet) unicodeInMusical_Symbols = CodepointSet([
    0x1d100, 0x1d200,
]);

immutable(CodepointSet) unicodeInBuginese = CodepointSet([
    0x01a00, 0x01a20,
]);

immutable(CodepointSet) unicodeInSaurashtra = CodepointSet([
    0x0a880, 0x0a8e0,
]);

immutable(CodepointSet) unicodeInCJK_Symbols_and_Punctuation = CodepointSet([
    0x03000, 0x03040,
]);

immutable(CodepointSet) unicodeInKangxi_Radicals = CodepointSet([
    0x02f00, 0x02fe0,
]);

immutable(CodepointSet) unicodeZp = CodepointSet([
    0x02029, 0x0202a,
]);

immutable(CodepointSet) unicodeHex_Digit = CodepointSet([
    0x00030, 0x0003a,
    0x00041, 0x00047,
    0x00061, 0x00067,
    0x0ff10, 0x0ff1a,
    0x0ff21, 0x0ff27,
    0x0ff41, 0x0ff47,
]);

immutable(CodepointSet) unicodeZs = CodepointSet([
    0x00020, 0x00021,
    0x000a0, 0x000a1,
    0x01680, 0x01681,
    0x0180e, 0x0180f,
    0x02000, 0x0200b,
    0x0202f, 0x02030,
    0x0205f, 0x02060,
    0x03000, 0x03001,
]);

immutable(CodepointSet) unicodeInThai = CodepointSet([
    0x00e00, 0x00e80,
]);

immutable(CodepointSet) unicodeDevanagari = CodepointSet([
    0x00900, 0x00951,
    0x00953, 0x00964,
    0x00966, 0x00970,
    0x00971, 0x00978,
    0x00979, 0x00980,
    0x0a8e0, 0x0a8fc,
]);

immutable(CodepointSet) unicodeInArrows = CodepointSet([
    0x02190, 0x02200,
]);

immutable(CodepointSet) unicodeEthiopic = CodepointSet([
    0x01200, 0x01249,
    0x0124a, 0x0124e,
    0x01250, 0x01257,
    0x01258, 0x01259,
    0x0125a, 0x0125e,
    0x01260, 0x01289,
    0x0128a, 0x0128e,
    0x01290, 0x012b1,
    0x012b2, 0x012b6,
    0x012b8, 0x012bf,
    0x012c0, 0x012c1,
    0x012c2, 0x012c6,
    0x012c8, 0x012d7,
    0x012d8, 0x01311,
    0x01312, 0x01316,
    0x01318, 0x0135b,
    0x0135d, 0x0137d,
    0x01380, 0x0139a,
    0x02d80, 0x02d97,
    0x02da0, 0x02da7,
    0x02da8, 0x02daf,
    0x02db0, 0x02db7,
    0x02db8, 0x02dbf,
    0x02dc0, 0x02dc7,
    0x02dc8, 0x02dcf,
    0x02dd0, 0x02dd7,
    0x02dd8, 0x02ddf,
    0x0ab01, 0x0ab07,
    0x0ab09, 0x0ab0f,
    0x0ab11, 0x0ab17,
    0x0ab20, 0x0ab27,
    0x0ab28, 0x0ab2f,
]);

immutable(CodepointSet) unicodeInCurrency_Symbols = CodepointSet([
    0x020a0, 0x020d0,
]);

immutable(CodepointSet) unicodeInOld_Persian = CodepointSet([
    0x103a0, 0x103e0,
]);

immutable(CodepointSet) unicodeInRumi_Numeral_Symbols = CodepointSet([
    0x10e60, 0x10e80,
]);

immutable(CodepointSet) unicodeInTags = CodepointSet([
    0xe0000, 0xe0080,
]);

immutable(CodepointSet) unicodeGreek = CodepointSet([
    0x00370, 0x00374,
    0x00375, 0x00378,
    0x0037a, 0x0037e,
    0x00384, 0x00385,
    0x00386, 0x00387,
    0x00388, 0x0038b,
    0x0038c, 0x0038d,
    0x0038e, 0x003a2,
    0x003a3, 0x003e2,
    0x003f0, 0x00400,
    0x01d26, 0x01d2b,
    0x01d5d, 0x01d62,
    0x01d66, 0x01d6b,
    0x01dbf, 0x01dc0,
    0x01f00, 0x01f16,
    0x01f18, 0x01f1e,
    0x01f20, 0x01f46,
    0x01f48, 0x01f4e,
    0x01f50, 0x01f58,
    0x01f59, 0x01f5a,
    0x01f5b, 0x01f5c,
    0x01f5d, 0x01f5e,
    0x01f5f, 0x01f7e,
    0x01f80, 0x01fb5,
    0x01fb6, 0x01fc5,
    0x01fc6, 0x01fd4,
    0x01fd6, 0x01fdc,
    0x01fdd, 0x01ff0,
    0x01ff2, 0x01ff5,
    0x01ff6, 0x01fff,
    0x02126, 0x02127,
    0x10140, 0x1018b,
    0x1d200, 0x1d246,
]);

immutable(CodepointSet) unicodeOl_Chiki = CodepointSet([
    0x01c50, 0x01c80,
]);

immutable(CodepointSet) unicodeTagbanwa = CodepointSet([
    0x01760, 0x0176d,
    0x0176e, 0x01771,
    0x01772, 0x01774,
]);

immutable(CodepointSet) unicodeOther_Uppercase = CodepointSet([
    0x02160, 0x02170,
    0x024b6, 0x024d0,
]);

immutable(CodepointSet) unicodeInOgham = CodepointSet([
    0x01680, 0x016a0,
]);

immutable(CodepointSet) unicodeInThaana = CodepointSet([
    0x00780, 0x007c0,
]);

immutable(CodepointSet) unicodeInEnclosed_Ideographic_Supplement = CodepointSet([
    0x1f200, 0x1f300,
]);

immutable(CodepointSet) unicodeInKhmer_Symbols = CodepointSet([
    0x019e0, 0x01a00,
]);

immutable(CodepointSet) unicodeCommon = CodepointSet([
    0x00000, 0x00041,
    0x0005b, 0x00061,
    0x0007b, 0x000aa,
    0x000ab, 0x000ba,
    0x000bb, 0x000c0,
    0x000d7, 0x000d8,
    0x000f7, 0x000f8,
    0x002b9, 0x002e0,
    0x002e5, 0x002ea,
    0x002ec, 0x00300,
    0x00374, 0x00375,
    0x0037e, 0x0037f,
    0x00385, 0x00386,
    0x00387, 0x00388,
    0x00589, 0x0058a,
    0x0060c, 0x0060d,
    0x0061b, 0x0061c,
    0x0061f, 0x00620,
    0x00640, 0x00641,
    0x00660, 0x0066a,
    0x006dd, 0x006de,
    0x00964, 0x00966,
    0x00970, 0x00971,
    0x00e3f, 0x00e40,
    0x00fd5, 0x00fd9,
    0x010fb, 0x010fc,
    0x016eb, 0x016ee,
    0x01735, 0x01737,
    0x01802, 0x01804,
    0x01805, 0x01806,
    0x01cd3, 0x01cd4,
    0x01ce1, 0x01ce2,
    0x01ce9, 0x01ced,
    0x01cee, 0x01cf3,
    0x02000, 0x0200c,
    0x0200e, 0x02065,
    0x0206a, 0x02071,
    0x02074, 0x0207f,
    0x02080, 0x0208f,
    0x020a0, 0x020ba,
    0x02100, 0x02126,
    0x02127, 0x0212a,
    0x0212c, 0x02132,
    0x02133, 0x0214e,
    0x0214f, 0x02160,
    0x02189, 0x0218a,
    0x02190, 0x023f4,
    0x02400, 0x02427,
    0x02440, 0x0244b,
    0x02460, 0x02700,
    0x02701, 0x027cb,
    0x027cc, 0x027cd,
    0x027ce, 0x02800,
    0x02900, 0x02b4d,
    0x02b50, 0x02b5a,
    0x02e00, 0x02e32,
    0x02ff0, 0x02ffc,
    0x03000, 0x03005,
    0x03006, 0x03007,
    0x03008, 0x03021,
    0x03030, 0x03038,
    0x0303c, 0x03040,
    0x0309b, 0x0309d,
    0x030a0, 0x030a1,
    0x030fb, 0x030fd,
    0x03190, 0x031a0,
    0x031c0, 0x031e4,
    0x03220, 0x03260,
    0x0327f, 0x032d0,
    0x03358, 0x03400,
    0x04dc0, 0x04e00,
    0x0a700, 0x0a722,
    0x0a788, 0x0a78b,
    0x0a830, 0x0a83a,
    0x0fd3e, 0x0fd40,
    0x0fdfd, 0x0fdfe,
    0x0fe10, 0x0fe1a,
    0x0fe30, 0x0fe53,
    0x0fe54, 0x0fe67,
    0x0fe68, 0x0fe6c,
    0x0feff, 0x0ff00,
    0x0ff01, 0x0ff21,
    0x0ff3b, 0x0ff41,
    0x0ff5b, 0x0ff66,
    0x0ff70, 0x0ff71,
    0x0ff9e, 0x0ffa0,
    0x0ffe0, 0x0ffe7,
    0x0ffe8, 0x0ffef,
    0x0fff9, 0x0fffe,
    0x10100, 0x10103,
    0x10107, 0x10134,
    0x10137, 0x10140,
    0x10190, 0x1019c,
    0x101d0, 0x101fd,
    0x1d000, 0x1d0f6,
    0x1d100, 0x1d127,
    0x1d129, 0x1d167,
    0x1d16a, 0x1d17b,
    0x1d183, 0x1d185,
    0x1d18c, 0x1d1aa,
    0x1d1ae, 0x1d1de,
    0x1d300, 0x1d357,
    0x1d360, 0x1d372,
    0x1d400, 0x1d455,
    0x1d456, 0x1d49d,
    0x1d49e, 0x1d4a0,
    0x1d4a2, 0x1d4a3,
    0x1d4a5, 0x1d4a7,
    0x1d4a9, 0x1d4ad,
    0x1d4ae, 0x1d4ba,
    0x1d4bb, 0x1d4bc,
    0x1d4bd, 0x1d4c4,
    0x1d4c5, 0x1d506,
    0x1d507, 0x1d50b,
    0x1d50d, 0x1d515,
    0x1d516, 0x1d51d,
    0x1d51e, 0x1d53a,
    0x1d53b, 0x1d53f,
    0x1d540, 0x1d545,
    0x1d546, 0x1d547,
    0x1d54a, 0x1d551,
    0x1d552, 0x1d6a6,
    0x1d6a8, 0x1d7cc,
    0x1d7ce, 0x1d800,
    0x1f000, 0x1f02c,
    0x1f030, 0x1f094,
    0x1f0a0, 0x1f0af,
    0x1f0b1, 0x1f0bf,
    0x1f0c1, 0x1f0d0,
    0x1f0d1, 0x1f0e0,
    0x1f100, 0x1f10b,
    0x1f110, 0x1f12f,
    0x1f130, 0x1f16a,
    0x1f170, 0x1f19b,
    0x1f1e6, 0x1f200,
    0x1f201, 0x1f203,
    0x1f210, 0x1f23b,
    0x1f240, 0x1f249,
    0x1f250, 0x1f252,
    0x1f300, 0x1f321,
    0x1f330, 0x1f336,
    0x1f337, 0x1f37d,
    0x1f380, 0x1f394,
    0x1f3a0, 0x1f3c5,
    0x1f3c6, 0x1f3cb,
    0x1f3e0, 0x1f3f1,
    0x1f400, 0x1f43f,
    0x1f440, 0x1f441,
    0x1f442, 0x1f4f8,
    0x1f4f9, 0x1f4fd,
    0x1f500, 0x1f53e,
    0x1f550, 0x1f568,
    0x1f5fb, 0x1f600,
    0x1f601, 0x1f611,
    0x1f612, 0x1f615,
    0x1f616, 0x1f617,
    0x1f618, 0x1f619,
    0x1f61a, 0x1f61b,
    0x1f61c, 0x1f61f,
    0x1f620, 0x1f626,
    0x1f628, 0x1f62c,
    0x1f62d, 0x1f62e,
    0x1f630, 0x1f634,
    0x1f635, 0x1f641,
    0x1f645, 0x1f650,
    0x1f680, 0x1f6c6,
    0x1f700, 0x1f774,
    0xe0001, 0xe0002,
    0xe0020, 0xe0080,
]);

immutable(CodepointSet) unicodeInCommon_Indic_Number_Forms = CodepointSet([
    0x0a830, 0x0a840,
]);

immutable(CodepointSet) unicodeInSmall_Form_Variants = CodepointSet([
    0x0fe50, 0x0fe70,
]);

immutable(CodepointSet) unicodeIdeographic = CodepointSet([
    0x03006, 0x03008,
    0x03021, 0x0302a,
    0x03038, 0x0303b,
    0x03400, 0x04db6,
    0x04e00, 0x09fcc,
    0x0f900, 0x0fa2e,
    0x0fa30, 0x0fa6e,
    0x0fa70, 0x0fada,
    0x20000, 0x2a6d7,
    0x2a700, 0x2b735,
    0x2b740, 0x2b81e,
    0x2f800, 0x2fa1e,
]);

immutable(CodepointSet) unicodeGeorgian = CodepointSet([
    0x010a0, 0x010c6,
    0x010d0, 0x010fb,
    0x010fc, 0x010fd,
    0x02d00, 0x02d26,
]);

immutable(CodepointSet) unicodeOsmanya = CodepointSet([
    0x10480, 0x1049e,
    0x104a0, 0x104aa,
]);

immutable(CodepointSet) unicodeInEthiopic = CodepointSet([
    0x01200, 0x01380,
]);

immutable(CodepointSet) unicodeInEnclosed_Alphanumerics = CodepointSet([
    0x02460, 0x02500,
]);

immutable(CodepointSet) unicodeCuneiform = CodepointSet([
    0x12000, 0x1236f,
    0x12400, 0x12463,
    0x12470, 0x12474,
]);

immutable(CodepointSet) unicodeSyriac = CodepointSet([
    0x00700, 0x0070e,
    0x0070f, 0x0074b,
    0x0074d, 0x00750,
]);

immutable(CodepointSet) unicodeInVertical_Forms = CodepointSet([
    0x0fe10, 0x0fe20,
]);

immutable(CodepointSet) unicodeInTai_Xuan_Jing_Symbols = CodepointSet([
    0x1d300, 0x1d360,
]);

immutable(CodepointSet) unicodeNoncharacter_Code_Point = CodepointSet([
    0x0fdd0, 0x0fdf0,
    0x0fffe, 0x10000,
    0x1fffe, 0x20000,
    0x2fffe, 0x30000,
    0x3fffe, 0x40000,
    0x4fffe, 0x50000,
    0x5fffe, 0x60000,
    0x6fffe, 0x70000,
    0x7fffe, 0x80000,
    0x8fffe, 0x90000,
    0x9fffe, 0xa0000,
    0xafffe, 0xb0000,
    0xbfffe, 0xc0000,
    0xcfffe, 0xd0000,
    0xdfffe, 0xe0000,
    0xefffe, 0xf0000,
    0xffffe, 0x100000,
    0x10fffe, 0x110000,
]);

immutable(CodepointSet) unicodeInMiscellaneous_Symbols_and_Arrows = CodepointSet([
    0x02b00, 0x02c00,
]);

immutable(CodepointSet) unicodeInOld_Italic = CodepointSet([
    0x10300, 0x10330,
]);

immutable(CodepointSet) unicodeMeetei_Mayek = CodepointSet([
    0x0abc0, 0x0abee,
    0x0abf0, 0x0abfa,
]);

immutable(CodepointSet) unicodeOther_Grapheme_Extend = CodepointSet([
    0x009be, 0x009bf,
    0x009d7, 0x009d8,
    0x00b3e, 0x00b3f,
    0x00b57, 0x00b58,
    0x00bbe, 0x00bbf,
    0x00bd7, 0x00bd8,
    0x00cc2, 0x00cc3,
    0x00cd5, 0x00cd7,
    0x00d3e, 0x00d3f,
    0x00d57, 0x00d58,
    0x00dcf, 0x00dd0,
    0x00ddf, 0x00de0,
    0x0200c, 0x0200e,
    0x0ff9e, 0x0ffa0,
    0x1d165, 0x1d166,
    0x1d16e, 0x1d173,
]);

immutable(CodepointSet) unicodeOther_Math = CodepointSet([
    0x0005e, 0x0005f,
    0x003d0, 0x003d3,
    0x003d5, 0x003d6,
    0x003f0, 0x003f2,
    0x003f4, 0x003f6,
    0x02016, 0x02017,
    0x02032, 0x02035,
    0x02040, 0x02041,
    0x02061, 0x02065,
    0x0207d, 0x0207f,
    0x0208d, 0x0208f,
    0x020d0, 0x020dd,
    0x020e1, 0x020e2,
    0x020e5, 0x020e7,
    0x020eb, 0x020f0,
    0x02102, 0x02103,
    0x02107, 0x02108,
    0x0210a, 0x02114,
    0x02115, 0x02116,
    0x02119, 0x0211e,
    0x02124, 0x02125,
    0x02128, 0x0212a,
    0x0212c, 0x0212e,
    0x0212f, 0x02132,
    0x02133, 0x02139,
    0x0213c, 0x02140,
    0x02145, 0x0214a,
    0x02195, 0x0219a,
    0x0219c, 0x021a0,
    0x021a1, 0x021a3,
    0x021a4, 0x021a6,
    0x021a7, 0x021a8,
    0x021a9, 0x021ae,
    0x021b0, 0x021b2,
    0x021b6, 0x021b8,
    0x021bc, 0x021ce,
    0x021d0, 0x021d2,
    0x021d3, 0x021d4,
    0x021d5, 0x021dc,
    0x021dd, 0x021de,
    0x021e4, 0x021e6,
    0x023b4, 0x023b6,
    0x023b7, 0x023b8,
    0x023d0, 0x023d1,
    0x023e2, 0x023e3,
    0x025a0, 0x025a2,
    0x025ae, 0x025b7,
    0x025bc, 0x025c1,
    0x025c6, 0x025c8,
    0x025ca, 0x025cc,
    0x025cf, 0x025d4,
    0x025e2, 0x025e3,
    0x025e4, 0x025e5,
    0x025e7, 0x025ed,
    0x02605, 0x02607,
    0x02640, 0x02641,
    0x02642, 0x02643,
    0x02660, 0x02664,
    0x0266d, 0x0266f,
    0x027c5, 0x027c7,
    0x027e6, 0x027f0,
    0x02983, 0x02999,
    0x029d8, 0x029dc,
    0x029fc, 0x029fe,
    0x0fe61, 0x0fe62,
    0x0fe63, 0x0fe64,
    0x0fe68, 0x0fe69,
    0x0ff3c, 0x0ff3d,
    0x0ff3e, 0x0ff3f,
    0x1d400, 0x1d455,
    0x1d456, 0x1d49d,
    0x1d49e, 0x1d4a0,
    0x1d4a2, 0x1d4a3,
    0x1d4a5, 0x1d4a7,
    0x1d4a9, 0x1d4ad,
    0x1d4ae, 0x1d4ba,
    0x1d4bb, 0x1d4bc,
    0x1d4bd, 0x1d4c4,
    0x1d4c5, 0x1d506,
    0x1d507, 0x1d50b,
    0x1d50d, 0x1d515,
    0x1d516, 0x1d51d,
    0x1d51e, 0x1d53a,
    0x1d53b, 0x1d53f,
    0x1d540, 0x1d545,
    0x1d546, 0x1d547,
    0x1d54a, 0x1d551,
    0x1d552, 0x1d6a6,
    0x1d6a8, 0x1d6c1,
    0x1d6c2, 0x1d6db,
    0x1d6dc, 0x1d6fb,
    0x1d6fc, 0x1d715,
    0x1d716, 0x1d735,
    0x1d736, 0x1d74f,
    0x1d750, 0x1d76f,
    0x1d770, 0x1d789,
    0x1d78a, 0x1d7a9,
    0x1d7aa, 0x1d7c3,
    0x1d7c4, 0x1d7cc,
    0x1d7ce, 0x1d800,
]);

immutable(CodepointSet) unicodeGujarati = CodepointSet([
    0x00a81, 0x00a84,
    0x00a85, 0x00a8e,
    0x00a8f, 0x00a92,
    0x00a93, 0x00aa9,
    0x00aaa, 0x00ab1,
    0x00ab2, 0x00ab4,
    0x00ab5, 0x00aba,
    0x00abc, 0x00ac6,
    0x00ac7, 0x00aca,
    0x00acb, 0x00ace,
    0x00ad0, 0x00ad1,
    0x00ae0, 0x00ae4,
    0x00ae6, 0x00af0,
    0x00af1, 0x00af2,
]);

immutable(CodepointSet) unicodeInBox_Drawing = CodepointSet([
    0x02500, 0x02580,
]);

immutable(CodepointSet) unicodeInTagbanwa = CodepointSet([
    0x01760, 0x01780,
]);

immutable(CodepointSet) unicodeInHangul_Syllables = CodepointSet([
    0x0ac00, 0x0d7b0,
]);

immutable(CodepointSet) unicodeLydian = CodepointSet([
    0x10920, 0x1093a,
    0x1093f, 0x10940,
]);

immutable(CodepointSet) unicodeInKatakana_Phonetic_Extensions = CodepointSet([
    0x031f0, 0x03200,
]);

immutable(CodepointSet) unicodeInTai_Tham = CodepointSet([
    0x01a20, 0x01ab0,
]);

immutable(CodepointSet) unicodeInNumber_Forms = CodepointSet([
    0x02150, 0x02190,
]);

immutable(CodepointSet) unicodeInBopomofo_Extended = CodepointSet([
    0x031a0, 0x031c0,
]);

immutable(CodepointSet) unicodeInherited = CodepointSet([
    0x00300, 0x00370,
    0x00485, 0x00487,
    0x0064b, 0x00656,
    0x0065f, 0x00660,
    0x00670, 0x00671,
    0x00951, 0x00953,
    0x01cd0, 0x01cd3,
    0x01cd4, 0x01ce1,
    0x01ce2, 0x01ce9,
    0x01ced, 0x01cee,
    0x01dc0, 0x01de7,
    0x01dfc, 0x01e00,
    0x0200c, 0x0200e,
    0x020d0, 0x020f1,
    0x0302a, 0x0302e,
    0x03099, 0x0309b,
    0x0fe00, 0x0fe10,
    0x0fe20, 0x0fe27,
    0x101fd, 0x101fe,
    0x1d167, 0x1d16a,
    0x1d17b, 0x1d183,
    0x1d185, 0x1d18c,
    0x1d1aa, 0x1d1ae,
    0xe0100, 0xe01f0,
]);

immutable(CodepointSet) unicodeInLetterlike_Symbols = CodepointSet([
    0x02100, 0x02150,
]);

immutable(CodepointSet) unicodeBuhid = CodepointSet([
    0x01740, 0x01754,
]);

immutable(CodepointSet) unicodeInCypriot_Syllabary = CodepointSet([
    0x10800, 0x10840,
]);

immutable(CodepointSet) unicodeInSyloti_Nagri = CodepointSet([
    0x0a800, 0x0a830,
]);

immutable(CodepointSet) unicodeInSamaritan = CodepointSet([
    0x00800, 0x00840,
]);

immutable(CodepointSet) unicodeInGeorgian = CodepointSet([
    0x010a0, 0x01100,
]);

immutable(CodepointSet) unicodeAlphabetic = CodepointSet([
    0x00041, 0x0005b,
    0x00061, 0x0007b,
    0x000aa, 0x000ab,
    0x000b5, 0x000b6,
    0x000ba, 0x000bb,
    0x000c0, 0x000d7,
    0x000d8, 0x000f7,
    0x000f8, 0x002c2,
    0x002c6, 0x002d2,
    0x002e0, 0x002e5,
    0x002ec, 0x002ed,
    0x002ee, 0x002ef,
    0x00345, 0x00346,
    0x00370, 0x00375,
    0x00376, 0x00378,
    0x0037a, 0x0037e,
    0x00386, 0x00387,
    0x00388, 0x0038b,
    0x0038c, 0x0038d,
    0x0038e, 0x003a2,
    0x003a3, 0x003f6,
    0x003f7, 0x00482,
    0x0048a, 0x00528,
    0x00531, 0x00557,
    0x00559, 0x0055a,
    0x00561, 0x00588,
    0x005b0, 0x005be,
    0x005bf, 0x005c0,
    0x005c1, 0x005c3,
    0x005c4, 0x005c6,
    0x005c7, 0x005c8,
    0x005d0, 0x005eb,
    0x005f0, 0x005f3,
    0x00610, 0x0061b,
    0x00620, 0x00658,
    0x00659, 0x00660,
    0x0066e, 0x006d4,
    0x006d5, 0x006dd,
    0x006e1, 0x006e9,
    0x006ed, 0x006f0,
    0x006fa, 0x006fd,
    0x006ff, 0x00700,
    0x00710, 0x00740,
    0x0074d, 0x007b2,
    0x007ca, 0x007eb,
    0x007f4, 0x007f6,
    0x007fa, 0x007fb,
    0x00800, 0x00818,
    0x0081a, 0x0082d,
    0x00840, 0x00859,
    0x00900, 0x0093c,
    0x0093d, 0x0094d,
    0x0094e, 0x00951,
    0x00955, 0x00964,
    0x00971, 0x00978,
    0x00979, 0x00980,
    0x00981, 0x00984,
    0x00985, 0x0098d,
    0x0098f, 0x00991,
    0x00993, 0x009a9,
    0x009aa, 0x009b1,
    0x009b2, 0x009b3,
    0x009b6, 0x009ba,
    0x009bd, 0x009c5,
    0x009c7, 0x009c9,
    0x009cb, 0x009cd,
    0x009ce, 0x009cf,
    0x009d7, 0x009d8,
    0x009dc, 0x009de,
    0x009df, 0x009e4,
    0x009f0, 0x009f2,
    0x00a01, 0x00a04,
    0x00a05, 0x00a0b,
    0x00a0f, 0x00a11,
    0x00a13, 0x00a29,
    0x00a2a, 0x00a31,
    0x00a32, 0x00a34,
    0x00a35, 0x00a37,
    0x00a38, 0x00a3a,
    0x00a3e, 0x00a43,
    0x00a47, 0x00a49,
    0x00a4b, 0x00a4d,
    0x00a51, 0x00a52,
    0x00a59, 0x00a5d,
    0x00a5e, 0x00a5f,
    0x00a70, 0x00a76,
    0x00a81, 0x00a84,
    0x00a85, 0x00a8e,
    0x00a8f, 0x00a92,
    0x00a93, 0x00aa9,
    0x00aaa, 0x00ab1,
    0x00ab2, 0x00ab4,
    0x00ab5, 0x00aba,
    0x00abd, 0x00ac6,
    0x00ac7, 0x00aca,
    0x00acb, 0x00acd,
    0x00ad0, 0x00ad1,
    0x00ae0, 0x00ae4,
    0x00b01, 0x00b04,
    0x00b05, 0x00b0d,
    0x00b0f, 0x00b11,
    0x00b13, 0x00b29,
    0x00b2a, 0x00b31,
    0x00b32, 0x00b34,
    0x00b35, 0x00b3a,
    0x00b3d, 0x00b45,
    0x00b47, 0x00b49,
    0x00b4b, 0x00b4d,
    0x00b56, 0x00b58,
    0x00b5c, 0x00b5e,
    0x00b5f, 0x00b64,
    0x00b71, 0x00b72,
    0x00b82, 0x00b84,
    0x00b85, 0x00b8b,
    0x00b8e, 0x00b91,
    0x00b92, 0x00b96,
    0x00b99, 0x00b9b,
    0x00b9c, 0x00b9d,
    0x00b9e, 0x00ba0,
    0x00ba3, 0x00ba5,
    0x00ba8, 0x00bab,
    0x00bae, 0x00bba,
    0x00bbe, 0x00bc3,
    0x00bc6, 0x00bc9,
    0x00bca, 0x00bcd,
    0x00bd0, 0x00bd1,
    0x00bd7, 0x00bd8,
    0x00c01, 0x00c04,
    0x00c05, 0x00c0d,
    0x00c0e, 0x00c11,
    0x00c12, 0x00c29,
    0x00c2a, 0x00c34,
    0x00c35, 0x00c3a,
    0x00c3d, 0x00c45,
    0x00c46, 0x00c49,
    0x00c4a, 0x00c4d,
    0x00c55, 0x00c57,
    0x00c58, 0x00c5a,
    0x00c60, 0x00c64,
    0x00c82, 0x00c84,
    0x00c85, 0x00c8d,
    0x00c8e, 0x00c91,
    0x00c92, 0x00ca9,
    0x00caa, 0x00cb4,
    0x00cb5, 0x00cba,
    0x00cbd, 0x00cc5,
    0x00cc6, 0x00cc9,
    0x00cca, 0x00ccd,
    0x00cd5, 0x00cd7,
    0x00cde, 0x00cdf,
    0x00ce0, 0x00ce4,
    0x00cf1, 0x00cf3,
    0x00d02, 0x00d04,
    0x00d05, 0x00d0d,
    0x00d0e, 0x00d11,
    0x00d12, 0x00d3b,
    0x00d3d, 0x00d45,
    0x00d46, 0x00d49,
    0x00d4a, 0x00d4d,
    0x00d4e, 0x00d4f,
    0x00d57, 0x00d58,
    0x00d60, 0x00d64,
    0x00d7a, 0x00d80,
    0x00d82, 0x00d84,
    0x00d85, 0x00d97,
    0x00d9a, 0x00db2,
    0x00db3, 0x00dbc,
    0x00dbd, 0x00dbe,
    0x00dc0, 0x00dc7,
    0x00dcf, 0x00dd5,
    0x00dd6, 0x00dd7,
    0x00dd8, 0x00de0,
    0x00df2, 0x00df4,
    0x00e01, 0x00e3b,
    0x00e40, 0x00e47,
    0x00e4d, 0x00e4e,
    0x00e81, 0x00e83,
    0x00e84, 0x00e85,
    0x00e87, 0x00e89,
    0x00e8a, 0x00e8b,
    0x00e8d, 0x00e8e,
    0x00e94, 0x00e98,
    0x00e99, 0x00ea0,
    0x00ea1, 0x00ea4,
    0x00ea5, 0x00ea6,
    0x00ea7, 0x00ea8,
    0x00eaa, 0x00eac,
    0x00ead, 0x00eba,
    0x00ebb, 0x00ebe,
    0x00ec0, 0x00ec5,
    0x00ec6, 0x00ec7,
    0x00ecd, 0x00ece,
    0x00edc, 0x00ede,
    0x00f00, 0x00f01,
    0x00f40, 0x00f48,
    0x00f49, 0x00f6d,
    0x00f71, 0x00f82,
    0x00f88, 0x00f98,
    0x00f99, 0x00fbd,
    0x01000, 0x01037,
    0x01038, 0x01039,
    0x0103b, 0x01040,
    0x01050, 0x01063,
    0x01065, 0x01069,
    0x0106e, 0x01087,
    0x0108e, 0x0108f,
    0x0109c, 0x0109e,
    0x010a0, 0x010c6,
    0x010d0, 0x010fb,
    0x010fc, 0x010fd,
    0x01100, 0x01249,
    0x0124a, 0x0124e,
    0x01250, 0x01257,
    0x01258, 0x01259,
    0x0125a, 0x0125e,
    0x01260, 0x01289,
    0x0128a, 0x0128e,
    0x01290, 0x012b1,
    0x012b2, 0x012b6,
    0x012b8, 0x012bf,
    0x012c0, 0x012c1,
    0x012c2, 0x012c6,
    0x012c8, 0x012d7,
    0x012d8, 0x01311,
    0x01312, 0x01316,
    0x01318, 0x0135b,
    0x0135f, 0x01360,
    0x01380, 0x01390,
    0x013a0, 0x013f5,
    0x01401, 0x0166d,
    0x0166f, 0x01680,
    0x01681, 0x0169b,
    0x016a0, 0x016eb,
    0x016ee, 0x016f1,
    0x01700, 0x0170d,
    0x0170e, 0x01714,
    0x01720, 0x01734,
    0x01740, 0x01754,
    0x01760, 0x0176d,
    0x0176e, 0x01771,
    0x01772, 0x01774,
    0x01780, 0x017b4,
    0x017b6, 0x017c9,
    0x017d7, 0x017d8,
    0x017dc, 0x017dd,
    0x01820, 0x01878,
    0x01880, 0x018ab,
    0x018b0, 0x018f6,
    0x01900, 0x0191d,
    0x01920, 0x0192c,
    0x01930, 0x01939,
    0x01950, 0x0196e,
    0x01970, 0x01975,
    0x01980, 0x019ac,
    0x019b0, 0x019ca,
    0x01a00, 0x01a1c,
    0x01a20, 0x01a5f,
    0x01a61, 0x01a75,
    0x01aa7, 0x01aa8,
    0x01b00, 0x01b34,
    0x01b35, 0x01b44,
    0x01b45, 0x01b4c,
    0x01b80, 0x01baa,
    0x01bae, 0x01bb0,
    0x01bc0, 0x01be6,
    0x01be7, 0x01bf2,
    0x01c00, 0x01c36,
    0x01c4d, 0x01c50,
    0x01c5a, 0x01c7e,
    0x01ce9, 0x01ced,
    0x01cee, 0x01cf3,
    0x01d00, 0x01dc0,
    0x01e00, 0x01f16,
    0x01f18, 0x01f1e,
    0x01f20, 0x01f46,
    0x01f48, 0x01f4e,
    0x01f50, 0x01f58,
    0x01f59, 0x01f5a,
    0x01f5b, 0x01f5c,
    0x01f5d, 0x01f5e,
    0x01f5f, 0x01f7e,
    0x01f80, 0x01fb5,
    0x01fb6, 0x01fbd,
    0x01fbe, 0x01fbf,
    0x01fc2, 0x01fc5,
    0x01fc6, 0x01fcd,
    0x01fd0, 0x01fd4,
    0x01fd6, 0x01fdc,
    0x01fe0, 0x01fed,
    0x01ff2, 0x01ff5,
    0x01ff6, 0x01ffd,
    0x02071, 0x02072,
    0x0207f, 0x02080,
    0x02090, 0x0209d,
    0x02102, 0x02103,
    0x02107, 0x02108,
    0x0210a, 0x02114,
    0x02115, 0x02116,
    0x02119, 0x0211e,
    0x02124, 0x02125,
    0x02126, 0x02127,
    0x02128, 0x02129,
    0x0212a, 0x0212e,
    0x0212f, 0x0213a,
    0x0213c, 0x02140,
    0x02145, 0x0214a,
    0x0214e, 0x0214f,
    0x02160, 0x02189,
    0x024b6, 0x024ea,
    0x02c00, 0x02c2f,
    0x02c30, 0x02c5f,
    0x02c60, 0x02ce5,
    0x02ceb, 0x02cef,
    0x02d00, 0x02d26,
    0x02d30, 0x02d66,
    0x02d6f, 0x02d70,
    0x02d80, 0x02d97,
    0x02da0, 0x02da7,
    0x02da8, 0x02daf,
    0x02db0, 0x02db7,
    0x02db8, 0x02dbf,
    0x02dc0, 0x02dc7,
    0x02dc8, 0x02dcf,
    0x02dd0, 0x02dd7,
    0x02dd8, 0x02ddf,
    0x02de0, 0x02e00,
    0x02e2f, 0x02e30,
    0x03005, 0x03008,
    0x03021, 0x0302a,
    0x03031, 0x03036,
    0x03038, 0x0303d,
    0x03041, 0x03097,
    0x0309d, 0x030a0,
    0x030a1, 0x030fb,
    0x030fc, 0x03100,
    0x03105, 0x0312e,
    0x03131, 0x0318f,
    0x031a0, 0x031bb,
    0x031f0, 0x03200,
    0x03400, 0x04db6,
    0x04e00, 0x09fcc,
    0x0a000, 0x0a48d,
    0x0a4d0, 0x0a4fe,
    0x0a500, 0x0a60d,
    0x0a610, 0x0a620,
    0x0a62a, 0x0a62c,
    0x0a640, 0x0a66f,
    0x0a67f, 0x0a698,
    0x0a6a0, 0x0a6f0,
    0x0a717, 0x0a720,
    0x0a722, 0x0a789,
    0x0a78b, 0x0a78f,
    0x0a790, 0x0a792,
    0x0a7a0, 0x0a7aa,
    0x0a7fa, 0x0a802,
    0x0a803, 0x0a806,
    0x0a807, 0x0a80b,
    0x0a80c, 0x0a828,
    0x0a840, 0x0a874,
    0x0a880, 0x0a8c4,
    0x0a8f2, 0x0a8f8,
    0x0a8fb, 0x0a8fc,
    0x0a90a, 0x0a92b,
    0x0a930, 0x0a953,
    0x0a960, 0x0a97d,
    0x0a980, 0x0a9b3,
    0x0a9b4, 0x0a9c0,
    0x0a9cf, 0x0a9d0,
    0x0aa00, 0x0aa37,
    0x0aa40, 0x0aa4e,
    0x0aa60, 0x0aa77,
    0x0aa7a, 0x0aa7b,
    0x0aa80, 0x0aabf,
    0x0aac0, 0x0aac1,
    0x0aac2, 0x0aac3,
    0x0aadb, 0x0aade,
    0x0ab01, 0x0ab07,
    0x0ab09, 0x0ab0f,
    0x0ab11, 0x0ab17,
    0x0ab20, 0x0ab27,
    0x0ab28, 0x0ab2f,
    0x0abc0, 0x0abeb,
    0x0ac00, 0x0d7a4,
    0x0d7b0, 0x0d7c7,
    0x0d7cb, 0x0d7fc,
    0x0f900, 0x0fa2e,
    0x0fa30, 0x0fa6e,
    0x0fa70, 0x0fada,
    0x0fb00, 0x0fb07,
    0x0fb13, 0x0fb18,
    0x0fb1d, 0x0fb29,
    0x0fb2a, 0x0fb37,
    0x0fb38, 0x0fb3d,
    0x0fb3e, 0x0fb3f,
    0x0fb40, 0x0fb42,
    0x0fb43, 0x0fb45,
    0x0fb46, 0x0fbb2,
    0x0fbd3, 0x0fd3e,
    0x0fd50, 0x0fd90,
    0x0fd92, 0x0fdc8,
    0x0fdf0, 0x0fdfc,
    0x0fe70, 0x0fe75,
    0x0fe76, 0x0fefd,
    0x0ff21, 0x0ff3b,
    0x0ff41, 0x0ff5b,
    0x0ff66, 0x0ffbf,
    0x0ffc2, 0x0ffc8,
    0x0ffca, 0x0ffd0,
    0x0ffd2, 0x0ffd8,
    0x0ffda, 0x0ffdd,
    0x10000, 0x1000c,
    0x1000d, 0x10027,
    0x10028, 0x1003b,
    0x1003c, 0x1003e,
    0x1003f, 0x1004e,
    0x10050, 0x1005e,
    0x10080, 0x100fb,
    0x10140, 0x10175,
    0x10280, 0x1029d,
    0x102a0, 0x102d1,
    0x10300, 0x1031f,
    0x10330, 0x1034b,
    0x10380, 0x1039e,
    0x103a0, 0x103c4,
    0x103c8, 0x103d0,
    0x103d1, 0x103d6,
    0x10400, 0x1049e,
    0x10800, 0x10806,
    0x10808, 0x10809,
    0x1080a, 0x10836,
    0x10837, 0x10839,
    0x1083c, 0x1083d,
    0x1083f, 0x10856,
    0x10900, 0x10916,
    0x10920, 0x1093a,
    0x10a00, 0x10a04,
    0x10a05, 0x10a07,
    0x10a0c, 0x10a14,
    0x10a15, 0x10a18,
    0x10a19, 0x10a34,
    0x10a60, 0x10a7d,
    0x10b00, 0x10b36,
    0x10b40, 0x10b56,
    0x10b60, 0x10b73,
    0x10c00, 0x10c49,
    0x11000, 0x11046,
    0x11082, 0x110b9,
    0x12000, 0x1236f,
    0x12400, 0x12463,
    0x13000, 0x1342f,
    0x16800, 0x16a39,
    0x1b000, 0x1b002,
    0x1d400, 0x1d455,
    0x1d456, 0x1d49d,
    0x1d49e, 0x1d4a0,
    0x1d4a2, 0x1d4a3,
    0x1d4a5, 0x1d4a7,
    0x1d4a9, 0x1d4ad,
    0x1d4ae, 0x1d4ba,
    0x1d4bb, 0x1d4bc,
    0x1d4bd, 0x1d4c4,
    0x1d4c5, 0x1d506,
    0x1d507, 0x1d50b,
    0x1d50d, 0x1d515,
    0x1d516, 0x1d51d,
    0x1d51e, 0x1d53a,
    0x1d53b, 0x1d53f,
    0x1d540, 0x1d545,
    0x1d546, 0x1d547,
    0x1d54a, 0x1d551,
    0x1d552, 0x1d6a6,
    0x1d6a8, 0x1d6c1,
    0x1d6c2, 0x1d6db,
    0x1d6dc, 0x1d6fb,
    0x1d6fc, 0x1d715,
    0x1d716, 0x1d735,
    0x1d736, 0x1d74f,
    0x1d750, 0x1d76f,
    0x1d770, 0x1d789,
    0x1d78a, 0x1d7a9,
    0x1d7aa, 0x1d7c3,
    0x1d7c4, 0x1d7cc,
    0x20000, 0x2a6d7,
    0x2a700, 0x2b735,
    0x2b740, 0x2b81e,
    0x2f800, 0x2fa1e,
]);

immutable(CodepointSet) unicodeBalinese = CodepointSet([
    0x01b00, 0x01b4c,
    0x01b50, 0x01b7d,
]);

immutable UnicodeProperty[] unicodeProperties = [
UnicodeProperty("Alphabetic", unicodeAlphabetic),
UnicodeProperty("Arabic", unicodeArabic),
UnicodeProperty("Armenian", unicodeArmenian),
UnicodeProperty("ASCII_Hex_Digit", unicodeASCII_Hex_Digit),
UnicodeProperty("Avestan", unicodeAvestan),
UnicodeProperty("Balinese", unicodeBalinese),
UnicodeProperty("Bamum", unicodeBamum),
UnicodeProperty("Batak", unicodeBatak),
UnicodeProperty("Bengali", unicodeBengali),
UnicodeProperty("Bidi_Control", unicodeBidi_Control),
UnicodeProperty("Bopomofo", unicodeBopomofo),
UnicodeProperty("Brahmi", unicodeBrahmi),
UnicodeProperty("Braille", unicodeBraille),
UnicodeProperty("Buginese", unicodeBuginese),
UnicodeProperty("Buhid", unicodeBuhid),
UnicodeProperty("Canadian_Aboriginal", unicodeCanadian_Aboriginal),
UnicodeProperty("Carian", unicodeCarian),
UnicodeProperty("Cc", unicodeCc),
UnicodeProperty("Cf", unicodeCf),
UnicodeProperty("Cham", unicodeCham),
UnicodeProperty("Cherokee", unicodeCherokee),
UnicodeProperty("Close_Punctuation", unicodePe),
UnicodeProperty("Cn", unicodeCn),
UnicodeProperty("Co", unicodeCo),
UnicodeProperty("Common", unicodeCommon),
UnicodeProperty("Connector_Punctuation", unicodePc),
UnicodeProperty("Control", unicodeCc),
UnicodeProperty("Coptic", unicodeCoptic),
UnicodeProperty("Cs", unicodeCs),
UnicodeProperty("Cuneiform", unicodeCuneiform),
UnicodeProperty("Currency_Symbol", unicodeSc),
UnicodeProperty("Cypriot", unicodeCypriot),
UnicodeProperty("Cyrillic", unicodeCyrillic),
UnicodeProperty("Dash", unicodeDash),
UnicodeProperty("Dash_Punctuation", unicodePd),
UnicodeProperty("Decimal_Number", unicodeNd),
UnicodeProperty("Deprecated", unicodeDeprecated),
UnicodeProperty("Deseret", unicodeDeseret),
UnicodeProperty("Devanagari", unicodeDevanagari),
UnicodeProperty("Diacritic", unicodeDiacritic),
UnicodeProperty("Egyptian_Hieroglyphs", unicodeEgyptian_Hieroglyphs),
UnicodeProperty("Enclosing_Mark", unicodeMe),
UnicodeProperty("Ethiopic", unicodeEthiopic),
UnicodeProperty("Extender", unicodeExtender),
UnicodeProperty("Final_Punctuation", unicodePf),
UnicodeProperty("Format", unicodeCf),
UnicodeProperty("Georgian", unicodeGeorgian),
UnicodeProperty("Glagolitic", unicodeGlagolitic),
UnicodeProperty("Gothic", unicodeGothic),
UnicodeProperty("Greek", unicodeGreek),
UnicodeProperty("Gujarati", unicodeGujarati),
UnicodeProperty("Gurmukhi", unicodeGurmukhi),
UnicodeProperty("Han", unicodeHan),
UnicodeProperty("Hangul", unicodeHangul),
UnicodeProperty("Hanunoo", unicodeHanunoo),
UnicodeProperty("Hebrew", unicodeHebrew),
UnicodeProperty("Hex_Digit", unicodeHex_Digit),
UnicodeProperty("Hiragana", unicodeHiragana),
UnicodeProperty("Hyphen", unicodeHyphen),
UnicodeProperty("Ideographic", unicodeIdeographic),
UnicodeProperty("IDS_Binary_Operator", unicodeIDS_Binary_Operator),
UnicodeProperty("IDS_Trinary_Operator", unicodeIDS_Trinary_Operator),
UnicodeProperty("Imperial_Aramaic", unicodeImperial_Aramaic),
UnicodeProperty("InAegean Numbers", unicodeInAegean_Numbers),
UnicodeProperty("InAlchemical Symbols", unicodeInAlchemical_Symbols),
UnicodeProperty("InAlphabetic Presentation Forms", unicodeInAlphabetic_Presentation_Forms),
UnicodeProperty("InAncient Greek Musical Notation", unicodeInAncient_Greek_Musical_Notation),
UnicodeProperty("InAncient Greek Numbers", unicodeInAncient_Greek_Numbers),
UnicodeProperty("InAncient Symbols", unicodeInAncient_Symbols),
UnicodeProperty("InArabic", unicodeInArabic),
UnicodeProperty("InArabic Presentation Forms-A", unicodeInArabic_Presentation_Forms_A),
UnicodeProperty("InArabic Presentation Forms-B", unicodeInArabic_Presentation_Forms_B),
UnicodeProperty("InArabic Supplement", unicodeInArabic_Supplement),
UnicodeProperty("InArmenian", unicodeInArmenian),
UnicodeProperty("InArrows", unicodeInArrows),
UnicodeProperty("InAvestan", unicodeInAvestan),
UnicodeProperty("InBalinese", unicodeInBalinese),
UnicodeProperty("InBamum", unicodeInBamum),
UnicodeProperty("InBamum Supplement", unicodeInBamum_Supplement),
UnicodeProperty("InBasic Latin", unicodeInBasic_Latin),
UnicodeProperty("InBatak", unicodeInBatak),
UnicodeProperty("InBengali", unicodeInBengali),
UnicodeProperty("InBlock Elements", unicodeInBlock_Elements),
UnicodeProperty("InBopomofo", unicodeInBopomofo),
UnicodeProperty("InBopomofo Extended", unicodeInBopomofo_Extended),
UnicodeProperty("InBox Drawing", unicodeInBox_Drawing),
UnicodeProperty("InBrahmi", unicodeInBrahmi),
UnicodeProperty("InBraille Patterns", unicodeInBraille_Patterns),
UnicodeProperty("InBuginese", unicodeInBuginese),
UnicodeProperty("InBuhid", unicodeInBuhid),
UnicodeProperty("InByzantine Musical Symbols", unicodeInByzantine_Musical_Symbols),
UnicodeProperty("InCarian", unicodeInCarian),
UnicodeProperty("InCham", unicodeInCham),
UnicodeProperty("InCherokee", unicodeInCherokee),
UnicodeProperty("InCJK Compatibility", unicodeInCJK_Compatibility),
UnicodeProperty("InCJK Compatibility Forms", unicodeInCJK_Compatibility_Forms),
UnicodeProperty("InCJK Compatibility Ideographs", unicodeInCJK_Compatibility_Ideographs),
UnicodeProperty("InCJK Compatibility Ideographs Supplement", unicodeInCJK_Compatibility_Ideographs_Supplement),
UnicodeProperty("InCJK Radicals Supplement", unicodeInCJK_Radicals_Supplement),
UnicodeProperty("InCJK Strokes", unicodeInCJK_Strokes),
UnicodeProperty("InCJK Symbols and Punctuation", unicodeInCJK_Symbols_and_Punctuation),
UnicodeProperty("InCJK Unified Ideographs", unicodeInCJK_Unified_Ideographs),
UnicodeProperty("InCJK Unified Ideographs Extension A", unicodeInCJK_Unified_Ideographs_Extension_A),
UnicodeProperty("InCJK Unified Ideographs Extension B", unicodeInCJK_Unified_Ideographs_Extension_B),
UnicodeProperty("InCJK Unified Ideographs Extension C", unicodeInCJK_Unified_Ideographs_Extension_C),
UnicodeProperty("InCJK Unified Ideographs Extension D", unicodeInCJK_Unified_Ideographs_Extension_D),
UnicodeProperty("InCombining Diacritical Marks", unicodeInCombining_Diacritical_Marks),
UnicodeProperty("InCombining Diacritical Marks for Symbols", unicodeInCombining_Diacritical_Marks_for_Symbols),
UnicodeProperty("InCombining Diacritical Marks Supplement", unicodeInCombining_Diacritical_Marks_Supplement),
UnicodeProperty("InCombining Half Marks", unicodeInCombining_Half_Marks),
UnicodeProperty("InCommon Indic Number Forms", unicodeInCommon_Indic_Number_Forms),
UnicodeProperty("InControl Pictures", unicodeInControl_Pictures),
UnicodeProperty("InCoptic", unicodeInCoptic),
UnicodeProperty("InCounting Rod Numerals", unicodeInCounting_Rod_Numerals),
UnicodeProperty("InCuneiform", unicodeInCuneiform),
UnicodeProperty("InCuneiform Numbers and Punctuation", unicodeInCuneiform_Numbers_and_Punctuation),
UnicodeProperty("InCurrency Symbols", unicodeInCurrency_Symbols),
UnicodeProperty("InCypriot Syllabary", unicodeInCypriot_Syllabary),
UnicodeProperty("InCyrillic", unicodeInCyrillic),
UnicodeProperty("InCyrillic Extended-A", unicodeInCyrillic_Extended_A),
UnicodeProperty("InCyrillic Extended-B", unicodeInCyrillic_Extended_B),
UnicodeProperty("InCyrillic Supplement", unicodeInCyrillic_Supplement),
UnicodeProperty("InDeseret", unicodeInDeseret),
UnicodeProperty("InDevanagari", unicodeInDevanagari),
UnicodeProperty("InDevanagari Extended", unicodeInDevanagari_Extended),
UnicodeProperty("InDingbats", unicodeInDingbats),
UnicodeProperty("InDomino Tiles", unicodeInDomino_Tiles),
UnicodeProperty("InEgyptian Hieroglyphs", unicodeInEgyptian_Hieroglyphs),
UnicodeProperty("InEmoticons", unicodeInEmoticons),
UnicodeProperty("InEnclosed Alphanumerics", unicodeInEnclosed_Alphanumerics),
UnicodeProperty("InEnclosed Alphanumeric Supplement", unicodeInEnclosed_Alphanumeric_Supplement),
UnicodeProperty("InEnclosed CJK Letters and Months", unicodeInEnclosed_CJK_Letters_and_Months),
UnicodeProperty("InEnclosed Ideographic Supplement", unicodeInEnclosed_Ideographic_Supplement),
UnicodeProperty("InEthiopic", unicodeInEthiopic),
UnicodeProperty("InEthiopic Extended", unicodeInEthiopic_Extended),
UnicodeProperty("InEthiopic Extended-A", unicodeInEthiopic_Extended_A),
UnicodeProperty("InEthiopic Supplement", unicodeInEthiopic_Supplement),
UnicodeProperty("InGeneral Punctuation", unicodeInGeneral_Punctuation),
UnicodeProperty("InGeometric Shapes", unicodeInGeometric_Shapes),
UnicodeProperty("InGeorgian", unicodeInGeorgian),
UnicodeProperty("InGeorgian Supplement", unicodeInGeorgian_Supplement),
UnicodeProperty("InGlagolitic", unicodeInGlagolitic),
UnicodeProperty("InGothic", unicodeInGothic),
UnicodeProperty("InGreek and Coptic", unicodeInGreek_and_Coptic),
UnicodeProperty("InGreek Extended", unicodeInGreek_Extended),
UnicodeProperty("InGujarati", unicodeInGujarati),
UnicodeProperty("InGurmukhi", unicodeInGurmukhi),
UnicodeProperty("InHalfwidth and Fullwidth Forms", unicodeInHalfwidth_and_Fullwidth_Forms),
UnicodeProperty("InHangul Compatibility Jamo", unicodeInHangul_Compatibility_Jamo),
UnicodeProperty("InHangul Jamo", unicodeInHangul_Jamo),
UnicodeProperty("InHangul Jamo Extended-A", unicodeInHangul_Jamo_Extended_A),
UnicodeProperty("InHangul Jamo Extended-B", unicodeInHangul_Jamo_Extended_B),
UnicodeProperty("InHangul Syllables", unicodeInHangul_Syllables),
UnicodeProperty("InHanunoo", unicodeInHanunoo),
UnicodeProperty("InHebrew", unicodeInHebrew),
UnicodeProperty("Inherited", unicodeInherited),
UnicodeProperty("InHigh Private Use Surrogates", unicodeInHigh_Private_Use_Surrogates),
UnicodeProperty("InHigh Surrogates", unicodeInHigh_Surrogates),
UnicodeProperty("InHiragana", unicodeInHiragana),
UnicodeProperty("InIdeographic Description Characters", unicodeInIdeographic_Description_Characters),
UnicodeProperty("InImperial Aramaic", unicodeInImperial_Aramaic),
UnicodeProperty("InInscriptional Pahlavi", unicodeInInscriptional_Pahlavi),
UnicodeProperty("InInscriptional Parthian", unicodeInInscriptional_Parthian),
UnicodeProperty("InIPA Extensions", unicodeInIPA_Extensions),
UnicodeProperty("Initial_Punctuation", unicodePi),
UnicodeProperty("InJavanese", unicodeInJavanese),
UnicodeProperty("InKaithi", unicodeInKaithi),
UnicodeProperty("InKana Supplement", unicodeInKana_Supplement),
UnicodeProperty("InKanbun", unicodeInKanbun),
UnicodeProperty("InKangxi Radicals", unicodeInKangxi_Radicals),
UnicodeProperty("InKannada", unicodeInKannada),
UnicodeProperty("InKatakana", unicodeInKatakana),
UnicodeProperty("InKatakana Phonetic Extensions", unicodeInKatakana_Phonetic_Extensions),
UnicodeProperty("InKayah Li", unicodeInKayah_Li),
UnicodeProperty("InKharoshthi", unicodeInKharoshthi),
UnicodeProperty("InKhmer", unicodeInKhmer),
UnicodeProperty("InKhmer Symbols", unicodeInKhmer_Symbols),
UnicodeProperty("InLao", unicodeInLao),
UnicodeProperty("InLatin-1 Supplement", unicodeInLatin_1_Supplement),
UnicodeProperty("InLatin Extended-A", unicodeInLatin_Extended_A),
UnicodeProperty("InLatin Extended Additional", unicodeInLatin_Extended_Additional),
UnicodeProperty("InLatin Extended-B", unicodeInLatin_Extended_B),
UnicodeProperty("InLatin Extended-C", unicodeInLatin_Extended_C),
UnicodeProperty("InLatin Extended-D", unicodeInLatin_Extended_D),
UnicodeProperty("InLepcha", unicodeInLepcha),
UnicodeProperty("InLetterlike Symbols", unicodeInLetterlike_Symbols),
UnicodeProperty("InLimbu", unicodeInLimbu),
UnicodeProperty("InLinear B Ideograms", unicodeInLinear_B_Ideograms),
UnicodeProperty("InLinear B Syllabary", unicodeInLinear_B_Syllabary),
UnicodeProperty("InLisu", unicodeInLisu),
UnicodeProperty("InLow Surrogates", unicodeInLow_Surrogates),
UnicodeProperty("InLycian", unicodeInLycian),
UnicodeProperty("InLydian", unicodeInLydian),
UnicodeProperty("InMahjong Tiles", unicodeInMahjong_Tiles),
UnicodeProperty("InMalayalam", unicodeInMalayalam),
UnicodeProperty("InMandaic", unicodeInMandaic),
UnicodeProperty("InMathematical Alphanumeric Symbols", unicodeInMathematical_Alphanumeric_Symbols),
UnicodeProperty("InMathematical Operators", unicodeInMathematical_Operators),
UnicodeProperty("InMeetei Mayek", unicodeInMeetei_Mayek),
UnicodeProperty("InMiscellaneous Mathematical Symbols-A", unicodeInMiscellaneous_Mathematical_Symbols_A),
UnicodeProperty("InMiscellaneous Mathematical Symbols-B", unicodeInMiscellaneous_Mathematical_Symbols_B),
UnicodeProperty("InMiscellaneous Symbols", unicodeInMiscellaneous_Symbols),
UnicodeProperty("InMiscellaneous Symbols and Arrows", unicodeInMiscellaneous_Symbols_and_Arrows),
UnicodeProperty("InMiscellaneous Symbols And Pictographs", unicodeInMiscellaneous_Symbols_And_Pictographs),
UnicodeProperty("InMiscellaneous Technical", unicodeInMiscellaneous_Technical),
UnicodeProperty("InModifier Tone Letters", unicodeInModifier_Tone_Letters),
UnicodeProperty("InMongolian", unicodeInMongolian),
UnicodeProperty("InMusical Symbols", unicodeInMusical_Symbols),
UnicodeProperty("InMyanmar", unicodeInMyanmar),
UnicodeProperty("InMyanmar Extended-A", unicodeInMyanmar_Extended_A),
UnicodeProperty("InNew Tai Lue", unicodeInNew_Tai_Lue),
UnicodeProperty("InNKo", unicodeInNKo),
UnicodeProperty("InNumber Forms", unicodeInNumber_Forms),
UnicodeProperty("InOgham", unicodeInOgham),
UnicodeProperty("InOl Chiki", unicodeInOl_Chiki),
UnicodeProperty("InOld Italic", unicodeInOld_Italic),
UnicodeProperty("InOld Persian", unicodeInOld_Persian),
UnicodeProperty("InOld South Arabian", unicodeInOld_South_Arabian),
UnicodeProperty("InOld Turkic", unicodeInOld_Turkic),
UnicodeProperty("InOptical Character Recognition", unicodeInOptical_Character_Recognition),
UnicodeProperty("InOriya", unicodeInOriya),
UnicodeProperty("InOsmanya", unicodeInOsmanya),
UnicodeProperty("InPhags-pa", unicodeInPhags_pa),
UnicodeProperty("InPhaistos Disc", unicodeInPhaistos_Disc),
UnicodeProperty("InPhoenician", unicodeInPhoenician),
UnicodeProperty("InPhonetic Extensions", unicodeInPhonetic_Extensions),
UnicodeProperty("InPhonetic Extensions Supplement", unicodeInPhonetic_Extensions_Supplement),
UnicodeProperty("InPlaying Cards", unicodeInPlaying_Cards),
UnicodeProperty("InPrivate Use Area", unicodeInPrivate_Use_Area),
UnicodeProperty("InRejang", unicodeInRejang),
UnicodeProperty("InRumi Numeral Symbols", unicodeInRumi_Numeral_Symbols),
UnicodeProperty("InRunic", unicodeInRunic),
UnicodeProperty("InSamaritan", unicodeInSamaritan),
UnicodeProperty("InSaurashtra", unicodeInSaurashtra),
UnicodeProperty("Inscriptional_Pahlavi", unicodeInscriptional_Pahlavi),
UnicodeProperty("Inscriptional_Parthian", unicodeInscriptional_Parthian),
UnicodeProperty("InShavian", unicodeInShavian),
UnicodeProperty("InSinhala", unicodeInSinhala),
UnicodeProperty("InSmall Form Variants", unicodeInSmall_Form_Variants),
UnicodeProperty("InSpacing Modifier Letters", unicodeInSpacing_Modifier_Letters),
UnicodeProperty("InSpecials", unicodeInSpecials),
UnicodeProperty("InSundanese", unicodeInSundanese),
UnicodeProperty("InSuperscripts and Subscripts", unicodeInSuperscripts_and_Subscripts),
UnicodeProperty("InSupplemental Arrows-A", unicodeInSupplemental_Arrows_A),
UnicodeProperty("InSupplemental Arrows-B", unicodeInSupplemental_Arrows_B),
UnicodeProperty("InSupplemental Mathematical Operators", unicodeInSupplemental_Mathematical_Operators),
UnicodeProperty("InSupplemental Punctuation", unicodeInSupplemental_Punctuation),
UnicodeProperty("InSupplementary Private Use Area-A", unicodeInSupplementary_Private_Use_Area_A),
UnicodeProperty("InSupplementary Private Use Area-B", unicodeInSupplementary_Private_Use_Area_B),
UnicodeProperty("InSyloti Nagri", unicodeInSyloti_Nagri),
UnicodeProperty("InSyriac", unicodeInSyriac),
UnicodeProperty("InTagalog", unicodeInTagalog),
UnicodeProperty("InTagbanwa", unicodeInTagbanwa),
UnicodeProperty("InTags", unicodeInTags),
UnicodeProperty("InTai Le", unicodeInTai_Le),
UnicodeProperty("InTai Tham", unicodeInTai_Tham),
UnicodeProperty("InTai Viet", unicodeInTai_Viet),
UnicodeProperty("InTai Xuan Jing Symbols", unicodeInTai_Xuan_Jing_Symbols),
UnicodeProperty("InTamil", unicodeInTamil),
UnicodeProperty("InTelugu", unicodeInTelugu),
UnicodeProperty("InThaana", unicodeInThaana),
UnicodeProperty("InThai", unicodeInThai),
UnicodeProperty("InTibetan", unicodeInTibetan),
UnicodeProperty("InTifinagh", unicodeInTifinagh),
UnicodeProperty("InTransport And Map Symbols", unicodeInTransport_And_Map_Symbols),
UnicodeProperty("InUgaritic", unicodeInUgaritic),
UnicodeProperty("InUnified Canadian Aboriginal Syllabics", unicodeInUnified_Canadian_Aboriginal_Syllabics),
UnicodeProperty("InUnified Canadian Aboriginal Syllabics Extended", unicodeInUnified_Canadian_Aboriginal_Syllabics_Extended),
UnicodeProperty("InVai", unicodeInVai),
UnicodeProperty("InVariation Selectors", unicodeInVariation_Selectors),
UnicodeProperty("InVariation Selectors Supplement", unicodeInVariation_Selectors_Supplement),
UnicodeProperty("InVedic Extensions", unicodeInVedic_Extensions),
UnicodeProperty("InVertical Forms", unicodeInVertical_Forms),
UnicodeProperty("InYijing Hexagram Symbols", unicodeInYijing_Hexagram_Symbols),
UnicodeProperty("InYi Radicals", unicodeInYi_Radicals),
UnicodeProperty("InYi Syllables", unicodeInYi_Syllables),
UnicodeProperty("Javanese", unicodeJavanese),
UnicodeProperty("Join_Control", unicodeJoin_Control),
UnicodeProperty("Kaithi", unicodeKaithi),
UnicodeProperty("Kannada", unicodeKannada),
UnicodeProperty("Katakana", unicodeKatakana),
UnicodeProperty("Kayah_Li", unicodeKayah_Li),
UnicodeProperty("Kharoshthi", unicodeKharoshthi),
UnicodeProperty("Khmer", unicodeKhmer),
UnicodeProperty("Lao", unicodeLao),
UnicodeProperty("Latin", unicodeLatin),
UnicodeProperty("Lepcha", unicodeLepcha),
UnicodeProperty("Letter_Number", unicodeNl),
UnicodeProperty("Limbu", unicodeLimbu),
UnicodeProperty("Linear_B", unicodeLinear_B),
UnicodeProperty("Line_Separator", unicodeZl),
UnicodeProperty("Lisu", unicodeLisu),
UnicodeProperty("Ll", unicodeLl),
UnicodeProperty("Lm", unicodeLm),
UnicodeProperty("Lo", unicodeLo),
UnicodeProperty("Logical_Order_Exception", unicodeLogical_Order_Exception),
UnicodeProperty("Lowercase_Letter", unicodeLl),
UnicodeProperty("Lt", unicodeLt),
UnicodeProperty("Lu", unicodeLu),
UnicodeProperty("Lycian", unicodeLycian),
UnicodeProperty("Lydian", unicodeLydian),
UnicodeProperty("Malayalam", unicodeMalayalam),
UnicodeProperty("Mandaic", unicodeMandaic),
UnicodeProperty("Math", unicodeMath),
UnicodeProperty("Math_Symbol", unicodeSm),
UnicodeProperty("Mc", unicodeMc),
UnicodeProperty("Me", unicodeMe),
UnicodeProperty("Meetei_Mayek", unicodeMeetei_Mayek),
UnicodeProperty("Mn", unicodeMn),
UnicodeProperty("Modifier_Letter", unicodeLm),
UnicodeProperty("Modifier_Symbol", unicodeSk),
UnicodeProperty("Mongolian", unicodeMongolian),
UnicodeProperty("Myanmar", unicodeMyanmar),
UnicodeProperty("Nd", unicodeNd),
UnicodeProperty("New_Tai_Lue", unicodeNew_Tai_Lue),
UnicodeProperty("Nko", unicodeNko),
UnicodeProperty("Nl", unicodeNl),
UnicodeProperty("No", unicodeNo),
UnicodeProperty("Noncharacter_Code_Point", unicodeNoncharacter_Code_Point),
UnicodeProperty("Nonspacing_Mark", unicodeMn),
UnicodeProperty("Ogham", unicodeOgham),
UnicodeProperty("Ol_Chiki", unicodeOl_Chiki),
UnicodeProperty("Old_Italic", unicodeOld_Italic),
UnicodeProperty("Old_Persian", unicodeOld_Persian),
UnicodeProperty("Old_South_Arabian", unicodeOld_South_Arabian),
UnicodeProperty("Old_Turkic", unicodeOld_Turkic),
UnicodeProperty("Open_Punctuation", unicodePs),
UnicodeProperty("Oriya", unicodeOriya),
UnicodeProperty("Osmanya", unicodeOsmanya),
UnicodeProperty("Other_Alphabetic", unicodeOther_Alphabetic),
UnicodeProperty("Other_Default_Ignorable_Code_Point", unicodeOther_Default_Ignorable_Code_Point),
UnicodeProperty("Other_Grapheme_Extend", unicodeOther_Grapheme_Extend),
UnicodeProperty("Other_ID_Continue", unicodeOther_ID_Continue),
UnicodeProperty("Other_ID_Start", unicodeOther_ID_Start),
UnicodeProperty("Other_Letter", unicodeLo),
UnicodeProperty("Other_Lowercase", unicodeOther_Lowercase),
UnicodeProperty("Other_Math", unicodeOther_Math),
UnicodeProperty("Other_Number", unicodeNo),
UnicodeProperty("Other_Punctuation", unicodePo),
UnicodeProperty("Other_Symbol", unicodeSo),
UnicodeProperty("Other_Uppercase", unicodeOther_Uppercase),
UnicodeProperty("Paragraph_Separator", unicodeZp),
UnicodeProperty("Pattern_Syntax", unicodePattern_Syntax),
UnicodeProperty("Pattern_White_Space", unicodePattern_White_Space),
UnicodeProperty("Pc", unicodePc),
UnicodeProperty("Pd", unicodePd),
UnicodeProperty("Pe", unicodePe),
UnicodeProperty("Pf", unicodePf),
UnicodeProperty("Phags_Pa", unicodePhags_Pa),
UnicodeProperty("Phoenician", unicodePhoenician),
UnicodeProperty("Pi", unicodePi),
UnicodeProperty("Po", unicodePo),
UnicodeProperty("Private_Use", unicodeCo),
UnicodeProperty("Ps", unicodePs),
UnicodeProperty("Quotation_Mark", unicodeQuotation_Mark),
UnicodeProperty("Radical", unicodeRadical),
UnicodeProperty("Rejang", unicodeRejang),
UnicodeProperty("Runic", unicodeRunic),
UnicodeProperty("Samaritan", unicodeSamaritan),
UnicodeProperty("Saurashtra", unicodeSaurashtra),
UnicodeProperty("Sc", unicodeSc),
UnicodeProperty("Shavian", unicodeShavian),
UnicodeProperty("Sinhala", unicodeSinhala),
UnicodeProperty("Sk", unicodeSk),
UnicodeProperty("Sm", unicodeSm),
UnicodeProperty("So", unicodeSo),
UnicodeProperty("Soft_Dotted", unicodeSoft_Dotted),
UnicodeProperty("Space_Separator", unicodeZs),
UnicodeProperty("Spacing_Mark", unicodeMc),
UnicodeProperty("STerm", unicodeSTerm),
UnicodeProperty("Sundanese", unicodeSundanese),
UnicodeProperty("Surrogate", unicodeCs),
UnicodeProperty("Syloti_Nagri", unicodeSyloti_Nagri),
UnicodeProperty("Syriac", unicodeSyriac),
UnicodeProperty("Tagalog", unicodeTagalog),
UnicodeProperty("Tagbanwa", unicodeTagbanwa),
UnicodeProperty("Tai_Le", unicodeTai_Le),
UnicodeProperty("Tai_Tham", unicodeTai_Tham),
UnicodeProperty("Tai_Viet", unicodeTai_Viet),
UnicodeProperty("Tamil", unicodeTamil),
UnicodeProperty("Telugu", unicodeTelugu),
UnicodeProperty("Terminal_Punctuation", unicodeTerminal_Punctuation),
UnicodeProperty("Thaana", unicodeThaana),
UnicodeProperty("Thai", unicodeThai),
UnicodeProperty("Tibetan", unicodeTibetan),
UnicodeProperty("Tifinagh", unicodeTifinagh),
UnicodeProperty("Titlecase_Letter", unicodeLt),
UnicodeProperty("Ugaritic", unicodeUgaritic),
UnicodeProperty("Unassigned", unicodeCn),
UnicodeProperty("Unified_Ideograph", unicodeUnified_Ideograph),
UnicodeProperty("Uppercase_Letter", unicodeLu),
UnicodeProperty("Vai", unicodeVai),
UnicodeProperty("Variation_Selector", unicodeVariation_Selector),
UnicodeProperty("White_Space", unicodeWhite_Space),
UnicodeProperty("Yi", unicodeYi),
UnicodeProperty("Zl", unicodeZl),
UnicodeProperty("Zp", unicodeZp),
UnicodeProperty("Zs", unicodeZs),
];
immutable NFC_QCN = CodepointSet([
    0x00340, 0x00342,
    0x00343, 0x00345,
    0x00374, 0x00375,
    0x0037e, 0x0037f,
    0x00387, 0x00388,
    0x00958, 0x00960,
    0x009dc, 0x009de,
    0x009df, 0x009e0,
    0x00a33, 0x00a34,
    0x00a36, 0x00a37,
    0x00a59, 0x00a5c,
    0x00a5e, 0x00a5f,
    0x00b5c, 0x00b5e,
    0x00f43, 0x00f44,
    0x00f4d, 0x00f4e,
    0x00f52, 0x00f53,
    0x00f57, 0x00f58,
    0x00f5c, 0x00f5d,
    0x00f69, 0x00f6a,
    0x00f73, 0x00f74,
    0x00f75, 0x00f77,
    0x00f78, 0x00f79,
    0x00f81, 0x00f82,
    0x00f93, 0x00f94,
    0x00f9d, 0x00f9e,
    0x00fa2, 0x00fa3,
    0x00fa7, 0x00fa8,
    0x00fac, 0x00fad,
    0x00fb9, 0x00fba,
    0x01f71, 0x01f72,
    0x01f73, 0x01f74,
    0x01f75, 0x01f76,
    0x01f77, 0x01f78,
    0x01f79, 0x01f7a,
    0x01f7b, 0x01f7c,
    0x01f7d, 0x01f7e,
    0x01fbb, 0x01fbc,
    0x01fbe, 0x01fbf,
    0x01fc9, 0x01fca,
    0x01fcb, 0x01fcc,
    0x01fd3, 0x01fd4,
    0x01fdb, 0x01fdc,
    0x01fe3, 0x01fe4,
    0x01feb, 0x01fec,
    0x01fee, 0x01ff0,
    0x01ff9, 0x01ffa,
    0x01ffb, 0x01ffc,
    0x01ffd, 0x01ffe,
    0x02000, 0x02002,
    0x02126, 0x02127,
    0x0212a, 0x0212c,
    0x02329, 0x0232b,
    0x02adc, 0x02add,
    0x0f900, 0x0fa0e,
    0x0fa10, 0x0fa11,
    0x0fa12, 0x0fa13,
    0x0fa15, 0x0fa1f,
    0x0fa20, 0x0fa21,
    0x0fa22, 0x0fa23,
    0x0fa25, 0x0fa27,
    0x0fa2a, 0x0fa2e,
    0x0fa30, 0x0fa6e,
    0x0fa70, 0x0fada,
    0x0fb1d, 0x0fb1e,
    0x0fb1f, 0x0fb20,
    0x0fb2a, 0x0fb37,
    0x0fb38, 0x0fb3d,
    0x0fb3e, 0x0fb3f,
    0x0fb40, 0x0fb42,
    0x0fb43, 0x0fb45,
    0x0fb46, 0x0fb4f,
    0x1d15e, 0x1d165,
    0x1d1bb, 0x1d1c1,
    0x2f800, 0x2fa1e,
]);

immutable NFC_QCM = CodepointSet([
    0x00300, 0x00305,
    0x00306, 0x0030d,
    0x0030f, 0x00310,
    0x00311, 0x00312,
    0x00313, 0x00315,
    0x0031b, 0x0031c,
    0x00323, 0x00329,
    0x0032d, 0x0032f,
    0x00330, 0x00332,
    0x00338, 0x00339,
    0x00342, 0x00343,
    0x00345, 0x00346,
    0x00653, 0x00656,
    0x0093c, 0x0093d,
    0x009be, 0x009bf,
    0x009d7, 0x009d8,
    0x00b3e, 0x00b3f,
    0x00b56, 0x00b58,
    0x00bbe, 0x00bbf,
    0x00bd7, 0x00bd8,
    0x00c56, 0x00c57,
    0x00cc2, 0x00cc3,
    0x00cd5, 0x00cd7,
    0x00d3e, 0x00d3f,
    0x00d57, 0x00d58,
    0x00dca, 0x00dcb,
    0x00dcf, 0x00dd0,
    0x00ddf, 0x00de0,
    0x0102e, 0x0102f,
    0x01161, 0x01176,
    0x011a8, 0x011c3,
    0x01b35, 0x01b36,
    0x03099, 0x0309b,
    0x110ba, 0x110bb,
]);

