/**************************************************************************\
 gatos (General ATI TV and Overlay Software)

  Project Coordinated By Insomnia (Steaphan Greene)
  (insomnia@core.binghamton.edu)

  Copyright (C) 1999 Steaphan Greene, yvind Aabling, Octavian Purdila, 
	Vladimir Dergachev and Christian Lupien.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.

\**************************************************************************/

#ifndef GATOS_ATIM64_H
#define GATOS_ATIM64_H 1

#ifdef __cplusplus
extern "C" {
#endif

#ifdef GATOS_ATIM64_C
#define WHERE
#else
#define WHERE	extern
#endif

#include <stdio.h>

#ifdef XY
#undef XY
#endif
#ifdef XYZ
#undef XYZ
#endif

#define XY(X,Y)		\
	( ( (0xFFFF&((u32)(X))) << 16 ) | (0xFFFF&((u32)(Y))) )
#define XYZ(X,Y,Z)	\
	( ( (0xFF&((u32)(X))) << 16 ) | ( (0xFF&((u32)(Y))) << 8 ) | (0xFF&((u32)(Z))) )

/* OVERLAY_SCALE_CNTL values */
#define DISABLE_M64_VIDEO	0x0000007BL
#define ENABLE_M64_VIDEO	\
	(0xC4000001L|((gatos.gamma)?((4-gatos.gamma)<<5):0)|(gatos.cold<<1))

/* CAPTURE_CONFIG values */
#define ENABLE_M64_CAPTURE	0x10000015L

/* ATI Mach64 function declarations */

int	m64_init(void) ;
int	m64_inita(void) ;
int	m64_initb(void) ;

int	m64_setcolorkey(void) ;
void	m64_enable_video(int) ;
void	m64_enable_capture(int) ;
void	m64_buffer_mode(void) ;
int	m64_setcaptsize(void) ;
int	m64_pollscreen(int) ;
void	m64_setgeometry(void) ;
int	m64_setgamma(void) ;
int	m64_setcold(void) ;

void	m64_rgbcapture(unsigned char*) ;
void	m64_capture(FILE*, int) ;
void	m64_playback(FILE*, int) ;

void	m64_dumpregs(void) ;

#ifdef GATOS_ATIM64_C
static int	m64_chipid(int, int, int, int) ;
#endif

#ifdef __cplusplus
}
#endif

#undef WHERE
#endif
