/* ethos-plugin-info-private.h
 *
 * Copyright (C) 2009 Christian Hergert <chris@dronelabs.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston MA 
 * 02110-1301 USA
 */

#ifndef __ETHOS_PLUGIN_INFO_PRIVATE_H__
#define __ETHOS_PLUGIN_INFO_PRIVATE_H__

#include <glib.h>
#include "ethos-plugin-info.h"

struct _EthosPluginInfoPrivate
{
	gchar    *id;
	gchar    *name;
	gchar    *module;
	gchar    *loader;
	gchar   **authors;
	gchar    *desc;
	gchar    *copyright;
	gchar    *website;
	gchar    *deps;
	gchar    *filename;
	gchar    *icon;
	gchar    *version;
	guint     iage;
	gboolean  active;
	GList    *errors;
};

void ethos_plugin_info_add_error  (EthosPluginInfo *plugin_info,
                                   const GError    *error);
void ethos_plugin_info_set_active (EthosPluginInfo  *plugin_info,
                                   gboolean          active);

#endif /* __ETHOS_PLUGIN_INFO_PRIVATE_H__ */
