/////////////////////////////////////////////////////////////
//                                                         //
// Copyright (c) 2003-2011 by The University of Queensland //
// Earth Systems Science Computational Centre (ESSCC)      //
// http://www.uq.edu.au/esscc                              //
//                                                         //
// Primary Business: Brisbane, Queensland, Australia       //
// Licensed under the Open Software License version 3.0    //
// http://www.opensource.org/licenses/osl-3.0.php          //
//                                                         //
/////////////////////////////////////////////////////////////


#ifndef ESYS_LSMITERATORPY_H
#define ESYS_LSMITERATORPY_H

#include <boost/python.hpp>

#include <string>

namespace esys
{
  namespace lsm
  {
    template <
      typename TmplIterator
    >
    class IteratorPy
    {
    public:
      typedef TmplIterator                  Iterator;
      typedef typename Iterator::value_type value_type;

      IteratorPy(const Iterator &it);

      /**
       * Returns the next item in the sequence.
       */
      value_type next();

      static void exportIterator(
        const std::string &pythonName,
        const std::string &pythonDocReturnType="object"
      );

    private:
      Iterator m_it;
    };
  }
}

#include "Python/esys/lsm/geometry/IteratorPy.hpp"

#endif
