/////////////////////////////////////////////////////////////
//                                                         //
// Copyright (c) 2003-2011 by The University of Queensland //
// Earth Systems Science Computational Centre (ESSCC)      //
// http://www.uq.edu.au/esscc                              //
//                                                         //
// Primary Business: Brisbane, Queensland, Australia       //
// Licensed under the Open Software License version 3.0    //
// http://www.opensource.org/licenses/osl-3.0.php          //
//                                                         //
/////////////////////////////////////////////////////////////


#include <boost/version.hpp>
#include <boost/python.hpp>
#include "Python/esys/lsm/RunnablePy.h"

namespace esys
{
  namespace lsm
  {
    void RunnablePy::run()
    {
      boost::python::override overrideMethod = this->get_override("run");
      if (overrideMethod)
      {
        overrideMethod();
      }
      else
      {
        defaultRun();
      }
    }

    void RunnablePy::defaultRun()
    {
      PyErr_SetString(
        PyExc_NotImplementedError,
        "run method needs to be implemented in derived class"
      );
      boost::python::throw_error_already_set();
    }

    void exportRunnable()
    {
      // Check that Boost 1.34.0 or higher is being used.
      // If so, disable auto-generation of C++ signatures for Epydoc
      // (which stumbles over indentation in the auto-generated strings).
      #if ((BOOST_VERSION / 100000 >= 1) \
          && (BOOST_VERSION / 100 % 1000 >= 34)) \
          || (BOOST_VERSION / 100000 >= 2)
        boost::python::docstring_options no_autogen(true,false);
      #endif

      boost::python::class_<
        RunnablePy,
        boost::noncopyable
      >(
        "Runnable",
        "Base class which contains overridable C{run} method."
      )
      .def(
        "run",
        &Runnable::run,
        &RunnablePy::defaultRun,
        "Method for C{run}ning."
      )
      ;
    }
  }
}
