/////////////////////////////////////////////////////////////
//                                                         //
// Copyright (c) 2003-2011 by The University of Queensland //
// Earth Systems Science Computational Centre (ESSCC)      //
// http://www.uq.edu.au/esscc                              //
//                                                         //
// Primary Business: Brisbane, Queensland, Australia       //
// Licensed under the Open Software License version 3.0    //
// http://www.opensource.org/licenses/osl-3.0.php          //
//                                                         //
/////////////////////////////////////////////////////////////

#ifndef __PLANE_H
#define __PLANE_H

//-- Project includes --
#include "Foundation/vec3.h"

/*!
  \class Plane
  \brief Class representing a Plane

  \author Steffen Abe
  $Revision$
  $Date$

*/
class Plane
{
 protected:
  Vec3 U,V ;
  bool force3D ;
  Vec3 Dir ;  
  Vec3 Pos ;
  
  void Create() ;
 public:
  Plane();
  Plane(const Vec3& iDir,const Vec3& iPos);
  Plane(const Vec3& iU,const Vec3& iV,const Vec3& iPos);
    
  virtual ~Plane() {}
    
  virtual double sep(const Vec3&) const;
  virtual double dist(const Vec3&) ; // signed separation according to Direction of the normal
  virtual Vec3 ToClosest(const Vec3& M) {return dist(M)*Dir; } ; // return the vector PM where P is the closest point to M on the surface.

  inline Vec3 GetU() const { return U; } ; // return U (for planes in a 2D space (ie. line)  U is in the space)
  inline Vec3 GetV() const { return V; } ; // V is null if this is a 2D space.
  inline const Vec3 &GetW() const { return Dir; } ; // The normal
  inline Vec3 getNormal() const { return Dir; } ;
  inline const Vec3 &GetO() const { return Pos; } ;
  inline Vec3 getPos() const { return Pos; } ;
} ;

namespace esys
{
  namespace lsm
  {
    typedef ::Plane Plane;
  }
}

#endif // __PLANE_H
