/**
* Copyright 1981-2007 ECMWF
* 
* Licensed under the GNU Lesser General Public License which
* incorporates the terms and conditions of version 3 of the GNU
* General Public License.
* See LICENSE and gpl-3.0.txt for details.
*/

#include "fortint.h"

void csgnbt_(
  fortint * kout,
  fortint * kin,
  fortint * kpos,
  fortint * kret) {

fortint value = *kin;
unsigned fortint sign = (value < 0 ) ? (1 << ((*kpos)-1)) : 0;
unsigned fortint mask = ~(-1 << ((*kpos)-1));

  if( value < 0 )
    *kout = ((-value) & mask) | sign;
  else
    *kout = (value & mask);

  *kret = 0;
  return;
}

void csgnbt(
  fortint * kout,
  fortint * kin,
  fortint * kpos,
  fortint * kret) {

  csgnbt_(kout,kin,kpos,kret);
}
