from re import compile, IGNORECASE

from dosage.helpers import BasicScraper, PHPScraper, indirectStarter


class NamirDeiter(BasicScraper):
    latestUrl = 'http://www.namirdeiter.com/'
    imageUrl = 'http://www.namirdeiter.com/comics/index.php\\?date=s%'
    imageSearch = compile(r'<img.+?(/comics/.+?[jpg|gif|png])[\'|\"]>')
    prevSearch = compile(r'(/comics/index.php\?date=.+?)">.+?previous')
    help = 'Index format: yyyymmdd'


class Nekobox(BasicScraper):
    latestUrl = 'http://www.nekobox.org/'
    imageUrl = 'http://www.nekobox.org/?date=%s'
    imageSearch = compile(r"\'(/comic/.+?)\'")
    prevSearch = compile(r"\'(.+?)\'.+?img[^>].+?Previous")
    help = 'Index format: yyyy-mm-dd'


class NeoEarth(BasicScraper):
    latestUrl = 'http://www.neo-earth.com/latest.php'
    imageUrl = 'http://www.neo-earth.com/daily.php?date=%s'
    imageSearch = compile(r'(/comics/.+?)"')
    prevSearch = compile(r'first.+?(/daily.+?)".+?prev')
    help = 'Index format: yymmdd'


class Nervillsaga(BasicScraper):
    latestUrl = 'http://www.nervillsaga.com/'
    imageUrl = 'http://www.nervillsaga.com/index.php?s=%s'
    imageSearch = compile(r'"(pic/.+?)"')
    prevSearch = compile(r'"(.+?)">Previous')
    help = 'Index format: nnn'


class NewAdventuresOfBobbin(BasicScraper):
    latestUrl = 'http://bobbin-comic.com/'
    imageUrl = 'http://bobbin-comic.com/show.php?id=%s'
    imageSearch = compile(r'"(\./strips/.*?)"')
    prevSearch = compile(r'"(show.php\?[^"\r\n]+)">PREVIOUS')
    help = 'Index format: n (unpadded)'


class NewWorld(BasicScraper):
    latestUrl = 'http://www.tfsnewworld.com/'
    imageUrl = 'http://www.tfsnewworld.com/index.php?date=%s'
    imageSearch = compile(r'<(?:img|embed)[^>]+src="([^"]+/\w+/\d+\.[^"]+)"')
    prevSearch = compile(r'class="nav_back"[^>]+href="(/index\.php\?date=\d+)"')
    help = 'Index format: yyyymmdd'


class Nihilism(BasicScraper):
    latestUrl = 'http://nihilism.danseibi.net/'
    imageUrl = 'http://nihilism.danseibi.net/?date=%s'
    imageSearch = compile(r'"(strips/.+?)"')
    prevSearch = compile(r'"(.+?)">previous')
    help = 'Index format: yyyymmdd'


class NoNeedForBushido(BasicScraper):
    latestUrl = 'http://www.noneedforbushido.com/archive.php'
    imageUrl = 'http://www.noneedforbushido.com/archive.php?strip_id=%s'
    imageSearch = compile(r'"(istrip_files/strips/.+?)"')
    prevSearch = compile(r'</a><a href="(archive.php\?strip_id=.+?)".+?_back')
    help = 'Index format: nnn'


class Nukees(BasicScraper):
    latestUrl = 'http://www.nukees.com/'
    imageUrl = 'http://www.nukees.com/d/%s'
    imageSearch = compile(r'"comic".+?"(/comics/.+?)"')
    prevSearch = compile(r'"(/d/.+?)".+?previous')
    help = 'Index format: yyyymmdd.html'


class NuklearPower(BasicScraper):
    basePath = 'http://www.nuklearpower.com/'
    prevSearch = compile(r'<a href="(http://www\.nuklearpower\.com/daily\.php\?date=\d{6})" class="nav3">Previous Comic')


class NekoTheKitty(BasicScraper):
    basePath = 'http://www.nekothekitty.net/cusp/'
    prevSearch = compile(r"<a href=\"(http://www\.nekothekitty\.net/cusp/daily\.php\?date=\d+)\"><img[^>]+alt='Previous Comic'")


class NeoGreenwood(BasicScraper):
    basePath = 'http://neogreenwood.1upshop.com/'
    prevSearch = compile(r'<a href="(http://neogreenwood\.1upshop\.com/daily\.php\?date=\d{6})"><img src="http://neogreenwood.1upshop.com/nav/sbac.gif')


class NichtLustig(BasicScraper):
    imageUrl = 'http://www.nichtlustig.de/toondb/%s.html'
    imageSearch = compile(r'<img src="(\.\./comics/full/\d+\.\w+)"', IGNORECASE)
    prevSearch = compile(r'<a href="(\d+\.html)"[^<>]*><img[^<>]*title="zum vorherigen', IGNORECASE)
    help = 'Index format: yymmdd'
    starter = indirectStarter('http://www.nichtlustig.de/main.html',
                              compile(r'<a href = "([^"]*toondb/\d+\.html)"', IGNORECASE))


class NinthElsewhere(BasicScraper):
    latestUrl = 'http://www.9thelsewhere.com/icenter.html'
    imageUrl = 'http://www.9thelsewhere.com/%s/9e%s_%s.html'
    imageSearch = compile(r'<img src="([^"]*9e\d+_\d+\.jpg)"')
    prevSearch = compile(r'<a href="([^"]+\.html)">\s*PREV')
    help = 'Index format: year-chapter-page'

    def setStrip(self, index):
        self.currentUrl = self.imageUrl % tuple(map(int, index.split('-')))


class Nodwick(BasicScraper):
    imageUrl = None
    imageSearch = compile(r'<img src="(http://nodwick.humor.gamespy.com/gamespyarchive/strips/[^"]*)"', IGNORECASE)
    prevSearch = compile(r'<a href="(index.php\?date=[0-9-]*)"><img src="back.jpg"', IGNORECASE)
    starter = indirectStarter('http://nodwick.humor.gamespy.com/gamespyarchive/index.php', prevSearch)
    help = 'Index format: None'
