/* AssistantBackup.c generated by valac 0.12.1, the Vala compiler
 * generated from AssistantBackup.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 2 -*- */
/*
    This file is part of Déjà Dup.
    For copyright information, see AUTHORS.

    Déjà Dup is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Déjà Dup is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Déjà Dup.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <common.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdkx.h>
#include <X11/Xlib.h>
#include <X11/Xatom.h>
#include <X11/Xutil.h>
#include <X11/Xregion.h>
#include <glib/gi18n-lib.h>


#define TYPE_ASSISTANT (assistant_get_type ())
#define ASSISTANT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ASSISTANT, Assistant))
#define ASSISTANT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ASSISTANT, AssistantClass))
#define IS_ASSISTANT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ASSISTANT))
#define IS_ASSISTANT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ASSISTANT))
#define ASSISTANT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ASSISTANT, AssistantClass))

typedef struct _Assistant Assistant;
typedef struct _AssistantClass AssistantClass;
typedef struct _AssistantPrivate AssistantPrivate;

#define ASSISTANT_TYPE_PAGE_INFO (assistant_page_info_get_type ())
#define ASSISTANT_PAGE_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ASSISTANT_TYPE_PAGE_INFO, AssistantPageInfo))
#define ASSISTANT_PAGE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ASSISTANT_TYPE_PAGE_INFO, AssistantPageInfoClass))
#define ASSISTANT_IS_PAGE_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ASSISTANT_TYPE_PAGE_INFO))
#define ASSISTANT_IS_PAGE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ASSISTANT_TYPE_PAGE_INFO))
#define ASSISTANT_PAGE_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ASSISTANT_TYPE_PAGE_INFO, AssistantPageInfoClass))

typedef struct _AssistantPageInfo AssistantPageInfo;
typedef struct _AssistantPageInfoClass AssistantPageInfoClass;

#define TYPE_ASSISTANT_OPERATION (assistant_operation_get_type ())
#define ASSISTANT_OPERATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ASSISTANT_OPERATION, AssistantOperation))
#define ASSISTANT_OPERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ASSISTANT_OPERATION, AssistantOperationClass))
#define IS_ASSISTANT_OPERATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ASSISTANT_OPERATION))
#define IS_ASSISTANT_OPERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ASSISTANT_OPERATION))
#define ASSISTANT_OPERATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ASSISTANT_OPERATION, AssistantOperationClass))

typedef struct _AssistantOperation AssistantOperation;
typedef struct _AssistantOperationClass AssistantOperationClass;
typedef struct _AssistantOperationPrivate AssistantOperationPrivate;

#define TYPE_STATUS_ICON (status_icon_get_type ())
#define STATUS_ICON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_STATUS_ICON, StatusIcon))
#define STATUS_ICON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_STATUS_ICON, StatusIconClass))
#define IS_STATUS_ICON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_STATUS_ICON))
#define IS_STATUS_ICON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_STATUS_ICON))
#define STATUS_ICON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_STATUS_ICON, StatusIconClass))

typedef struct _StatusIcon StatusIcon;
typedef struct _StatusIconClass StatusIconClass;

#define TYPE_ASSISTANT_BACKUP (assistant_backup_get_type ())
#define ASSISTANT_BACKUP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ASSISTANT_BACKUP, AssistantBackup))
#define ASSISTANT_BACKUP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ASSISTANT_BACKUP, AssistantBackupClass))
#define IS_ASSISTANT_BACKUP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ASSISTANT_BACKUP))
#define IS_ASSISTANT_BACKUP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ASSISTANT_BACKUP))
#define ASSISTANT_BACKUP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ASSISTANT_BACKUP, AssistantBackupClass))

typedef struct _AssistantBackup AssistantBackup;
typedef struct _AssistantBackupClass AssistantBackupClass;
typedef struct _AssistantBackupPrivate AssistantBackupPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _Assistant {
	GtkWindow parent_instance;
	AssistantPrivate * priv;
	GtkImage* header_icon;
	GtkEventBox* page_box;
	GList* current;
};

struct _AssistantClass {
	GtkWindowClass parent_class;
};

struct _AssistantOperation {
	Assistant parent_instance;
	AssistantOperationPrivate * priv;
	StatusIcon* status_icon;
	gboolean succeeded;
	GtkLabel* summary_label;
	DejaDupOperation* op;
};

struct _AssistantOperationClass {
	AssistantClass parent_class;
	GtkWidget* (*make_confirm_page) (AssistantOperation* self);
	void (*add_setup_pages) (AssistantOperation* self);
	void (*add_custom_config_pages) (AssistantOperation* self);
	DejaDupOperation* (*create_op) (AssistantOperation* self);
	gchar* (*get_progress_file_prefix) (AssistantOperation* self);
	GtkWidget* (*make_progress_page) (AssistantOperation* self);
	void (*show_error) (AssistantOperation* self, const gchar* _error_, const gchar* detail);
	GtkWidget* (*make_summary_page) (AssistantOperation* self);
	void (*apply_finished) (AssistantOperation* self, DejaDupOperation* op, gboolean success, gboolean cancelled);
	void (*do_prepare) (AssistantOperation* self, Assistant* assist, GtkWidget* page);
	void (*do_cancel) (AssistantOperation* self);
	void (*do_close) (AssistantOperation* self);
};

struct _AssistantBackup {
	AssistantOperation parent_instance;
	AssistantBackupPrivate * priv;
};

struct _AssistantBackupClass {
	AssistantOperationClass parent_class;
};


static gpointer assistant_backup_parent_class = NULL;

GType assistant_get_type (void) G_GNUC_CONST;
static gpointer assistant_page_info_ref (gpointer instance);
static void assistant_page_info_unref (gpointer instance);
static GParamSpec* assistant_param_spec_page_info (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) G_GNUC_UNUSED;
static void assistant_value_set_page_info (GValue* value, gpointer v_object) G_GNUC_UNUSED;
static void assistant_value_take_page_info (GValue* value, gpointer v_object) G_GNUC_UNUSED;
static gpointer assistant_value_get_page_info (const GValue* value) G_GNUC_UNUSED;
static GType assistant_page_info_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
GType assistant_operation_get_type (void) G_GNUC_CONST;
GType status_icon_get_type (void) G_GNUC_CONST;
GType assistant_backup_get_type (void) G_GNUC_CONST;
enum  {
	ASSISTANT_BACKUP_DUMMY_PROPERTY
};
AssistantBackup* assistant_backup_new (gboolean automatic);
AssistantBackup* assistant_backup_construct (GType object_type, gboolean automatic);
static DejaDupOperation* assistant_backup_real_create_op (AssistantOperation* base);
void assistant_operation_ensure_status_icon (AssistantOperation* self, DejaDupOperation* o);
gboolean assistant_operation_get_automatic (AssistantOperation* self);
gboolean status_icon_get_show_automatic_progress (StatusIcon* self);
static void _lambda24_ (DejaDupOperation* op, gboolean first, AssistantBackup* self);
void assistant_operation_set_secondary_label (AssistantOperation* self, const gchar* text);
void assistant_operation_ask_passphrase (AssistantOperation* self, gboolean first);
static void __lambda24__deja_dup_operation_is_full (DejaDupOperation* _sender, gboolean first, gpointer self);
void assistant_hide_for_now (Assistant* self);
static void assistant_backup_do_resume (AssistantBackup* self);
void assistant_operation_hide_everything (AssistantOperation* self);
void assistant_operation_do_close (AssistantOperation* self);
static gchar* assistant_backup_real_get_progress_file_prefix (AssistantOperation* base);
static void assistant_backup_real_do_prepare (AssistantOperation* base, Assistant* assist, GtkWidget* page);
void assistant_operation_do_prepare (AssistantOperation* self, Assistant* assist, GtkWidget* page);
GtkWidget* assistant_operation_get_summary_page (AssistantOperation* self);
gboolean assistant_operation_get_error_occurred (AssistantOperation* self);
void assistant_set_page_title (Assistant* self, GtkWidget* page, const gchar* title);
static gboolean _lambda25_ (AssistantBackup* self);
static gboolean __lambda25__gsource_func (gpointer self);
GtkWidget* assistant_operation_get_progress_page (AssistantOperation* self);
static GObject * assistant_backup_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
void assistant_set_apply_text (Assistant* self, const gchar* value);
static void _assistant_backup_do_resume_assistant_resumed (Assistant* _sender, gpointer self);


AssistantBackup* assistant_backup_construct (GType object_type, gboolean automatic) {
	AssistantBackup * self = NULL;
	self = (AssistantBackup*) g_object_new (object_type, "automatic", automatic, NULL);
	return self;
}


AssistantBackup* assistant_backup_new (gboolean automatic) {
	return assistant_backup_construct (TYPE_ASSISTANT_BACKUP, automatic);
}


static void _lambda24_ (DejaDupOperation* op, gboolean first, AssistantBackup* self) {
	const gchar* _tmp0_ = NULL;
	g_return_if_fail (op != NULL);
	deja_dup_operation_set_use_progress (op, TRUE);
	if (first) {
		const gchar* _tmp1_ = NULL;
		_tmp1_ = _ ("Creating the first backup.  This may take a while.");
		_tmp0_ = _tmp1_;
	} else {
		const gchar* _tmp2_ = NULL;
		_tmp2_ = _ ("Creating a fresh backup to protect against backup corruption.  This wi" \
"ll take longer than normal.");
		_tmp0_ = _tmp2_;
	}
	assistant_operation_set_secondary_label ((AssistantOperation*) self, _tmp0_);
	if (first) {
		assistant_operation_ask_passphrase ((AssistantOperation*) self, first);
	}
}


static void __lambda24__deja_dup_operation_is_full (DejaDupOperation* _sender, gboolean first, gpointer self) {
	_lambda24_ (_sender, first, self);
}


static DejaDupOperation* assistant_backup_real_create_op (AssistantOperation* base) {
	AssistantBackup * self;
	DejaDupOperation* result = NULL;
	GdkWindow* _tmp0_ = NULL;
	Window _tmp1_;
	Window xid;
	DejaDupOperationBackup* _tmp2_ = NULL;
	DejaDupOperationBackup* rv;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_;
	gboolean _tmp7_;
	self = (AssistantBackup*) base;
	gtk_widget_realize ((GtkWidget*) self);
	_tmp0_ = gtk_widget_get_window ((GtkWidget*) self);
	_tmp1_ = gdk_x11_window_get_xid (_tmp0_);
	xid = _tmp1_;
	_tmp2_ = deja_dup_operation_backup_new ((guint) xid);
	rv = _tmp2_;
	assistant_operation_ensure_status_icon ((AssistantOperation*) self, (DejaDupOperation*) rv);
	_tmp4_ = assistant_operation_get_automatic ((AssistantOperation*) self);
	if (_tmp4_) {
		gboolean _tmp5_ = FALSE;
		if (((AssistantOperation*) self)->status_icon == NULL) {
			_tmp5_ = TRUE;
		} else {
			gboolean _tmp6_;
			_tmp6_ = status_icon_get_show_automatic_progress (((AssistantOperation*) self)->status_icon);
			_tmp5_ = !_tmp6_;
		}
		_tmp3_ = _tmp5_;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		deja_dup_operation_set_use_progress ((DejaDupOperation*) rv, FALSE);
	}
	g_signal_connect_object ((DejaDupOperation*) rv, "is-full", (GCallback) __lambda24__deja_dup_operation_is_full, self, 0);
	_tmp7_ = assistant_operation_get_automatic ((AssistantOperation*) self);
	if (_tmp7_) {
		assistant_hide_for_now ((Assistant*) self);
	} else {
		gtk_widget_show_all ((GtkWidget*) self);
	}
	result = (DejaDupOperation*) rv;
	return result;
}


static void assistant_backup_do_resume (AssistantBackup* self) {
	g_return_if_fail (self != NULL);
	assistant_operation_hide_everything ((AssistantOperation*) self);
	if (((AssistantOperation*) self)->op != NULL) {
		deja_dup_operation_stop (((AssistantOperation*) self)->op);
	} else {
		((AssistantOperation*) self)->succeeded = TRUE;
		assistant_operation_do_close ((AssistantOperation*) self);
	}
}


static gchar* assistant_backup_real_get_progress_file_prefix (AssistantOperation* base) {
	AssistantBackup * self;
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	self = (AssistantBackup*) base;
	_tmp0_ = _ ("Backing up:");
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}


static gboolean _lambda25_ (AssistantBackup* self) {
	gboolean result = FALSE;
	assistant_operation_do_close ((AssistantOperation*) self);
	result = FALSE;
	return result;
}


static gboolean __lambda25__gsource_func (gpointer self) {
	gboolean result;
	result = _lambda25_ (self);
	return result;
}


static void assistant_backup_real_do_prepare (AssistantOperation* base, Assistant* assist, GtkWidget* page) {
	AssistantBackup * self;
	GtkWidget* _tmp0_ = NULL;
	self = (AssistantBackup*) base;
	g_return_if_fail (assist != NULL);
	g_return_if_fail (page != NULL);
	ASSISTANT_OPERATION_CLASS (assistant_backup_parent_class)->do_prepare (ASSISTANT_OPERATION (self), assist, page);
	_tmp0_ = assistant_operation_get_summary_page ((AssistantOperation*) self);
	if (page == _tmp0_) {
		gboolean _tmp1_;
		_tmp1_ = assistant_operation_get_error_occurred ((AssistantOperation*) self);
		if (_tmp1_) {
			const gchar* _tmp2_ = NULL;
			_tmp2_ = _ ("Backup Failed");
			assistant_set_page_title ((Assistant*) self, page, _tmp2_);
		} else {
			g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, __lambda25__gsource_func, g_object_ref (self), g_object_unref);
		}
	} else {
		GtkWidget* _tmp3_ = NULL;
		_tmp3_ = assistant_operation_get_progress_page ((AssistantOperation*) self);
		if (page == _tmp3_) {
			const gchar* _tmp4_ = NULL;
			_tmp4_ = _ ("Backing Up…");
			assistant_set_page_title ((Assistant*) self, page, _tmp4_);
		}
	}
}


static void _assistant_backup_do_resume_assistant_resumed (Assistant* _sender, gpointer self) {
	assistant_backup_do_resume (self);
}


static GObject * assistant_backup_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	AssistantBackup * self;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	parent_class = G_OBJECT_CLASS (assistant_backup_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = ASSISTANT_BACKUP (obj);
	_tmp0_ = C_ ("back up is verb", "Back Up");
	gtk_window_set_title ((GtkWindow*) self, _tmp0_);
	_tmp1_ = C_ ("back up is verb", "_Back Up");
	assistant_set_apply_text ((Assistant*) self, _tmp1_);
	g_signal_connect_object ((Assistant*) self, "resumed", (GCallback) _assistant_backup_do_resume_assistant_resumed, self, 0);
	return obj;
}


static void assistant_backup_class_init (AssistantBackupClass * klass) {
	assistant_backup_parent_class = g_type_class_peek_parent (klass);
	ASSISTANT_OPERATION_CLASS (klass)->create_op = assistant_backup_real_create_op;
	ASSISTANT_OPERATION_CLASS (klass)->get_progress_file_prefix = assistant_backup_real_get_progress_file_prefix;
	ASSISTANT_OPERATION_CLASS (klass)->do_prepare = assistant_backup_real_do_prepare;
	G_OBJECT_CLASS (klass)->constructor = assistant_backup_constructor;
}


static void assistant_backup_instance_init (AssistantBackup * self) {
}


GType assistant_backup_get_type (void) {
	static volatile gsize assistant_backup_type_id__volatile = 0;
	if (g_once_init_enter (&assistant_backup_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (AssistantBackupClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) assistant_backup_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AssistantBackup), 0, (GInstanceInitFunc) assistant_backup_instance_init, NULL };
		GType assistant_backup_type_id;
		assistant_backup_type_id = g_type_register_static (TYPE_ASSISTANT_OPERATION, "AssistantBackup", &g_define_type_info, 0);
		g_once_init_leave (&assistant_backup_type_id__volatile, assistant_backup_type_id);
	}
	return assistant_backup_type_id__volatile;
}



