#include <iostream>

#include <boost/bind.hpp>
#include <boost/thread/thread.hpp>

#include <list>
#include <string>

#include "rpcdriver.h"

using namespace rpc;
using namespace std;

rpc::RpcDriver* rd;

class HelloHandler : public RpcCommandHandler
{
public:
	HelloHandler(const std::string& cmdName) : RpcCommandHandler(cmdName,
																 NULL,
																 1) {}
	virtual void handleCommand( int clientId, 
								const std::list<boost::any>& params )
{


std::cout << "Handle hello" << std::endl;
// Send a reply

	rpc::CmdPtr cmd(new list<boost::any>);
	cmd->push_back( string("hoho") );
	list<boost::any> list1;
	for(int i = 0; i < 10;i++) {
		list<boost::any> list2;
		for(int j=0;j<5;j++) list2.push_back( i*j );
		list1.push_back(list2);
	}
	cmd->push_back( 10 );
	cmd->push_back( list1 );
	rd->queueCommand( -1, cmd );
}
};

int main (int argc, char * const argv[]) {
	
	try {
		
		// Create instance of RpcDriver
		rpc::RpcServerDriver driver( 6161 );
		rd = &driver;
		std::cout << "Server started." << std::endl;
			
		RpcCommandHandlerPtr hptr(new HelloHandler("hello"));
		driver.registerCommand(hptr);
		
		driver.waitForCompletion();
	}
	catch(...) {
		std::cout << "Exception reached all the way to end of main";
	}
    return 0;
}
