/*  beef - Flexible Brainfuck interpreter
 *  Copyright (C) 2005-2007  KiyuKo <eof AT kiyuko DOT org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 *  Homepage: http://www.kiyuko.org/beef
 */

#include "beef.h"

void code_dump (struct instruction *code, long indent)
{
  long i;

  while (code->type != ']') {
    switch (code->type) {
      case '[':
          code_dump (code->loop, indent + 1);
        break;
      default:
          for (i = 0; i < indent; i++)
            printf ("\t");
          printf ("%c (%ld)\n", code->type, code->quantity);
        break;
    }
    if (code->type != ']')
      code = code->next;
  }
}

