/*******************************************************************************
 * Copyright (c) 2000, 2009 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.aspectj.org.eclipse.jdt.internal.compiler.lookup;

import org.aspectj.org.eclipse.jdt.internal.compiler.env.ICompilationUnit;

public class SourceTypeCollisionException extends RuntimeException {
	private static final long serialVersionUID = 4798247636899127380L;

	public ICompilationUnit[] newAnnotationProcessorUnits;
	/**
	 * Javadoc on {@link javax.annotation.processing.RoundEnvironment#processingOver()} claims that
	 * types generated by last round of annotation processing should not be subject to a subsequent rounds
	 * of annotation processing. So this flag have to be added to handle last round of annotation processing gracefully.
	 */
	public boolean afterLastAnnotationProcessingRound = false;
}
