![banner](https://raw.githubusercontent.com/androguard/androguard/master/assets/CI/banner.png)

# Androguard

[![Build Status](https://travis-ci.org/androguard/androguard.svg?branch=master)](https://travis-ci.org/androguard/androguard)
[![Documentation Status](https://readthedocs.org/projects/androguard/badge/?version=latest)](http://androguard.readthedocs.io/en/latest/?badge=latest)
[![PyPI version](https://badge.fury.io/py/androguard.svg)](https://badge.fury.io/py/androguard)
[![Codecoverage](https://codecov.io/gh/androguard/androguard/branch/master/graph/badge.svg)](https://codecov.io/gh/androguard/androguard/)

```
pip install -U androguard
```
... let's start reversing!

## Features

Androguard is a full python tool to play with Android files.

* DEX, ODEX
* APK
* Android's binary xml
* Android resources
* Disassemble DEX/ODEX bytecodes
* Decompiler for DEX/ODEX files

## Authors: Androguard Team

Androguard + tools: Anthony Desnos (desnos at t0t0.fr).

DAD (DAD is A Decompiler): Geoffroy Gueguen (geoffroy dot gueguen at gmail dot com)

## Documentation

Find the documentation for master on [ReadTheDocs](http://androguard.readthedocs.io/en/latest/).

There are some (probably broken/outdated) examples and demos in the folders [demos](https://github.com/androguard/androguard/tree/master/demos) and [examples](https://github.com/androguard/androguard/tree/master/examples).

## Projects using Androguard
In alphabetical order

* [AndroPyTool](https://github.com/alexMyG/AndroPyTool)
* [AppKnox](http://appknox.com)
* [Cuckoo Sandbox](https://cuckoosandbox.org)
* [Droidbot](https://github.com/honeynet/droidbot)
* [Droidstatx](https://github.com/integrity-sa/droidstatx)
* [εxodus](https://github.com/Exodus-Privacy/exodus)
* [F-Droid Server](https://gitlab.com/fdroid/fdroidserver)
* [gplaycli](https://github.com/matlink/gplaycli)
* [Koodous](https://koodous.com)
* [MobSF](https://github.com/MobSF/Mobile-Security-Framework-MobSF)
* [qiew](https://github.com/mtivadar/qiew)
* [Viper Framework](https://github.com/viper-framework/viper)
* ... and many more!

You are using Androguard and are not listed here? Just create a [ticket](https://github.com/androguard/androguard/issues) or send us a [pull request](https://github.com/androguard/androguard/pulls) with your project!

## Licenses

### Androguard

Copyright (C) 2012 - 2016, Anthony Desnos (desnos at t0t0.fr)
All rights reserved.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS-IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

### DAD

Copyright (C) 2012 - 2016, Geoffroy Gueguen (geoffroy dot gueguen at gmail dot com)
All rights reserved.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS-IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
