Feature: W0583

  W0583 detects that arguments specified to call the function does not match
  with the corresponding function-definition appears after the function-call.

  Scenario: array as an argument
    Given a target source named "W0583.c" with:
      """
      int main(void)
      {
          int a[] = { 0, 1, 2 };
          return foo(a);
      }

      int foo(const int *p) { /* W0583 should not be output */
          return *p;
      }
      """
    When I successfully run `adlint W0583.c` on noarch
    Then the output should not match with /4:.*:W0583/
    And the output should exactly match with:
      | mesg  | line | column |
      | W0109 | 4    | 15     |
      | W0117 | 7    | 5      |
      | W0422 | 8    | 12     |
      | W0104 | 7    | 20     |
      | W0589 | 7    | 5      |
      | W0591 | 7    | 5      |

# vim:ts=2:sw=2:sts=2:et:
