#include <iostream>

#include "Message.hh"
#include "CommandlineOptions.hh"

#include "Global.hh"
#include "Message.hh"
#include "Symmetry.hh"
#include "PointConfiguration.hh"

int main (const int argc, const char** argv) {
  using namespace topcom;

  CommandlineOptions::init(argc, argv);
  MessageStreams::forced() << std::endl;
  MessageStreams::forced() << "------------------------------------------------------------------\n";
  MessageStreams::forced() << " pretty-printing a point configuration \n";
  MessageStreams::forced() << " TOPCOM client: " << CommandlineOptions::client() << '\n';
  MessageStreams::forced() << "------------------------------------------------------------------\n";
  MessageStreams::forced() << std::endl;
  PointConfiguration points;
  if (points.read(std::cin)) {
    MessageStreams::verbose() << "read points " << points << std::endl;
    if (CommandlineOptions::preprocess_points()) {
      Symmetry sym (points.no());
      points.preprocess(sym);
    }
    SymmetryGroup symmetries(points.no());
    if (!CommandlineOptions::ignore_symmetries()) {
      if (symmetries.read_generators(std::cin)) {
	MessageStreams::verbose() << symmetries.generators().size() + 1 << " symmetry generators in total." << std::endl;
	MessageStreams::debug() << "symmetry generators:" << std::endl;
	symmetries.write_generators(MessageStreams::debug());
	MessageStreams::debug() << std::endl;
      }
    }
    else {
      MessageStreams::verbose() << "no valid symmetry generators found." << std::endl;
    }
    MessageStreams::result() << "points:" << std::endl;
    points.pretty_print(MessageStreams::result());
    MessageStreams::result() << std::endl;
    MessageStreams::result() << "symmetry generators:" << std::endl;
    symmetries.pretty_print_sorted_generators(MessageStreams::result());
    return 0;
  }
  else {
    return 1;
  }
}

// eof points2prettyprint.cc
