 #!/bin/sh
#
# tardy - a tar post-processor
# Copyright (C) 2011 Peter Miller
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or (at
# your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program. If not, see <http://www.gnu.org/licenses/>.
#

TEST_SUBJECT="ustar output"
. test_prelude

cat > test.ok << 'fubar'
00000000: 73 6E 6F 74 2F 00 00 00 00 00 00 00 00 00 00 00  snot/...........
00000010: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................
00000020: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................
00000030: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................
00000040: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................
00000050: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................
00000060: 00 00 00 00 30 30 30 30 37 35 35 00 30 30 30 30  ....0000755.0000
00000070: 30 30 30 00 30 30 30 30 30 30 30 00 30 30 30 30  000.0000000.0000
00000080: 30 30 30 30 30 30 30 00 30 30 30 30 30 32 35 30  0000000.00000250
00000090: 36 30 30 00 30 30 31 31 32 36 34 00 35 00 00 00  600.0011264.5...
000000A0: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................
000000B0: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................
000000C0: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................
000000D0: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................
000000E0: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................
000000F0: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................
00000100: 00 75 73 74 61 72 00 30 30 72 6F 6F 74 00 00 00  .ustar.00root...
00000110: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................
00000120: 00 00 00 00 00 00 00 00 00 72 6F 6F 74 00 00 00  .........root...
00000130: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................
00000140: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................
00000150: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................
00000160: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................
00000170: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................
00000180: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................
00000190: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................
000001A0: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................
000001B0: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................
000001C0: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................
000001D0: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................
000001E0: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................
000001F0: 00 00 00 00 00 00 00 00 00 00 00 00 74 61 72 00  ............tar.
00000200: 73 6E 6F 74 2F 66 00 00 00 00 00 00 00 00 00 00  snot/f..........
00000210: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................
00000220: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................
00000230: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................
00000240: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................
00000250: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................
00000260: 00 00 00 00 30 30 30 30 36 34 34 00 30 30 30 30  ....0000644.0000
00000270: 30 30 30 00 30 30 30 30 30 30 30 00 30 30 30 30  000.0000000.0000
00000280: 30 30 30 30 30 30 35 00 30 30 30 30 30 32 35 30  0000005.00000250
00000290: 36 30 30 00 30 30 31 31 34 32 37 00 30 00 00 00  600.0011427.0...
000002A0: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................
000002B0: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................
000002C0: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................
000002D0: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................
000002E0: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................
000002F0: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................
00000300: 00 75 73 74 61 72 00 30 30 72 6F 6F 74 00 00 00  .ustar.00root...
00000310: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................
00000320: 00 00 00 00 00 00 00 00 00 72 6F 6F 74 00 00 00  .........root...
00000330: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................
00000340: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................
00000350: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................
00000360: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................
00000370: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................
00000380: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................
00000390: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................
000003A0: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................
000003B0: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................
000003C0: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................
000003D0: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................
000003E0: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................
000003F0: 00 00 00 00 00 00 00 00 00 00 00 00 74 61 72 00  ............tar.
00000400: 68 61 68 61 0A 00 00 00 00 00 00 00 00 00 00 00  haha............
00000410: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................
00000420: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................
00000430: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................
00000440: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................
00000450: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................
00000460: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................
00000470: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................
00000480: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................
00000490: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................
000004A0: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................
000004B0: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................
000004C0: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................
000004D0: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................
000004E0: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................
000004F0: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................
00000500: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................
00000510: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................
00000520: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................
00000530: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................
00000540: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................
00000550: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................
00000560: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................
00000570: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................
00000580: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................
00000590: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................
000005A0: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................
000005B0: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................
000005C0: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................
000005D0: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................
000005E0: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................
000005F0: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00  ................
fubar
if test $? -ne 0 ; then no_result; fi

mkdir snot || no_result
echo haha > snot/f || no_result
tar cf snot.tar snot || no_result

#
# test the ustar output functionality
#
tardy -auto-test --ofmt=ustar --hexdump snot.tar test.out
if test $? -ne 0 ; then fail; fi

diff test.ok test.out || fail

#
# Only definite negatives are possible.
# The functionality exercised by this test appears to work,
# no other guarantees are made.
#
pass
