# 2022-11-22 Triage Log

A fairly quiet week with regressions unfortunately slightly outweighing improvements. There was not any particular change of much note. Many of the regressions were justifiable since they were for critical bug fixes.

Triage done by **@rylev**.
Revision range: [96ddd32c..a78c9bee](https://perf.rust-lang.org/?start=96ddd32c4bfb1d78f0cd03eb068b1710a8cebeef&end=a78c9bee4d9d51a3891bd8ecae1f28a93b83653b&absolute=false&stat=instructions%3Au)

**Summary**:

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.7%  | [0.2%, 3.0%]   | 76    |
| Regressions ❌ <br /> (secondary)  | 1.5%  | [0.3%, 8.4%]   | 69    |
| Improvements ✅ <br /> (primary)   | -0.7% | [-1.8%, -0.2%] | 18    |
| Improvements ✅ <br /> (secondary) | -1.4% | [-3.2%, -0.2%] | 35    |
| All ❌✅ (primary)                 | 0.4%  | [-1.8%, 3.0%]  | 94    |


7 Regressions, 4 Improvements, 6 Mixed; 5 of them in rollups
47 artifact comparisons made in total

#### Regressions

Rollup of 13 pull requests [#104428](https://github.com/rust-lang/rust/pull/104428) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=101e1822c3e54e63996c8aaa014d55716f3937eb&end=ca92d90b5917e7176d5ff06607a2cd5352c088d3&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 1.2% | [0.3%, 3.3%] | 14    |
| Regressions ❌ <br /> (secondary)  | 2.1% | [0.3%, 3.3%] | 23    |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 1.2% | [0.3%, 3.3%] | 14    |
- [Justification](https://github.com/rust-lang/rust/pull/104404#issuecomment-1317574300) for this regression was posted #104404. Effectively this regression is taking us back to the baseline. 


Perform simple scalar replacement of aggregates (SROA) MIR opt [#102570](https://github.com/rust-lang/rust/pull/102570) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=a00f8ba7fcac1b27341679c51bf5a3271fa82df3&end=79146baa9c7e00b716cc41f8660a56cd2acdf8bd&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.2%  | [0.2%, 0.2%]   | 2     |
| Regressions ❌ <br /> (secondary)  | 0.4%  | [0.2%, 0.8%]   | 6     |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -1.4% | [-1.4%, -1.4%] | 1     |
| All ❌✅ (primary)                 | 0.2%  | [0.2%, 0.2%]   | 2     |
- [#104404](https://github.com/rust-lang/rust/pull/104404) is the cause of the regression.


Attempt to reuse `Vec<T>` backing storage for `Rc/Arc<[T]>` [#104205](https://github.com/rust-lang/rust/pull/104205) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=7c75fe4c8547c276574cacb144919d67fd8ab302&end=36db030a7c3c51cb4484cbd8c8daebcf5057d61c&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -    | -            | 0     |
| Regressions ❌ <br /> (secondary)  | 0.4% | [0.1%, 1.4%] | 16    |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | -    | -            | 0     |
- This was reverted in [#104571](https://github.com/rust-lang/rust/pull/104571).


Rollup of 11 pull requests [#104555](https://github.com/rust-lang/rust/pull/104555) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=30117a1dbb843da1d5ab1258e89a3ed0b1940475&end=9d46c7a3e69966782e163877151c1f0cea8b630a&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.4% | [0.4%, 0.5%] | 2     |
| Regressions ❌ <br /> (secondary)  | 1.3% | [1.3%, 1.3%] | 2     |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.4% | [0.4%, 0.5%] | 2     |
- `externs` is noisy at the moment, and the two `doc` regressions for `syn` and `webrender` are small enough to not worry about.


Rollup of 8 pull requests [#104600](https://github.com/rust-lang/rust/pull/104600) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=becc24a23aed2639db3b78acd93ec6d553898583&end=2f8d8040166a730d0da7bba0f2864f0ef7ff6364&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.4% | [0.2%, 0.7%] | 3     |
| Regressions ❌ <br /> (secondary)  | 6.1% | [1.3%, 8.8%] | 3     |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.4% | [0.2%, 0.7%] | 3     |
- #104411 seems to be causing most of this. 
- The regressions are few enough in number that I don't think this is necessarily worth looking into.

Revert Vec/Rc storage reuse opt [#104571](https://github.com/rust-lang/rust/pull/104571) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=5e6de2369c82ed0b36e6b651b041bad5cb5e1ef8&end=62c627c7a3a9b3e193a5ae6e1ec7348bc5136301&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.5% | [0.4%, 0.5%] | 5     |
| Regressions ❌ <br /> (secondary)  | 1.2% | [1.2%, 1.2%] | 2     |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.5% | [0.4%, 0.5%] | 5     |
- This removes a recently-merged optimization that caused CI failures because it doesn't work reliably on all platforms.


Clean up and harden various methods around trait substs [#104533](https://github.com/rust-lang/rust/pull/104533) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=b7bc90fea3b441234a84b49fdafeb75815eebbab&end=28a53cdb4695b71cb9ee39959df88542056479cd&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.3%  | [0.2%, 0.5%]   | 11    |
| Regressions ❌ <br /> (secondary)  | 0.6%  | [0.2%, 0.9%]   | 27    |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -0.3% | [-0.3%, -0.3%] | 1     |
| All ❌✅ (primary)                 | 0.3%  | [0.2%, 0.5%]   | 11    |
- Currently being investigated by @oli-obk in [#104709](https://github.com/rust-lang/rust/pull/104709)


#### Improvements

Merge basic blocks where possible when generating LLVM IR. [#103138](https://github.com/rust-lang/rust/pull/103138) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=bebd57a9602e48431c90274fbf7d96683b0708b6&end=251831ece9601d64172127b6caae9087358c2386&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.8% | [-1.4%, -0.4%] | 6     |
| Improvements ✅ <br /> (secondary) | -0.3% | [-0.3%, -0.2%] | 2     |
| All ❌✅ (primary)                 | -0.8% | [-1.4%, -0.4%] | 6     |


Record `LocalDefId` in HIR nodes instead of a side table [#104170](https://github.com/rust-lang/rust/pull/104170) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=9340e5c1b9dee53fd32a18f7bfb54faabfe00b7b&end=7c75fe4c8547c276574cacb144919d67fd8ab302&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.3% | [-0.3%, -0.2%] | 4     |
| Improvements ✅ <br /> (secondary) | -1.1% | [-2.3%, -0.6%] | 12    |
| All ❌✅ (primary)                 | -0.3% | [-0.3%, -0.2%] | 4     |


Remove allow(rustc::potential_query_instability) from rustc_ast_lowering [#104330](https://github.com/rust-lang/rust/pull/104330) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=9d46c7a3e69966782e163877151c1f0cea8b630a&end=fd3bfb35511cbcff59ce1454d3db627b576d7e92&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -0.6% | [-1.3%, -0.3%] | 6     |
| All ❌✅ (primary)                 | -     | -              | 0     |


Factor out `conservative_is_privately_uninhabited` [#103454](https://github.com/rust-lang/rust/pull/103454) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=ccde51a912e89478a649dc9e64b5584a5971f75f&end=736c675d2ab65bcde6554e1b73340c2dbc27c85a&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.4% | [-0.9%, -0.2%] | 22    |
| Improvements ✅ <br /> (secondary) | -0.7% | [-0.7%, -0.7%] | 2     |
| All ❌✅ (primary)                 | -0.4% | [-0.9%, -0.2%] | 22    |


#### Mixed

Rollup of 9 pull requests [#104437](https://github.com/rust-lang/rust/pull/104437) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=357f66072959f494d5fa2e6a269c6100eed703c1&end=6d651a295e0e0c331153288b10b78344a4ede20b&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.3%  | [0.2%, 0.4%]   | 4     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -0.3% | [-0.3%, -0.3%] | 1     |
| All ❌✅ (primary)                 | 0.3%  | [0.2%, 0.4%]   | 4     |
- Too small a regression for us to investigate this rollup (this is just barely passing the mark for being considered significant).


Use `token::Lit` in `ast::ExprKind::Lit`. [#102944](https://github.com/rust-lang/rust/pull/102944) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=e9493d63c2a57b91556dccd219e21821432c7445&end=bebd57a9602e48431c90274fbf7d96683b0708b6&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.3%  | [0.2%, 0.7%]   | 16    |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.2% | [-0.2%, -0.2%] | 1     |
| Improvements ✅ <br /> (secondary) | -0.5% | [-1.0%, -0.3%] | 10    |
| All ❌✅ (primary)                 | 0.3%  | [-0.2%, 0.7%]  | 17    |
- The wins and losses roughly balance out. Also, this will enable some additional improvements by shrinking the size of `ast::Expr`.


x86_64 SSE2 fast-path for str.contains(&str) and short needles [#103779](https://github.com/rust-lang/rust/pull/103779) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=251831ece9601d64172127b6caae9087358c2386&end=9340e5c1b9dee53fd32a18f7bfb54faabfe00b7b&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.4%  | [0.3%, 0.6%]   | 4     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.4% | [-0.5%, -0.3%] | 5     |
| Improvements ✅ <br /> (secondary) | -1.0% | [-1.3%, -0.6%] | 4     |
| All ❌✅ (primary)                 | -0.1% | [-0.5%, 0.6%]  | 9     |
- A few wins, a few losses, it roughly balances out.


Shrink `ast::Expr` harder [#101562](https://github.com/rust-lang/rust/pull/101562) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=fd3bfb35511cbcff59ce1454d3db627b576d7e92&end=70fe5f08fffd16dc20506f7d140e47b074f77964&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.4%  | [0.2%, 0.8%]   | 10    |
| Regressions ❌ <br /> (secondary)  | 0.4%  | [0.1%, 0.7%]   | 10    |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -0.3% | [-0.6%, -0.2%] | 13    |
| All ❌✅ (primary)                 | 0.4%  | [0.2%, 0.8%]   | 10    |
- Instruction count results are mixed. But the real results are for cycles and wall-time, which show lots of improvements.


Revert "Normalize opaques with escaping bound vars" [#103509](https://github.com/rust-lang/rust/pull/103509) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=2f8d8040166a730d0da7bba0f2864f0ef7ff6364&end=5e6de2369c82ed0b36e6b651b041bad5cb5e1ef8&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | 0.6%  | [0.3%, 0.8%]   | 3     |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -1.6% | [-2.2%, -0.3%] | 6     |
| All ❌✅ (primary)                 | -     | -              | 0     |
- This is a necessary fix for a compiler hang. Additionally the improvements outweigh the regressions and this is all confined to secondary benchmarks.


Rollup of 6 pull requests [#104646](https://github.com/rust-lang/rust/pull/104646) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=911cbf8e46f0f3b044c87fc5cbca922878db757b&end=a28f3c88e50a77bc2a91889241248c4543854e61&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.7%  | [0.4%, 0.9%]   | 7     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -1.4% | [-2.1%, -0.4%] | 9     |
| All ❌✅ (primary)                 | 0.7%  | [0.4%, 0.9%]   | 7     |
- Regressions are noise
