// Copyright 2019 The Fuchsia Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#[macro_use]
extern crate zerocopy;

fn main() {}

// These tests cause errors which are generated by a later compilation pass than
// the other errors we generate, and so if they're compiled in the same file,
// the compiler will never get to that pass, and so we won't get the errors.

//
// FromBytes errors
//

#[derive(FromBytes)]
struct FromBytes1 {
    not_from_bytes: &'static str,
}

//
// AsBytes errors
//

#[derive(AsBytes)]
#[repr(C)]
struct AsBytes1 {
    a: u8,
    b: u16,
}

//
// Unaligned errors
//


#[derive(Unaligned)]
#[repr(C)]
struct Unaligned1 {
    aligned: u16,
}

// This specifically tests a bug we had in an old version of the code in which
// the trait bound would only be enforced for the first field's type.
#[derive(Unaligned)]
#[repr(C)]
struct Unaligned2 {
    unaligned: u8,
    aligned: u16,
}

#[derive(Unaligned)]
#[repr(transparent)]
struct Unaligned3 {
    aligned: u16,
}