NFS_SYSCONFIG="/etc/sysconfig/nfs"
NFS_SYSCONFIG_LOCAL_BACKUP="/etc/sysconfig/nfs.ha.bu"
NFS_SYSCONFIG_AUTOGEN_TAG="AUTOGENERATED by $0 high availability resource-agent"

nfsserver_redhat_meta_data() {
cat<<EOF
<parameter name="nfsd_args" unique="0" required="0">
<longdesc lang="en">
Specifies what arguments to pass to the nfs daemon on startup. View the rpc.nfsd man page for information on what arguments are available.
Note that setting this value will override all settings placed in the local /etc/sysconfig/nfs file.
</longdesc>
<shortdesc lang="en">
rpc.nfsd options
</shortdesc>
<content type="string" />
</parameter>

<parameter name="lockd_udp_port" unique="0" required="0">
<longdesc lang="en">
The udp port lockd should listen on.
Note that setting this value will override all settings placed in the local /etc/sysconfig/nfs file.
</longdesc>
<shortdesc lang="en">
lockd udp port
</shortdesc>
<content type="integer" />
</parameter>

<parameter name="lockd_tcp_port" unique="0" required="0">
<longdesc lang="en">
The tcp port lockd should listen on.
Note that setting this value will override all settings placed in the local /etc/sysconfig/nfs file.
</longdesc>
<shortdesc lang="en">
lockd tcp port
</shortdesc>
<content type="integer" />
</parameter>

<parameter name="statd_outgoing_port" unique="0" required="0">
<longdesc lang="en">
The source port number sm-notify uses when sending reboot notifications.
Note that setting this value will override all settings placed in the local /etc/sysconfig/nfs file.
</longdesc>
<shortdesc lang="en">
sm-notify source port
</shortdesc>
<content type="integer" />
</parameter>

<parameter name="statd_port" unique="0" required="0">
<longdesc lang="en">
The port number used for RPC listener sockets.
Note that setting this value will override all settings placed in the local /etc/sysconfig/nfs file.
</longdesc>
<shortdesc lang="en">
rpc.statd listener port
</shortdesc>
<content type="integer" />
</parameter>

<parameter name="mountd_port" unique="0" required="0">
<longdesc lang="en">
The port number used for rpc.mountd listener sockets.
Note that setting this value will override all settings placed in the local /etc/sysconfig/nfs file.
</longdesc>
<shortdesc lang="en">
rpc.mountd listener port
</shortdesc>
<content type="integer" />
</parameter>

<parameter name="rquotad_port" unique="0" required="0">
<longdesc lang="en">
The port number used for rpc.rquotad.
Note that setting this value will override all settings placed in the local /etc/sysconfig/nfs file.
</longdesc>
<shortdesc lang="en">
rpc.rquotad port
</shortdesc>
<content type="integer" />
</parameter>
EOF
}

set_arg()
{
	local key="$1"
	local value="$2"
	local file="$3"
	local requires_sysconfig="$4"

	if [ -z "$value" ]; then
		return
	fi

	# only write to the tmp /etc/sysconfig/nfs if sysconfig exists.
	# otherwise this distro does not support setting these options.
	if [ -d "/etc/sysconfig" ]; then
		# replace if the value exists, append otherwise
		if grep "^\s*${key}=" $file ; then
			sed -i "s/\s*${key}=.*$/${key}=\"${value}\"/" $file
		else
			echo "${key}=\"${value}\"" >> $file
		fi
	elif [ "$requires_sysconfig" = "true" ]; then
		ocf_log warn "/etc/sysconfig/nfs not found, unable to set port and nfsd args."
	fi

	export ${key}="${value}"
}

set_env_args()
{
	local tmpconfig=$(mktemp ${HA_RSCTMP}/nfsserver-tmp-XXXXX)
	local statd_args

	if [ -f "$NFS_SYSCONFIG" ]; then
		## Take the $NFS_SYSCONFIG file as our skeleton
		cp $NFS_SYSCONFIG $tmpconfig
	fi

	# nfsd args
	set_arg "RPCNFSDARGS" "$OCF_RESKEY_nfsd_args" "$tmpconfig" "true"

	# mountd args
	if [ -n "$OCF_RESKEY_mountd_port" ]; then
		set_arg "RPCMOUNTDOPTS" "-p $OCF_RESKEY_mountd_port" "$tmpconfig" "true"
	fi

	# statd args. we always want to perform the notify using sm-notify after
	# both rpc.statd and the nfsd daemons are initialized
	statd_args="--no-notify"
	if [ -n "$OCF_RESKEY_statd_outgoing_port" ]; then
		statd_args="$statd_args -o $OCF_RESKEY_statd_outgoing_port"
	fi
	if [ -n "$OCF_RESKEY_statd_port" ]; then
		statd_args="$statd_args -p $OCF_RESKEY_statd_port"
	fi
	set_arg "STATDARG" "$statd_args" "$tmpconfig" "false"

	# lockd ports
	set_arg "LOCKD_UDPPORT" "$OCF_RESKEY_lockd_udp_port" "$tmpconfig" "true"
	set_arg "LOCKD_TCPPORT" "$OCF_RESKEY_lockd_tcp_port" "$tmpconfig" "true"

	# rquotad_port
	if [ -n "$OCF_RESKEY_rquotad_port" ]; then
		set_arg "RPCRQUOTADOPTS" "-p $OCF_RESKEY_rquotad_port" "$tmpconfig" "true"
	fi

	# override local nfs config. preserve previous local config though.
	if [ -s $tmpconfig ]; then
		if [ -f "$NFS_SYSCONFIG" ]; then
			cat $NFS_SYSCONFIG | grep -q -e "$NFS_SYSCONFIG_AUTOGEN_TAG" > /dev/null 2>&1
			if [ $? -ne 0 ]; then
				# backup local nfs config if it doesn't have our HA autogen tag in it.
				mv -f $NFS_SYSCONFIG $NFS_SYSCONFIG_LOCAL_BACKUP
			fi
		fi

		cat $tmpconfig | grep -q -e "$NFS_SYSCONFIG_AUTOGEN_TAG" > /dev/null 2>&1 
		if [ $? -ne 0 ]; then
			echo "# $NFS_SYSCONFIG_AUTOGEN_TAG" > $NFS_SYSCONFIG
			echo "# local config backup stored here, '$NFS_SYSCONFIG_LOCAL_BACKUP'" >> $NFS_SYSCONFIG
			cat $tmpconfig >> $NFS_SYSCONFIG
		else
			cat $tmpconfig > $NFS_SYSCONFIG
		fi
	fi
	rm -f $tmpconfig
}
