% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/options.R
\name{unitizer.opts}
\alias{unitizer.opts}
\title{Unitizer Options}
\description{
Description of major \code{unitizer} option settings.  Once \code{unitizer}
is loaded, you can see a full list of \code{unitizer} options with
\code{grep("^unitizer", options(), value=TRUE)}.
}
\section{Basic State Options}{


Basic state options:

\itemize{
  \item \code{unitizer.state}: default state tracking setting (see
    \code{unitizerState})
  \item \code{unitizer.seed}: default seed to use when random seed tracking
    is enabled; this is of type "Wichman-Hill" because it is a lot more
    compact than the default R random seed, and should be adequate for most
    unit testing purposes.
}
}

\section{Options State Options}{


Additionally, when tracking option state we set options to what you would
find in a freshly loaded vanilla R session, except for systems specific
options which we leave unchanged (e.g. \code{getOption("papersize")}).
If you want to add default option values or options to leave unchanged, you
can use:

\itemize{
  \item \code{unitizer.opts.init}: named list, where names are options, and
    the associated value is the value to use as the default value for that
    option when a \code{unitizer} is launched with options tracking enabled.
  \item \code{unitizer.opts.asis}: character, containing regular expressions
    to match options to leave unchanged (e.g \code{"^unitizer\\."})
}
}

\section{Search Path and Namespace State Options}{


We also provide options to limit what elements can be removed from
the search path and/or have their namespaces unloaded when \code{unitizer}
tracks the search path state.  For example, we use this mechanism to prevent
removal of the \code{unitizer} package itself as well as the default
R vanilla session packages.

\itemize{
  \item \code{unitizer.namespace.keep}: character, names of namespaces to
    keep loaded (e.g. \code{"utils"}); note that any imported namespaces
    imported by namespaces listed here will also remain loaded
  \item \code{unitizer.search.path.keep}: character, names of objects to
    keep on search path (e.g. \code{"package:utils"}, note the
   \code{"package:"}); associated namespaces will also be kept loaded
}
\bold{IMPORTANT}: There is a dependency between options tracking and search
path / namespace exceptions that stems from most packages setting their
default options when they are loaded.  As a result, if you add any packages
or namespaces to these options and options state tracking is enabled, then
you must also add their options to \code{unitizer.opts.init} or
\code{unitizer.opts.asis} to ensure those options remain loaded or at least
set to reasonable values.  If you do not do this the packages risk having
their options unset.

Some packages cannot be easily loaded and unloaded.  For example
\code{data.table} (<= 1.9.5) cannot be unloaded without causing a segfault
(see issue \href{https://github.com/Rdatatable/data.table/issues/990}{#990}).
For this reason \code{data.table} is included in
\code{getOption("unitizer.namespace.keep")} by default.
}

\section{Sytem Default State Options}{


The following options hold the default system values for the search
path / namespace and options state tracking options:
\itemize{
  \item \code{unitizer.namespace.keep.base}: namespaces that are known to
    cause problems when unloaded (as of this writing includes
    \code{data.table})
  \item \code{unitizer.search.path.keep.base}: vanilla R session packages,
    plus \code{"package:unitizer"} and \code{"tools:rstudio"}, the latter
    because its implementation prevents re-attaching it if it is detached.
  \item \code{unitizer.opts.asis.base}: system specific options that should
    not affect test evaluation (e.g. \code{getOption("editor")}).
  \item \code{unitizer.opts.init.base}: base options (e.g.
    \code{getOption("width")} that will be set to what we believe are the
    factory settings for them.
}
These are kept separate from the user specified ones to limit the possibility
of inadvertent modification. They are exposed as options to allow the user to
unset single values if required, though this is intended to be rare.
\code{unitizer} runs with the union of user options and the system versions
described here.  For \code{unitizer.opts.init}, any options set that are
also present in \code{unitizer.opts.init.base} will overrule the base
version.
}

\section{Display / Text Capture Options}{


These options control how \code{unitizer} displays data such as diffs, test
results, etc.

\itemize{
  \item \code{unitizer.test.out.lines}: integer(2L), where first values is
    maximum number of lines of screen output to show for each test, and
    second value is the number of lines to show if there are more lines than
    allowed by the first value
  \item \code{unitizer.test.msg.lines}: like \code{unitizer.test.out.lines},
    but for \code{stderr output}
  \item \code{unitizer.test.fail.context.lines}: integer(2L), used
    exclusively when comparing new to references tests when test faile; first
    values is maximum number of lines of context to show around a test,
    centered on differences if there are any, and second value is the number
    of context lines to show if using the first value is not sufficient to
    fully display the test results
  \item \code{unitizer.show.output}: TRUE or FALSE, whether to display test
    \code{stdout} and \code{stderr} output as it is evaluated.
  \item \code{unitizer.disable.capt}: logical(2L), not NA, with names
    \code{c("output", "message")} where each value indicates whether the
    corresponding stream should be captured or not.  For \code{stdout} the
    stream is still captured but setting the value to FALSE tees it.
  \item \code{unitizer.max.capture.chars}: integer(1L) maximum number of
    characters to allow capture of per test
  \item \code{unitizer.color} whether to use ANSI color escape sequences,
    set to TRUE to force, FALSE to force off, or NULL to attempt to auto
    detect (based on code from package:crayon, thanks Gabor Csardi)
  \item \code{unitizer.use.diff} TRUE or FALSE, whether to use a diff of
    test errors (defaults to TRUE)
}
}

\section{Misc Options}{


\itemize{
  \item \code{unitizer.history.file} character(1L) location of file to use
    to store history of command entered by user in in interactive
    \code{unitizer} prompt; \code{""} is interpreted as tempfile()
  \item \code{unitizer.prompt.b4.quit.time} integer(1L) \code{unitizers} that
    take more seconds than this to evaluate will post a confirmation prompt
    before quitting; this is to avoid accidentally quitting after running a
    \code{unitizer} with many slow running tests and having to re-run them
    again.
  \item \code{unitizer.restarts.ok} TRUE or FALSE, suppresses warnings when
    running inside a `withRestarts` block, which is normally a warning.
    Needed due to `test_that` adding a `withRestart`
}
}

\seealso{
\code{\link{unitizerState}}
}
