#' @title Manipulate Microsoft Word and PowerPoint Documents with 'officer'
#'
#' @description
#' The officer package facilitates access to and manipulation of
#' 'Microsoft Word' and 'Microsoft PowerPoint' documents from R.
#' It also supports the writing of 'RTF' documents.
#'
#' Examples of usage are:
#'
#' * Create Word documents with tables, titles, TOC and graphics
#' * Importation of Word and PowerPoint files into data objects
#' * Write updated content back to a PowerPoint presentation
#' * Clinical reporting automation
#' * Production of reports from a shiny application
#'
#' To start with officer, read about [read_docx()], [read_pptx()]
#' or [rtf_doc()].
#'
#' The package is also providing several objects that can be printed
#' in 'R Markdown' documents for advanced Word or PowerPoint
#' reporting as [run_autonum()] and [block_caption()].
#'
#' @seealso The user documentation: \url{https://ardata-fr.github.io/officeverse/} and
#' manuals \url{https://davidgohel.github.io/officer/}
#' @docType package
#' @name officer
"_PACKAGE"
