% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resample.R
\name{resample}
\alias{resample}
\title{A "lazy" resample.}
\usage{
resample(data, idx)
}
\arguments{
\item{data}{The data frame}

\item{idx}{A vector of integer indexes indicating which rows have
been selected. These values should lie between 1 and \code{nrow(data)}
but they are not checked by this function in the interests of performance.}
}
\description{
Often you will resample a dataset hundreds or thousands of times. Storing
the complete resample each time would be very inefficient so this class
instead stores a "pointer" to the original dataset, and a vector of row
indexes. To turn this into a regular data frame, call \code{as.data.frame},
to extract the indices, use \code{as.integer}.
}
\examples{
resample(mtcars, 1:10)

b <- resample_bootstrap(mtcars)
b
as.integer(b)
as.data.frame(b)

# Many modelling functions will do the coercion for you, so you can
# use a resample object directly in the data argument
lm(mpg ~ wt, data = b)
}
\seealso{
Other resampling techniques: 
\code{\link{bootstrap}()},
\code{\link{resample_bootstrap}()},
\code{\link{resample_partition}()}
}
\concept{resampling techniques}
