% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/guide-colorsteps.R
\name{guide_coloursteps}
\alias{guide_coloursteps}
\alias{guide_colorsteps}
\title{Discretized colourbar guide}
\usage{
guide_coloursteps(
  title = waiver(),
  theme = NULL,
  alpha = NA,
  even.steps = TRUE,
  show.limits = NULL,
  direction = NULL,
  reverse = FALSE,
  order = 0,
  available_aes = c("colour", "color", "fill"),
  ...
)

guide_colorsteps(
  title = waiver(),
  theme = NULL,
  alpha = NA,
  even.steps = TRUE,
  show.limits = NULL,
  direction = NULL,
  reverse = FALSE,
  order = 0,
  available_aes = c("colour", "color", "fill"),
  ...
)
}
\arguments{
\item{title}{A character string or expression indicating a title of guide.
If \code{NULL}, the title is not shown. By default
(\code{\link[=waiver]{waiver()}}), the name of the scale object or the name
specified in \code{\link[=labs]{labs()}} is used for the title.}

\item{theme}{A \code{\link[=theme]{theme}} object to style the guide individually or
differently from the plot's theme settings. The \code{theme} argument in the
guide overrides, and is combined with, the plot's theme.}

\item{alpha}{A numeric between 0 and 1 setting the colour transparency of
the bar. Use \code{NA} to preserve the alpha encoded in the colour itself
(default).}

\item{even.steps}{Should the rendered size of the bins be equal, or should
they be proportional to their length in the data space? Defaults to \code{TRUE}}

\item{show.limits}{Logical. Should the limits of the scale be shown with
labels and ticks. Default is \code{NULL} meaning it will take the value from the
scale. This argument is ignored if \code{labels} is given as a vector of
values. If one or both of the limits is also given in \code{breaks} it will be
shown irrespective of the value of \code{show.limits}.}

\item{direction}{A character string indicating the direction of the guide.
One of "horizontal" or "vertical."}

\item{reverse}{logical. If \code{TRUE} the colourbar is reversed. By default,
the highest value is on the top and the lowest value is on the bottom}

\item{order}{positive integer less than 99 that specifies the order of
this guide among multiple guides. This controls the order in which
multiple guides are displayed, not the contents of the guide itself.
If 0 (default), the order is determined by a secret algorithm.}

\item{available_aes}{A vector of character strings listing the aesthetics
for which a colourbar can be drawn.}

\item{...}{ignored.}
}
\value{
A guide object
}
\description{
This guide is version of \code{\link[=guide_colourbar]{guide_colourbar()}} for binned colour and fill
scales. It shows areas between breaks as a single constant colour instead of
the gradient known from the colourbar counterpart.
}
\section{Use with discrete scale}{

This guide is intended to show binned data and work together with ggplot2's
binning scales. However, it is sometimes desirable to perform the binning in
a separate step, either as part of a stat (e.g. \code{\link[=stat_contour_filled]{stat_contour_filled()}}) or
prior to the visualisation. If you want to use this guide for discrete data
the levels must follow the naming scheme implemented by \code{\link[base:cut]{base::cut()}}. This
means that a bin must be encoded as \code{"(<lower>, <upper>]"} with \verb{<lower>}
giving the lower bound of the bin and \verb{<upper>} giving the upper bound
(\code{"[<lower>, <upper>)"} is also accepted). If you use \code{\link[base:cut]{base::cut()}} to
perform the binning everything should work as expected, if not, some recoding
may be needed.
}

\examples{
df <- expand.grid(X1 = 1:10, X2 = 1:10)
df$value <- df$X1 * df$X2

p <- ggplot(df, aes(X1, X2)) + geom_tile(aes(fill = value))

# Coloursteps guide is the default for binned colour scales
p + scale_fill_binned()

# By default each bin in the guide is the same size irrespectively of how
# their sizes relate in data space
p + scale_fill_binned(breaks = c(10, 25, 50))

# This can be changed with the `even.steps` argument
p + scale_fill_binned(
  breaks = c(10, 25, 50),
  guide = guide_coloursteps(even.steps = FALSE)
)

# By default the limits is not shown, but this can be changed
p + scale_fill_binned(guide = guide_coloursteps(show.limits = TRUE))

# (can also be set in the scale)
p + scale_fill_binned(show.limits = TRUE)
}
\seealso{
The \href{https://ggplot2-book.org/scales-colour#sec-guide-coloursteps}{binned legend section} of the online ggplot2 book.

Other guides: 
\code{\link{guide_bins}()},
\code{\link{guide_colourbar}()},
\code{\link{guide_legend}()},
\code{\link{guides}()}
}
\concept{guides}
