% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\docType{methods}
\name{getBlankLabel,RccSet-method}
\alias{getBlankLabel,RccSet-method}
\alias{getBlankLabel}
\title{Get the SampleType value that indicates blank samples}
\usage{
\S4method{getBlankLabel}{RccSet}(rccSet, showWarnings = TRUE)
}
\arguments{
\item{rccSet}{An RccSet}

\item{showWarnings}{Logical. If FALSE, no warnings will be generated (if any).}
}
\value{
NULL if the SampleType column is missing altogether, NA if the varMetadata doesn't
have blankLabel recorded, or the blankLabel value otherwise.
}
\description{
Returns the phenoData SampleType value that indicates blank samples (i.e. water runs).
This value is parsed from the single-quoted string enclosed by "blankLabel='...'"
in the varMetadata for SampleType.
}
\examples{
data(example_rccSet)
blankLabel <- getBlankLabel(example_rccSet)

}
\author{
Robert Ziman
}
