# SPDX-License-Identifier: GPL-2.0-or-later

"""
trace/generated-tracers.h
"""

__author__     = "Lluís Vilanova <vilanova@ac.upc.edu>"
__copyright__  = "Copyright 2012-2017, Lluís Vilanova <vilanova@ac.upc.edu>"
__license__    = "GPL version 2 or (at your option) any later version"

__maintainer__ = "Stefan Hajnoczi"
__email__      = "stefanha@redhat.com"


from tracetool import out


def generate(events, backend, group):
    header = "trace/control.h"

    out('/* This file is autogenerated by tracetool, do not edit. */',
        '/* SPDX-License-Identifier: GPL-2.0-or-later */',
        '',
        '#ifndef TRACE_%s_GENERATED_TRACERS_H' % group.upper(),
        '#define TRACE_%s_GENERATED_TRACERS_H' % group.upper(),
        '',
        '#include "%s"' % header,
        '')

    for e in events:
        out('extern TraceEvent %(event)s;',
            event = e.api(e.QEMU_EVENT))

    for e in events:
        out('extern uint16_t %s;' % e.api(e.QEMU_DSTATE))

    # static state
    for e in events:
        if 'disable' in e.properties:
            enabled = 0
        else:
            enabled = 1
        out('#define TRACE_%s_ENABLED %d' % (e.name.upper(), enabled))

    backend.generate_begin(events, group)

    for e in events:
        # tracer-specific dstate
        out('',
            '#define %(api)s() ( \\',
            api=e.api(e.QEMU_BACKEND_DSTATE))

        if "disable" not in e.properties:
            backend.generate_backend_dstate(e, group)

        out('    false)')

        out('',
            'static inline void %(api)s(%(args)s)',
            '{',
            api=e.api(),
            args=e.args)

        if "disable" not in e.properties:
            backend.generate(e, group, check_trace_event_get_state=False)

            if backend.check_trace_event_get_state:
                event_id = 'TRACE_' + e.name.upper()
                cond = "trace_event_get_state(%s)" % event_id
                out('    if (%(cond)s) {',
                        cond=cond)
                backend.generate(e, group, check_trace_event_get_state=True)
                out('    }')
        out('}')

    backend.generate_end(events, group)

    out('#endif /* TRACE_%s_GENERATED_TRACERS_H */' % group.upper())
