# pylint: disable=line-too-long,useless-suppression
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.identity import DefaultAzureCredential

from azure.mgmt.security import SecurityCenter

"""
# PREREQUISITES
    pip install azure-identity
    pip install azure-mgmt-security
# USAGE
    python create_io_tsecurity_solution.py

    Before run the sample, please set the values of the client ID, tenant ID and client secret
    of the AAD application as environment variables: AZURE_CLIENT_ID, AZURE_TENANT_ID,
    AZURE_CLIENT_SECRET. For more info about how to get the value, please see:
    https://docs.microsoft.com/azure/active-directory/develop/howto-create-service-principal-portal
"""


def main():
    client = SecurityCenter(
        credential=DefaultAzureCredential(),
        subscription_id="20ff7fc3-e762-44dd-bd96-b71116dcdc23",
    )

    response = client.iot_security_solution.create_or_update(
        resource_group_name="MyGroup",
        solution_name="default",
        iot_security_solution_data={
            "location": "East Us",
            "properties": {
                "disabledDataSources": [],
                "displayName": "Solution Default",
                "export": [],
                "iotHubs": [
                    "/subscriptions/075423e9-7d33-4166-8bdf-3920b04e3735/resourceGroups/myRg/providers/Microsoft.Devices/IotHubs/FirstIotHub"
                ],
                "recommendationsConfiguration": [
                    {"recommendationType": "IoT_OpenPorts", "status": "Disabled"},
                    {"recommendationType": "IoT_SharedCredentials", "status": "Disabled"},
                ],
                "status": "Enabled",
                "unmaskedIpLoggingStatus": "Enabled",
                "userDefinedResources": {
                    "query": 'where type != "microsoft.devices/iothubs" | where name contains "iot"',
                    "querySubscriptions": ["075423e9-7d33-4166-8bdf-3920b04e3735"],
                },
                "workspace": "/subscriptions/c4930e90-cd72-4aa5-93e9-2d081d129569/resourceGroups/myRg/providers/Microsoft.OperationalInsights/workspaces/myWorkspace1",
            },
            "tags": {},
        },
    )
    print(response)


# x-ms-original-file: specification/security/resource-manager/Microsoft.Security/stable/2019-08-01/examples/IoTSecuritySolutions/CreateIoTSecuritySolution.json
if __name__ == "__main__":
    main()
