# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.sql import SqlManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestSqlManagementDatabasesOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(SqlManagementClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_databases_list_by_server(self, resource_group):
        response = self.client.databases.list_by_server(
            resource_group_name=resource_group.name,
            server_name="str",
            api_version="2024-11-01-preview",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_databases_get(self, resource_group):
        response = self.client.databases.get(
            resource_group_name=resource_group.name,
            server_name="str",
            database_name="str",
            api_version="2024-11-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_databases_begin_create_or_update(self, resource_group):
        response = self.client.databases.begin_create_or_update(
            resource_group_name=resource_group.name,
            server_name="str",
            database_name="str",
            parameters={
                "location": "str",
                "autoPauseDelay": 0,
                "availabilityZone": "str",
                "catalogCollation": "str",
                "collation": "str",
                "createMode": "str",
                "creationDate": "2020-02-20 00:00:00",
                "currentBackupStorageRedundancy": "str",
                "currentServiceObjectiveName": "str",
                "currentSku": {"name": "str", "capacity": 0, "family": "str", "size": "str", "tier": "str"},
                "databaseId": "str",
                "defaultSecondaryLocation": "str",
                "earliestRestoreDate": "2020-02-20 00:00:00",
                "elasticPoolId": "str",
                "encryptionProtector": "str",
                "encryptionProtectorAutoRotation": bool,
                "failoverGroupId": "str",
                "federatedClientId": "str",
                "freeLimitExhaustionBehavior": "str",
                "highAvailabilityReplicaCount": 0,
                "id": "str",
                "identity": {
                    "tenantId": "str",
                    "type": "str",
                    "userAssignedIdentities": {"str": {"clientId": "str", "principalId": "str"}},
                },
                "isInfraEncryptionEnabled": bool,
                "isLedgerOn": bool,
                "keys": {
                    "str": {
                        "creationDate": "2020-02-20 00:00:00",
                        "keyVersion": "str",
                        "subregion": "str",
                        "thumbprint": "str",
                        "type": "str",
                    }
                },
                "kind": "str",
                "licenseType": "str",
                "longTermRetentionBackupResourceId": "str",
                "maintenanceConfigurationId": "str",
                "managedBy": "str",
                "manualCutover": bool,
                "maxLogSizeBytes": 0,
                "maxSizeBytes": 0,
                "minCapacity": 0.0,
                "name": "str",
                "pausedDate": "2020-02-20 00:00:00",
                "performCutover": bool,
                "preferredEnclaveType": "str",
                "readScale": "str",
                "recoverableDatabaseId": "str",
                "recoveryServicesRecoveryPointId": "str",
                "requestedBackupStorageRedundancy": "str",
                "requestedServiceObjectiveName": "str",
                "restorableDroppedDatabaseId": "str",
                "restorePointInTime": "2020-02-20 00:00:00",
                "resumedDate": "2020-02-20 00:00:00",
                "sampleName": "str",
                "secondaryType": "str",
                "sku": {"name": "str", "capacity": 0, "family": "str", "size": "str", "tier": "str"},
                "sourceDatabaseDeletionDate": "2020-02-20 00:00:00",
                "sourceDatabaseId": "str",
                "sourceResourceId": "str",
                "status": "str",
                "tags": {"str": "str"},
                "type": "str",
                "useFreeLimit": bool,
                "zoneRedundant": bool,
            },
            api_version="2024-11-01-preview",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_databases_begin_delete(self, resource_group):
        response = self.client.databases.begin_delete(
            resource_group_name=resource_group.name,
            server_name="str",
            database_name="str",
            api_version="2024-11-01-preview",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_databases_begin_update(self, resource_group):
        response = self.client.databases.begin_update(
            resource_group_name=resource_group.name,
            server_name="str",
            database_name="str",
            parameters={
                "autoPauseDelay": 0,
                "catalogCollation": "str",
                "collation": "str",
                "createMode": "str",
                "creationDate": "2020-02-20 00:00:00",
                "currentBackupStorageRedundancy": "str",
                "currentServiceObjectiveName": "str",
                "currentSku": {"name": "str", "capacity": 0, "family": "str", "size": "str", "tier": "str"},
                "databaseId": "str",
                "defaultSecondaryLocation": "str",
                "earliestRestoreDate": "2020-02-20 00:00:00",
                "elasticPoolId": "str",
                "encryptionProtector": "str",
                "encryptionProtectorAutoRotation": bool,
                "failoverGroupId": "str",
                "federatedClientId": "str",
                "freeLimitExhaustionBehavior": "str",
                "highAvailabilityReplicaCount": 0,
                "identity": {
                    "tenantId": "str",
                    "type": "str",
                    "userAssignedIdentities": {"str": {"clientId": "str", "principalId": "str"}},
                },
                "isInfraEncryptionEnabled": bool,
                "isLedgerOn": bool,
                "keys": {
                    "str": {
                        "creationDate": "2020-02-20 00:00:00",
                        "keyVersion": "str",
                        "subregion": "str",
                        "thumbprint": "str",
                        "type": "str",
                    }
                },
                "licenseType": "str",
                "longTermRetentionBackupResourceId": "str",
                "maintenanceConfigurationId": "str",
                "manualCutover": bool,
                "maxLogSizeBytes": 0,
                "maxSizeBytes": 0,
                "minCapacity": 0.0,
                "pausedDate": "2020-02-20 00:00:00",
                "performCutover": bool,
                "preferredEnclaveType": "str",
                "readScale": "str",
                "recoverableDatabaseId": "str",
                "recoveryServicesRecoveryPointId": "str",
                "requestedBackupStorageRedundancy": "str",
                "requestedServiceObjectiveName": "str",
                "restorableDroppedDatabaseId": "str",
                "restorePointInTime": "2020-02-20 00:00:00",
                "resumedDate": "2020-02-20 00:00:00",
                "sampleName": "str",
                "secondaryType": "str",
                "sku": {"name": "str", "capacity": 0, "family": "str", "size": "str", "tier": "str"},
                "sourceDatabaseDeletionDate": "2020-02-20 00:00:00",
                "sourceDatabaseId": "str",
                "status": "str",
                "tags": {"str": "str"},
                "useFreeLimit": bool,
                "zoneRedundant": bool,
            },
            api_version="2024-11-01-preview",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_databases_begin_export(self, resource_group):
        response = self.client.databases.begin_export(
            resource_group_name=resource_group.name,
            server_name="str",
            database_name="str",
            parameters={
                "administratorLogin": "str",
                "storageKey": "str",
                "storageKeyType": "str",
                "storageUri": "str",
                "administratorLoginPassword": "str",
                "authenticationType": "str",
                "networkIsolation": {"sqlServerResourceId": "str", "storageAccountResourceId": "str"},
            },
            api_version="2024-11-01-preview",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_databases_begin_failover(self, resource_group):
        response = self.client.databases.begin_failover(
            resource_group_name=resource_group.name,
            server_name="str",
            database_name="str",
            api_version="2024-11-01-preview",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_databases_begin_import_method(self, resource_group):
        response = self.client.databases.begin_import_method(
            resource_group_name=resource_group.name,
            server_name="str",
            database_name="str",
            parameters={
                "administratorLogin": "str",
                "storageKey": "str",
                "storageKeyType": "str",
                "storageUri": "str",
                "administratorLoginPassword": "str",
                "authenticationType": "str",
                "networkIsolation": {"sqlServerResourceId": "str", "storageAccountResourceId": "str"},
            },
            api_version="2024-11-01-preview",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_databases_rename(self, resource_group):
        response = self.client.databases.rename(
            resource_group_name=resource_group.name,
            server_name="str",
            database_name="str",
            parameters={"id": "str"},
            api_version="2024-11-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_databases_begin_pause(self, resource_group):
        response = self.client.databases.begin_pause(
            resource_group_name=resource_group.name,
            server_name="str",
            database_name="str",
            api_version="2024-11-01-preview",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_databases_begin_resume(self, resource_group):
        response = self.client.databases.begin_resume(
            resource_group_name=resource_group.name,
            server_name="str",
            database_name="str",
            api_version="2024-11-01-preview",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_databases_begin_upgrade_data_warehouse(self, resource_group):
        response = self.client.databases.begin_upgrade_data_warehouse(
            resource_group_name=resource_group.name,
            server_name="str",
            database_name="str",
            api_version="2024-11-01-preview",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_databases_list_by_elastic_pool(self, resource_group):
        response = self.client.databases.list_by_elastic_pool(
            resource_group_name=resource_group.name,
            server_name="str",
            elastic_pool_name="str",
            api_version="2024-11-01-preview",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_databases_list_inaccessible_by_server(self, resource_group):
        response = self.client.databases.list_inaccessible_by_server(
            resource_group_name=resource_group.name,
            server_name="str",
            api_version="2024-11-01-preview",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...
