//*
// Standalone signaling server for the Nextcloud Spreed app.
// Copyright (C) 2022 struktur AG
//
// @author Joachim Bauch <bauch@struktur.de>
//
// @license GNU AGPL version 3 or any later version
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Affero General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Affero General Public License for more details.
//
// You should have received a copy of the GNU Affero General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// source: grpc_sessions.proto

package signaling

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.64.0 or later.
const _ = grpc.SupportPackageIsVersion9

const (
	RpcSessions_LookupResumeId_FullMethodName      = "/signaling.RpcSessions/LookupResumeId"
	RpcSessions_LookupSessionId_FullMethodName     = "/signaling.RpcSessions/LookupSessionId"
	RpcSessions_IsSessionInCall_FullMethodName     = "/signaling.RpcSessions/IsSessionInCall"
	RpcSessions_GetInternalSessions_FullMethodName = "/signaling.RpcSessions/GetInternalSessions"
	RpcSessions_ProxySession_FullMethodName        = "/signaling.RpcSessions/ProxySession"
)

// RpcSessionsClient is the client API for RpcSessions service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type RpcSessionsClient interface {
	LookupResumeId(ctx context.Context, in *LookupResumeIdRequest, opts ...grpc.CallOption) (*LookupResumeIdReply, error)
	LookupSessionId(ctx context.Context, in *LookupSessionIdRequest, opts ...grpc.CallOption) (*LookupSessionIdReply, error)
	IsSessionInCall(ctx context.Context, in *IsSessionInCallRequest, opts ...grpc.CallOption) (*IsSessionInCallReply, error)
	GetInternalSessions(ctx context.Context, in *GetInternalSessionsRequest, opts ...grpc.CallOption) (*GetInternalSessionsReply, error)
	ProxySession(ctx context.Context, opts ...grpc.CallOption) (grpc.BidiStreamingClient[ClientSessionMessage, ServerSessionMessage], error)
}

type rpcSessionsClient struct {
	cc grpc.ClientConnInterface
}

func NewRpcSessionsClient(cc grpc.ClientConnInterface) RpcSessionsClient {
	return &rpcSessionsClient{cc}
}

func (c *rpcSessionsClient) LookupResumeId(ctx context.Context, in *LookupResumeIdRequest, opts ...grpc.CallOption) (*LookupResumeIdReply, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(LookupResumeIdReply)
	err := c.cc.Invoke(ctx, RpcSessions_LookupResumeId_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *rpcSessionsClient) LookupSessionId(ctx context.Context, in *LookupSessionIdRequest, opts ...grpc.CallOption) (*LookupSessionIdReply, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(LookupSessionIdReply)
	err := c.cc.Invoke(ctx, RpcSessions_LookupSessionId_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *rpcSessionsClient) IsSessionInCall(ctx context.Context, in *IsSessionInCallRequest, opts ...grpc.CallOption) (*IsSessionInCallReply, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(IsSessionInCallReply)
	err := c.cc.Invoke(ctx, RpcSessions_IsSessionInCall_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *rpcSessionsClient) GetInternalSessions(ctx context.Context, in *GetInternalSessionsRequest, opts ...grpc.CallOption) (*GetInternalSessionsReply, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(GetInternalSessionsReply)
	err := c.cc.Invoke(ctx, RpcSessions_GetInternalSessions_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *rpcSessionsClient) ProxySession(ctx context.Context, opts ...grpc.CallOption) (grpc.BidiStreamingClient[ClientSessionMessage, ServerSessionMessage], error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	stream, err := c.cc.NewStream(ctx, &RpcSessions_ServiceDesc.Streams[0], RpcSessions_ProxySession_FullMethodName, cOpts...)
	if err != nil {
		return nil, err
	}
	x := &grpc.GenericClientStream[ClientSessionMessage, ServerSessionMessage]{ClientStream: stream}
	return x, nil
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type RpcSessions_ProxySessionClient = grpc.BidiStreamingClient[ClientSessionMessage, ServerSessionMessage]

// RpcSessionsServer is the server API for RpcSessions service.
// All implementations must embed UnimplementedRpcSessionsServer
// for forward compatibility.
type RpcSessionsServer interface {
	LookupResumeId(context.Context, *LookupResumeIdRequest) (*LookupResumeIdReply, error)
	LookupSessionId(context.Context, *LookupSessionIdRequest) (*LookupSessionIdReply, error)
	IsSessionInCall(context.Context, *IsSessionInCallRequest) (*IsSessionInCallReply, error)
	GetInternalSessions(context.Context, *GetInternalSessionsRequest) (*GetInternalSessionsReply, error)
	ProxySession(grpc.BidiStreamingServer[ClientSessionMessage, ServerSessionMessage]) error
	mustEmbedUnimplementedRpcSessionsServer()
}

// UnimplementedRpcSessionsServer must be embedded to have
// forward compatible implementations.
//
// NOTE: this should be embedded by value instead of pointer to avoid a nil
// pointer dereference when methods are called.
type UnimplementedRpcSessionsServer struct{}

func (UnimplementedRpcSessionsServer) LookupResumeId(context.Context, *LookupResumeIdRequest) (*LookupResumeIdReply, error) {
	return nil, status.Errorf(codes.Unimplemented, "method LookupResumeId not implemented")
}
func (UnimplementedRpcSessionsServer) LookupSessionId(context.Context, *LookupSessionIdRequest) (*LookupSessionIdReply, error) {
	return nil, status.Errorf(codes.Unimplemented, "method LookupSessionId not implemented")
}
func (UnimplementedRpcSessionsServer) IsSessionInCall(context.Context, *IsSessionInCallRequest) (*IsSessionInCallReply, error) {
	return nil, status.Errorf(codes.Unimplemented, "method IsSessionInCall not implemented")
}
func (UnimplementedRpcSessionsServer) GetInternalSessions(context.Context, *GetInternalSessionsRequest) (*GetInternalSessionsReply, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetInternalSessions not implemented")
}
func (UnimplementedRpcSessionsServer) ProxySession(grpc.BidiStreamingServer[ClientSessionMessage, ServerSessionMessage]) error {
	return status.Errorf(codes.Unimplemented, "method ProxySession not implemented")
}
func (UnimplementedRpcSessionsServer) mustEmbedUnimplementedRpcSessionsServer() {}
func (UnimplementedRpcSessionsServer) testEmbeddedByValue()                     {}

// UnsafeRpcSessionsServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to RpcSessionsServer will
// result in compilation errors.
type UnsafeRpcSessionsServer interface {
	mustEmbedUnimplementedRpcSessionsServer()
}

func RegisterRpcSessionsServer(s grpc.ServiceRegistrar, srv RpcSessionsServer) {
	// If the following call pancis, it indicates UnimplementedRpcSessionsServer was
	// embedded by pointer and is nil.  This will cause panics if an
	// unimplemented method is ever invoked, so we test this at initialization
	// time to prevent it from happening at runtime later due to I/O.
	if t, ok := srv.(interface{ testEmbeddedByValue() }); ok {
		t.testEmbeddedByValue()
	}
	s.RegisterService(&RpcSessions_ServiceDesc, srv)
}

func _RpcSessions_LookupResumeId_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(LookupResumeIdRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RpcSessionsServer).LookupResumeId(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: RpcSessions_LookupResumeId_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RpcSessionsServer).LookupResumeId(ctx, req.(*LookupResumeIdRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RpcSessions_LookupSessionId_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(LookupSessionIdRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RpcSessionsServer).LookupSessionId(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: RpcSessions_LookupSessionId_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RpcSessionsServer).LookupSessionId(ctx, req.(*LookupSessionIdRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RpcSessions_IsSessionInCall_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(IsSessionInCallRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RpcSessionsServer).IsSessionInCall(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: RpcSessions_IsSessionInCall_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RpcSessionsServer).IsSessionInCall(ctx, req.(*IsSessionInCallRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RpcSessions_GetInternalSessions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetInternalSessionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RpcSessionsServer).GetInternalSessions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: RpcSessions_GetInternalSessions_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RpcSessionsServer).GetInternalSessions(ctx, req.(*GetInternalSessionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RpcSessions_ProxySession_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(RpcSessionsServer).ProxySession(&grpc.GenericServerStream[ClientSessionMessage, ServerSessionMessage]{ServerStream: stream})
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type RpcSessions_ProxySessionServer = grpc.BidiStreamingServer[ClientSessionMessage, ServerSessionMessage]

// RpcSessions_ServiceDesc is the grpc.ServiceDesc for RpcSessions service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var RpcSessions_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "signaling.RpcSessions",
	HandlerType: (*RpcSessionsServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "LookupResumeId",
			Handler:    _RpcSessions_LookupResumeId_Handler,
		},
		{
			MethodName: "LookupSessionId",
			Handler:    _RpcSessions_LookupSessionId_Handler,
		},
		{
			MethodName: "IsSessionInCall",
			Handler:    _RpcSessions_IsSessionInCall_Handler,
		},
		{
			MethodName: "GetInternalSessions",
			Handler:    _RpcSessions_GetInternalSessions_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "ProxySession",
			Handler:       _RpcSessions_ProxySession_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
	},
	Metadata: "grpc_sessions.proto",
}
