Running Autopilot tests
=======================

NOTE: autopilot is currently not available in UBports and the instructions below are no longer accurate.

Ubuntu Calendar App follows a test driven development where autopilot tests are run before every merge into trunk.
If you are submitting your bugfix/patch to the calendar app, please follow the following steps below to ensure that all tests pass before proposing a merge request.

If you are looking for more info about Autopilot or writing AP tests for the calendar app, here are some useful links to help you:

* http://developer.ubuntu.com/start/quality
* https://developer.ubuntu.com/api/autopilot/python/1.5.0/

For help and options on running tests, see:

* https://developer.ubuntu.com/en/start/platform/guides/running-autopilot-tests/

Prerequisites
=============

Install the following autopilot packages required to run the tests,
    $ sudo apt-get install python3-autopilot python3-dateutil libautopilot-qt ubuntu-ui-toolkit-autopilot python3-autopilot-vis

address-book-service-testability package may also be required if not already installed
   $ sudo apt-get install address-book-service-testability

Running tests on the desktop
============================

Using terminal:

*  Branch the calendar app code,
    $ bzr branch lp:ubuntu-calendar-app

*  Build the calendar app,
    $ mkdir builddir && cd builddir
    $ cmake ..  && make -j3
    $ cd ..

*  Navigate to the tests/autopilot directory.
    $ cd tests/autopilot

*  run all tests.
    $ autopilot3 run -vv ubuntu_calendar_app

    to list all tests:
    $ autopilot3 list ubuntu_calendar_app

    To run only one test (for instance: test_change_week_across_year in TestWeekview.py):
    $ autopilot3 run -vv ubuntu_calendar_app.tests.test_weekview.TestWeekview.test_change_week_across_year 

    Debugging tests using autopilot vis
    $ autopilot3 launch -i Qt qmlscene ../../app/ubuntu-calendar-app.qml
    $ autopilot3 vis

Running tests using Ubuntu SDK
==============================

Refer this tutorial to run tests on Ubuntu SDK: https://developer.ubuntu.com/en/start/platform/guides/running-autopilot-tests/

Running tests on device or emulator
===================================

Using autopkg:

1. navigate to the directory where the ubuntu-calendar-app branch is and run:
  $ adt-run ubuntu-calendar-app --click=com.ubuntu.calendar --- ssh -s adb -p YOURPASSWORD
