# Security Policy

## Supported Versions

We recommend that all users always use the latest version of ejabberd.

To ensure the best experience and security, upgrade to the latest version available on [this repo](https://github.com/processone/ejabberd).

## Reporting a Vulnerability

### Private Reporting  

**Preferred Method**: Use GitHub's private vulnerability reporting system by clicking the "Report a Vulnerability" button in the [Security tab of this repository](https://github.com/processone/ejabberd/security). This ensures your report is securely transmitted and tracked.  

**Alternative**: If you cannot use the GitHub system, send an email to **`contact@process-one.net`** with the following details:  

- A clear description of the vulnerability.  
- Steps to reproduce the issue.  
- Any potential impact or exploitation scenarios.  

### Response Time  

We aim to acknowledge receipt of your report within 72 hours. You can expect regular updates on the status of your report.  

### Resolution  

If the vulnerability is confirmed, we will work on a patch or mitigation strategy.  
We will notify you once the issue is resolved and coordinate a public disclosure if needed.  

### Acknowledgements  

We value and appreciate the contributions of security researchers and community members.  
If you wish, we are happy to acknowledge your efforts publicly by listing your name (or alias) below in this document.  
Please let us know if you would like to be recognized when reporting the vulnerability.

## Public Discussion

For general inquiries or discussions about the project’s security, feel free to chat with us here:

- XMPP room: `ejabberd@conference.process-one.net`
- [GitHub Discussions](https://github.com/processone/ejabberd/discussions)

However, please note that if the issue is **critical** or potentially exploitable, **do not share it publicly**. Instead, we strongly recommend you contact the maintainers directly via the private reporting methods outlined above to ensure a secure and timely response.

Thank you for helping us improve the security of ejabberd!
