# source: http://physics.nist.gov/cgi-bin/Compositions/stand_alone.pl?ele=&ascii=ascii2&isotype=some

isotopes = \
{1: {1: {'Atomic Number': 1,
         'Atomic Symbol': 'H',
         'Isotopic Composition': 99.9885,
         'Mass Number': 1,
         'Relative Atomic Mass': 1.0078250321,
         'Standard Atomic Weight': 1.00794},
     2: {'Atomic Number': 1,
         'Atomic Symbol': 'D',
         'Isotopic Composition': 0.0115,
         'Mass Number': 2,
         'Relative Atomic Mass': 2.0141017780,
         'Standard Atomic Weight': 1.00794},
     3: {'Atomic Number': 1,
         'Atomic Symbol': 'T',
         'Isotopic Composition': '',
         'Mass Number': 3,
         'Relative Atomic Mass': 3.0160492675,
         'Standard Atomic Weight': 1.00794}},
 2: {3: {'Atomic Number': 2,
         'Atomic Symbol': 'He',
         'Isotopic Composition': 0.000137,
         'Mass Number': 3,
         'Relative Atomic Mass': 3.0160293097,
         'Standard Atomic Weight': 4.002602},
     4: {'Atomic Number': 2,
         'Atomic Symbol': 'He',
         'Isotopic Composition': 99.999863,
         'Mass Number': 4,
         'Relative Atomic Mass': 4.0026032497,
         'Standard Atomic Weight': 4.002602}},
 3: {6: {'Atomic Number': 3,
         'Atomic Symbol': 'Li',
         'Isotopic Composition': 7.59,
         'Mass Number': 6,
         'Relative Atomic Mass': 6.0151223,
         'Standard Atomic Weight': 6.941},
     7: {'Atomic Number': 3,
         'Atomic Symbol': 'Li',
         'Isotopic Composition': 92.41,
         'Mass Number': 7,
         'Relative Atomic Mass': 7.0160040,
         'Standard Atomic Weight': 6.941}},
 4: {9: {'Atomic Number': 4,
         'Atomic Symbol': 'Be',
         'Isotopic Composition': 100,
         'Mass Number': 9,
         'Relative Atomic Mass': 9.0121821,
         'Standard Atomic Weight': 9.012182}},
 5: {10: {'Atomic Number': 5,
          'Atomic Symbol': 'B',
          'Isotopic Composition': 19.9,
          'Mass Number': 10,
          'Relative Atomic Mass': 10.0129370,
          'Standard Atomic Weight': 10.811},
     11: {'Atomic Number': 5,
          'Atomic Symbol': 'B',
          'Isotopic Composition': 80.1,
          'Mass Number': 11,
          'Relative Atomic Mass': 11.0093055,
          'Standard Atomic Weight': 10.811}},
 6: {12: {'Atomic Number': 6,
          'Atomic Symbol': 'C',
          'Isotopic Composition': 98.93,
          'Mass Number': 12,
          'Relative Atomic Mass': 12.0000000,
          'Standard Atomic Weight': 12.0107},
     13: {'Atomic Number': 6,
          'Atomic Symbol': 'C',
          'Isotopic Composition': 1.07,
          'Mass Number': 13,
          'Relative Atomic Mass': 13.0033548378,
          'Standard Atomic Weight': 12.0107},
     14: {'Atomic Number': 6,
          'Atomic Symbol': 'C',
          'Isotopic Composition': '',
          'Mass Number': 14,
          'Relative Atomic Mass': 14.003241988,
          'Standard Atomic Weight': 12.0107}},
 7: {14: {'Atomic Number': 7,
          'Atomic Symbol': 'N',
          'Isotopic Composition': 99.632,
          'Mass Number': 14,
          'Relative Atomic Mass': 14.0030740052,
          'Standard Atomic Weight': 14.0067},
     15: {'Atomic Number': 7,
          'Atomic Symbol': 'N',
          'Isotopic Composition': 0.368,
          'Mass Number': 15,
          'Relative Atomic Mass': 15.0001088984,
          'Standard Atomic Weight': 14.0067}},
 8: {16: {'Atomic Number': 8,
          'Atomic Symbol': 'O',
          'Isotopic Composition': 99.757,
          'Mass Number': 16,
          'Relative Atomic Mass': 15.9949146221,
          'Standard Atomic Weight': 15.9994},
     17: {'Atomic Number': 8,
          'Atomic Symbol': 'O',
          'Isotopic Composition': 0.038,
          'Mass Number': 17,
          'Relative Atomic Mass': 16.99913150,
          'Standard Atomic Weight': 15.9994},
     18: {'Atomic Number': 8,
          'Atomic Symbol': 'O',
          'Isotopic Composition': 0.205,
          'Mass Number': 18,
          'Relative Atomic Mass': 17.9991604,
          'Standard Atomic Weight': 15.9994}},
 9: {19: {'Atomic Number': 9,
          'Atomic Symbol': 'F',
          'Isotopic Composition': 100,
          'Mass Number': 19,
          'Relative Atomic Mass': 18.99840320,
          'Standard Atomic Weight': 18.9984032}},
 10: {20: {'Atomic Number': 10,
           'Atomic Symbol': 'Ne',
           'Isotopic Composition': 90.48,
           'Mass Number': 20,
           'Relative Atomic Mass': 19.9924401759,
           'Standard Atomic Weight': 20.1797},
      21: {'Atomic Number': 10,
           'Atomic Symbol': 'Ne',
           'Isotopic Composition': 0.27,
           'Mass Number': 21,
           'Relative Atomic Mass': 20.99384674,
           'Standard Atomic Weight': 20.1797},
      22: {'Atomic Number': 10,
           'Atomic Symbol': 'Ne',
           'Isotopic Composition': 9.25,
           'Mass Number': 22,
           'Relative Atomic Mass': 21.99138551,
           'Standard Atomic Weight': 20.1797}},
 11: {23: {'Atomic Number': 11,
           'Atomic Symbol': 'Na',
           'Isotopic Composition': 100,
           'Mass Number': 23,
           'Relative Atomic Mass': 22.98976967,
           'Standard Atomic Weight': 22.989770}},
 12: {24: {'Atomic Number': 12,
           'Atomic Symbol': 'Mg',
           'Isotopic Composition': 78.99,
           'Mass Number': 24,
           'Relative Atomic Mass': 23.98504190,
           'Standard Atomic Weight': 24.3050},
      25: {'Atomic Number': 12,
           'Atomic Symbol': 'Mg',
           'Isotopic Composition': 10.00,
           'Mass Number': 25,
           'Relative Atomic Mass': 24.98583702,
           'Standard Atomic Weight': 24.3050},
      26: {'Atomic Number': 12,
           'Atomic Symbol': 'Mg',
           'Isotopic Composition': 11.01,
           'Mass Number': 26,
           'Relative Atomic Mass': 25.98259304,
           'Standard Atomic Weight': 24.3050}},
 13: {27: {'Atomic Number': 13,
           'Atomic Symbol': 'Al',
           'Isotopic Composition': 100,
           'Mass Number': 27,
           'Relative Atomic Mass': 26.98153844,
           'Standard Atomic Weight': 26.981538}},
 14: {28: {'Atomic Number': 14,
           'Atomic Symbol': 'Si',
           'Isotopic Composition': 92.2297,
           'Mass Number': 28,
           'Relative Atomic Mass': 27.9769265327,
           'Standard Atomic Weight': 28.0855},
      29: {'Atomic Number': 14,
           'Atomic Symbol': 'Si',
           'Isotopic Composition': 4.6832,
           'Mass Number': 29,
           'Relative Atomic Mass': 28.97649472,
           'Standard Atomic Weight': 28.0855},
      30: {'Atomic Number': 14,
           'Atomic Symbol': 'Si',
           'Isotopic Composition': 3.0872,
           'Mass Number': 30,
           'Relative Atomic Mass': 29.97377022,
           'Standard Atomic Weight': 28.0855}},
 15: {31: {'Atomic Number': 15,
           'Atomic Symbol': 'P',
           'Isotopic Composition': 100,
           'Mass Number': 31,
           'Relative Atomic Mass': 30.97376151,
           'Standard Atomic Weight': 30.973761}},
 16: {32: {'Atomic Number': 16,
           'Atomic Symbol': 'S',
           'Isotopic Composition': 94.93,
           'Mass Number': 32,
           'Relative Atomic Mass': 31.97207069,
           'Standard Atomic Weight': 32.065},
      33: {'Atomic Number': 16,
           'Atomic Symbol': 'S',
           'Isotopic Composition': 0.76,
           'Mass Number': 33,
           'Relative Atomic Mass': 32.97145850,
           'Standard Atomic Weight': 32.065},
      34: {'Atomic Number': 16,
           'Atomic Symbol': 'S',
           'Isotopic Composition': 4.29,
           'Mass Number': 34,
           'Relative Atomic Mass': 33.96786683,
           'Standard Atomic Weight': 32.065},
      36: {'Atomic Number': 16,
           'Atomic Symbol': 'S',
           'Isotopic Composition': 0.02,
           'Mass Number': 36,
           'Relative Atomic Mass': 35.96708088,
           'Standard Atomic Weight': 32.065}},
 17: {35: {'Atomic Number': 17,
           'Atomic Symbol': 'Cl',
           'Isotopic Composition': 75.78,
           'Mass Number': 35,
           'Relative Atomic Mass': 34.96885271,
           'Standard Atomic Weight': 35.453},
      37: {'Atomic Number': 17,
           'Atomic Symbol': 'Cl',
           'Isotopic Composition': 24.22,
           'Mass Number': 37,
           'Relative Atomic Mass': 36.96590260,
           'Standard Atomic Weight': 35.453}},
 18: {36: {'Atomic Number': 18,
           'Atomic Symbol': 'Ar',
           'Isotopic Composition': 0.3365,
           'Mass Number': 36,
           'Relative Atomic Mass': 35.96754628,
           'Standard Atomic Weight': 39.948},
      38: {'Atomic Number': 18,
           'Atomic Symbol': 'Ar',
           'Isotopic Composition': 0.0632,
           'Mass Number': 38,
           'Relative Atomic Mass': 37.9627322,
           'Standard Atomic Weight': 39.948},
      40: {'Atomic Number': 18,
           'Atomic Symbol': 'Ar',
           'Isotopic Composition': 99.6003,
           'Mass Number': 40,
           'Relative Atomic Mass': 39.962383123,
           'Standard Atomic Weight': 39.948}},
 19: {39: {'Atomic Number': 19,
           'Atomic Symbol': 'K',
           'Isotopic Composition': 93.2581,
           'Mass Number': 39,
           'Relative Atomic Mass': 38.9637069,
           'Standard Atomic Weight': 39.0983},
      40: {'Atomic Number': 19,
           'Atomic Symbol': 'K',
           'Isotopic Composition': 0.0117,
           'Mass Number': 40,
           'Relative Atomic Mass': 39.96399867,
           'Standard Atomic Weight': 39.0983},
      41: {'Atomic Number': 19,
           'Atomic Symbol': 'K',
           'Isotopic Composition': 6.7302,
           'Mass Number': 41,
           'Relative Atomic Mass': 40.96182597,
           'Standard Atomic Weight': 39.0983}},
 20: {40: {'Atomic Number': 20,
           'Atomic Symbol': 'Ca',
           'Isotopic Composition': 96.941,
           'Mass Number': 40,
           'Relative Atomic Mass': 39.9625912,
           'Standard Atomic Weight': 40.078},
      42: {'Atomic Number': 20,
           'Atomic Symbol': 'Ca',
           'Isotopic Composition': 0.647,
           'Mass Number': 42,
           'Relative Atomic Mass': 41.9586183,
           'Standard Atomic Weight': 40.078},
      43: {'Atomic Number': 20,
           'Atomic Symbol': 'Ca',
           'Isotopic Composition': 0.135,
           'Mass Number': 43,
           'Relative Atomic Mass': 42.9587668,
           'Standard Atomic Weight': 40.078},
      44: {'Atomic Number': 20,
           'Atomic Symbol': 'Ca',
           'Isotopic Composition': 2.086,
           'Mass Number': 44,
           'Relative Atomic Mass': 43.9554811,
           'Standard Atomic Weight': 40.078},
      46: {'Atomic Number': 20,
           'Atomic Symbol': 'Ca',
           'Isotopic Composition': 0.004,
           'Mass Number': 46,
           'Relative Atomic Mass': 45.9536928,
           'Standard Atomic Weight': 40.078},
      48: {'Atomic Number': 20,
           'Atomic Symbol': 'Ca',
           'Isotopic Composition': 0.187,
           'Mass Number': 48,
           'Relative Atomic Mass': 47.952534,
           'Standard Atomic Weight': 40.078}},
 21: {45: {'Atomic Number': 21,
           'Atomic Symbol': 'Sc',
           'Isotopic Composition': 100,
           'Mass Number': 45,
           'Relative Atomic Mass': 44.9559102,
           'Standard Atomic Weight': 44.955910}},
 22: {46: {'Atomic Number': 22,
           'Atomic Symbol': 'Ti',
           'Isotopic Composition': 8.25,
           'Mass Number': 46,
           'Relative Atomic Mass': 45.9526295,
           'Standard Atomic Weight': 47.867},
      47: {'Atomic Number': 22,
           'Atomic Symbol': 'Ti',
           'Isotopic Composition': 7.44,
           'Mass Number': 47,
           'Relative Atomic Mass': 46.9517638,
           'Standard Atomic Weight': 47.867},
      48: {'Atomic Number': 22,
           'Atomic Symbol': 'Ti',
           'Isotopic Composition': 73.72,
           'Mass Number': 48,
           'Relative Atomic Mass': 47.9479471,
           'Standard Atomic Weight': 47.867},
      49: {'Atomic Number': 22,
           'Atomic Symbol': 'Ti',
           'Isotopic Composition': 5.41,
           'Mass Number': 49,
           'Relative Atomic Mass': 48.9478708,
           'Standard Atomic Weight': 47.867},
      50: {'Atomic Number': 22,
           'Atomic Symbol': 'Ti',
           'Isotopic Composition': 5.18,
           'Mass Number': 50,
           'Relative Atomic Mass': 49.9447921,
           'Standard Atomic Weight': 47.867}},
 23: {50: {'Atomic Number': 23,
           'Atomic Symbol': 'V',
           'Isotopic Composition': 0.250,
           'Mass Number': 50,
           'Relative Atomic Mass': 49.9471628,
           'Standard Atomic Weight': 50.9415},
      51: {'Atomic Number': 23,
           'Atomic Symbol': 'V',
           'Isotopic Composition': 99.750,
           'Mass Number': 51,
           'Relative Atomic Mass': 50.9439637,
           'Standard Atomic Weight': 50.9415}},
 24: {50: {'Atomic Number': 24,
           'Atomic Symbol': 'Cr',
           'Isotopic Composition': 4.345,
           'Mass Number': 50,
           'Relative Atomic Mass': 49.9460496,
           'Standard Atomic Weight': 51.9961},
      52: {'Atomic Number': 24,
           'Atomic Symbol': 'Cr',
           'Isotopic Composition': 83.789,
           'Mass Number': 52,
           'Relative Atomic Mass': 51.9405119,
           'Standard Atomic Weight': 51.9961},
      53: {'Atomic Number': 24,
           'Atomic Symbol': 'Cr',
           'Isotopic Composition': 9.501,
           'Mass Number': 53,
           'Relative Atomic Mass': 52.9406538,
           'Standard Atomic Weight': 51.9961},
      54: {'Atomic Number': 24,
           'Atomic Symbol': 'Cr',
           'Isotopic Composition': 2.365,
           'Mass Number': 54,
           'Relative Atomic Mass': 53.9388849,
           'Standard Atomic Weight': 51.9961}},
 25: {55: {'Atomic Number': 25,
           'Atomic Symbol': 'Mn',
           'Isotopic Composition': 100,
           'Mass Number': 55,
           'Relative Atomic Mass': 54.9380496,
           'Standard Atomic Weight': 54.938049}},
 26: {54: {'Atomic Number': 26,
           'Atomic Symbol': 'Fe',
           'Isotopic Composition': 5.845,
           'Mass Number': 54,
           'Relative Atomic Mass': 53.9396148,
           'Standard Atomic Weight': 55.845},
      56: {'Atomic Number': 26,
           'Atomic Symbol': 'Fe',
           'Isotopic Composition': 91.754,
           'Mass Number': 56,
           'Relative Atomic Mass': 55.9349421,
           'Standard Atomic Weight': 55.845},
      57: {'Atomic Number': 26,
           'Atomic Symbol': 'Fe',
           'Isotopic Composition': 2.119,
           'Mass Number': 57,
           'Relative Atomic Mass': 56.9353987,
           'Standard Atomic Weight': 55.845},
      58: {'Atomic Number': 26,
           'Atomic Symbol': 'Fe',
           'Isotopic Composition': 0.282,
           'Mass Number': 58,
           'Relative Atomic Mass': 57.9332805,
           'Standard Atomic Weight': 55.845}},
 27: {59: {'Atomic Number': 27,
           'Atomic Symbol': 'Co',
           'Isotopic Composition': 100,
           'Mass Number': 59,
           'Relative Atomic Mass': 58.9332002,
           'Standard Atomic Weight': 58.933200}},
 28: {58: {'Atomic Number': 28,
           'Atomic Symbol': 'Ni',
           'Isotopic Composition': 68.0769,
           'Mass Number': 58,
           'Relative Atomic Mass': 57.9353479,
           'Standard Atomic Weight': 58.6934},
      60: {'Atomic Number': 28,
           'Atomic Symbol': 'Ni',
           'Isotopic Composition': 26.2231,
           'Mass Number': 60,
           'Relative Atomic Mass': 59.9307906,
           'Standard Atomic Weight': 58.6934},
      61: {'Atomic Number': 28,
           'Atomic Symbol': 'Ni',
           'Isotopic Composition': 1.1399,
           'Mass Number': 61,
           'Relative Atomic Mass': 60.9310604,
           'Standard Atomic Weight': 58.6934},
      62: {'Atomic Number': 28,
           'Atomic Symbol': 'Ni',
           'Isotopic Composition': 3.6345,
           'Mass Number': 62,
           'Relative Atomic Mass': 61.9283488,
           'Standard Atomic Weight': 58.6934},
      64: {'Atomic Number': 28,
           'Atomic Symbol': 'Ni',
           'Isotopic Composition': 0.9256,
           'Mass Number': 64,
           'Relative Atomic Mass': 63.9279696,
           'Standard Atomic Weight': 58.6934}},
 29: {63: {'Atomic Number': 29,
           'Atomic Symbol': 'Cu',
           'Isotopic Composition': 69.17,
           'Mass Number': 63,
           'Relative Atomic Mass': 62.9296011,
           'Standard Atomic Weight': 63.546},
      65: {'Atomic Number': 29,
           'Atomic Symbol': 'Cu',
           'Isotopic Composition': 30.83,
           'Mass Number': 65,
           'Relative Atomic Mass': 64.9277937,
           'Standard Atomic Weight': 63.546}},
 30: {64: {'Atomic Number': 30,
           'Atomic Symbol': 'Zn',
           'Isotopic Composition': 48.63,
           'Mass Number': 64,
           'Relative Atomic Mass': 63.9291466,
           'Standard Atomic Weight': 65.409},
      66: {'Atomic Number': 30,
           'Atomic Symbol': 'Zn',
           'Isotopic Composition': 27.90,
           'Mass Number': 66,
           'Relative Atomic Mass': 65.9260368,
           'Standard Atomic Weight': 65.409},
      67: {'Atomic Number': 30,
           'Atomic Symbol': 'Zn',
           'Isotopic Composition': 4.10,
           'Mass Number': 67,
           'Relative Atomic Mass': 66.9271309,
           'Standard Atomic Weight': 65.409},
      68: {'Atomic Number': 30,
           'Atomic Symbol': 'Zn',
           'Isotopic Composition': 18.75,
           'Mass Number': 68,
           'Relative Atomic Mass': 67.9248476,
           'Standard Atomic Weight': 65.409},
      70: {'Atomic Number': 30,
           'Atomic Symbol': 'Zn',
           'Isotopic Composition': 0.62,
           'Mass Number': 70,
           'Relative Atomic Mass': 69.925325,
           'Standard Atomic Weight': 65.409}},
 31: {69: {'Atomic Number': 31,
           'Atomic Symbol': 'Ga',
           'Isotopic Composition': 60.108,
           'Mass Number': 69,
           'Relative Atomic Mass': 68.925581,
           'Standard Atomic Weight': 69.723},
      71: {'Atomic Number': 31,
           'Atomic Symbol': 'Ga',
           'Isotopic Composition': 39.892,
           'Mass Number': 71,
           'Relative Atomic Mass': 70.9247050,
           'Standard Atomic Weight': 69.723}},
 32: {70: {'Atomic Number': 32,
           'Atomic Symbol': 'Ge',
           'Isotopic Composition': 20.84,
           'Mass Number': 70,
           'Relative Atomic Mass': 69.9242504,
           'Standard Atomic Weight': 72.64},
      72: {'Atomic Number': 32,
           'Atomic Symbol': 'Ge',
           'Isotopic Composition': 27.54,
           'Mass Number': 72,
           'Relative Atomic Mass': 71.9220762,
           'Standard Atomic Weight': 72.64},
      73: {'Atomic Number': 32,
           'Atomic Symbol': 'Ge',
           'Isotopic Composition': 7.73,
           'Mass Number': 73,
           'Relative Atomic Mass': 72.9234594,
           'Standard Atomic Weight': 72.64},
      74: {'Atomic Number': 32,
           'Atomic Symbol': 'Ge',
           'Isotopic Composition': 36.28,
           'Mass Number': 74,
           'Relative Atomic Mass': 73.9211782,
           'Standard Atomic Weight': 72.64},
      76: {'Atomic Number': 32,
           'Atomic Symbol': 'Ge',
           'Isotopic Composition': 7.61,
           'Mass Number': 76,
           'Relative Atomic Mass': 75.9214027,
           'Standard Atomic Weight': 72.64}},
 33: {75: {'Atomic Number': 33,
           'Atomic Symbol': 'As',
           'Isotopic Composition': 100,
           'Mass Number': 75,
           'Relative Atomic Mass': 74.9215964,
           'Standard Atomic Weight': 74.92160}},
 34: {74: {'Atomic Number': 34,
           'Atomic Symbol': 'Se',
           'Isotopic Composition': 0.89,
           'Mass Number': 74,
           'Relative Atomic Mass': 73.9224766,
           'Standard Atomic Weight': 78.96},
      76: {'Atomic Number': 34,
           'Atomic Symbol': 'Se',
           'Isotopic Composition': 9.37,
           'Mass Number': 76,
           'Relative Atomic Mass': 75.9192141,
           'Standard Atomic Weight': 78.96},
      77: {'Atomic Number': 34,
           'Atomic Symbol': 'Se',
           'Isotopic Composition': 7.63,
           'Mass Number': 77,
           'Relative Atomic Mass': 76.9199146,
           'Standard Atomic Weight': 78.96},
      78: {'Atomic Number': 34,
           'Atomic Symbol': 'Se',
           'Isotopic Composition': 23.77,
           'Mass Number': 78,
           'Relative Atomic Mass': 77.9173095,
           'Standard Atomic Weight': 78.96},
      80: {'Atomic Number': 34,
           'Atomic Symbol': 'Se',
           'Isotopic Composition': 49.61,
           'Mass Number': 80,
           'Relative Atomic Mass': 79.9165218,
           'Standard Atomic Weight': 78.96},
      82: {'Atomic Number': 34,
           'Atomic Symbol': 'Se',
           'Isotopic Composition': 8.73,
           'Mass Number': 82,
           'Relative Atomic Mass': 81.9167000,
           'Standard Atomic Weight': 78.96}},
 35: {79: {'Atomic Number': 35,
           'Atomic Symbol': 'Br',
           'Isotopic Composition': 50.69,
           'Mass Number': 79,
           'Relative Atomic Mass': 78.9183376,
           'Standard Atomic Weight': 79.904},
      81: {'Atomic Number': 35,
           'Atomic Symbol': 'Br',
           'Isotopic Composition': 49.31,
           'Mass Number': 81,
           'Relative Atomic Mass': 80.916291,
           'Standard Atomic Weight': 79.904}},
 36: {78: {'Atomic Number': 36,
           'Atomic Symbol': 'Kr',
           'Isotopic Composition': 0.35,
           'Mass Number': 78,
           'Relative Atomic Mass': 77.920386,
           'Standard Atomic Weight': 83.798},
      80: {'Atomic Number': 36,
           'Atomic Symbol': 'Kr',
           'Isotopic Composition': 2.28,
           'Mass Number': 80,
           'Relative Atomic Mass': 79.916378,
           'Standard Atomic Weight': 83.798},
      82: {'Atomic Number': 36,
           'Atomic Symbol': 'Kr',
           'Isotopic Composition': 11.58,
           'Mass Number': 82,
           'Relative Atomic Mass': 81.9134846,
           'Standard Atomic Weight': 83.798},
      83: {'Atomic Number': 36,
           'Atomic Symbol': 'Kr',
           'Isotopic Composition': 11.49,
           'Mass Number': 83,
           'Relative Atomic Mass': 82.914136,
           'Standard Atomic Weight': 83.798},
      84: {'Atomic Number': 36,
           'Atomic Symbol': 'Kr',
           'Isotopic Composition': 57.00,
           'Mass Number': 84,
           'Relative Atomic Mass': 83.911507,
           'Standard Atomic Weight': 83.798},
      86: {'Atomic Number': 36,
           'Atomic Symbol': 'Kr',
           'Isotopic Composition': 17.30,
           'Mass Number': 86,
           'Relative Atomic Mass': 85.9106103,
           'Standard Atomic Weight': 83.798}},
 37: {85: {'Atomic Number': 37,
           'Atomic Symbol': 'Rb',
           'Isotopic Composition': 72.17,
           'Mass Number': 85,
           'Relative Atomic Mass': 84.9117893,
           'Standard Atomic Weight': 85.4678},
      87: {'Atomic Number': 37,
           'Atomic Symbol': 'Rb',
           'Isotopic Composition': 27.83,
           'Mass Number': 87,
           'Relative Atomic Mass': 86.9091835,
           'Standard Atomic Weight': 85.4678}},
 38: {84: {'Atomic Number': 38,
           'Atomic Symbol': 'Sr',
           'Isotopic Composition': 0.56,
           'Mass Number': 84,
           'Relative Atomic Mass': 83.913425,
           'Standard Atomic Weight': 87.62},
      86: {'Atomic Number': 38,
           'Atomic Symbol': 'Sr',
           'Isotopic Composition': 9.86,
           'Mass Number': 86,
           'Relative Atomic Mass': 85.9092624,
           'Standard Atomic Weight': 87.62},
      87: {'Atomic Number': 38,
           'Atomic Symbol': 'Sr',
           'Isotopic Composition': 7.00,
           'Mass Number': 87,
           'Relative Atomic Mass': 86.9088793,
           'Standard Atomic Weight': 87.62},
      88: {'Atomic Number': 38,
           'Atomic Symbol': 'Sr',
           'Isotopic Composition': 82.58,
           'Mass Number': 88,
           'Relative Atomic Mass': 87.9056143,
           'Standard Atomic Weight': 87.62}},
 39: {89: {'Atomic Number': 39,
           'Atomic Symbol': 'Y',
           'Isotopic Composition': 100,
           'Mass Number': 89,
           'Relative Atomic Mass': 88.9058479,
           'Standard Atomic Weight': 88.90585}},
 40: {90: {'Atomic Number': 40,
           'Atomic Symbol': 'Zr',
           'Isotopic Composition': 51.45,
           'Mass Number': 90,
           'Relative Atomic Mass': 89.9047037,
           'Standard Atomic Weight': 91.224},
      91: {'Atomic Number': 40,
           'Atomic Symbol': 'Zr',
           'Isotopic Composition': 11.22,
           'Mass Number': 91,
           'Relative Atomic Mass': 90.9056450,
           'Standard Atomic Weight': 91.224},
      92: {'Atomic Number': 40,
           'Atomic Symbol': 'Zr',
           'Isotopic Composition': 17.15,
           'Mass Number': 92,
           'Relative Atomic Mass': 91.9050401,
           'Standard Atomic Weight': 91.224},
      94: {'Atomic Number': 40,
           'Atomic Symbol': 'Zr',
           'Isotopic Composition': 17.38,
           'Mass Number': 94,
           'Relative Atomic Mass': 93.9063158,
           'Standard Atomic Weight': 91.224},
      96: {'Atomic Number': 40,
           'Atomic Symbol': 'Zr',
           'Isotopic Composition': 2.80,
           'Mass Number': 96,
           'Relative Atomic Mass': 95.908276,
           'Standard Atomic Weight': 91.224}},
 41: {93: {'Atomic Number': 41,
           'Atomic Symbol': 'Nb',
           'Isotopic Composition': 100,
           'Mass Number': 93,
           'Relative Atomic Mass': 92.9063775,
           'Standard Atomic Weight': 92.90638}},
 42: {92: {'Atomic Number': 42,
           'Atomic Symbol': 'Mo',
           'Isotopic Composition': 14.84,
           'Mass Number': 92,
           'Relative Atomic Mass': 91.906810,
           'Standard Atomic Weight': 95.94},
      94: {'Atomic Number': 42,
           'Atomic Symbol': 'Mo',
           'Isotopic Composition': 9.25,
           'Mass Number': 94,
           'Relative Atomic Mass': 93.9050876,
           'Standard Atomic Weight': 95.94},
      95: {'Atomic Number': 42,
           'Atomic Symbol': 'Mo',
           'Isotopic Composition': 15.92,
           'Mass Number': 95,
           'Relative Atomic Mass': 94.9058415,
           'Standard Atomic Weight': 95.94},
      96: {'Atomic Number': 42,
           'Atomic Symbol': 'Mo',
           'Isotopic Composition': 16.68,
           'Mass Number': 96,
           'Relative Atomic Mass': 95.9046789,
           'Standard Atomic Weight': 95.94},
      97: {'Atomic Number': 42,
           'Atomic Symbol': 'Mo',
           'Isotopic Composition': 9.55,
           'Mass Number': 97,
           'Relative Atomic Mass': 96.9060210,
           'Standard Atomic Weight': 95.94},
      98: {'Atomic Number': 42,
           'Atomic Symbol': 'Mo',
           'Isotopic Composition': 24.13,
           'Mass Number': 98,
           'Relative Atomic Mass': 97.9054078,
           'Standard Atomic Weight': 95.94},
      100: {'Atomic Number': 42,
            'Atomic Symbol': 'Mo',
            'Isotopic Composition': 9.63,
            'Mass Number': 100,
            'Relative Atomic Mass': 99.907477,
            'Standard Atomic Weight': 95.94}},
 43: {97: {'Atomic Number': 43,
           'Atomic Symbol': 'Tc',
           'Isotopic Composition': '',
           'Mass Number': 97,
           'Relative Atomic Mass': 96.906365,
           'Standard Atomic Weight': 98},
      98: {'Atomic Number': 43,
           'Atomic Symbol': 'Tc',
           'Isotopic Composition': '',
           'Mass Number': 98,
           'Relative Atomic Mass': 97.907216,
           'Standard Atomic Weight': 98},
      99: {'Atomic Number': 43,
           'Atomic Symbol': 'Tc',
           'Isotopic Composition': '',
           'Mass Number': 99,
           'Relative Atomic Mass': 98.9062546,
           'Standard Atomic Weight': 98}},
 44: {96: {'Atomic Number': 44,
           'Atomic Symbol': 'Ru',
           'Isotopic Composition': 5.54,
           'Mass Number': 96,
           'Relative Atomic Mass': 95.907598,
           'Standard Atomic Weight': 101.07},
      98: {'Atomic Number': 44,
           'Atomic Symbol': 'Ru',
           'Isotopic Composition': 1.87,
           'Mass Number': 98,
           'Relative Atomic Mass': 97.905287,
           'Standard Atomic Weight': 101.07},
      99: {'Atomic Number': 44,
           'Atomic Symbol': 'Ru',
           'Isotopic Composition': 12.76,
           'Mass Number': 99,
           'Relative Atomic Mass': 98.9059393,
           'Standard Atomic Weight': 101.07},
      100: {'Atomic Number': 44,
            'Atomic Symbol': 'Ru',
            'Isotopic Composition': 12.60,
            'Mass Number': 100,
            'Relative Atomic Mass': 99.9042197,
            'Standard Atomic Weight': 101.07},
      101: {'Atomic Number': 44,
            'Atomic Symbol': 'Ru',
            'Isotopic Composition': 17.06,
            'Mass Number': 101,
            'Relative Atomic Mass': 100.9055822,
            'Standard Atomic Weight': 101.07},
      102: {'Atomic Number': 44,
            'Atomic Symbol': 'Ru',
            'Isotopic Composition': 31.55,
            'Mass Number': 102,
            'Relative Atomic Mass': 101.9043495,
            'Standard Atomic Weight': 101.07},
      104: {'Atomic Number': 44,
            'Atomic Symbol': 'Ru',
            'Isotopic Composition': 18.62,
            'Mass Number': 104,
            'Relative Atomic Mass': 103.905430,
            'Standard Atomic Weight': 101.07}},
 45: {103: {'Atomic Number': 45,
            'Atomic Symbol': 'Rh',
            'Isotopic Composition': 100,
            'Mass Number': 103,
            'Relative Atomic Mass': 102.905504,
            'Standard Atomic Weight': 102.90550}},
 46: {102: {'Atomic Number': 46,
            'Atomic Symbol': 'Pd',
            'Isotopic Composition': 1.02,
            'Mass Number': 102,
            'Relative Atomic Mass': 101.905608,
            'Standard Atomic Weight': 106.42},
      104: {'Atomic Number': 46,
            'Atomic Symbol': 'Pd',
            'Isotopic Composition': 11.14,
            'Mass Number': 104,
            'Relative Atomic Mass': 103.904035,
            'Standard Atomic Weight': 106.42},
      105: {'Atomic Number': 46,
            'Atomic Symbol': 'Pd',
            'Isotopic Composition': 22.33,
            'Mass Number': 105,
            'Relative Atomic Mass': 104.905084,
            'Standard Atomic Weight': 106.42},
      106: {'Atomic Number': 46,
            'Atomic Symbol': 'Pd',
            'Isotopic Composition': 27.33,
            'Mass Number': 106,
            'Relative Atomic Mass': 105.903483,
            'Standard Atomic Weight': 106.42},
      108: {'Atomic Number': 46,
            'Atomic Symbol': 'Pd',
            'Isotopic Composition': 26.46,
            'Mass Number': 108,
            'Relative Atomic Mass': 107.903894,
            'Standard Atomic Weight': 106.42},
      110: {'Atomic Number': 46,
            'Atomic Symbol': 'Pd',
            'Isotopic Composition': 11.72,
            'Mass Number': 110,
            'Relative Atomic Mass': 109.905152,
            'Standard Atomic Weight': 106.42}},
 47: {107: {'Atomic Number': 47,
            'Atomic Symbol': 'Ag',
            'Isotopic Composition': 51.839,
            'Mass Number': 107,
            'Relative Atomic Mass': 106.905093,
            'Standard Atomic Weight': 107.8682},
      109: {'Atomic Number': 47,
            'Atomic Symbol': 'Ag',
            'Isotopic Composition': 48.161,
            'Mass Number': 109,
            'Relative Atomic Mass': 108.904756,
            'Standard Atomic Weight': 107.8682}},
 48: {106: {'Atomic Number': 48,
            'Atomic Symbol': 'Cd',
            'Isotopic Composition': 1.25,
            'Mass Number': 106,
            'Relative Atomic Mass': 105.906458,
            'Standard Atomic Weight': 112.411},
      108: {'Atomic Number': 48,
            'Atomic Symbol': 'Cd',
            'Isotopic Composition': 0.89,
            'Mass Number': 108,
            'Relative Atomic Mass': 107.904183,
            'Standard Atomic Weight': 112.411},
      110: {'Atomic Number': 48,
            'Atomic Symbol': 'Cd',
            'Isotopic Composition': 12.49,
            'Mass Number': 110,
            'Relative Atomic Mass': 109.903006,
            'Standard Atomic Weight': 112.411},
      111: {'Atomic Number': 48,
            'Atomic Symbol': 'Cd',
            'Isotopic Composition': 12.80,
            'Mass Number': 111,
            'Relative Atomic Mass': 110.904182,
            'Standard Atomic Weight': 112.411},
      112: {'Atomic Number': 48,
            'Atomic Symbol': 'Cd',
            'Isotopic Composition': 24.13,
            'Mass Number': 112,
            'Relative Atomic Mass': 111.9027572,
            'Standard Atomic Weight': 112.411},
      113: {'Atomic Number': 48,
            'Atomic Symbol': 'Cd',
            'Isotopic Composition': 12.22,
            'Mass Number': 113,
            'Relative Atomic Mass': 112.9044009,
            'Standard Atomic Weight': 112.411},
      114: {'Atomic Number': 48,
            'Atomic Symbol': 'Cd',
            'Isotopic Composition': 28.73,
            'Mass Number': 114,
            'Relative Atomic Mass': 113.9033581,
            'Standard Atomic Weight': 112.411},
      116: {'Atomic Number': 48,
            'Atomic Symbol': 'Cd',
            'Isotopic Composition': 7.49,
            'Mass Number': 116,
            'Relative Atomic Mass': 115.904755,
            'Standard Atomic Weight': 112.411}},
 49: {113: {'Atomic Number': 49,
            'Atomic Symbol': 'In',
            'Isotopic Composition': 4.29,
            'Mass Number': 113,
            'Relative Atomic Mass': 112.904061,
            'Standard Atomic Weight': 114.818},
      115: {'Atomic Number': 49,
            'Atomic Symbol': 'In',
            'Isotopic Composition': 95.71,
            'Mass Number': 115,
            'Relative Atomic Mass': 114.903878,
            'Standard Atomic Weight': 114.818}},
 50: {112: {'Atomic Number': 50,
            'Atomic Symbol': 'Sn',
            'Isotopic Composition': 0.97,
            'Mass Number': 112,
            'Relative Atomic Mass': 111.904821,
            'Standard Atomic Weight': 118.710},
      114: {'Atomic Number': 50,
            'Atomic Symbol': 'Sn',
            'Isotopic Composition': 0.66,
            'Mass Number': 114,
            'Relative Atomic Mass': 113.902782,
            'Standard Atomic Weight': 118.710},
      115: {'Atomic Number': 50,
            'Atomic Symbol': 'Sn',
            'Isotopic Composition': 0.34,
            'Mass Number': 115,
            'Relative Atomic Mass': 114.903346,
            'Standard Atomic Weight': 118.710},
      116: {'Atomic Number': 50,
            'Atomic Symbol': 'Sn',
            'Isotopic Composition': 14.54,
            'Mass Number': 116,
            'Relative Atomic Mass': 115.901744,
            'Standard Atomic Weight': 118.710},
      117: {'Atomic Number': 50,
            'Atomic Symbol': 'Sn',
            'Isotopic Composition': 7.68,
            'Mass Number': 117,
            'Relative Atomic Mass': 116.902954,
            'Standard Atomic Weight': 118.710},
      118: {'Atomic Number': 50,
            'Atomic Symbol': 'Sn',
            'Isotopic Composition': 24.22,
            'Mass Number': 118,
            'Relative Atomic Mass': 117.901606,
            'Standard Atomic Weight': 118.710},
      119: {'Atomic Number': 50,
            'Atomic Symbol': 'Sn',
            'Isotopic Composition': 8.59,
            'Mass Number': 119,
            'Relative Atomic Mass': 118.903309,
            'Standard Atomic Weight': 118.710},
      120: {'Atomic Number': 50,
            'Atomic Symbol': 'Sn',
            'Isotopic Composition': 32.58,
            'Mass Number': 120,
            'Relative Atomic Mass': 119.9021966,
            'Standard Atomic Weight': 118.710},
      122: {'Atomic Number': 50,
            'Atomic Symbol': 'Sn',
            'Isotopic Composition': 4.63,
            'Mass Number': 122,
            'Relative Atomic Mass': 121.9034401,
            'Standard Atomic Weight': 118.710},
      124: {'Atomic Number': 50,
            'Atomic Symbol': 'Sn',
            'Isotopic Composition': 5.79,
            'Mass Number': 124,
            'Relative Atomic Mass': 123.9052746,
            'Standard Atomic Weight': 118.710}},
 51: {121: {'Atomic Number': 51,
            'Atomic Symbol': 'Sb',
            'Isotopic Composition': 57.21,
            'Mass Number': 121,
            'Relative Atomic Mass': 120.9038180,
            'Standard Atomic Weight': 121.760},
      123: {'Atomic Number': 51,
            'Atomic Symbol': 'Sb',
            'Isotopic Composition': 42.79,
            'Mass Number': 123,
            'Relative Atomic Mass': 122.9042157,
            'Standard Atomic Weight': 121.760}},
 52: {120: {'Atomic Number': 52,
            'Atomic Symbol': 'Te',
            'Isotopic Composition': 0.09,
            'Mass Number': 120,
            'Relative Atomic Mass': 119.904020,
            'Standard Atomic Weight': 127.60},
      122: {'Atomic Number': 52,
            'Atomic Symbol': 'Te',
            'Isotopic Composition': 2.55,
            'Mass Number': 122,
            'Relative Atomic Mass': 121.9030471,
            'Standard Atomic Weight': 127.60},
      123: {'Atomic Number': 52,
            'Atomic Symbol': 'Te',
            'Isotopic Composition': 0.89,
            'Mass Number': 123,
            'Relative Atomic Mass': 122.9042730,
            'Standard Atomic Weight': 127.60},
      124: {'Atomic Number': 52,
            'Atomic Symbol': 'Te',
            'Isotopic Composition': 4.74,
            'Mass Number': 124,
            'Relative Atomic Mass': 123.9028195,
            'Standard Atomic Weight': 127.60},
      125: {'Atomic Number': 52,
            'Atomic Symbol': 'Te',
            'Isotopic Composition': 7.07,
            'Mass Number': 125,
            'Relative Atomic Mass': 124.9044247,
            'Standard Atomic Weight': 127.60},
      126: {'Atomic Number': 52,
            'Atomic Symbol': 'Te',
            'Isotopic Composition': 18.84,
            'Mass Number': 126,
            'Relative Atomic Mass': 125.9033055,
            'Standard Atomic Weight': 127.60},
      128: {'Atomic Number': 52,
            'Atomic Symbol': 'Te',
            'Isotopic Composition': 31.74,
            'Mass Number': 128,
            'Relative Atomic Mass': 127.9044614,
            'Standard Atomic Weight': 127.60},
      130: {'Atomic Number': 52,
            'Atomic Symbol': 'Te',
            'Isotopic Composition': 34.08,
            'Mass Number': 130,
            'Relative Atomic Mass': 129.9062228,
            'Standard Atomic Weight': 127.60}},
 53: {127: {'Atomic Number': 53,
            'Atomic Symbol': 'I',
            'Isotopic Composition': 100,
            'Mass Number': 127,
            'Relative Atomic Mass': 126.904468,
            'Standard Atomic Weight': 126.90447}},
 54: {124: {'Atomic Number': 54,
            'Atomic Symbol': 'Xe',
            'Isotopic Composition': 0.09,
            'Mass Number': 124,
            'Relative Atomic Mass': 123.9058958,
            'Standard Atomic Weight': 131.293},
      126: {'Atomic Number': 54,
            'Atomic Symbol': 'Xe',
            'Isotopic Composition': 0.09,
            'Mass Number': 126,
            'Relative Atomic Mass': 125.904269,
            'Standard Atomic Weight': 131.293},
      128: {'Atomic Number': 54,
            'Atomic Symbol': 'Xe',
            'Isotopic Composition': 1.92,
            'Mass Number': 128,
            'Relative Atomic Mass': 127.9035304,
            'Standard Atomic Weight': 131.293},
      129: {'Atomic Number': 54,
            'Atomic Symbol': 'Xe',
            'Isotopic Composition': 26.44,
            'Mass Number': 129,
            'Relative Atomic Mass': 128.9047795,
            'Standard Atomic Weight': 131.293},
      130: {'Atomic Number': 54,
            'Atomic Symbol': 'Xe',
            'Isotopic Composition': 4.08,
            'Mass Number': 130,
            'Relative Atomic Mass': 129.9035079,
            'Standard Atomic Weight': 131.293},
      131: {'Atomic Number': 54,
            'Atomic Symbol': 'Xe',
            'Isotopic Composition': 21.18,
            'Mass Number': 131,
            'Relative Atomic Mass': 130.9050819,
            'Standard Atomic Weight': 131.293},
      132: {'Atomic Number': 54,
            'Atomic Symbol': 'Xe',
            'Isotopic Composition': 26.89,
            'Mass Number': 132,
            'Relative Atomic Mass': 131.9041545,
            'Standard Atomic Weight': 131.293},
      134: {'Atomic Number': 54,
            'Atomic Symbol': 'Xe',
            'Isotopic Composition': 10.44,
            'Mass Number': 134,
            'Relative Atomic Mass': 133.9053945,
            'Standard Atomic Weight': 131.293},
      136: {'Atomic Number': 54,
            'Atomic Symbol': 'Xe',
            'Isotopic Composition': 8.87,
            'Mass Number': 136,
            'Relative Atomic Mass': 135.907220,
            'Standard Atomic Weight': 131.293}},
 55: {133: {'Atomic Number': 55,
            'Atomic Symbol': 'Cs',
            'Isotopic Composition': 100,
            'Mass Number': 133,
            'Relative Atomic Mass': 132.905447,
            'Standard Atomic Weight': 132.90545}},
 56: {130: {'Atomic Number': 56,
            'Atomic Symbol': 'Ba',
            'Isotopic Composition': 0.106,
            'Mass Number': 130,
            'Relative Atomic Mass': 129.906310,
            'Standard Atomic Weight': 137.327},
      132: {'Atomic Number': 56,
            'Atomic Symbol': 'Ba',
            'Isotopic Composition': 0.101,
            'Mass Number': 132,
            'Relative Atomic Mass': 131.905056,
            'Standard Atomic Weight': 137.327},
      134: {'Atomic Number': 56,
            'Atomic Symbol': 'Ba',
            'Isotopic Composition': 2.417,
            'Mass Number': 134,
            'Relative Atomic Mass': 133.904503,
            'Standard Atomic Weight': 137.327},
      135: {'Atomic Number': 56,
            'Atomic Symbol': 'Ba',
            'Isotopic Composition': 6.592,
            'Mass Number': 135,
            'Relative Atomic Mass': 134.905683,
            'Standard Atomic Weight': 137.327},
      136: {'Atomic Number': 56,
            'Atomic Symbol': 'Ba',
            'Isotopic Composition': 7.854,
            'Mass Number': 136,
            'Relative Atomic Mass': 135.904570,
            'Standard Atomic Weight': 137.327},
      137: {'Atomic Number': 56,
            'Atomic Symbol': 'Ba',
            'Isotopic Composition': 11.232,
            'Mass Number': 137,
            'Relative Atomic Mass': 136.905821,
            'Standard Atomic Weight': 137.327},
      138: {'Atomic Number': 56,
            'Atomic Symbol': 'Ba',
            'Isotopic Composition': 71.698,
            'Mass Number': 138,
            'Relative Atomic Mass': 137.905241,
            'Standard Atomic Weight': 137.327}},
 57: {138: {'Atomic Number': 57,
            'Atomic Symbol': 'La',
            'Isotopic Composition': 0.090,
            'Mass Number': 138,
            'Relative Atomic Mass': 137.907107,
            'Standard Atomic Weight': 138.9055},
      139: {'Atomic Number': 57,
            'Atomic Symbol': 'La',
            'Isotopic Composition': 99.910,
            'Mass Number': 139,
            'Relative Atomic Mass': 138.906348,
            'Standard Atomic Weight': 138.9055}},
 58: {136: {'Atomic Number': 58,
            'Atomic Symbol': 'Ce',
            'Isotopic Composition': 0.185,
            'Mass Number': 136,
            'Relative Atomic Mass': 135.907140,
            'Standard Atomic Weight': 140.116},
      138: {'Atomic Number': 58,
            'Atomic Symbol': 'Ce',
            'Isotopic Composition': 0.251,
            'Mass Number': 138,
            'Relative Atomic Mass': 137.905986,
            'Standard Atomic Weight': 140.116},
      140: {'Atomic Number': 58,
            'Atomic Symbol': 'Ce',
            'Isotopic Composition': 88.450,
            'Mass Number': 140,
            'Relative Atomic Mass': 139.905434,
            'Standard Atomic Weight': 140.116},
      142: {'Atomic Number': 58,
            'Atomic Symbol': 'Ce',
            'Isotopic Composition': 11.114,
            'Mass Number': 142,
            'Relative Atomic Mass': 141.909240,
            'Standard Atomic Weight': 140.116}},
 59: {141: {'Atomic Number': 59,
            'Atomic Symbol': 'Pr',
            'Isotopic Composition': 100,
            'Mass Number': 141,
            'Relative Atomic Mass': 140.907648,
            'Standard Atomic Weight': 140.90765}},
 60: {142: {'Atomic Number': 60,
            'Atomic Symbol': 'Nd',
            'Isotopic Composition': 27.2,
            'Mass Number': 142,
            'Relative Atomic Mass': 141.907719,
            'Standard Atomic Weight': 144.24},
      143: {'Atomic Number': 60,
            'Atomic Symbol': 'Nd',
            'Isotopic Composition': 12.2,
            'Mass Number': 143,
            'Relative Atomic Mass': 142.909810,
            'Standard Atomic Weight': 144.24},
      144: {'Atomic Number': 60,
            'Atomic Symbol': 'Nd',
            'Isotopic Composition': 23.8,
            'Mass Number': 144,
            'Relative Atomic Mass': 143.910083,
            'Standard Atomic Weight': 144.24},
      145: {'Atomic Number': 60,
            'Atomic Symbol': 'Nd',
            'Isotopic Composition': 8.3,
            'Mass Number': 145,
            'Relative Atomic Mass': 144.912569,
            'Standard Atomic Weight': 144.24},
      146: {'Atomic Number': 60,
            'Atomic Symbol': 'Nd',
            'Isotopic Composition': 17.2,
            'Mass Number': 146,
            'Relative Atomic Mass': 145.913112,
            'Standard Atomic Weight': 144.24},
      148: {'Atomic Number': 60,
            'Atomic Symbol': 'Nd',
            'Isotopic Composition': 5.7,
            'Mass Number': 148,
            'Relative Atomic Mass': 147.916889,
            'Standard Atomic Weight': 144.24},
      150: {'Atomic Number': 60,
            'Atomic Symbol': 'Nd',
            'Isotopic Composition': 5.6,
            'Mass Number': 150,
            'Relative Atomic Mass': 149.920887,
            'Standard Atomic Weight': 144.24}},
 61: {145: {'Atomic Number': 61,
            'Atomic Symbol': 'Pm',
            'Isotopic Composition': '',
            'Mass Number': 145,
            'Relative Atomic Mass': 144.912744,
            'Standard Atomic Weight': 145},
      147: {'Atomic Number': 61,
            'Atomic Symbol': 'Pm',
            'Isotopic Composition': '',
            'Mass Number': 147,
            'Relative Atomic Mass': 146.915134,
            'Standard Atomic Weight': 145}},
 62: {144: {'Atomic Number': 62,
            'Atomic Symbol': 'Sm',
            'Isotopic Composition': 3.07,
            'Mass Number': 144,
            'Relative Atomic Mass': 143.911995,
            'Standard Atomic Weight': 150.36},
      147: {'Atomic Number': 62,
            'Atomic Symbol': 'Sm',
            'Isotopic Composition': 14.99,
            'Mass Number': 147,
            'Relative Atomic Mass': 146.914893,
            'Standard Atomic Weight': 150.36},
      148: {'Atomic Number': 62,
            'Atomic Symbol': 'Sm',
            'Isotopic Composition': 11.24,
            'Mass Number': 148,
            'Relative Atomic Mass': 147.914818,
            'Standard Atomic Weight': 150.36},
      149: {'Atomic Number': 62,
            'Atomic Symbol': 'Sm',
            'Isotopic Composition': 13.82,
            'Mass Number': 149,
            'Relative Atomic Mass': 148.917180,
            'Standard Atomic Weight': 150.36},
      150: {'Atomic Number': 62,
            'Atomic Symbol': 'Sm',
            'Isotopic Composition': 7.38,
            'Mass Number': 150,
            'Relative Atomic Mass': 149.917271,
            'Standard Atomic Weight': 150.36},
      152: {'Atomic Number': 62,
            'Atomic Symbol': 'Sm',
            'Isotopic Composition': 26.75,
            'Mass Number': 152,
            'Relative Atomic Mass': 151.919728,
            'Standard Atomic Weight': 150.36},
      154: {'Atomic Number': 62,
            'Atomic Symbol': 'Sm',
            'Isotopic Composition': 22.75,
            'Mass Number': 154,
            'Relative Atomic Mass': 153.922205,
            'Standard Atomic Weight': 150.36}},
 63: {151: {'Atomic Number': 63,
            'Atomic Symbol': 'Eu',
            'Isotopic Composition': 47.81,
            'Mass Number': 151,
            'Relative Atomic Mass': 150.919846,
            'Standard Atomic Weight': 151.964},
      153: {'Atomic Number': 63,
            'Atomic Symbol': 'Eu',
            'Isotopic Composition': 52.19,
            'Mass Number': 153,
            'Relative Atomic Mass': 152.921226,
            'Standard Atomic Weight': 151.964}},
 64: {152: {'Atomic Number': 64,
            'Atomic Symbol': 'Gd',
            'Isotopic Composition': 0.20,
            'Mass Number': 152,
            'Relative Atomic Mass': 151.919788,
            'Standard Atomic Weight': 157.25},
      154: {'Atomic Number': 64,
            'Atomic Symbol': 'Gd',
            'Isotopic Composition': 2.18,
            'Mass Number': 154,
            'Relative Atomic Mass': 153.920862,
            'Standard Atomic Weight': 157.25},
      155: {'Atomic Number': 64,
            'Atomic Symbol': 'Gd',
            'Isotopic Composition': 14.80,
            'Mass Number': 155,
            'Relative Atomic Mass': 154.922619,
            'Standard Atomic Weight': 157.25},
      156: {'Atomic Number': 64,
            'Atomic Symbol': 'Gd',
            'Isotopic Composition': 20.47,
            'Mass Number': 156,
            'Relative Atomic Mass': 155.922120,
            'Standard Atomic Weight': 157.25},
      157: {'Atomic Number': 64,
            'Atomic Symbol': 'Gd',
            'Isotopic Composition': 15.65,
            'Mass Number': 157,
            'Relative Atomic Mass': 156.923957,
            'Standard Atomic Weight': 157.25},
      158: {'Atomic Number': 64,
            'Atomic Symbol': 'Gd',
            'Isotopic Composition': 24.84,
            'Mass Number': 158,
            'Relative Atomic Mass': 157.924101,
            'Standard Atomic Weight': 157.25},
      160: {'Atomic Number': 64,
            'Atomic Symbol': 'Gd',
            'Isotopic Composition': 21.86,
            'Mass Number': 160,
            'Relative Atomic Mass': 159.927051,
            'Standard Atomic Weight': 157.25}},
 65: {159: {'Atomic Number': 65,
            'Atomic Symbol': 'Tb',
            'Isotopic Composition': 100,
            'Mass Number': 159,
            'Relative Atomic Mass': 158.925343,
            'Standard Atomic Weight': 158.92534}},
 66: {156: {'Atomic Number': 66,
            'Atomic Symbol': 'Dy',
            'Isotopic Composition': 0.06,
            'Mass Number': 156,
            'Relative Atomic Mass': 155.924278,
            'Standard Atomic Weight': 162.500},
      158: {'Atomic Number': 66,
            'Atomic Symbol': 'Dy',
            'Isotopic Composition': 0.10,
            'Mass Number': 158,
            'Relative Atomic Mass': 157.924405,
            'Standard Atomic Weight': 162.500},
      160: {'Atomic Number': 66,
            'Atomic Symbol': 'Dy',
            'Isotopic Composition': 2.34,
            'Mass Number': 160,
            'Relative Atomic Mass': 159.925194,
            'Standard Atomic Weight': 162.500},
      161: {'Atomic Number': 66,
            'Atomic Symbol': 'Dy',
            'Isotopic Composition': 18.91,
            'Mass Number': 161,
            'Relative Atomic Mass': 160.926930,
            'Standard Atomic Weight': 162.500},
      162: {'Atomic Number': 66,
            'Atomic Symbol': 'Dy',
            'Isotopic Composition': 25.51,
            'Mass Number': 162,
            'Relative Atomic Mass': 161.926795,
            'Standard Atomic Weight': 162.500},
      163: {'Atomic Number': 66,
            'Atomic Symbol': 'Dy',
            'Isotopic Composition': 24.90,
            'Mass Number': 163,
            'Relative Atomic Mass': 162.928728,
            'Standard Atomic Weight': 162.500},
      164: {'Atomic Number': 66,
            'Atomic Symbol': 'Dy',
            'Isotopic Composition': 28.18,
            'Mass Number': 164,
            'Relative Atomic Mass': 163.929171,
            'Standard Atomic Weight': 162.500}},
 67: {165: {'Atomic Number': 67,
            'Atomic Symbol': 'Ho',
            'Isotopic Composition': 100,
            'Mass Number': 165,
            'Relative Atomic Mass': 164.930319,
            'Standard Atomic Weight': 164.93032}},
 68: {162: {'Atomic Number': 68,
            'Atomic Symbol': 'Er',
            'Isotopic Composition': 0.14,
            'Mass Number': 162,
            'Relative Atomic Mass': 161.928775,
            'Standard Atomic Weight': 167.259},
      164: {'Atomic Number': 68,
            'Atomic Symbol': 'Er',
            'Isotopic Composition': 1.61,
            'Mass Number': 164,
            'Relative Atomic Mass': 163.929197,
            'Standard Atomic Weight': 167.259},
      166: {'Atomic Number': 68,
            'Atomic Symbol': 'Er',
            'Isotopic Composition': 33.61,
            'Mass Number': 166,
            'Relative Atomic Mass': 165.930290,
            'Standard Atomic Weight': 167.259},
      167: {'Atomic Number': 68,
            'Atomic Symbol': 'Er',
            'Isotopic Composition': 22.93,
            'Mass Number': 167,
            'Relative Atomic Mass': 166.932045,
            'Standard Atomic Weight': 167.259},
      168: {'Atomic Number': 68,
            'Atomic Symbol': 'Er',
            'Isotopic Composition': 26.78,
            'Mass Number': 168,
            'Relative Atomic Mass': 167.932368,
            'Standard Atomic Weight': 167.259},
      170: {'Atomic Number': 68,
            'Atomic Symbol': 'Er',
            'Isotopic Composition': 14.93,
            'Mass Number': 170,
            'Relative Atomic Mass': 169.935460,
            'Standard Atomic Weight': 167.259}},
 69: {169: {'Atomic Number': 69,
            'Atomic Symbol': 'Tm',
            'Isotopic Composition': 100,
            'Mass Number': 169,
            'Relative Atomic Mass': 168.934211,
            'Standard Atomic Weight': 168.93421}},
 70: {168: {'Atomic Number': 70,
            'Atomic Symbol': 'Yb',
            'Isotopic Composition': 0.13,
            'Mass Number': 168,
            'Relative Atomic Mass': 167.933894,
            'Standard Atomic Weight': 173.04},
      170: {'Atomic Number': 70,
            'Atomic Symbol': 'Yb',
            'Isotopic Composition': 3.04,
            'Mass Number': 170,
            'Relative Atomic Mass': 169.934759,
            'Standard Atomic Weight': 173.04},
      171: {'Atomic Number': 70,
            'Atomic Symbol': 'Yb',
            'Isotopic Composition': 14.28,
            'Mass Number': 171,
            'Relative Atomic Mass': 170.936322,
            'Standard Atomic Weight': 173.04},
      172: {'Atomic Number': 70,
            'Atomic Symbol': 'Yb',
            'Isotopic Composition': 21.83,
            'Mass Number': 172,
            'Relative Atomic Mass': 171.9363777,
            'Standard Atomic Weight': 173.04},
      173: {'Atomic Number': 70,
            'Atomic Symbol': 'Yb',
            'Isotopic Composition': 16.13,
            'Mass Number': 173,
            'Relative Atomic Mass': 172.9382068,
            'Standard Atomic Weight': 173.04},
      174: {'Atomic Number': 70,
            'Atomic Symbol': 'Yb',
            'Isotopic Composition': 31.83,
            'Mass Number': 174,
            'Relative Atomic Mass': 173.9388581,
            'Standard Atomic Weight': 173.04},
      176: {'Atomic Number': 70,
            'Atomic Symbol': 'Yb',
            'Isotopic Composition': 12.76,
            'Mass Number': 176,
            'Relative Atomic Mass': 175.942568,
            'Standard Atomic Weight': 173.04}},
 71: {175: {'Atomic Number': 71,
            'Atomic Symbol': 'Lu',
            'Isotopic Composition': 97.41,
            'Mass Number': 175,
            'Relative Atomic Mass': 174.9407679,
            'Standard Atomic Weight': 174.967},
      176: {'Atomic Number': 71,
            'Atomic Symbol': 'Lu',
            'Isotopic Composition': 2.59,
            'Mass Number': 176,
            'Relative Atomic Mass': 175.9426824,
            'Standard Atomic Weight': 174.967}},
 72: {174: {'Atomic Number': 72,
            'Atomic Symbol': 'Hf',
            'Isotopic Composition': 0.16,
            'Mass Number': 174,
            'Relative Atomic Mass': 173.940040,
            'Standard Atomic Weight': 178.49},
      176: {'Atomic Number': 72,
            'Atomic Symbol': 'Hf',
            'Isotopic Composition': 5.26,
            'Mass Number': 176,
            'Relative Atomic Mass': 175.9414018,
            'Standard Atomic Weight': 178.49},
      177: {'Atomic Number': 72,
            'Atomic Symbol': 'Hf',
            'Isotopic Composition': 18.60,
            'Mass Number': 177,
            'Relative Atomic Mass': 176.9432200,
            'Standard Atomic Weight': 178.49},
      178: {'Atomic Number': 72,
            'Atomic Symbol': 'Hf',
            'Isotopic Composition': 27.28,
            'Mass Number': 178,
            'Relative Atomic Mass': 177.9436977,
            'Standard Atomic Weight': 178.49},
      179: {'Atomic Number': 72,
            'Atomic Symbol': 'Hf',
            'Isotopic Composition': 13.62,
            'Mass Number': 179,
            'Relative Atomic Mass': 178.9458151,
            'Standard Atomic Weight': 178.49},
      180: {'Atomic Number': 72,
            'Atomic Symbol': 'Hf',
            'Isotopic Composition': 35.08,
            'Mass Number': 180,
            'Relative Atomic Mass': 179.9465488,
            'Standard Atomic Weight': 178.49}},
 73: {180: {'Atomic Number': 73,
            'Atomic Symbol': 'Ta',
            'Isotopic Composition': 0.012,
            'Mass Number': 180,
            'Relative Atomic Mass': 179.947466,
            'Standard Atomic Weight': 180.9479},
      181: {'Atomic Number': 73,
            'Atomic Symbol': 'Ta',
            'Isotopic Composition': 99.988,
            'Mass Number': 181,
            'Relative Atomic Mass': 180.947996,
            'Standard Atomic Weight': 180.9479}},
 74: {180: {'Atomic Number': 74,
            'Atomic Symbol': 'W',
            'Isotopic Composition': 0.12,
            'Mass Number': 180,
            'Relative Atomic Mass': 179.946706,
            'Standard Atomic Weight': 183.84},
      182: {'Atomic Number': 74,
            'Atomic Symbol': 'W',
            'Isotopic Composition': 26.50,
            'Mass Number': 182,
            'Relative Atomic Mass': 181.948206,
            'Standard Atomic Weight': 183.84},
      183: {'Atomic Number': 74,
            'Atomic Symbol': 'W',
            'Isotopic Composition': 14.31,
            'Mass Number': 183,
            'Relative Atomic Mass': 182.9502245,
            'Standard Atomic Weight': 183.84},
      184: {'Atomic Number': 74,
            'Atomic Symbol': 'W',
            'Isotopic Composition': 30.64,
            'Mass Number': 184,
            'Relative Atomic Mass': 183.9509326,
            'Standard Atomic Weight': 183.84},
      186: {'Atomic Number': 74,
            'Atomic Symbol': 'W',
            'Isotopic Composition': 28.43,
            'Mass Number': 186,
            'Relative Atomic Mass': 185.954362,
            'Standard Atomic Weight': 183.84}},
 75: {185: {'Atomic Number': 75,
            'Atomic Symbol': 'Re',
            'Isotopic Composition': 37.40,
            'Mass Number': 185,
            'Relative Atomic Mass': 184.9529557,
            'Standard Atomic Weight': 186.207},
      187: {'Atomic Number': 75,
            'Atomic Symbol': 'Re',
            'Isotopic Composition': 62.60,
            'Mass Number': 187,
            'Relative Atomic Mass': 186.9557508,
            'Standard Atomic Weight': 186.207}},
 76: {184: {'Atomic Number': 76,
            'Atomic Symbol': 'Os',
            'Isotopic Composition': 0.02,
            'Mass Number': 184,
            'Relative Atomic Mass': 183.952491,
            'Standard Atomic Weight': 190.23},
      186: {'Atomic Number': 76,
            'Atomic Symbol': 'Os',
            'Isotopic Composition': 1.59,
            'Mass Number': 186,
            'Relative Atomic Mass': 185.953838,
            'Standard Atomic Weight': 190.23},
      187: {'Atomic Number': 76,
            'Atomic Symbol': 'Os',
            'Isotopic Composition': 1.96,
            'Mass Number': 187,
            'Relative Atomic Mass': 186.9557479,
            'Standard Atomic Weight': 190.23},
      188: {'Atomic Number': 76,
            'Atomic Symbol': 'Os',
            'Isotopic Composition': 13.24,
            'Mass Number': 188,
            'Relative Atomic Mass': 187.9558360,
            'Standard Atomic Weight': 190.23},
      189: {'Atomic Number': 76,
            'Atomic Symbol': 'Os',
            'Isotopic Composition': 16.15,
            'Mass Number': 189,
            'Relative Atomic Mass': 188.9581449,
            'Standard Atomic Weight': 190.23},
      190: {'Atomic Number': 76,
            'Atomic Symbol': 'Os',
            'Isotopic Composition': 26.26,
            'Mass Number': 190,
            'Relative Atomic Mass': 189.958445,
            'Standard Atomic Weight': 190.23},
      192: {'Atomic Number': 76,
            'Atomic Symbol': 'Os',
            'Isotopic Composition': 40.78,
            'Mass Number': 192,
            'Relative Atomic Mass': 191.961479,
            'Standard Atomic Weight': 190.23}},
 77: {191: {'Atomic Number': 77,
            'Atomic Symbol': 'Ir',
            'Isotopic Composition': 37.3,
            'Mass Number': 191,
            'Relative Atomic Mass': 190.960591,
            'Standard Atomic Weight': 192.217},
      193: {'Atomic Number': 77,
            'Atomic Symbol': 'Ir',
            'Isotopic Composition': 62.7,
            'Mass Number': 193,
            'Relative Atomic Mass': 192.962924,
            'Standard Atomic Weight': 192.217}},
 78: {190: {'Atomic Number': 78,
            'Atomic Symbol': 'Pt',
            'Isotopic Composition': 0.014,
            'Mass Number': 190,
            'Relative Atomic Mass': 189.959930,
            'Standard Atomic Weight': 195.078},
      192: {'Atomic Number': 78,
            'Atomic Symbol': 'Pt',
            'Isotopic Composition': 0.782,
            'Mass Number': 192,
            'Relative Atomic Mass': 191.961035,
            'Standard Atomic Weight': 195.078},
      194: {'Atomic Number': 78,
            'Atomic Symbol': 'Pt',
            'Isotopic Composition': 32.967,
            'Mass Number': 194,
            'Relative Atomic Mass': 193.962664,
            'Standard Atomic Weight': 195.078},
      195: {'Atomic Number': 78,
            'Atomic Symbol': 'Pt',
            'Isotopic Composition': 33.832,
            'Mass Number': 195,
            'Relative Atomic Mass': 194.964774,
            'Standard Atomic Weight': 195.078},
      196: {'Atomic Number': 78,
            'Atomic Symbol': 'Pt',
            'Isotopic Composition': 25.242,
            'Mass Number': 196,
            'Relative Atomic Mass': 195.964935,
            'Standard Atomic Weight': 195.078},
      198: {'Atomic Number': 78,
            'Atomic Symbol': 'Pt',
            'Isotopic Composition': 7.163,
            'Mass Number': 198,
            'Relative Atomic Mass': 197.967876,
            'Standard Atomic Weight': 195.078}},
 79: {197: {'Atomic Number': 79,
            'Atomic Symbol': 'Au',
            'Isotopic Composition': 100,
            'Mass Number': 197,
            'Relative Atomic Mass': 196.966552,
            'Standard Atomic Weight': 196.96655}},
 80: {196: {'Atomic Number': 80,
            'Atomic Symbol': 'Hg',
            'Isotopic Composition': 0.15,
            'Mass Number': 196,
            'Relative Atomic Mass': 195.965815,
            'Standard Atomic Weight': 200.59},
      198: {'Atomic Number': 80,
            'Atomic Symbol': 'Hg',
            'Isotopic Composition': 9.97,
            'Mass Number': 198,
            'Relative Atomic Mass': 197.966752,
            'Standard Atomic Weight': 200.59},
      199: {'Atomic Number': 80,
            'Atomic Symbol': 'Hg',
            'Isotopic Composition': 16.87,
            'Mass Number': 199,
            'Relative Atomic Mass': 198.968262,
            'Standard Atomic Weight': 200.59},
      200: {'Atomic Number': 80,
            'Atomic Symbol': 'Hg',
            'Isotopic Composition': 23.10,
            'Mass Number': 200,
            'Relative Atomic Mass': 199.968309,
            'Standard Atomic Weight': 200.59},
      201: {'Atomic Number': 80,
            'Atomic Symbol': 'Hg',
            'Isotopic Composition': 13.18,
            'Mass Number': 201,
            'Relative Atomic Mass': 200.970285,
            'Standard Atomic Weight': 200.59},
      202: {'Atomic Number': 80,
            'Atomic Symbol': 'Hg',
            'Isotopic Composition': 29.86,
            'Mass Number': 202,
            'Relative Atomic Mass': 201.970626,
            'Standard Atomic Weight': 200.59},
      204: {'Atomic Number': 80,
            'Atomic Symbol': 'Hg',
            'Isotopic Composition': 6.87,
            'Mass Number': 204,
            'Relative Atomic Mass': 203.973476,
            'Standard Atomic Weight': 200.59}},
 81: {203: {'Atomic Number': 81,
            'Atomic Symbol': 'Tl',
            'Isotopic Composition': 29.524,
            'Mass Number': 203,
            'Relative Atomic Mass': 202.972329,
            'Standard Atomic Weight': 204.3833},
      205: {'Atomic Number': 81,
            'Atomic Symbol': 'Tl',
            'Isotopic Composition': 70.476,
            'Mass Number': 205,
            'Relative Atomic Mass': 204.974412,
            'Standard Atomic Weight': 204.3833}},
 82: {204: {'Atomic Number': 82,
            'Atomic Symbol': 'Pb',
            'Isotopic Composition': 1.4,
            'Mass Number': 204,
            'Relative Atomic Mass': 203.973029,
            'Standard Atomic Weight': 207.2},
      206: {'Atomic Number': 82,
            'Atomic Symbol': 'Pb',
            'Isotopic Composition': 24.1,
            'Mass Number': 206,
            'Relative Atomic Mass': 205.974449,
            'Standard Atomic Weight': 207.2},
      207: {'Atomic Number': 82,
            'Atomic Symbol': 'Pb',
            'Isotopic Composition': 22.1,
            'Mass Number': 207,
            'Relative Atomic Mass': 206.975881,
            'Standard Atomic Weight': 207.2},
      208: {'Atomic Number': 82,
            'Atomic Symbol': 'Pb',
            'Isotopic Composition': 52.4,
            'Mass Number': 208,
            'Relative Atomic Mass': 207.976636,
            'Standard Atomic Weight': 207.2}},
 83: {209: {'Atomic Number': 83,
            'Atomic Symbol': 'Bi',
            'Isotopic Composition': 100,
            'Mass Number': 209,
            'Relative Atomic Mass': 208.980383,
            'Standard Atomic Weight': 208.98038}},
 84: {209: {'Atomic Number': 84,
            'Atomic Symbol': 'Po',
            'Isotopic Composition': '',
            'Mass Number': 209,
            'Relative Atomic Mass': 208.982416,
            'Standard Atomic Weight': 209},
      210: {'Atomic Number': 84,
            'Atomic Symbol': 'Po',
            'Isotopic Composition': '',
            'Mass Number': 210,
            'Relative Atomic Mass': 209.982857,
            'Standard Atomic Weight': 209}},
 85: {210: {'Atomic Number': 85,
            'Atomic Symbol': 'At',
            'Isotopic Composition': '',
            'Mass Number': 210,
            'Relative Atomic Mass': 209.987131,
            'Standard Atomic Weight': 210},
      211: {'Atomic Number': 85,
            'Atomic Symbol': 'At',
            'Isotopic Composition': '',
            'Mass Number': 211,
            'Relative Atomic Mass': 210.987481,
            'Standard Atomic Weight': 210}},
 86: {211: {'Atomic Number': 86,
            'Atomic Symbol': 'Rn',
            'Isotopic Composition': '',
            'Mass Number': 211,
            'Relative Atomic Mass': 210.990585,
            'Standard Atomic Weight': 222},
      220: {'Atomic Number': 86,
            'Atomic Symbol': 'Rn',
            'Isotopic Composition': '',
            'Mass Number': 220,
            'Relative Atomic Mass': 220.0113841,
            'Standard Atomic Weight': 222},
      222: {'Atomic Number': 86,
            'Atomic Symbol': 'Rn',
            'Isotopic Composition': '',
            'Mass Number': 222,
            'Relative Atomic Mass': 222.0175705,
            'Standard Atomic Weight': 222}},
 87: {223: {'Atomic Number': 87,
            'Atomic Symbol': 'Fr',
            'Isotopic Composition': '',
            'Mass Number': 223,
            'Relative Atomic Mass': 223.0197307,
            'Standard Atomic Weight': 223}},
 88: {223: {'Atomic Number': 88,
            'Atomic Symbol': 'Ra',
            'Isotopic Composition': '',
            'Mass Number': 223,
            'Relative Atomic Mass': 223.018497,
            'Standard Atomic Weight': 226},
      224: {'Atomic Number': 88,
            'Atomic Symbol': 'Ra',
            'Isotopic Composition': '',
            'Mass Number': 224,
            'Relative Atomic Mass': 224.0202020,
            'Standard Atomic Weight': 226},
      226: {'Atomic Number': 88,
            'Atomic Symbol': 'Ra',
            'Isotopic Composition': '',
            'Mass Number': 226,
            'Relative Atomic Mass': 226.0254026,
            'Standard Atomic Weight': 226},
      228: {'Atomic Number': 88,
            'Atomic Symbol': 'Ra',
            'Isotopic Composition': '',
            'Mass Number': 228,
            'Relative Atomic Mass': 228.0310641,
            'Standard Atomic Weight': 226}},
 89: {227: {'Atomic Number': 89,
            'Atomic Symbol': 'Ac',
            'Isotopic Composition': '',
            'Mass Number': 227,
            'Relative Atomic Mass': 227.0277470,
            'Standard Atomic Weight': 227}},
 90: {230: {'Atomic Number': 90,
            'Atomic Symbol': 'Th',
            'Isotopic Composition': '',
            'Mass Number': 230,
            'Relative Atomic Mass': 230.0331266,
            'Standard Atomic Weight': 232.0381},
      232: {'Atomic Number': 90,
            'Atomic Symbol': 'Th',
            'Isotopic Composition': 100,
            'Mass Number': 232,
            'Relative Atomic Mass': 232.0380504,
            'Standard Atomic Weight': 232.0381}},
 91: {231: {'Atomic Number': 91,
            'Atomic Symbol': 'Pa',
            'Isotopic Composition': 100,
            'Mass Number': 231,
            'Relative Atomic Mass': 231.0358789,
            'Standard Atomic Weight': 231.03588}},
 92: {233: {'Atomic Number': 92,
            'Atomic Symbol': 'U',
            'Isotopic Composition': '',
            'Mass Number': 233,
            'Relative Atomic Mass': 233.039628,
            'Standard Atomic Weight': 238.02891},
      234: {'Atomic Number': 92,
            'Atomic Symbol': 'U',
            'Isotopic Composition': 0.0055,
            'Mass Number': 234,
            'Relative Atomic Mass': 234.0409456,
            'Standard Atomic Weight': 238.02891},
      235: {'Atomic Number': 92,
            'Atomic Symbol': 'U',
            'Isotopic Composition': 0.7200,
            'Mass Number': 235,
            'Relative Atomic Mass': 235.0439231,
            'Standard Atomic Weight': 238.02891},
      236: {'Atomic Number': 92,
            'Atomic Symbol': 'U',
            'Isotopic Composition': '',
            'Mass Number': 236,
            'Relative Atomic Mass': 236.0455619,
            'Standard Atomic Weight': 238.02891},
      238: {'Atomic Number': 92,
            'Atomic Symbol': 'U',
            'Isotopic Composition': 99.2745,
            'Mass Number': 238,
            'Relative Atomic Mass': 238.0507826,
            'Standard Atomic Weight': 238.02891}},
 93: {237: {'Atomic Number': 93,
            'Atomic Symbol': 'Np',
            'Isotopic Composition': '',
            'Mass Number': 237,
            'Relative Atomic Mass': 237.0481673,
            'Standard Atomic Weight': 237},
      239: {'Atomic Number': 93,
            'Atomic Symbol': 'Np',
            'Isotopic Composition': '',
            'Mass Number': 239,
            'Relative Atomic Mass': 239.0529314,
            'Standard Atomic Weight': 237}},
 94: {238: {'Atomic Number': 94,
            'Atomic Symbol': 'Pu',
            'Isotopic Composition': '',
            'Mass Number': 238,
            'Relative Atomic Mass': 238.0495534,
            'Standard Atomic Weight': 244},
      239: {'Atomic Number': 94,
            'Atomic Symbol': 'Pu',
            'Isotopic Composition': '',
            'Mass Number': 239,
            'Relative Atomic Mass': 239.0521565,
            'Standard Atomic Weight': 244},
      240: {'Atomic Number': 94,
            'Atomic Symbol': 'Pu',
            'Isotopic Composition': '',
            'Mass Number': 240,
            'Relative Atomic Mass': 240.0538075,
            'Standard Atomic Weight': 244},
      241: {'Atomic Number': 94,
            'Atomic Symbol': 'Pu',
            'Isotopic Composition': '',
            'Mass Number': 241,
            'Relative Atomic Mass': 241.0568453,
            'Standard Atomic Weight': 244},
      242: {'Atomic Number': 94,
            'Atomic Symbol': 'Pu',
            'Isotopic Composition': '',
            'Mass Number': 242,
            'Relative Atomic Mass': 242.0587368,
            'Standard Atomic Weight': 244},
      244: {'Atomic Number': 94,
            'Atomic Symbol': 'Pu',
            'Isotopic Composition': '',
            'Mass Number': 244,
            'Relative Atomic Mass': 244.064198,
            'Standard Atomic Weight': 244}},
 95: {241: {'Atomic Number': 95,
            'Atomic Symbol': 'Am',
            'Isotopic Composition': '',
            'Mass Number': 241,
            'Relative Atomic Mass': 241.0568229,
            'Standard Atomic Weight': 243},
      243: {'Atomic Number': 95,
            'Atomic Symbol': 'Am',
            'Isotopic Composition': '',
            'Mass Number': 243,
            'Relative Atomic Mass': 243.0613727,
            'Standard Atomic Weight': 243}},
 96: {243: {'Atomic Number': 96,
            'Atomic Symbol': 'Cm',
            'Isotopic Composition': '',
            'Mass Number': 243,
            'Relative Atomic Mass': 243.0613822,
            'Standard Atomic Weight': 247},
      244: {'Atomic Number': 96,
            'Atomic Symbol': 'Cm',
            'Isotopic Composition': '',
            'Mass Number': 244,
            'Relative Atomic Mass': 244.0627463,
            'Standard Atomic Weight': 247},
      245: {'Atomic Number': 96,
            'Atomic Symbol': 'Cm',
            'Isotopic Composition': '',
            'Mass Number': 245,
            'Relative Atomic Mass': 245.0654856,
            'Standard Atomic Weight': 247},
      246: {'Atomic Number': 96,
            'Atomic Symbol': 'Cm',
            'Isotopic Composition': '',
            'Mass Number': 246,
            'Relative Atomic Mass': 246.0672176,
            'Standard Atomic Weight': 247},
      247: {'Atomic Number': 96,
            'Atomic Symbol': 'Cm',
            'Isotopic Composition': '',
            'Mass Number': 247,
            'Relative Atomic Mass': 247.070347,
            'Standard Atomic Weight': 247},
      248: {'Atomic Number': 96,
            'Atomic Symbol': 'Cm',
            'Isotopic Composition': '',
            'Mass Number': 248,
            'Relative Atomic Mass': 248.072342,
            'Standard Atomic Weight': 247}},
 97: {247: {'Atomic Number': 97,
            'Atomic Symbol': 'Bk',
            'Isotopic Composition': '',
            'Mass Number': 247,
            'Relative Atomic Mass': 247.070299,
            'Standard Atomic Weight': 247},
      249: {'Atomic Number': 97,
            'Atomic Symbol': 'Bk',
            'Isotopic Composition': '',
            'Mass Number': 249,
            'Relative Atomic Mass': 249.074980,
            'Standard Atomic Weight': 247}},
 98: {249: {'Atomic Number': 98,
            'Atomic Symbol': 'Cf',
            'Isotopic Composition': '',
            'Mass Number': 249,
            'Relative Atomic Mass': 249.074847,
            'Standard Atomic Weight': 251},
      250: {'Atomic Number': 98,
            'Atomic Symbol': 'Cf',
            'Isotopic Composition': '',
            'Mass Number': 250,
            'Relative Atomic Mass': 250.0764000,
            'Standard Atomic Weight': 251},
      251: {'Atomic Number': 98,
            'Atomic Symbol': 'Cf',
            'Isotopic Composition': '',
            'Mass Number': 251,
            'Relative Atomic Mass': 251.079580,
            'Standard Atomic Weight': 251},
      252: {'Atomic Number': 98,
            'Atomic Symbol': 'Cf',
            'Isotopic Composition': '',
            'Mass Number': 252,
            'Relative Atomic Mass': 252.081620,
            'Standard Atomic Weight': 251}},
 99: {252: {'Atomic Number': 99,
            'Atomic Symbol': 'Es',
            'Isotopic Composition': '',
            'Mass Number': 252,
            'Relative Atomic Mass': 252.082970,
            'Standard Atomic Weight': 252}},
 100: {257: {'Atomic Number': 100,
             'Atomic Symbol': 'Fm',
             'Isotopic Composition': '',
             'Mass Number': 257,
             'Relative Atomic Mass': 257.095099,
             'Standard Atomic Weight': 257}},
 101: {256: {'Atomic Number': 101,
             'Atomic Symbol': 'Md',
             'Isotopic Composition': '',
             'Mass Number': 256,
             'Relative Atomic Mass': 256.094050,
             'Standard Atomic Weight': 258},
       258: {'Atomic Number': 101,
             'Atomic Symbol': 'Md',
             'Isotopic Composition': '',
             'Mass Number': 258,
             'Relative Atomic Mass': 258.098425,
             'Standard Atomic Weight': 258}},
 102: {259: {'Atomic Number': 102,
             'Atomic Symbol': 'No',
             'Isotopic Composition': '',
             'Mass Number': 259,
             'Relative Atomic Mass': 259.10102,
             'Standard Atomic Weight': 259}},
 103: {262: {'Atomic Number': 103,
             'Atomic Symbol': 'Lr',
             'Isotopic Composition': '',
             'Mass Number': 262,
             'Relative Atomic Mass': 262.10969,
             'Standard Atomic Weight': 262}},
 104: {261: {'Atomic Number': 104,
             'Atomic Symbol': 'Rf',
             'Isotopic Composition': '',
             'Mass Number': 261,
             'Relative Atomic Mass': 261.10875,
             'Standard Atomic Weight': 261}},
 105: {262: {'Atomic Number': 105,
             'Atomic Symbol': 'Db',
             'Isotopic Composition': '',
             'Mass Number': 262,
             'Relative Atomic Mass': 262.11415,
             'Standard Atomic Weight': 262}},
 106: {266: {'Atomic Number': 106,
             'Atomic Symbol': 'Sg',
             'Isotopic Composition': '',
             'Mass Number': 266,
             'Relative Atomic Mass': 266.12193,
             'Standard Atomic Weight': 266}},
 107: {264: {'Atomic Number': 107,
             'Atomic Symbol': 'Bh',
             'Isotopic Composition': '',
             'Mass Number': 264,
             'Relative Atomic Mass': 264.12473,
             'Standard Atomic Weight': 264}},
 108: {277: {'Atomic Number': 108,
             'Atomic Symbol': 'Hs',
             'Isotopic Composition': '',
             'Mass Number': 277,
             'Relative Atomic Mass': '',
             'Standard Atomic Weight': 277}},
 109: {268: {'Atomic Number': 109,
             'Atomic Symbol': 'Mt',
             'Isotopic Composition': '',
             'Mass Number': 268,
             'Relative Atomic Mass': 268.13882,
             'Standard Atomic Weight': 268}},
 110: {281: {'Atomic Number': 110,
             'Atomic Symbol': 'Uun',
             'Isotopic Composition': '',
             'Mass Number': 281,
             'Relative Atomic Mass': '',
             'Standard Atomic Weight': 281}},
 111: {272: {'Atomic Number': 111,
             'Atomic Symbol': 'Uuu',
             'Isotopic Composition': '',
             'Mass Number': 272,
             'Relative Atomic Mass': 272.15348,
             'Standard Atomic Weight': 272}},
 112: {285: {'Atomic Number': 112,
             'Atomic Symbol': 'Uub',
             'Isotopic Composition': '',
             'Mass Number': 285,
             'Relative Atomic Mass': '',
             'Standard Atomic Weight': 285}},
 114: {289: {'Atomic Number': 114,
             'Atomic Symbol': 'Uuq',
             'Isotopic Composition': '',
             'Mass Number': 289,
             'Relative Atomic Mass': '',
             'Standard Atomic Weight': 289}}}