# Key Commands

Please replace some keys with the following in macOS:

- <kbd>Ctrl</kbd> → <kbd>⌘ command</kbd>
- <kbd>Alt</kbd> → <kbd>⌥ option</kbd>
- <kbd>BackSpace</kbd> → <kbd>delete</kbd>
- <kbd>Delete</kbd> → <kbd>fn</kbd>+<kbd>delete</kbd>

## General

| Key                               | Command                     |
| --------------------------------- | --------------------------- |
| <kbd>Ctrl</kbd>+<kbd>N</kbd>      | Create new module           |
| <kbd>Ctrl</kbd>+<kbd>O</kbd>      | Open module                 |
| <kbd>Ctrl</kbd>+<kbd>S</kbd>      | Save module                 |
| <kbd>Ctrl</kbd>+<kbd>P</kbd>      | Open module property dialog |
| <kbd>Return</kbd>                 | Play/stop song              |
| <kbd>Space</kbd>                  | Toggle jam/edit mode        |
| <kbd>F1</kbd>                     | Show effect list dialog     |
| <kbd>F2</kbd>                     | Focus on pattern editor     |
| <kbd>F3</kbd>                     | Focus on order list         |
| <kbd>F4</kbd>                     | Focus on instrument list    |
| <kbd>F5</kbd>                     | Play from start             |
| <kbd>F6</kbd>                     | Play pattern                |
| <kbd>F7</kbd>                     | Play from current position  |
| <kbd>Ctrl</kbd>+<kbd>F7</kbd>     | Play from marker            |
| <kbd>Ctrl</kbd>+<kbd>Return</kbd> | Play only current step      |
| <kbd>F8</kbd>                     | Stop song                   |
| <kbd>F12</kbd>                    | Kill sound                  |

## Instrument List

| Key                          | Command                        |
| ---------------------------- | ------------------------------ |
| <kbd>Insert</kbd>            | Add instrument                 |
| <kbd>Delete</kbd>            | Remove instrument              |
| <kbd>Ctrl</kbd>+<kbd>I</kbd> | Open current instrument editor |

## Order List

| Key                                              | Command             |
| ------------------------------------------------ | ------------------- |
| <kbd>Ctrl</kbd>+<kbd>C</kbd>                     | Copy                |
| <kbd>Ctrl</kbd>+<kbd>V</kbd>                     | Paste               |
| <kbd>Ctrl</kbd>+<kbd>A</kbd>                     | Select track/all    |
| <kbd>Ctrl</kbd>+<kbd>D</kbd>                     | Duplicate order     |
| <kbd>Alt</kbd>+<kbd>D</kbd>                      | Clone patterns      |
| <kbd>Home</kbd>                                  | Jump to first order |
| <kbd>End</kbd>                                   | Jump to last order  |
| <kbd>PageUp</kbd>                                | Jump to upper oder  |
| <kbd>PageDown</kbd>                              | Jump to lower oder  |
| <kbd>Insert</kbd> or <kbd>Alt</kbd>+<kbd>B</kbd> | Insert order below  |
| <kbd>Delete</kbd>                                | Delete order        |
| <kbd>Escape</kbd>                                | Deselect            |

## Pattern Editor

| Key                                                            | Command                                     |
| -------------------------------------------------------------- | ------------------------------------------- |
| <kbd>Ctrl</kbd>+<kbd>C</kbd>                                   | Copy                                        |
| <kbd>Ctrl</kbd>+<kbd>X</kbd>                                   | Cut                                         |
| <kbd>Ctrl</kbd>+<kbd>V</kbd>                                   | Paste                                       |
| <kbd>Ctrl</kbd>+<kbd>M</kbd>                                   | Paste and mix                               |
| <kbd>Ctrl</kbd>+<kbd>A</kbd>                                   | Select track/all                            |
| <kbd>Ctrl</kbd>+<kbd>G</kbd>                                   | Interpolate                                 |
| <kbd>Ctrl</kbd>+<kbd>R</kbd>                                   | Reverse                                     |
| <kbd>Ctrl</kbd>+<kbd>F1</kbd> or <kbd>Ctrl</kbd>+scroll up     | Decrease note                               |
| <kbd>Ctrl</kbd>+<kbd>F2</kbd> or <kbd>Ctrl</kbd>+scroll down   | Increase note                               |
| <kbd>Ctrl</kbd>+<kbd>F3</kbd>                                  | Decrease octave                             |
| <kbd>Ctrl</kbd>+<kbd>F4</kbd>                                  | Increase octave                             |
| <kbd>Shift</kbd>+<kbd>F1</kbd> or <kbd>Shift</kbd>+scroll up   | Fine decrease values                        |
| <kbd>Shift</kbd>+<kbd>F2</kbd> or <kbd>Shift</kbd>+scroll down | Fine increase values                        |
| <kbd>Shift</kbd>+<kbd>F3</kbd>                                 | Coarse decrease values                      |
| <kbd>Shift</kbd>+<kbd>F4</kbd>                                 | Coarse increase values                      |
| <kbd>Alt</kbd>+<kbd>F9</kbd>                                   | Toggle track                                |
| <kbd>Alt</kbd>+<kbd>F10</kbd>                                  | Solo track                                  |
| <kbd>Alt</kbd>+<kbd>←</kbd>                                    | Select previous instrument                  |
| <kbd>Alt</kbd>+<kbd>→</kbd>                                    | Select next instrument                      |
| <kbd>Alt</kbd>+<kbd>S</kbd>                                    | Replace instrument                          |
| <kbd>Alt</kbd>+<kbd>L</kbd>                                    | Expand effect column                        |
| <kbd>Alt</kbd>+<kbd>K</kbd>                                    | Shrink effect column                        |
| <kbd>Ctrl</kbd>+<kbd>K</kbd>                                   | Add/Remove bookmark on the current position |
| <kbd>Ctrl</kbd>+<kbd>B</kbd>                                   | Set/Delete marker                           |
| <kbd>Alt</kbd>+<kbd>G</kbd>                                    | Show Go To dialog                           |
| <kbd>Tab</kbd>                                                 | Jump to right track                         |
| <kbd>BackTab</kbd>                                             | Jump to left track                          |
| <kbd>Home</kbd>                                                | Jump to first step                          |
| <kbd>End</kbd>                                                 | Jump to last step                           |
| <kbd>PageUp</kbd>                                              | Jump to upper step                          |
| <kbd>PageDown</kbd>                                            | Jump to lower step                          |
| <kbd>Ctrl</kbd>+<kbd>↑</kbd>                                   | Jump to upper 1st highlighted step          |
| <kbd>Ctrl</kbd>+<kbd>↓</kbd>                                   | Jump to lower 1st highlighted step          |
| <kbd>Ctrl</kbd>+<kbd>PageUp</kbd>                              | Jump to previous bookmark                   |
| <kbd>Ctrl</kbd>+<kbd>PageDown</kbd>                            | Jump to next bookmark                       |
| <kbd>Ctrl</kbd>+<kbd>←</kbd>                                   | Go to previous order                        |
| <kbd>Ctrl</kbd>+<kbd>→</kbd>                                   | Go to next order                            |
| <kbd>Insert</kbd> or <kbd>Alt</kbd>+<kbd>↓</kbd>               | Insert step                                 |
| <kbd>BackSpace</kbd> or <kbd>Alt</kbd>+<kbd>↑</kbd>            | Delete the step above                       |
| <kbd>Delete</kbd>                                              | Delete commands                             |
| <kbd>Escape</kbd>                                              | Deselection                                 |
| <kbd>-</kbd>                                                   | Key off                                     |
| <kbd>\*</kbd> (numpad)                                         | Increase octave/echo buffer number          |
| <kbd>/</kbd> (numpad)                                          | Decrease octave/echo buffer number          |
| <kbd>^</kbd>                                                   | Echo buffer access                          |

There are two rows of a piano keyboard:

```text
Current octave+1
 2 3  5 6 7  9
Q W ER T Y UI O

Current octave
 S D  G H J  L
Z X CV B N M, .
```

The keyboard shortcuts and layout can be changed in the configuration.
